# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator

class GetDataExplorerSettingsResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    preset: Optional[StrictStr] = Field(None, description="Preset to use for the data explorer.")
    dimensionality_reduction_technique: Optional[StrictStr] = Field(None, alias="dimensionalityReductionTechnique")
    impulse_id: Optional[StrictInt] = Field(None, alias="impulseId", description="Which impulse to use (if preset is either 'current-impulse' or 'current-impulse-embeddings'). If this is undefined then 'defaultImpulseId' is used.")
    dimensionality_reduction_recommendation: StrictStr = Field(..., alias="dimensionalityReductionRecommendation")
    __properties = ["success", "error", "preset", "dimensionalityReductionTechnique", "impulseId", "dimensionalityReductionRecommendation"]

    @validator('preset')
    def preset_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('keywords', 'images', 'current-impulse', 'current-impulse-embeddings'):
            raise ValueError("must validate the enum values ('keywords', 'images', 'current-impulse', 'current-impulse-embeddings')")
        return v

    @validator('dimensionality_reduction_technique')
    def dimensionality_reduction_technique_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('tsne', 'pca'):
            raise ValueError("must validate the enum values ('tsne', 'pca')")
        return v

    @validator('dimensionality_reduction_recommendation')
    def dimensionality_reduction_recommendation_validate_enum(cls, v):
        if v not in ('tsne', 'pca'):
            raise ValueError("must validate the enum values ('tsne', 'pca')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> GetDataExplorerSettingsResponse:
        """Create an instance of GetDataExplorerSettingsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GetDataExplorerSettingsResponse:
        """Create an instance of GetDataExplorerSettingsResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GetDataExplorerSettingsResponse.construct(**obj)

        _obj = GetDataExplorerSettingsResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "preset": obj.get("preset"),
            "dimensionality_reduction_technique": obj.get("dimensionalityReductionTechnique"),
            "impulse_id": obj.get("impulseId"),
            "dimensionality_reduction_recommendation": obj.get("dimensionalityReductionRecommendation")
        })
        return _obj

