# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt
from edgeimpulse_api.models.job_state_execution_details import JobStateExecutionDetails
from edgeimpulse_api.models.job_step import JobStep

class JobState(BaseModel):
    version: StrictInt = Field(..., description="version number (indicates the order of the state)")
    timestamp: datetime = Field(..., description="timestamp when the job transistioned to this new step")
    execution_details: Optional[JobStateExecutionDetails] = Field(None, alias="executionDetails")
    step: JobStep = ...
    __properties = ["version", "timestamp", "executionDetails", "step"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> JobState:
        """Create an instance of JobState from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of execution_details
        if self.execution_details:
            _dict['executionDetails'] = self.execution_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of step
        if self.step:
            _dict['step'] = self.step.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> JobState:
        """Create an instance of JobState from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return JobState.construct(**obj)

        _obj = JobState.construct(**{
            "version": obj.get("version"),
            "timestamp": obj.get("timestamp"),
            "execution_details": JobStateExecutionDetails.from_dict(obj.get("executionDetails")) if obj.get("executionDetails") is not None else None,
            "step": JobStep.from_dict(obj.get("step")) if obj.get("step") is not None else None
        })
        return _obj

