# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr
from edgeimpulse_api.models.organization_transfer_learning_block_model_file import OrganizationTransferLearningBlockModelFile

class OrganizationTransferLearningBlockCustomVariant(BaseModel):
    key: StrictStr = Field(..., description="Unique identifier or key for this custom variant")
    name: StrictStr = Field(..., description="Custom variant display name")
    inferencing_entrypoint: StrictStr = Field(..., alias="inferencingEntrypoint", description="The entrypoint command to run custom inferencing for this model variant, via the learn block container")
    profiling_entrypoint: Optional[StrictStr] = Field(None, alias="profilingEntrypoint", description="The entrypoint command to run custom profiling for this model variant, via the learn block container")
    model_files: Optional[List[OrganizationTransferLearningBlockModelFile]] = Field(None, alias="modelFiles")
    __properties = ["key", "name", "inferencingEntrypoint", "profilingEntrypoint", "modelFiles"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationTransferLearningBlockCustomVariant:
        """Create an instance of OrganizationTransferLearningBlockCustomVariant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in model_files (list)
        _items = []
        if self.model_files:
            for _item in self.model_files:
                if _item:
                    _items.append(_item.to_dict())
            _dict['modelFiles'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationTransferLearningBlockCustomVariant:
        """Create an instance of OrganizationTransferLearningBlockCustomVariant from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationTransferLearningBlockCustomVariant.construct(**obj)

        _obj = OrganizationTransferLearningBlockCustomVariant.construct(**{
            "key": obj.get("key"),
            "name": obj.get("name"),
            "inferencing_entrypoint": obj.get("inferencingEntrypoint"),
            "profiling_entrypoint": obj.get("profilingEntrypoint"),
            "model_files": [OrganizationTransferLearningBlockModelFile.from_dict(_item) for _item in obj.get("modelFiles")] if obj.get("modelFiles") is not None else None
        })
        return _obj

