# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.performance_calibration_false_positive import PerformanceCalibrationFalsePositive

class PerformanceCalibrationParameterSetStatsInner(BaseModel):
    label: StrictStr = ...
    true_positives: StrictInt = Field(..., alias="truePositives")
    false_positives: StrictInt = Field(..., alias="falsePositives")
    false_negatives: StrictInt = Field(..., alias="falseNegatives")
    true_negatives: StrictInt = Field(..., alias="trueNegatives")
    false_positive_rate: float = Field(..., alias="falsePositiveRate")
    false_negative_rate: float = Field(..., alias="falseNegativeRate")
    false_positive_details: Optional[List[PerformanceCalibrationFalsePositive]] = Field(None, alias="falsePositiveDetails", description="The details of every false positive detection.")
    false_negative_times: List[float] = Field(..., alias="falseNegativeTimes", description="The times in ms at which false negatives occurred. These correspond to specific items in the ground truth.")
    __properties = ["label", "truePositives", "falsePositives", "falseNegatives", "trueNegatives", "falsePositiveRate", "falseNegativeRate", "falsePositiveDetails", "falseNegativeTimes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> PerformanceCalibrationParameterSetStatsInner:
        """Create an instance of PerformanceCalibrationParameterSetStatsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in false_positive_details (list)
        _items = []
        if self.false_positive_details:
            for _item in self.false_positive_details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['falsePositiveDetails'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PerformanceCalibrationParameterSetStatsInner:
        """Create an instance of PerformanceCalibrationParameterSetStatsInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PerformanceCalibrationParameterSetStatsInner.construct(**obj)

        _obj = PerformanceCalibrationParameterSetStatsInner.construct(**{
            "label": obj.get("label"),
            "true_positives": obj.get("truePositives"),
            "false_positives": obj.get("falsePositives"),
            "false_negatives": obj.get("falseNegatives"),
            "true_negatives": obj.get("trueNegatives"),
            "false_positive_rate": obj.get("falsePositiveRate"),
            "false_negative_rate": obj.get("falseNegativeRate"),
            "false_positive_details": [PerformanceCalibrationFalsePositive.from_dict(_item) for _item in obj.get("falsePositiveDetails")] if obj.get("falsePositiveDetails") is not None else None,
            "false_negative_times": obj.get("falseNegativeTimes")
        })
        return _obj

