# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.project_collaborator import ProjectCollaborator

class ProjectPrivateData(BaseModel):
    last_accessed: Optional[datetime] = Field(None, alias="lastAccessed")
    metadata: Dict[str, Any] = Field(..., description="Metadata about the project")
    data_explorer_screenshot: Optional[StrictStr] = Field(None, alias="dataExplorerScreenshot")
    is_enterprise_project: StrictBool = Field(..., alias="isEnterpriseProject", description="Whether this is an enterprise project")
    collaborators: Optional[List[ProjectCollaborator]] = None
    whitelabel_id: Optional[StrictInt] = Field(..., alias="whitelabelId", description="Unique identifier of the white label this project belongs to, if any.")
    __properties = ["lastAccessed", "metadata", "dataExplorerScreenshot", "isEnterpriseProject", "collaborators", "whitelabelId"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ProjectPrivateData:
        """Create an instance of ProjectPrivateData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in collaborators (list)
        _items = []
        if self.collaborators:
            for _item in self.collaborators:
                if _item:
                    _items.append(_item.to_dict())
            _dict['collaborators'] = _items
        # set to None if whitelabel_id (nullable) is None
        if self.whitelabel_id is None:
            _dict['whitelabelId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProjectPrivateData:
        """Create an instance of ProjectPrivateData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ProjectPrivateData.construct(**obj)

        _obj = ProjectPrivateData.construct(**{
            "last_accessed": obj.get("lastAccessed"),
            "metadata": obj.get("metadata"),
            "data_explorer_screenshot": obj.get("dataExplorerScreenshot"),
            "is_enterprise_project": obj.get("isEnterpriseProject"),
            "collaborators": [ProjectCollaborator.from_dict(_item) for _item in obj.get("collaborators")] if obj.get("collaborators") is not None else None,
            "whitelabel_id": obj.get("whitelabelId")
        })
        return _obj

