# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.ai_actions_operates_on import AIActionsOperatesOn
from edgeimpulse_api.models.dsp_group_item import DSPGroupItem
from edgeimpulse_api.models.transformation_job_operates_on_enum import TransformationJobOperatesOnEnum

class PublicOrganizationTransformationBlock(BaseModel):
    id: StrictInt = ...
    owner_organization_id: StrictInt = Field(..., alias="ownerOrganizationId")
    owner_organization_name: StrictStr = Field(..., alias="ownerOrganizationName")
    name: StrictStr = ...
    created: datetime = ...
    last_updated: Optional[datetime] = Field(None, alias="lastUpdated")
    description: StrictStr = ...
    operates_on: TransformationJobOperatesOnEnum = Field(..., alias="operatesOn")
    allow_extra_cli_arguments: StrictBool = Field(..., alias="allowExtraCliArguments")
    parameters: Optional[List[Dict[str, Any]]] = Field(None, description="List of parameters, spec'ed according to https://docs.edgeimpulse.com/docs/tips-and-tricks/adding-parameters-to-custom-blocks")
    parameters_ui: Optional[List[DSPGroupItem]] = Field(None, alias="parametersUI", description="List of parameters to be rendered in the UI")
    repository_url: Optional[StrictStr] = Field(None, alias="repositoryUrl", description="URL to the source code of this custom learn block.")
    show_in_data_sources: StrictBool = Field(..., alias="showInDataSources", description="Whether to show this block in 'Data sources'. Only applies for standalone blocks.")
    show_in_create_transformation_job: StrictBool = Field(..., alias="showInCreateTransformationJob", description="Whether to show this block in 'Create transformation job'. Only applies for standalone blocks.")
    show_in_synthetic_data: StrictBool = Field(..., alias="showInSyntheticData", description="Whether to show this block in 'Synthetic data'. Only applies for standalone blocks.")
    show_in_ai_actions: StrictBool = Field(..., alias="showInAIActions", description="Whether to show this block in 'AI Labeling'. Only applies for standalone blocks.")
    ai_actions_operates_on: Optional[List[AIActionsOperatesOn]] = Field(None, alias="aiActionsOperatesOn", description="For AI labeling blocks, this lists the data types that the block supports. If this field is empty then there's no information about supported data types.")
    __properties = ["id", "ownerOrganizationId", "ownerOrganizationName", "name", "created", "lastUpdated", "description", "operatesOn", "allowExtraCliArguments", "parameters", "parametersUI", "repositoryUrl", "showInDataSources", "showInCreateTransformationJob", "showInSyntheticData", "showInAIActions", "aiActionsOperatesOn"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> PublicOrganizationTransformationBlock:
        """Create an instance of PublicOrganizationTransformationBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in parameters_ui (list)
        _items = []
        if self.parameters_ui:
            for _item in self.parameters_ui:
                if _item:
                    _items.append(_item.to_dict())
            _dict['parametersUI'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PublicOrganizationTransformationBlock:
        """Create an instance of PublicOrganizationTransformationBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PublicOrganizationTransformationBlock.construct(**obj)

        _obj = PublicOrganizationTransformationBlock.construct(**{
            "id": obj.get("id"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "owner_organization_name": obj.get("ownerOrganizationName"),
            "name": obj.get("name"),
            "created": obj.get("created"),
            "last_updated": obj.get("lastUpdated"),
            "description": obj.get("description"),
            "operates_on": obj.get("operatesOn"),
            "allow_extra_cli_arguments": obj.get("allowExtraCliArguments"),
            "parameters": obj.get("parameters"),
            "parameters_ui": [DSPGroupItem.from_dict(_item) for _item in obj.get("parametersUI")] if obj.get("parametersUI") is not None else None,
            "repository_url": obj.get("repositoryUrl"),
            "show_in_data_sources": obj.get("showInDataSources"),
            "show_in_create_transformation_job": obj.get("showInCreateTransformationJob"),
            "show_in_synthetic_data": obj.get("showInSyntheticData"),
            "show_in_ai_actions": obj.get("showInAIActions"),
            "ai_actions_operates_on": obj.get("aiActionsOperatesOn")
        })
        return _obj

