# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictStr, validator
from edgeimpulse_api.models.application_budget import ApplicationBudget
from edgeimpulse_api.models.target_constraints_device import TargetConstraintsDevice

class TargetConstraints(BaseModel):
    selected_target_based_on: Optional[StrictStr] = Field(None, alias="selectedTargetBasedOn", description="A type explaining how the target was chosen. If updating this manually, use the 'user-configured' type")
    target_devices: List[TargetConstraintsDevice] = Field(..., alias="targetDevices", description="The potential targets for the project, where each entry captures hardware attributes that allow target guidance throughout the Studio workflow. The first target in the list is considered as the selected target for the project.")
    application_budgets: List[ApplicationBudget] = Field(..., alias="applicationBudgets", description="A list of application budgets to be configured based on target device. An application budget enables guidance on performance and resource usage. The first application budget in the list is considered as the selected budget for the project.")
    __properties = ["selectedTargetBasedOn", "targetDevices", "applicationBudgets"]

    @validator('selected_target_based_on')
    def selected_target_based_on_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('user-configured', 'default', 'default-accepted', 'recent-project', 'connected-device'):
            raise ValueError("must validate the enum values ('user-configured', 'default', 'default-accepted', 'recent-project', 'connected-device')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> TargetConstraints:
        """Create an instance of TargetConstraints from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in target_devices (list)
        _items = []
        if self.target_devices:
            for _item in self.target_devices:
                if _item:
                    _items.append(_item.to_dict())
            _dict['targetDevices'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in application_budgets (list)
        _items = []
        if self.application_budgets:
            for _item in self.application_budgets:
                if _item:
                    _items.append(_item.to_dict())
            _dict['applicationBudgets'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TargetConstraints:
        """Create an instance of TargetConstraints from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TargetConstraints.construct(**obj)

        _obj = TargetConstraints.construct(**{
            "selected_target_based_on": obj.get("selectedTargetBasedOn"),
            "target_devices": [TargetConstraintsDevice.from_dict(_item) for _item in obj.get("targetDevices")] if obj.get("targetDevices") is not None else None,
            "application_budgets": [ApplicationBudget.from_dict(_item) for _item in obj.get("applicationBudgets")] if obj.get("applicationBudgets") is not None else None
        })
        return _obj

