# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.theme_colors import ThemeColors
from edgeimpulse_api.models.theme_favicon import ThemeFavicon
from edgeimpulse_api.models.theme_logos import ThemeLogos

class Theme(BaseModel):
    id: StrictInt = ...
    owner_user_id: Optional[StrictInt] = Field(None, alias="ownerUserId")
    owner_organization_id: Optional[StrictInt] = Field(None, alias="ownerOrganizationId")
    name: StrictStr = ...
    favicon: ThemeFavicon = ...
    logos: ThemeLogos = ...
    colors: ThemeColors = ...
    __properties = ["id", "ownerUserId", "ownerOrganizationId", "name", "favicon", "logos", "colors"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> Theme:
        """Create an instance of Theme from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of favicon
        if self.favicon:
            _dict['favicon'] = self.favicon.to_dict()
        # override the default output from pydantic by calling `to_dict()` of logos
        if self.logos:
            _dict['logos'] = self.logos.to_dict()
        # override the default output from pydantic by calling `to_dict()` of colors
        if self.colors:
            _dict['colors'] = self.colors.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Theme:
        """Create an instance of Theme from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Theme.construct(**obj)

        _obj = Theme.construct(**{
            "id": obj.get("id"),
            "owner_user_id": obj.get("ownerUserId"),
            "owner_organization_id": obj.get("ownerOrganizationId"),
            "name": obj.get("name"),
            "favicon": ThemeFavicon.from_dict(obj.get("favicon")) if obj.get("favicon") is not None else None,
            "logos": ThemeLogos.from_dict(obj.get("logos")) if obj.get("logos") is not None else None,
            "colors": ThemeColors.from_dict(obj.get("colors")) if obj.get("colors") is not None else None
        })
        return _obj

