# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.block_display_category import BlockDisplayCategory
from edgeimpulse_api.models.block_type import BlockType
from edgeimpulse_api.models.dsp_group_item import DSPGroupItem
from edgeimpulse_api.models.keras_visual_layer_type import KerasVisualLayerType
from edgeimpulse_api.models.learn_block_type import LearnBlockType
from edgeimpulse_api.models.transfer_learning_model_block_no_longer_available import TransferLearningModelBlockNoLongerAvailable

class TransferLearningModel(BaseModel):
    name: StrictStr = ...
    short_name: StrictStr = Field(..., alias="shortName")
    abbreviated_name: Optional[StrictStr] = Field(None, alias="abbreviatedName")
    description: StrictStr = ...
    has_neurons: StrictBool = Field(..., alias="hasNeurons")
    has_dropout: StrictBool = Field(..., alias="hasDropout")
    default_neurons: Optional[StrictInt] = Field(None, alias="defaultNeurons")
    default_dropout: Optional[float] = Field(None, alias="defaultDropout")
    default_learning_rate: Optional[float] = Field(None, alias="defaultLearningRate")
    default_training_cycles: Optional[float] = Field(None, alias="defaultTrainingCycles")
    has_image_augmentation: Optional[StrictBool] = Field(None, alias="hasImageAugmentation")
    type: KerasVisualLayerType = ...
    learn_block_type: LearnBlockType = Field(..., alias="learnBlockType")
    organization_model_id: Optional[StrictInt] = Field(None, alias="organizationModelId")
    implementation_version: Optional[StrictInt] = Field(None, alias="implementationVersion")
    repository_url: Optional[StrictStr] = Field(None, alias="repositoryUrl", description="URL to the source code of this custom learn block.")
    author: StrictStr = ...
    block_type: BlockType = Field(..., alias="blockType")
    custom_parameters: Optional[List[DSPGroupItem]] = Field(None, alias="customParameters")
    display_category: Optional[BlockDisplayCategory] = Field(None, alias="displayCategory")
    block_no_longer_available: Optional[TransferLearningModelBlockNoLongerAvailable] = Field(None, alias="blockNoLongerAvailable")
    __properties = ["name", "shortName", "abbreviatedName", "description", "hasNeurons", "hasDropout", "defaultNeurons", "defaultDropout", "defaultLearningRate", "defaultTrainingCycles", "hasImageAugmentation", "type", "learnBlockType", "organizationModelId", "implementationVersion", "repositoryUrl", "author", "blockType", "customParameters", "displayCategory", "blockNoLongerAvailable"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> TransferLearningModel:
        """Create an instance of TransferLearningModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in custom_parameters (list)
        _items = []
        if self.custom_parameters:
            for _item in self.custom_parameters:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customParameters'] = _items
        # override the default output from pydantic by calling `to_dict()` of block_no_longer_available
        if self.block_no_longer_available:
            _dict['blockNoLongerAvailable'] = self.block_no_longer_available.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransferLearningModel:
        """Create an instance of TransferLearningModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransferLearningModel.construct(**obj)

        _obj = TransferLearningModel.construct(**{
            "name": obj.get("name"),
            "short_name": obj.get("shortName"),
            "abbreviated_name": obj.get("abbreviatedName"),
            "description": obj.get("description"),
            "has_neurons": obj.get("hasNeurons"),
            "has_dropout": obj.get("hasDropout"),
            "default_neurons": obj.get("defaultNeurons"),
            "default_dropout": obj.get("defaultDropout"),
            "default_learning_rate": obj.get("defaultLearningRate"),
            "default_training_cycles": obj.get("defaultTrainingCycles"),
            "has_image_augmentation": obj.get("hasImageAugmentation"),
            "type": obj.get("type"),
            "learn_block_type": obj.get("learnBlockType"),
            "organization_model_id": obj.get("organizationModelId"),
            "implementation_version": obj.get("implementationVersion"),
            "repository_url": obj.get("repositoryUrl"),
            "author": obj.get("author"),
            "block_type": obj.get("blockType"),
            "custom_parameters": [DSPGroupItem.from_dict(_item) for _item in obj.get("customParameters")] if obj.get("customParameters") is not None else None,
            "display_category": obj.get("displayCategory"),
            "block_no_longer_available": TransferLearningModelBlockNoLongerAvailable.from_dict(obj.get("blockNoLongerAvailable")) if obj.get("blockNoLongerAvailable") is not None else None
        })
        return _obj

