# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.keras_model_variant_enum import KerasModelVariantEnum
from edgeimpulse_api.models.model_engine_short_enum import ModelEngineShortEnum
from edgeimpulse_api.models.project_visibility import ProjectVisibility
from edgeimpulse_api.models.tutorial_type import TutorialType

class UpdateProjectRequest(BaseModel):
    logo: Optional[StrictStr] = Field(None, description="New logo URL, or set to `null` to remove the logo.")
    name: Optional[StrictStr] = Field(None, description="New project name.")
    description: Optional[StrictStr] = None
    project_visibility: Optional[ProjectVisibility] = Field(None, alias="projectVisibility")
    public_project_listed: Optional[StrictBool] = Field(None, alias="publicProjectListed", description="If the project allows public access, whether to list it the public projects overview response. If not listed, the project is still accessible via direct link. If the project does not allow public access, this field has no effect. ")
    last_deploy_eon_compiler: Optional[StrictBool] = Field(None, alias="lastDeployEonCompiler", description="Call this when clicking the Eon compiler setting")
    last_deploy_model_engine: Optional[StrictStr] = Field(None, alias="lastDeployModelEngine")
    latency_device: Optional[StrictStr] = Field(None, alias="latencyDevice", description="MCU used for calculating latency")
    experiments: Optional[List[StrictStr]] = None
    show_create_first_impulse: Optional[StrictBool] = Field(None, alias="showCreateFirstImpulse", description="Whether to show the 'Create your first impulse' section on the dashboard")
    labeling_method: Optional[StrictStr] = Field(None, alias="labelingMethod", description="What labeling flow to use")
    selected_project_type_in_wizard: Optional[StrictStr] = Field(None, alias="selectedProjectTypeInWizard", description="Which option was selected in the project type wizard")
    getting_started_step: Optional[StrictInt] = Field(None, alias="gettingStartedStep", description="The next step in the getting started wizard, or set to -1 to clear the getting started wizard")
    getting_started_tutorial: Optional[TutorialType] = Field(None, alias="gettingStartedTutorial")
    getting_started_classes: Optional[List[StrictStr]] = Field(None, alias="gettingStartedClasses", description="Classes or labels used in the getting started wizard")
    use_gpu: Optional[StrictBool] = Field(None, alias="useGpu", description="Whether to use GPU for training")
    compute_time_limit_m: Optional[StrictInt] = Field(None, alias="computeTimeLimitM", description="Job limit in minutes")
    dsp_file_size_mb: Optional[StrictInt] = Field(None, alias="dspFileSizeMb", description="DSP file size in MB")
    enterprise_performance: Optional[StrictBool] = Field(None, alias="enterprisePerformance")
    train_job_ram_mb: Optional[StrictInt] = Field(None, alias="trainJobRamMb", description="Amount of RAM allocated to training jobs")
    metadata: Optional[Dict[str, Any]] = Field(None, description="New metadata about the project")
    readme: Optional[StrictStr] = Field(None, description="Readme for the project (in Markdown)")
    last_acquisition_label: Optional[StrictStr] = Field(None, alias="lastAcquisitionLabel")
    train_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="trainJobNotificationUids", description="The IDs of users who should be notified when a Keras or retrain job is finished.")
    dsp_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="dspJobNotificationUids", description="The IDs of users who should be notified when a DSP job is finished.")
    model_testing_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="modelTestingJobNotificationUids", description="The IDs of users who should be notified when a model testing job is finished.")
    export_job_notification_uids: Optional[List[StrictInt]] = Field(None, alias="exportJobNotificationUids", description="The IDs of users who should be notified when an export job is finished.")
    csv_import_config: Optional[Dict[str, Any]] = Field(None, alias="csvImportConfig", description="Config file specifying how to process CSV files. (set to null to clear the config)")
    in_pretrained_model_flow: Optional[StrictBool] = Field(None, alias="inPretrainedModelFlow")
    dsp_page_size: Optional[StrictInt] = Field(None, alias="dspPageSize", description="Set to '0' to disable DSP paging")
    ind_pause_processing_samples: Optional[StrictBool] = Field(None, alias="indPauseProcessingSamples", description="Used in tests, to ensure samples that need to be processed async are not picked up until the flag is set to FALSE again.")
    show_sensor_data_in_acquisition_graph: Optional[StrictBool] = Field(None, alias="showSensorDataInAcquisitionGraph", description="Whether to show the actual sensor data in acquisition charts (only applies when you have structured labels)")
    last_deployment_target: Optional[StrictStr] = Field(None, alias="lastDeploymentTarget", description="Which deployment target was last selected (used to populate this deployment target again the next time you visit the deployment page). Should match the _format_ property of the response from listDeploymentTargetsForProject.")
    data_acquisition_page_size: Optional[StrictInt] = Field(None, alias="dataAcquisitionPageSize", description="Default page size on data acquisition")
    data_acquisition_view_type: Optional[StrictStr] = Field(None, alias="dataAcquisitionViewType", description="Default view type on data acquisition")
    data_acquisition_grid_column_count: Optional[StrictInt] = Field(None, alias="dataAcquisitionGridColumnCount", description="Number of grid columns in non-detailed view on data acquisition")
    data_acquisition_grid_column_count_detailed: Optional[StrictInt] = Field(None, alias="dataAcquisitionGridColumnCountDetailed", description="Number of grid columns in detailed view on data acquisition")
    show_exact_sample_length: Optional[StrictBool] = Field(None, alias="showExactSampleLength", description="If enabled, does not round sample length to hours/minutes/seconds, but always displays sample length in milliseconds. E.g. instead of 1m 32s, this'll say 92,142ms.")
    inline_edit_bounding_boxes: Optional[StrictBool] = Field(None, alias="inlineEditBoundingBoxes", description="If enabled, allows editing bounding box labels directly from the acquisition UI.")
    default_profiling_variant: Optional[KerasModelVariantEnum] = Field(None, alias="defaultProfilingVariant")
    enabled_model_profiling_variants: Optional[List[KerasModelVariantEnum]] = Field(None, alias="enabledModelProfilingVariants", description="Set of model variants enabled by default on the model testing and live classification pages.")
    impulse_list_core_metrics_hidden_columns: Optional[List[StrictStr]] = Field(None, alias="impulseListCoreMetricsHiddenColumns", description="Which core metrics should be hidden in the impulse list. See 'GetAllDetailedImpulsesResponse' for a list of all metrics.")
    impulse_list_additional_metrics_shown_columns: Optional[List[StrictStr]] = Field(None, alias="impulseListAdditionalMetricsShownColumns", description="Which additional metrics should be shown in the impulse list. See 'GetAllDetailedImpulsesResponse' for a list of all metrics.")
    impulse_list_extra_columns: Optional[List[StrictStr]] = Field(None, alias="impulseListExtraColumns", description="Which extra columns should be shown in the impulse list.")
    ai_actions_grid_column_count: Optional[StrictInt] = Field(None, alias="aiActionsGridColumnCount", description="Number of grid columns in AI Actions")
    last_shown_model_engine: Optional[ModelEngineShortEnum] = Field(None, alias="lastShownModelEngine")
    versioning_storage_size_mib: Optional[StrictInt] = Field(None, alias="versioningStorageSizeMib")
    __properties = ["logo", "name", "description", "projectVisibility", "publicProjectListed", "lastDeployEonCompiler", "lastDeployModelEngine", "latencyDevice", "experiments", "showCreateFirstImpulse", "labelingMethod", "selectedProjectTypeInWizard", "gettingStartedStep", "gettingStartedTutorial", "gettingStartedClasses", "useGpu", "computeTimeLimitM", "dspFileSizeMb", "enterprisePerformance", "trainJobRamMb", "metadata", "readme", "lastAcquisitionLabel", "trainJobNotificationUids", "dspJobNotificationUids", "modelTestingJobNotificationUids", "exportJobNotificationUids", "csvImportConfig", "inPretrainedModelFlow", "dspPageSize", "indPauseProcessingSamples", "showSensorDataInAcquisitionGraph", "lastDeploymentTarget", "dataAcquisitionPageSize", "dataAcquisitionViewType", "dataAcquisitionGridColumnCount", "dataAcquisitionGridColumnCountDetailed", "showExactSampleLength", "inlineEditBoundingBoxes", "defaultProfilingVariant", "enabledModelProfilingVariants", "impulseListCoreMetricsHiddenColumns", "impulseListAdditionalMetricsShownColumns", "impulseListExtraColumns", "aiActionsGridColumnCount", "lastShownModelEngine", "versioningStorageSizeMib"]

    @validator('labeling_method')
    def labeling_method_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('single_label', 'object_detection'):
            raise ValueError("must validate the enum values ('single_label', 'object_detection')")
        return v

    @validator('selected_project_type_in_wizard')
    def selected_project_type_in_wizard_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('accelerometer', 'audio', 'image_classification', 'object_detection', 'something_else'):
            raise ValueError("must validate the enum values ('accelerometer', 'audio', 'image_classification', 'object_detection', 'something_else')")
        return v

    @validator('data_acquisition_view_type')
    def data_acquisition_view_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('list', 'grid'):
            raise ValueError("must validate the enum values ('list', 'grid')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> UpdateProjectRequest:
        """Create an instance of UpdateProjectRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UpdateProjectRequest:
        """Create an instance of UpdateProjectRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UpdateProjectRequest.construct(**obj)

        _obj = UpdateProjectRequest.construct(**{
            "logo": obj.get("logo"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "project_visibility": obj.get("projectVisibility"),
            "public_project_listed": obj.get("publicProjectListed"),
            "last_deploy_eon_compiler": obj.get("lastDeployEonCompiler"),
            "last_deploy_model_engine": obj.get("lastDeployModelEngine"),
            "latency_device": obj.get("latencyDevice"),
            "experiments": obj.get("experiments"),
            "show_create_first_impulse": obj.get("showCreateFirstImpulse"),
            "labeling_method": obj.get("labelingMethod"),
            "selected_project_type_in_wizard": obj.get("selectedProjectTypeInWizard"),
            "getting_started_step": obj.get("gettingStartedStep"),
            "getting_started_tutorial": obj.get("gettingStartedTutorial"),
            "getting_started_classes": obj.get("gettingStartedClasses"),
            "use_gpu": obj.get("useGpu"),
            "compute_time_limit_m": obj.get("computeTimeLimitM"),
            "dsp_file_size_mb": obj.get("dspFileSizeMb"),
            "enterprise_performance": obj.get("enterprisePerformance"),
            "train_job_ram_mb": obj.get("trainJobRamMb"),
            "metadata": obj.get("metadata"),
            "readme": obj.get("readme"),
            "last_acquisition_label": obj.get("lastAcquisitionLabel"),
            "train_job_notification_uids": obj.get("trainJobNotificationUids"),
            "dsp_job_notification_uids": obj.get("dspJobNotificationUids"),
            "model_testing_job_notification_uids": obj.get("modelTestingJobNotificationUids"),
            "export_job_notification_uids": obj.get("exportJobNotificationUids"),
            "csv_import_config": obj.get("csvImportConfig"),
            "in_pretrained_model_flow": obj.get("inPretrainedModelFlow"),
            "dsp_page_size": obj.get("dspPageSize"),
            "ind_pause_processing_samples": obj.get("indPauseProcessingSamples"),
            "show_sensor_data_in_acquisition_graph": obj.get("showSensorDataInAcquisitionGraph"),
            "last_deployment_target": obj.get("lastDeploymentTarget"),
            "data_acquisition_page_size": obj.get("dataAcquisitionPageSize"),
            "data_acquisition_view_type": obj.get("dataAcquisitionViewType"),
            "data_acquisition_grid_column_count": obj.get("dataAcquisitionGridColumnCount"),
            "data_acquisition_grid_column_count_detailed": obj.get("dataAcquisitionGridColumnCountDetailed"),
            "show_exact_sample_length": obj.get("showExactSampleLength"),
            "inline_edit_bounding_boxes": obj.get("inlineEditBoundingBoxes"),
            "default_profiling_variant": obj.get("defaultProfilingVariant"),
            "enabled_model_profiling_variants": obj.get("enabledModelProfilingVariants"),
            "impulse_list_core_metrics_hidden_columns": obj.get("impulseListCoreMetricsHiddenColumns"),
            "impulse_list_additional_metrics_shown_columns": obj.get("impulseListAdditionalMetricsShownColumns"),
            "impulse_list_extra_columns": obj.get("impulseListExtraColumns"),
            "ai_actions_grid_column_count": obj.get("aiActionsGridColumnCount"),
            "last_shown_model_engine": obj.get("lastShownModelEngine"),
            "versioning_storage_size_mib": obj.get("versioningStorageSizeMib")
        })
        return _obj

