# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.storage_provider import StorageProvider

class VerifyOrganizationBucketRequest(BaseModel):
    storage_provider: Optional[StorageProvider] = Field(None, alias="storageProvider")
    access_key: StrictStr = Field(..., alias="accessKey", description="Access key for the storage service: - For S3 and GCS: Use the access key. - For Azure: Use the Storage Account Name. ")
    secret_key: Optional[StrictStr] = Field(None, alias="secretKey", description="Secret key for the storage service: - For S3 and GCS: Use the secret key. - For Azure: Use the Storage Account Access Key. Note: You should either pass a `secretKey` value or a `bucketId` value. ")
    bucket_id: Optional[StrictInt] = Field(None, alias="bucketId", description="ID of an existing bucket. If provided, the credentials from this bucket will be used unless overridden by the `secretKey` property. ")
    bucket: StrictStr = Field(..., description="Name of the storage bucket or container.")
    endpoint: StrictStr = Field(..., description="Endpoint URL for the storage service. For S3-compatible services, Azure, or custom endpoints. ")
    region: Optional[StrictStr] = Field(None, description="Optional region of the storage service (if applicable).")
    prefix: Optional[StrictStr] = Field(None, description="Optional prefix within the bucket. Set this if you don't have access to the full bucket or want to limit the scope. ")
    __properties = ["storageProvider", "accessKey", "secretKey", "bucketId", "bucket", "endpoint", "region", "prefix"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> VerifyOrganizationBucketRequest:
        """Create an instance of VerifyOrganizationBucketRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerifyOrganizationBucketRequest:
        """Create an instance of VerifyOrganizationBucketRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VerifyOrganizationBucketRequest.construct(**obj)

        _obj = VerifyOrganizationBucketRequest.construct(**{
            "storage_provider": obj.get("storageProvider"),
            "access_key": obj.get("accessKey"),
            "secret_key": obj.get("secretKey"),
            "bucket_id": obj.get("bucketId"),
            "bucket": obj.get("bucket"),
            "endpoint": obj.get("endpoint"),
            "region": obj.get("region"),
            "prefix": obj.get("prefix")
        })
        return _obj

