
# passguard-assistant

A privacy-friendly **Password Health + Security Assistant** library.

- Checks password strength
- Suggests strong passwords
- Rotation reminders (1, 3, 6 months) with "remembered or not" logic
- Failed-attempt logging with optional email alerts
- Simple CLI

> No OS-level monitoring. Use the provided hooks inside your app/backend.

## Local Install (dev)
```bash
pip install -U build twine
pip install .
```

## Quickstart
```python
from passguard_assistant import PassGuard

pg = PassGuard(admin_email="admin@example.com")

print(pg.check_strength("HelloWorld123!"))
print(pg.suggest_password(length=16, ensure_all_classes=True))

print(pg.reset_reminder(months=3, remember_flag=1))

pg.log_attempt(success=False, ip="203.0.113.42", user_agent="Mozilla/5.0", username="sathish")
pg.log_attempt(success=False, ip="203.0.113.42", user_agent="Mozilla/5.0", username="sathish")
pg.log_attempt(success=False, ip="203.0.113.42", user_agent="Mozilla/5.0", username="sathish")  # should trigger alert
```

### SMTP via environment variables
```
PASSGUARD_SMTP_HOST=smtp.example.com
PASSGUARD_SMTP_PORT=587
PASSGUARD_SMTP_USER=apikey
PASSGUARD_SMTP_PASS=yourpassword
PASSGUARD_FROM_EMAIL=alerts@example.com
```

## CLI
```bash
passguard check "HelloWorld123!"
passguard suggest --length 20
passguard log --failed --ip 203.0.113.42 --username alice
```

## Build & Publish (when ready)
```bash
python -m build
twine upload dist/*
```
