"""Forms and fields for apps to use."""

from nautobot.core.forms import (
    add_blank_choice,
    AddressFieldMixin,
    BootstrapMixin,
    BulkEditForm,
    BulkRenameForm,
    ConfirmationForm,
    CSVModelForm,
    DynamicFilterForm,
    ImportForm,
    PrefixFieldMixin,
    ReturnURLForm,
    TableConfigForm,
)
from nautobot.core.forms.fields import (
    CommentField,
    CSVChoiceField,
    CSVContentTypeField,
    CSVDataField,
    CSVFileField,
    CSVModelChoiceField,
    CSVMultipleChoiceField,
    CSVMultipleContentTypeField,
    DynamicModelChoiceField,
    DynamicModelChoiceMixin,
    DynamicModelMultipleChoiceField,
    ExpandableIPAddressField,
    ExpandableNameField,
    JSONArrayFormField,
    JSONField,
    LaxURLField,
    MACAddressField,
    MultiMatchModelMultipleChoiceField,
    MultipleContentTypeField,
    MultiValueCharField,
    NullableDateField,
    NumericArrayField,
    SlugField,
    TagFilterField,
)
from nautobot.core.forms.forms import dynamic_formset_factory
from nautobot.core.forms.utils import (
    add_field_to_filter_form_class,
    expand_alphanumeric_pattern,
    expand_ipaddress_pattern,
    form_from_model,
    parse_alphanumeric_range,
    parse_numeric_range,
    restrict_form_fields,
)
from nautobot.core.forms.widgets import (
    APISelect,
    APISelectMultiple,
    AutoPopulateWidget,
    BulkEditNullBooleanSelect,
    ColorSelect,
    ContentTypeSelect,
    DatePicker,
    DateTimePicker,
    MultiValueCharInput,
    SelectWithDisabled,
    SelectWithPK,
    SlugWidget,
    SmallTextarea,
    StaticSelect2,
    StaticSelect2Multiple,
    TimePicker,
)
from nautobot.extras.forms import (
    CustomFieldModelBulkEditFormMixin,
    CustomFieldModelCSVForm,
    CustomFieldModelFormMixin,
    DynamicGroupModelFormMixin,
    NautobotBulkEditForm,
    NautobotModelForm,
    NoteModelBulkEditFormMixin,
    NoteModelFormMixin,
    RelationshipModelBulkEditFormMixin,
    RelationshipModelFormMixin,
    StatusModelBulkEditFormMixin,
    TagsBulkEditFormMixin,
)
from nautobot.extras.forms.base import NautobotFilterForm
from nautobot.extras.forms.forms import (
    get_git_datasource_content_choices,
    provider_choices,
    provider_choices_with_blank,
)
from nautobot.extras.forms.mixins import (
    ContactTeamModelFilterFormMixin,
    CustomFieldModelFilterFormMixin,
    NoteFormBase,
    RelationshipModelFilterFormMixin,
    RoleModelBulkEditFormMixin,
    RoleModelFilterFormMixin,
    StatusModelFilterFormMixin,
)
from nautobot.ipam.formfields import IPAddressFormField, IPNetworkFormField

__all__ = (
    "APISelect",
    "APISelectMultiple",
    "AddressFieldMixin",
    "AutoPopulateWidget",
    "BootstrapMixin",
    "BulkEditForm",
    "BulkEditNullBooleanSelect",
    "BulkRenameForm",
    "CSVChoiceField",
    "CSVContentTypeField",
    "CSVDataField",
    "CSVFileField",
    "CSVModelChoiceField",
    "CSVModelForm",
    "CSVMultipleChoiceField",
    "CSVMultipleContentTypeField",
    "ColorSelect",
    "CommentField",
    "ConfirmationForm",
    "ContactTeamModelFilterFormMixin",
    "ContentTypeSelect",
    "CustomFieldModelBulkEditFormMixin",
    "CustomFieldModelCSVForm",
    "CustomFieldModelFilterFormMixin",
    "CustomFieldModelFormMixin",
    "DatePicker",
    "DateTimePicker",
    "DynamicFilterForm",
    "DynamicGroupModelFormMixin",
    "DynamicModelChoiceField",
    "DynamicModelChoiceMixin",
    "DynamicModelMultipleChoiceField",
    "ExpandableIPAddressField",
    "ExpandableNameField",
    "IPAddressFormField",
    "IPNetworkFormField",
    "ImportForm",
    "JSONArrayFormField",
    "JSONField",
    "LaxURLField",
    "MACAddressField",
    "MultiMatchModelMultipleChoiceField",
    "MultiValueCharField",
    "MultiValueCharInput",
    "MultipleContentTypeField",
    "NautobotBulkEditForm",
    "NautobotFilterForm",
    "NautobotModelForm",
    "NoteFormBase",
    "NoteModelBulkEditFormMixin",
    "NoteModelFormMixin",
    "NullableDateField",
    "NumericArrayField",
    "PrefixFieldMixin",
    "RelationshipModelBulkEditFormMixin",
    "RelationshipModelFilterFormMixin",
    "RelationshipModelFormMixin",
    "ReturnURLForm",
    "RoleModelBulkEditFormMixin",
    "RoleModelFilterFormMixin",
    "SelectWithDisabled",
    "SelectWithPK",
    "SlugField",
    "SlugWidget",
    "SmallTextarea",
    "StaticSelect2",
    "StaticSelect2Multiple",
    "StatusModelBulkEditFormMixin",
    "StatusModelFilterFormMixin",
    "TableConfigForm",
    "TagFilterField",
    "TagsBulkEditFormMixin",
    "TimePicker",
    "add_blank_choice",
    "add_field_to_filter_form_class",
    "dynamic_formset_factory",
    "expand_alphanumeric_pattern",
    "expand_ipaddress_pattern",
    "form_from_model",
    "get_git_datasource_content_choices",
    "parse_alphanumeric_range",
    "parse_numeric_range",
    "provider_choices",
    "provider_choices_with_blank",
    "restrict_form_fields",
)
