# Generated by Django 3.2.16 on 2023-01-31 04:17

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("tenancy", "0005_rename_foreign_keys_and_related_names"),
        ("dcim", "0035_rename_path_end_point_related_name"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="powerpanel",
            options={"ordering": ["location", "name"]},
        ),
        migrations.AlterModelOptions(
            name="rack",
            options={"ordering": ("location", "group", "_name")},
        ),
        migrations.RemoveField(
            model_name="location",
            name="site",
        ),
        migrations.RemoveField(
            model_name="rack",
            name="site",
        ),
        migrations.AlterField(
            model_name="device",
            name="location",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="devices", to="dcim.location"
            ),
        ),
        migrations.AlterField(
            model_name="powerpanel",
            name="location",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="powerpanels", to="dcim.location"
            ),
        ),
        migrations.AlterField(
            model_name="rack",
            name="location",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="racks", to="dcim.location"
            ),
        ),
        migrations.AlterField(
            model_name="rackgroup",
            name="location",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="rack_groups", to="dcim.location"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="device",
            unique_together={
                ("virtual_chassis", "vc_position"),
                ("location", "tenant", "name"),
                ("rack", "position", "face"),
            },
        ),
        migrations.AlterUniqueTogether(
            name="powerpanel",
            unique_together={("location", "name")},
        ),
        migrations.AlterUniqueTogether(
            name="rackgroup",
            unique_together={("location", "slug"), ("location", "name")},
        ),
        migrations.RemoveField(
            model_name="device",
            name="site",
        ),
        migrations.RemoveField(
            model_name="powerpanel",
            name="site",
        ),
        migrations.RemoveField(
            model_name="rackgroup",
            name="site",
        ),
    ]
