# Generated by Django 3.2.17 on 2023-02-17 17:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion

import nautobot.core.models.fields


class Migration(migrations.Migration):
    dependencies = [
        ("tenancy", "0006_created_datetime"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("dcim", "0037_created_datetime"),
    ]

    operations = [
        migrations.RenameField(
            model_name="poweroutlettemplate",
            old_name="power_port",
            new_name="power_port_template",
        ),
        migrations.AlterField(
            model_name="poweroutlettemplate",
            name="power_port_template",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="power_outlet_templates",
                to="dcim.powerporttemplate",
            ),
        ),
        migrations.RenameField(
            model_name="frontporttemplate",
            old_name="rear_port",
            new_name="rear_port_template",
        ),
        migrations.AlterField(
            model_name="frontporttemplate",
            name="rear_port_template",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="front_port_templates",
                to="dcim.rearporttemplate",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="frontporttemplate",
            unique_together={("device_type", "name"), ("rear_port_template", "rear_port_position")},
        ),
        migrations.AlterField(
            model_name="consoleport",
            name="_path",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="console_ports",
                to="dcim.cablepath",
            ),
        ),
        migrations.AlterField(
            model_name="consoleport",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="console_ports", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="consoleporttemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="console_port_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="consoleserverport",
            name="_path",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="console_server_ports",
                to="dcim.cablepath",
            ),
        ),
        migrations.AlterField(
            model_name="consoleserverport",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="console_server_ports", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="consoleserverporttemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="console_server_port_templates",
                to="dcim.devicetype",
            ),
        ),
        migrations.AlterField(
            model_name="device",
            name="device_redundancy_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="devices",
                to="dcim.deviceredundancygroup",
            ),
        ),
        migrations.AlterField(
            model_name="device",
            name="device_type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="devices", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="devicebay",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="device_bays", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="devicebaytemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="device_bay_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="frontport",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="front_ports", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="frontport",
            name="rear_port",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="front_ports", to="dcim.rearport"
            ),
        ),
        migrations.AlterField(
            model_name="frontporttemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="front_port_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="interface",
            name="_path",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="interfaces",
                to="dcim.cablepath",
            ),
        ),
        migrations.AlterField(
            model_name="interface",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="interfaces", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="interfacetemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="interface_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="inventoryitem",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="inventory_items", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="powerfeed",
            name="_path",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="power_feeds",
                to="dcim.cablepath",
            ),
        ),
        migrations.AlterField(
            model_name="powerfeed",
            name="power_panel",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="power_feeds", to="dcim.powerpanel"
            ),
        ),
        migrations.AlterField(
            model_name="powerfeed",
            name="rack",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="power_feeds",
                to="dcim.rack",
            ),
        ),
        migrations.AlterField(
            model_name="poweroutlet",
            name="_path",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="power_outlets",
                to="dcim.cablepath",
            ),
        ),
        migrations.AlterField(
            model_name="poweroutlet",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="power_outlets", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="poweroutlet",
            name="power_port",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="power_outlets",
                to="dcim.powerport",
            ),
        ),
        migrations.AlterField(
            model_name="poweroutlettemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="power_outlet_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="powerpanel",
            name="location",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="power_panels", to="dcim.location"
            ),
        ),
        migrations.AlterField(
            model_name="powerpanel",
            name="rack_group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="power_panels",
                to="dcim.rackgroup",
            ),
        ),
        migrations.AlterField(
            model_name="powerport",
            name="_path",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="power_ports",
                to="dcim.cablepath",
            ),
        ),
        migrations.AlterField(
            model_name="powerport",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="power_ports", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="powerporttemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="power_port_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterField(
            model_name="rackreservation",
            name="rack",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="rack_reservations", to="dcim.rack"
            ),
        ),
        migrations.AlterField(
            model_name="rackreservation",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="rack_reservations",
                to="tenancy.tenant",
            ),
        ),
        migrations.AlterField(
            model_name="rackreservation",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="rack_reservations",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="rearport",
            name="device",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="rear_ports", to="dcim.device"
            ),
        ),
        migrations.AlterField(
            model_name="rearporttemplate",
            name="device_type",
            field=nautobot.core.models.fields.ForeignKeyWithAutoRelatedName(
                on_delete=django.db.models.deletion.CASCADE, related_name="rear_port_templates", to="dcim.devicetype"
            ),
        ),
        migrations.AlterModelOptions(
            name="rack",
            options={"ordering": ("location", "rack_group", "_name")},
        ),
        migrations.RenameField(
            model_name="rack",
            old_name="group",
            new_name="rack_group",
        ),
        migrations.AlterField(
            model_name="frontporttemplate",
            name="rear_port_template",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="front_port_templates",
                to="dcim.rearporttemplate",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="rack",
            unique_together={("rack_group", "facility_id"), ("rack_group", "name")},
        ),
        migrations.AlterField(
            model_name="device",
            name="secrets_group",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="devices",
                to="extras.secretsgroup",
            ),
        ),
        migrations.AlterField(
            model_name="deviceredundancygroup",
            name="secrets_group",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="device_redundancy_groups",
                to="extras.secretsgroup",
            ),
        ),
    ]
