# Generated by Django 4.2.23 on 2025-08-11 21:07

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("dcim", "0071_alter_consoleport_options_and_more"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="powerfeed",
            options={"ordering": ["power_panel", "breaker_position", "name"]},
        ),
        migrations.AlterUniqueTogether(
            name="powerfeed",
            unique_together={("power_panel", "name")},
        ),
        migrations.AddField(
            model_name="powerfeed",
            name="breaker_pole_count",
            field=models.PositiveSmallIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="powerfeed",
            name="breaker_position",
            field=models.PositiveIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="powerfeed",
            name="destination_panel",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="feeders",
                to="dcim.powerpanel",
            ),
        ),
        migrations.AddField(
            model_name="powerfeed",
            name="power_path",
            field=models.CharField(blank=True, max_length=20),
        ),
        migrations.AddField(
            model_name="powerpanel",
            name="breaker_position_count",
            field=models.PositiveIntegerField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="powerpanel",
            name="panel_type",
            field=models.CharField(blank=True, max_length=30),
        ),
        migrations.AddField(
            model_name="powerpanel",
            name="power_path",
            field=models.CharField(blank=True, max_length=20),
        ),
        migrations.AddField(
            model_name="powerport",
            name="power_factor",
            field=models.DecimalField(
                decimal_places=2,
                default="0.95",
                max_digits=4,
                validators=[
                    django.core.validators.MinValueValidator(0.01),
                    django.core.validators.MaxValueValidator(1.0),
                ],
            ),
        ),
        migrations.AddField(
            model_name="powerporttemplate",
            name="power_factor",
            field=models.DecimalField(
                decimal_places=2,
                default="0.95",
                max_digits=4,
                validators=[
                    django.core.validators.MinValueValidator(0.01),
                    django.core.validators.MaxValueValidator(1.0),
                ],
            ),
        ),
        migrations.AlterUniqueTogether(
            name="powerfeed",
            unique_together={("power_panel", "breaker_position"), ("power_panel", "name")},
        ),
        migrations.AddIndex(
            model_name="powerfeed",
            index=models.Index(fields=["power_panel", "breaker_position"], name="dcim_powerf_power_p_b4d96d_idx"),
        ),
    ]
