# Generated by Django 3.2.22 on 2023-11-01 21:29

import uuid

import django.core.serializers.json
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion

import nautobot.core.models.fields
import nautobot.core.models.validators
import nautobot.extras.models.mixins


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0100_fileproxy_job_result"),
    ]

    operations = [
        migrations.CreateModel(
            name="ExternalIntegration",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                (
                    "remote_url",
                    models.CharField(
                        max_length=500, validators=[nautobot.core.models.validators.EnhancedURLValidator()]
                    ),
                ),
                ("verify_ssl", models.BooleanField(default=True)),
                ("timeout", models.IntegerField(default=30, validators=[django.core.validators.MinValueValidator(0)])),
                ("extra_config", models.JSONField(blank=True, null=True)),
                (
                    "secrets_group",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to="extras.secretsgroup"
                    ),
                ),
                ("tags", nautobot.core.models.fields.TagsField(through="extras.TaggedItem", to="extras.Tag")),
                ("ca_file_path", models.CharField(blank=True, max_length=255)),
                (
                    "headers",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("http_method", models.CharField(blank=True, max_length=10)),
            ],
            options={
                "ordering": ["name"],
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
    ]
