# Generated by Django 3.2.18 on 2023-03-14 21:24

import uuid

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion

import nautobot.extras.models.mixins
import nautobot.ipam.models


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0072_rename_model_fields"),
        ("ipam", "0029_ip_address_to_interface_uniqueness_constraints"),
    ]

    operations = [
        migrations.CreateModel(
            name="VRFPrefixAssignment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                (
                    "prefix",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="vrf_assignments", to="ipam.prefix"
                    ),
                ),
                (
                    "vrf",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name="+", to="ipam.vrf"),
                ),
            ],
            options={
                "unique_together": {("vrf", "prefix")},
            },
        ),
        migrations.CreateModel(
            name="VRFDeviceAssignment",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("rd", models.CharField(blank=True, max_length=21, null=True)),
                ("name", models.CharField(blank=True, max_length=100)),
                (
                    "device",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="vrf_assignments",
                        to="dcim.device",
                    ),
                ),
                (
                    "virtual_machine",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="vrf_assignments",
                        to="virtualization.virtualmachine",
                    ),
                ),
                (
                    "vrf",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="device_assignments", to="ipam.vrf"
                    ),
                ),
            ],
            options={
                "unique_together": {
                    ("vrf", "virtual_machine"),
                    ("vrf", "device"),
                },
            },
        ),
        migrations.CreateModel(
            name="Namespace",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(db_index=True, max_length=255, unique=True)),
                ("description", models.CharField(blank=True, max_length=200)),
                (
                    "location",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="namespaces",
                        to="dcim.location",
                    ),
                ),
                ("tags", nautobot.core.models.fields.TagsField(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "abstract": False,
                "ordering": ("name",),
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
        migrations.AddField(
            model_name="prefix",
            name="ip_version",
            field=models.IntegerField(db_index=True, editable=False, null=True),
        ),
        migrations.AddField(
            model_name="prefix",
            name="namespace",
            field=models.ForeignKey(
                default=nautobot.ipam.models.get_default_namespace_pk,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="prefixes",
                to="ipam.namespace",
            ),
        ),
        migrations.AlterModelOptions(
            name="prefix",
            options={
                "ordering": ("namespace", "ip_version", "network", "prefix_length"),
                "verbose_name_plural": "prefixes",
            },
        ),
        migrations.AddField(
            model_name="vrf",
            name="devices",
            field=models.ManyToManyField(related_name="vrfs", through="ipam.VRFDeviceAssignment", to="dcim.Device"),
        ),
        migrations.AddField(
            model_name="vrf",
            name="virtual_machines",
            field=models.ManyToManyField(
                related_name="vrfs", through="ipam.VRFDeviceAssignment", to="virtualization.VirtualMachine"
            ),
        ),
        migrations.AddField(
            model_name="vrf",
            name="namespace",
            field=models.ForeignKey(
                default=nautobot.ipam.models.get_default_namespace_pk,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="vrfs",
                to="ipam.namespace",
            ),
        ),
        migrations.AlterField(
            model_name="vrf",
            name="rd",
            field=models.CharField(blank=True, max_length=21, null=True),
        ),
        migrations.AlterModelOptions(
            name="vrf",
            options={"ordering": ("namespace", "name", "rd"), "verbose_name": "VRF", "verbose_name_plural": "VRFs"},
        ),
        migrations.AddField(
            model_name="vrf",
            name="prefixes_m2m",
            field=models.ManyToManyField(related_name="vrfs_m2m", through="ipam.VRFPrefixAssignment", to="ipam.Prefix"),
        ),
        migrations.AddField(
            model_name="prefix",
            name="parent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="children",
                to="ipam.prefix",
            ),
        ),
        migrations.AlterIndexTogether(
            name="prefix",
            index_together={
                ("network", "broadcast", "prefix_length"),
                ("namespace", "network", "broadcast", "prefix_length"),
            },
        ),
        #
        #  Folded in from 0032_ipam__ipaddress__add_parent.py
        #
        migrations.AddField(
            model_name="ipaddress",
            name="ip_version",
            field=models.IntegerField(db_index=True, editable=False, null=True),
        ),
        migrations.AddField(
            model_name="ipaddress",
            name="parent",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="ip_addresses",
                to="ipam.prefix",
            ),
        ),
        migrations.AddField(
            model_name="ipaddress",
            name="type",
            field=models.CharField(default="host", max_length=50),
        ),
        migrations.AlterModelOptions(
            name="ipaddress",
            options={
                "ordering": ("ip_version", "host", "prefix_length"),
                "verbose_name": "IP address",
                "verbose_name_plural": "IP addresses",
            },
        ),
    ]
