# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Binding(pulumi.CustomResource):
    arguments: pulumi.Output[dict]
    """
    Additional key/value arguments for the binding.
    """
    destination: pulumi.Output[str]
    """
    The destination queue or exchange.
    """
    destination_type: pulumi.Output[str]
    """
    The type of destination (queue or exchange).
    """
    properties_key: pulumi.Output[str]
    """
    A unique key to refer to the binding.
    """
    routing_key: pulumi.Output[str]
    """
    A routing key for the binding.
    """
    source: pulumi.Output[str]
    """
    The source exchange.
    """
    vhost: pulumi.Output[str]
    """
    The vhost to create the resource in.
    """
    def __init__(__self__, resource_name, opts=None, arguments=None, destination=None, destination_type=None, routing_key=None, source=None, vhost=None, __props__=None, __name__=None, __opts__=None):
        """
        The ``.Binding`` resource creates and manages a binding relationship
        between a queue an exchange.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_rabbitmq as rabbitmq

        test_v_host = rabbitmq.VHost("testVHost")
        guest = rabbitmq.Permissions("guest",
            permissions={
                "configure": ".*",
                "read": ".*",
                "write": ".*",
            },
            user="guest",
            vhost=test_v_host.name)
        test_exchange = rabbitmq.Exchange("testExchange",
            settings={
                "autoDelete": True,
                "durable": False,
                "type": "fanout",
            },
            vhost=guest.vhost)
        test_queue = rabbitmq.Queue("testQueue",
            settings={
                "autoDelete": False,
                "durable": True,
            },
            vhost=guest.vhost)
        test_binding = rabbitmq.Binding("testBinding",
            destination=test_queue.name,
            destination_type="queue",
            routing_key="#",
            source=test_exchange.name,
            vhost=test_v_host.name)
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] arguments: Additional key/value arguments for the binding.
        :param pulumi.Input[str] destination: The destination queue or exchange.
        :param pulumi.Input[str] destination_type: The type of destination (queue or exchange).
        :param pulumi.Input[str] routing_key: A routing key for the binding.
        :param pulumi.Input[str] source: The source exchange.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['arguments'] = arguments
            if destination is None:
                raise TypeError("Missing required property 'destination'")
            __props__['destination'] = destination
            if destination_type is None:
                raise TypeError("Missing required property 'destination_type'")
            __props__['destination_type'] = destination_type
            __props__['routing_key'] = routing_key
            if source is None:
                raise TypeError("Missing required property 'source'")
            __props__['source'] = source
            if vhost is None:
                raise TypeError("Missing required property 'vhost'")
            __props__['vhost'] = vhost
            __props__['properties_key'] = None
        super(Binding, __self__).__init__(
            'rabbitmq:index/binding:Binding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, arguments=None, destination=None, destination_type=None, properties_key=None, routing_key=None, source=None, vhost=None):
        """
        Get an existing Binding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[dict] arguments: Additional key/value arguments for the binding.
        :param pulumi.Input[str] destination: The destination queue or exchange.
        :param pulumi.Input[str] destination_type: The type of destination (queue or exchange).
        :param pulumi.Input[str] properties_key: A unique key to refer to the binding.
        :param pulumi.Input[str] routing_key: A routing key for the binding.
        :param pulumi.Input[str] source: The source exchange.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["arguments"] = arguments
        __props__["destination"] = destination
        __props__["destination_type"] = destination_type
        __props__["properties_key"] = properties_key
        __props__["routing_key"] = routing_key
        __props__["source"] = source
        __props__["vhost"] = vhost
        return Binding(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

