# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class TopicPermissions(pulumi.CustomResource):
    permissions: pulumi.Output[list]
    """
    The settings of the permissions. The structure is
    described below.

      * `exchange` (`str`) - The exchange to set the permissions for.
      * `read` (`str`) - The "read" ACL.
      * `write` (`str`) - The "write" ACL.
    """
    user: pulumi.Output[str]
    """
    The user to apply the permissions to.
    """
    vhost: pulumi.Output[str]
    """
    The vhost to create the resource in.
    """
    def __init__(__self__, resource_name, opts=None, permissions=None, user=None, vhost=None, __props__=None, __name__=None, __opts__=None):
        """
        The ``.TopicPermissions`` resource creates and manages a user's set of
        topic permissions.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_rabbitmq as rabbitmq

        test_v_host = rabbitmq.VHost("testVHost")
        test_user = rabbitmq.User("testUser",
            password="foobar",
            tags=["administrator"])
        test_topic_permissions = rabbitmq.TopicPermissions("testTopicPermissions",
            permissions=[{
                "exchange": "amq.topic",
                "read": ".*",
                "write": ".*",
            }],
            user=test_user.name,
            vhost=test_v_host.name)
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] permissions: The settings of the permissions. The structure is
               described below.
        :param pulumi.Input[str] user: The user to apply the permissions to.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.

        The **permissions** object supports the following:

          * `exchange` (`pulumi.Input[str]`) - The exchange to set the permissions for.
          * `read` (`pulumi.Input[str]`) - The "read" ACL.
          * `write` (`pulumi.Input[str]`) - The "write" ACL.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if permissions is None:
                raise TypeError("Missing required property 'permissions'")
            __props__['permissions'] = permissions
            if user is None:
                raise TypeError("Missing required property 'user'")
            __props__['user'] = user
            __props__['vhost'] = vhost
        super(TopicPermissions, __self__).__init__(
            'rabbitmq:index/topicPermissions:TopicPermissions',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, permissions=None, user=None, vhost=None):
        """
        Get an existing TopicPermissions resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] permissions: The settings of the permissions. The structure is
               described below.
        :param pulumi.Input[str] user: The user to apply the permissions to.
        :param pulumi.Input[str] vhost: The vhost to create the resource in.

        The **permissions** object supports the following:

          * `exchange` (`pulumi.Input[str]`) - The exchange to set the permissions for.
          * `read` (`pulumi.Input[str]`) - The "read" ACL.
          * `write` (`pulumi.Input[str]`) - The "write" ACL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["permissions"] = permissions
        __props__["user"] = user
        __props__["vhost"] = vhost
        return TopicPermissions(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

