from typing import Iterator

# Auth Plugin ---------------------------------------------------------------------------------
class AuthPlugin:
    def __init__(self, plugins: dict[str | bytes, type] | None = None) -> None: ...
    # Property
    @property
    def mysql_native_password(self) -> type | None: ...
    @mysql_native_password.setter
    def mysql_native_password(self, handler: type) -> None: ...
    @property
    def caching_sha2_password(self) -> type | None: ...
    @caching_sha2_password.setter
    def caching_sha2_password(self, handler: type) -> None: ...
    @property
    def sha256_password(self) -> type | None: ...
    @sha256_password.setter
    def sha256_password(self, handler: type) -> None: ...
    @property
    def client_ed25519(self) -> type | None: ...
    @client_ed25519.setter
    def client_ed25519(self, handler: type) -> None: ...
    @property
    def mysql_old_password(self) -> type | None: ...
    @mysql_old_password.setter
    def mysql_old_password(self, handler: type) -> None: ...
    @property
    def mysql_clear_password(self) -> type | None: ...
    @mysql_clear_password.setter
    def mysql_clear_password(self, handler: type) -> None: ...
    @property
    def dialog(self) -> type | None: ...
    @dialog.setter
    def dialog(self, handler: type) -> None: ...
    # Handler
    def get(self, plugin_name: str | bytes) -> type | None: ...
    def set(self, plugin_name: str | bytes, handler: type) -> bool: ...
    # Special Methods
    def __repr__(self) -> str: ...
    def __getitem__(self, key: str | bytes) -> type: ...
    def __contains__(self, plugin_name: str | bytes) -> bool: ...
    def __iter__(self) -> Iterator[type]: ...
    def __len__(self) -> int: ...
    def __bool__(self) -> bool: ...

# Password ------------------------------------------------------------------------------------
def scramble_native_password(password: bytes, salt: bytes) -> bytes: ...
def scramble_caching_sha2(password: bytes, salt: bytes) -> bytes: ...
def sha2_rsa_encrypt(password: bytes, salt: bytes, public_key: bytes) -> bytes: ...
def ed25519_password(password: bytes, scramble: bytes) -> bytes: ...
