from os import PathLike
from asyncio import Future, Task
from typing_extensions import Self
from typing import Literal, Generator, Any
import pandas as pd
from sqlcycli._ssl import SSL
from sqlcycli._auth import AuthPlugin
from sqlcycli._optionfile import OptionFile
from sqlcycli import connection as sync_conn
from sqlcycli.aio import connection as async_conn

# Cursor --------------------------------------------------------------------------------------
def validate_sync_cursor(
    cursor: (
        type[sync_conn.Cursor | async_conn.Cursor | tuple | dict | pd.DataFrame] | None
    ),
) -> type[sync_conn.Cursor] | None: ...
def validate_async_cursor(
    cursor: (
        type[sync_conn.Cursor | async_conn.Cursor | tuple | dict | pd.DataFrame] | None
    ),
) -> type[async_conn.Cursor] | None: ...

# Pool Connection -----------------------------------------------------------------------------
class PoolConnection(async_conn.BaseConnection):
    @property
    def close_scheduled(self) -> bool: ...
    def schedule_close(self) -> bool: ...

class PoolSyncConnection(sync_conn.BaseConnection):
    @property
    def close_scheduled(self) -> bool: ...
    def schedule_close(self) -> bool: ...

# Pool Connection Manager ---------------------------------------------------------------------
class PoolConnectionManager:
    def __init__(self, pool: Pool): ...
    # sync
    def __enter__(self) -> PoolSyncConnection: ...
    def __exit__(self, exc_type, exc_val, exc_tb): ...
    # async
    def __await__(self) -> Generator[Any, Any, PoolConnection]: ...
    async def __aenter__(self) -> PoolConnection: ...
    async def __aexit__(self, exc_type, exc_val, exc_tb): ...

class PoolTransactionManager(PoolConnectionManager):
    def __init__(self, pool: Pool): ...
    # sync
    def __enter__(self) -> PoolSyncConnection: ...
    def __exit__(self, exc_type, exc_val, exc_tb): ...
    # async
    async def __aenter__(self) -> PoolConnection: ...
    async def __aexit__(self, exc_type, exc_val, exc_tb): ...

# Pool ----------------------------------------------------------------------------------------
class Pool:
    def __init__(
        self,
        host: str | None = "localhost",
        port: int = 3306,
        user: str | bytes | None = None,
        password: str | bytes | None = None,
        database: str | bytes | None = None,
        min_size: int = 0,
        max_size: int = 10,
        recycle: int | None = None,
        *,
        charset: str | None = "utf8mb4",
        collation: str | None = None,
        connect_timeout: int = 5,
        read_timeout: int | None = None,
        write_timeout: int | None = None,
        wait_timeout: int | None = None,
        interactive_timeout: int | None = None,
        lock_wait_timeout: int | None = None,
        execution_timeout: int | None = None,
        bind_address: str | None = None,
        unix_socket: str | None = None,
        autocommit: bool | None = False,
        local_infile: bool = False,
        max_allowed_packet: int | str | None = None,
        sql_mode: str | None = None,
        init_command: str | None = None,
        cursor: (
            type[async_conn.Cursor | tuple | dict | pd.DataFrame] | None
        ) = async_conn.Cursor,
        client_flag: int = 0,
        program_name: str | None = None,
        option_file: str | bytes | PathLike | OptionFile | None = None,
        ssl: SSL | object | None = None,
        auth_plugin: dict[str | bytes, type] | AuthPlugin | None = None,
        server_public_key: bytes | None = None,
        use_decimal: bool = False,
        decode_bit: bool = False,
        decode_json: bool = False,
    ): ...
    # Property --------------------------------------------------------------------------------
    # . client
    @property
    def host(self) -> str: ...
    @property
    def port(self) -> int: ...
    @property
    def user(self) -> str | None: ...
    @property
    def password(self) -> str: ...
    @property
    def database(self) -> str | None: ...
    @property
    def charset(self) -> str: ...
    @property
    def collation(self) -> str: ...
    @property
    def encoding(self) -> str: ...
    @property
    def connect_timeout(self) -> int: ...
    @property
    def bind_address(self) -> str | None: ...
    @property
    def unix_socket(self) -> str | None: ...
    @property
    def autocommit(self) -> bool | None: ...
    @property
    def local_infile(self) -> bool: ...
    @property
    def max_allowed_packet(self) -> int: ...
    @property
    def sql_mode(self) -> str | None: ...
    @property
    def init_command(self) -> str | None: ...
    @property
    def client_flag(self) -> int: ...
    @property
    def ssl(self) -> object | None: ...
    @property
    def auth_plugin(self) -> AuthPlugin | None: ...
    # . server
    @property
    def protocol_version(self) -> int | None: ...
    @property
    def server_info(self) -> str | None: ...
    @property
    def server_version(self) -> tuple[int] | None: ...
    @property
    def server_version_major(self) -> int | None: ...
    @property
    def server_vendor(self) -> Literal["mysql", "mariadb"] | None: ...
    @property
    def server_auth_plugin_name(self) -> str | None: ...
    # . decode
    @property
    def use_decimal(self) -> bool: ...
    @property
    def decode_bit(self) -> bool: ...
    @property
    def decode_json(self) -> bool: ...
    # . pool
    @property
    def free(self) -> int: ...
    @property
    def used(self) -> int: ...
    @property
    def total(self) -> int: ...
    @property
    def min_size(self) -> int: ...
    @property
    def max_size(self) -> int: ...
    @property
    def recycle(self) -> int | None: ...
    # Pool ------------------------------------------------------------------------------------
    def set_min_size(self, size: int) -> bool: ...
    def set_recycle(self, recycle: int | None) -> bool: ...
    def set_autocommit(self, value: bool) -> bool: ...
    def set_use_decimal(self, value: bool) -> bool: ...
    def set_decode_bit(self, value: bool) -> bool: ...
    def set_decode_json(self, value: bool) -> bool: ...
    # Acquire / Transaction / Fill / Release --------------------------------------------------
    def acquire(self) -> PoolConnectionManager: ...
    def transaction(self) -> PoolTransactionManager: ...
    async def fill(self, num: int = 1) -> None: ...
    def release(self, conn: PoolConnection | PoolSyncConnection) -> Task[None]: ...
    # Close -----------------------------------------------------------------------------------
    def close(self) -> Task[None]: ...
    async def wait_for_closure(self) -> None: ...
    async def clear(self) -> None: ...
    def terminate(self) -> bool: ...
    def closed(self) -> bool: ...
    # Query -----------------------------------------------------------------------------------
    def escape_args(
        self,
        args: Any,
        many: bool = False,
        itemize: bool = True,
    ) -> str | tuple[str | tuple[str]] | list[str | tuple[str]]: ...
    # Special Methods -------------------------------------------------------------------------
    def __repr__(self) -> str: ...
    def __enter__(self) -> Self: ...
    def __exit__(self, exc_type, exc_val, exc_tb): ...
    async def __aenter__(self) -> Self: ...
    async def __aexit__(self, exc_type, exc_val, exc_tb): ...
