from typing import Iterator

# Charset(s) ----------------------------------------------------------------------------------
class Charset:
    def __init__(
        self,
        id: int,
        name: str,
        collation: str,
        is_default: bool = False,
    ): ...
    # Property
    @property
    def id(self) -> int: ...
    @property
    def name(self) -> str: ...
    @property
    def collation(self) -> str: ...
    @property
    def is_default(self) -> bool: ...
    @property
    def encoding(self) -> bytes: ...
    # Methods
    def is_binary(self) -> bool: ...
    def __repr__(self) -> str: ...
    def __eq__(self, o: object) -> bool: ...
    def __hash__(self) -> int: ...

class Charsets:
    def __init__(self) -> None: ...
    # Add Charset
    def add(self, charset: Charset) -> bool: ...
    # Access Charset
    def by_id(self, id: int) -> Charset: ...
    def by_name(self, name: str) -> Charset: ...
    def by_collation(self, collation: str) -> Charset: ...
    def by_name_n_collation(self, name: str, collation: str) -> Charset: ...
    # Special Methods
    def __iter__(self) -> Iterator[Charset]: ...
    def __repr__(self) -> str: ...

# Functions -----------------------------------------------------------------------------------
def all_charsets() -> Charsets: ...
def by_id(id: int) -> Charset: ...
def by_name(name: str) -> Charset: ...
def by_collation(collation: str) -> Charset: ...
def by_name_n_collation(name: str, collation: str) -> Charset: ...
