# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-09-14 15:35
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.CharField(max_length=150, primary_key=True, serialize=False)),
                ('owner', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Client',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150)),
                ('is_integrated', models.BooleanField(default=False)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('limit', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='ClientUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('password', models.CharField(max_length=12, blank=True)),
                ('usage', models.IntegerField(blank=True)),
                ('admin', models.BooleanField(default=False)),
                ('limit', models.IntegerField()),
                ('client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='fallballapp.Client')),
                ('owner', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Reseller',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=120)),
                ('rid', models.CharField(max_length=120, verbose_name='Reseller ID')),
                ('limit', models.IntegerField()),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='fallballapp.Application')),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='client',
            name='reseller',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='fallballapp.Reseller'),
        ),
        migrations.AlterUniqueTogether(
            name='reseller',
            unique_together=set([('application', 'rid'), ('application', 'name')]),
        ),
        migrations.AlterUniqueTogether(
            name='clientuser',
            unique_together=set([('client', 'email')]),
        ),
        migrations.AlterUniqueTogether(
            name='client',
            unique_together=set([('reseller', 'name')]),
        ),
    ]
