# mypy-boto3-chime

[![PyPI - mypy-boto3-chime](https://img.shields.io/pypi/v/mypy-boto3-chime.svg?color=blue)](https://pypi.org/project/mypy-boto3-chime)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-chime.svg?color=blue)](https://pypi.org/project/mypy-boto3-chime)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Chime 1.16.10](https://boto3.amazonaws.com/v1/documentation/api/1.16.10/reference/services/chime.html#Chime) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-chime](#mypy-boto3-chime)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Chime` service.

```bash
python -m pip install boto3-stubs[chime]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[chime]` in your environment: `python -m pip install 'boto3-stubs[chime]'`

Both type checking and auto-complete should work for `Chime` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[chime]` in your environment: `python -m pip install 'boto3-stubs[chime]'`

Both type checking and auto-complete should work for `Chime` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[chime]` in your environment: `python -m pip install 'boto3-stubs[chime]'`
- Run `mypy` as usual

Type checking should work for `Chime` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[chime]` in your environment: `python -m pip install 'boto3-stubs[chime]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Chime` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ChimeClient` provides annotations for `boto3.client("chime")`.

```python
import boto3

from mypy_boto3_chime import ChimeClient

client: ChimeClient = boto3.client("chime")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ChimeClient = session.client("chime")
```

### Paginators annotations

`mypy_boto3_chime.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_chime import ChimeClient
from mypy_boto3_chime.paginator import ListAccountsPaginator, ListUsersPaginator

client: ChimeClient = boto3.client("chime")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_accounts_paginator: ListAccountsPaginator = client.get_paginator("list_accounts")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
```







### Typed dictionations

`mypy_boto3_chime.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_chime.type_defs import (
    AccountSettingsTypeDef,
    AccountTypeDef,
    AlexaForBusinessMetadataTypeDef,
    AssociatePhoneNumbersWithVoiceConnectorGroupResponseTypeDef,
    AssociatePhoneNumbersWithVoiceConnectorResponseTypeDef,
    AttendeeTypeDef,
    BatchCreateAttendeeResponseTypeDef,
    BatchCreateRoomMembershipResponseTypeDef,
    BatchDeletePhoneNumberResponseTypeDef,
    BatchSuspendUserResponseTypeDef,
    BatchUnsuspendUserResponseTypeDef,
    BatchUpdatePhoneNumberResponseTypeDef,
    BatchUpdateUserResponseTypeDef,
    BotTypeDef,
    BusinessCallingSettingsTypeDef,
    ConversationRetentionSettingsTypeDef,
    CreateAccountResponseTypeDef,
    CreateAttendeeErrorTypeDef,
    CreateAttendeeRequestItemTypeDef,
    CreateAttendeeResponseTypeDef,
    CreateBotResponseTypeDef,
    CreateMeetingResponseTypeDef,
    CreateMeetingWithAttendeesResponseTypeDef,
    CreatePhoneNumberOrderResponseTypeDef,
    CreateProxySessionResponseTypeDef,
    CreateRoomMembershipResponseTypeDef,
    CreateRoomResponseTypeDef,
    CreateUserResponseTypeDef,
    CreateVoiceConnectorGroupResponseTypeDef,
    CreateVoiceConnectorResponseTypeDef,
    CredentialTypeDef,
    DisassociatePhoneNumbersFromVoiceConnectorGroupResponseTypeDef,
    DisassociatePhoneNumbersFromVoiceConnectorResponseTypeDef,
    DNISEmergencyCallingConfigurationTypeDef,
    EmergencyCallingConfigurationTypeDef,
    EventsConfigurationTypeDef,
    GeoMatchParamsTypeDef,
    GetAccountResponseTypeDef,
    GetAccountSettingsResponseTypeDef,
    GetAttendeeResponseTypeDef,
    GetBotResponseTypeDef,
    GetEventsConfigurationResponseTypeDef,
    GetGlobalSettingsResponseTypeDef,
    GetMeetingResponseTypeDef,
    GetPhoneNumberOrderResponseTypeDef,
    GetPhoneNumberResponseTypeDef,
    GetPhoneNumberSettingsResponseTypeDef,
    GetProxySessionResponseTypeDef,
    GetRetentionSettingsResponseTypeDef,
    GetRoomResponseTypeDef,
    GetUserResponseTypeDef,
    GetUserSettingsResponseTypeDef,
    GetVoiceConnectorEmergencyCallingConfigurationResponseTypeDef,
    GetVoiceConnectorGroupResponseTypeDef,
    GetVoiceConnectorLoggingConfigurationResponseTypeDef,
    GetVoiceConnectorOriginationResponseTypeDef,
    GetVoiceConnectorProxyResponseTypeDef,
    GetVoiceConnectorResponseTypeDef,
    GetVoiceConnectorStreamingConfigurationResponseTypeDef,
    GetVoiceConnectorTerminationHealthResponseTypeDef,
    GetVoiceConnectorTerminationResponseTypeDef,
    InviteTypeDef,
    InviteUsersResponseTypeDef,
    ListAccountsResponseTypeDef,
    ListAttendeesResponseTypeDef,
    ListAttendeeTagsResponseTypeDef,
    ListBotsResponseTypeDef,
    ListMeetingsResponseTypeDef,
    ListMeetingTagsResponseTypeDef,
    ListPhoneNumberOrdersResponseTypeDef,
    ListPhoneNumbersResponseTypeDef,
    ListProxySessionsResponseTypeDef,
    ListRoomMembershipsResponseTypeDef,
    ListRoomsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUsersResponseTypeDef,
    ListVoiceConnectorGroupsResponseTypeDef,
    ListVoiceConnectorsResponseTypeDef,
    ListVoiceConnectorTerminationCredentialsResponseTypeDef,
    LoggingConfigurationTypeDef,
    MediaPlacementTypeDef,
    MeetingNotificationConfigurationTypeDef,
    MeetingTypeDef,
    MemberErrorTypeDef,
    MembershipItemTypeDef,
    MemberTypeDef,
    OrderedPhoneNumberTypeDef,
    OriginationRouteTypeDef,
    OriginationTypeDef,
    PaginatorConfigTypeDef,
    ParticipantTypeDef,
    PhoneNumberAssociationTypeDef,
    PhoneNumberCapabilitiesTypeDef,
    PhoneNumberErrorTypeDef,
    PhoneNumberOrderTypeDef,
    PhoneNumberTypeDef,
    ProxySessionTypeDef,
    ProxyTypeDef,
    PutEventsConfigurationResponseTypeDef,
    PutRetentionSettingsResponseTypeDef,
    PutVoiceConnectorEmergencyCallingConfigurationResponseTypeDef,
    PutVoiceConnectorLoggingConfigurationResponseTypeDef,
    PutVoiceConnectorOriginationResponseTypeDef,
    PutVoiceConnectorProxyResponseTypeDef,
    PutVoiceConnectorStreamingConfigurationResponseTypeDef,
    PutVoiceConnectorTerminationResponseTypeDef,
    RegenerateSecurityTokenResponseTypeDef,
    ResetPersonalPINResponseTypeDef,
    RestorePhoneNumberResponseTypeDef,
    RetentionSettingsTypeDef,
    RoomMembershipTypeDef,
    RoomRetentionSettingsTypeDef,
    RoomTypeDef,
    SearchAvailablePhoneNumbersResponseTypeDef,
    SigninDelegateGroupTypeDef,
    StreamingConfigurationTypeDef,
    StreamingNotificationTargetTypeDef,
    TagTypeDef,
    TelephonySettingsTypeDef,
    TerminationHealthTypeDef,
    TerminationTypeDef,
    UpdateAccountResponseTypeDef,
    UpdateBotResponseTypeDef,
    UpdatePhoneNumberRequestItemTypeDef,
    UpdatePhoneNumberResponseTypeDef,
    UpdateProxySessionResponseTypeDef,
    UpdateRoomMembershipResponseTypeDef,
    UpdateRoomResponseTypeDef,
    UpdateUserRequestItemTypeDef,
    UpdateUserResponseTypeDef,
    UpdateVoiceConnectorGroupResponseTypeDef,
    UpdateVoiceConnectorResponseTypeDef,
    UserErrorTypeDef,
    UserSettingsTypeDef,
    UserTypeDef,
    VoiceConnectorGroupTypeDef,
    VoiceConnectorItemTypeDef,
    VoiceConnectorSettingsTypeDef,
    VoiceConnectorTypeDef,
)

def get_structure() -> AccountSettingsTypeDef:
    return {
      ...
    }
```
