# Compliance Audit Report

**Policy Pack:** aleo-baseline  
**Score:** 70/100  
**Status:** ❌ FAILED

## Summary

- **Total Checks:** 40
- **Passed:** 31
- **Failed:** 9
- **Critical:** 3
- **High:** 6
- **Medium:** 0
- **Low:** 0

## Violations

### Integer Overflow Risk

**Severity:** HIGH  
**Location:** `../compliedger-aleo/programs/sbom_registry/tests/test_sbom_registry.leo:12`  
**Message:** Potential overflow in arithmetic operation

**Remediation:** Use checked arithmetic or add bounds validation

### Missing Input Validation

**Severity:** HIGH  
**Location:** `../compliedger-aleo/programs/sbom_registry/src/main.leo:18`  
**Message:** Transition 'register' accepts inputs but lacks validation

**Remediation:** Add assertions to validate input parameters

### Missing Input Validation

**Severity:** HIGH  
**Location:** `../compliedger-aleo/programs/sbom_registry/src/main.leo:49`  
**Message:** Transition 'update_verified' accepts inputs but lacks validation

**Remediation:** Add assertions to validate input parameters

### Missing Input Validation

**Severity:** HIGH  
**Location:** `../compliedger-aleo/programs/sbom_registry/src/main.leo:76`  
**Message:** Transition 'update_verified_with_score' accepts inputs but lacks validation

**Remediation:** Add assertions to validate input parameters

### Unprotected State Mutation

**Severity:** CRITICAL  
**Location:** `../compliedger-aleo/programs/sbom_registry/src/main.leo:27`  
**Message:** Function 'finalize_reg' mutates state without access control

**Remediation:** Add caller verification before state changes

### Unprotected State Mutation

**Severity:** CRITICAL  
**Location:** `../compliedger-aleo/programs/sbom_registry/src/main.leo:57`  
**Message:** Function 'finalize_update' mutates state without access control

**Remediation:** Add caller verification before state changes

### Unprotected State Mutation

**Severity:** CRITICAL  
**Location:** `../compliedger-aleo/programs/sbom_registry/src/main.leo:84`  
**Message:** Function 'finalize_update_score' mutates state without access control

**Remediation:** Add caller verification before state changes

### Integer Overflow Risk

**Severity:** HIGH  
**Location:** `../compliedger-aleo/programs/compliance_oracle/tests/test_compliance_oracle.leo:12`  
**Message:** Potential overflow in arithmetic operation

**Remediation:** Use checked arithmetic or add bounds validation

### Missing Input Validation

**Severity:** HIGH  
**Location:** `../compliedger-aleo/programs/compliance_oracle/src/main.leo:7`  
**Message:** Transition 'attest_public' accepts inputs but lacks validation

**Remediation:** Add assertions to validate input parameters

