# Installation Guide

Complete installation instructions for Comp-LEO SDK.

## Quick Install

### Using pip (Recommended)

```bash
pip install comp-leo
```

### From Source

```bash
git clone https://github.com/compiledger/comp-leo-sdk
cd comp-leo-sdk
pip install -e .
```

## Installation Options

### Basic Installation (CLI + Python SDK)

```bash
pip install comp-leo
```

**Includes:**
- `comp-leo` CLI tool
- Python SDK for programmatic use
- All policy packs
- Core dependencies

### With API Server

```bash
pip install comp-leo[api]
```

**Additional components:**
- FastAPI web framework
- Uvicorn ASGI server
- Authentication libraries
- Rate limiting support

### Development Installation

```bash
git clone https://github.com/compiledger/comp-leo-sdk
cd comp-leo-sdk
pip install -e ".[dev,api]"
```

**Includes everything plus:**
- pytest for testing
- black, ruff for code quality
- mypy for type checking
- All development tools

## Requirements

- **Python:** 3.10 or higher
- **OS:** macOS, Linux, Windows (WSL recommended)
- **Memory:** 512MB minimum
- **Disk:** 100MB

## Verify Installation

```bash
# Check version
comp-leo --version

# Run help
comp-leo --help

# List policies
comp-leo list-policies
```

## Platform-Specific Instructions

### macOS

```bash
# Install Python 3.10+ via Homebrew
brew install python@3.10

# Install Comp-LEO
pip3 install comp-leo

# Verify
comp-leo --version
```

### Linux (Ubuntu/Debian)

```bash
# Install Python 3.10+
sudo apt update
sudo apt install python3.10 python3-pip

# Install Comp-LEO
pip3 install comp-leo

# Add to PATH if needed
export PATH="$HOME/.local/bin:$PATH"

# Verify
comp-leo --version
```

### Windows (WSL)

```bash
# Enable WSL and install Ubuntu
wsl --install

# Inside WSL
sudo apt update
sudo apt install python3 python3-pip

# Install Comp-LEO
pip3 install comp-leo

# Verify
comp-leo --version
```

## Virtual Environment (Recommended)

Using a virtual environment keeps dependencies isolated:

```bash
# Create virtual environment
python -m venv comp-leo-env

# Activate (macOS/Linux)
source comp-leo-env/bin/activate

# Activate (Windows)
comp-leo-env\Scripts\activate

# Install
pip install comp-leo

# When done
deactivate
```

## Docker Installation

### Run CLI in Container

```bash
docker run -v $(pwd)/programs:/programs compiledger/comp-leo check /programs
```

### Run API Server

```bash
docker run -p 8000:8000 compiledger/comp-leo-api
```

### Build from Source

```bash
# Clone repository
git clone https://github.com/compiledger/comp-leo-sdk
cd comp-leo-sdk

# Build image
docker build -t comp-leo .

# Run
docker run -v $(pwd)/programs:/programs comp-leo check /programs
```

## IDE Integration

### VS Code

1. Install Python extension
2. Install Comp-LEO: `pip install comp-leo`
3. Configure linter in `.vscode/settings.json`:

```json
{
    "python.linting.enabled": true,
    "python.linting.comp-leoPath": "comp-leo"
}
```

### PyCharm

1. Install Comp-LEO in project interpreter
2. Add external tool:
   - Program: `comp-leo`
   - Arguments: `check $FilePath$`
   - Working directory: `$ProjectFileDir$`

## Troubleshooting

### "comp-leo: command not found"

**Solution:** Add pip install location to PATH

```bash
# macOS/Linux
export PATH="$HOME/.local/bin:$PATH"

# Add to ~/.bashrc or ~/.zshrc for persistence
echo 'export PATH="$HOME/.local/bin:$PATH"' >> ~/.bashrc
```

### "ModuleNotFoundError: No module named 'comp_leo'"

**Solution:** Ensure correct Python version

```bash
# Check Python version
python --version  # Should be 3.10+

# If using python3 explicitly
python3 -m pip install comp-leo
```

### "Permission denied"

**Solution:** Install for user only

```bash
pip install --user comp-leo
```

### Import errors with API dependencies

**Solution:** Install with API extras

```bash
pip install comp-leo[api]
```

### Slow performance on large codebases

**Solution:** Increase Python memory or use parallel processing (future)

```bash
# Check memory usage
comp-leo check programs/ --verbose
```

## Upgrading

### To Latest Version

```bash
pip install --upgrade comp-leo
```

### To Specific Version

```bash
pip install comp-leo==0.2.0
```

### Check for Updates

```bash
pip list --outdated | grep comp-leo
```

## Uninstallation

```bash
pip uninstall comp-leo
```

## Configuration

### Config File (Optional)

Create `~/.comp-leo/config.yaml`:

```yaml
default_policy: aleo-baseline
threshold: 75
fail_on_critical: true
output_format: terminal

# API settings
api:
  endpoint: https://api.compiledger.com
  key: your_key_here
```

### Environment Variables

```bash
export COMPLEO_POLICY=nist-800-53
export COMPLEO_THRESHOLD=80
export COMPLEO_API_KEY=your_key
```

## Getting Help

If you encounter issues:

1. Check [documentation](https://docs.compiledger.com)
2. Search [issues](https://github.com/compiledger/comp-leo-sdk/issues)
3. Join [Discord](https://discord.gg/compiledger)
4. Email support@compiledger.com

## Next Steps

After installation:

1. Read [QUICKSTART.md](QUICKSTART.md)
2. Try examples: `python examples/python_api_usage.py`
3. Check your first Leo file: `comp-leo check programs/`
4. Set up CI/CD integration

---

**Installation complete! 🎉**

Run `comp-leo --help` to get started.
