# Publishing Comp-LEO to PyPI

## Step 1: Configure PyPI Credentials

Create `~/.pypirc` in your home directory:

```bash
cat > ~/.pypirc << 'EOF'
[pypi]
username = __token__
password = pypi-AgEIcHlwaS5vcmcCJDAxMDk4OTZlLWQxM2YtNDdiNy04MWZkLWEzYjY3ZGUyZTQ4YQACKlszLCIwMGIxOTcwOC0zMDY3LTQzNDItYjQwYi0zNWIwYWZkZTQ5YjgiXQAABiA4wjtXtAkUdL1TbZtoRjhndEsKSbs4SjdQPMqTvEzpFA
EOF

chmod 600 ~/.pypirc
```

## Step 2: Install Build Tools

```bash
pip3 install --upgrade build twine
```

## Step 3: Clean Previous Builds

```bash
cd /Users/satyamsinghal/Desktop/Products/Aleo\ Certi/comp-leo-sdk
rm -rf build/ dist/ *.egg-info
```

## Step 4: Build the Package

```bash
python3 -m build
```

This creates:
- `dist/comp_leo-0.1.0-py3-none-any.whl` (wheel)
- `dist/comp-leo-0.1.0.tar.gz` (source distribution)

## Step 5: Check the Package

```bash
twine check dist/*
```

Expected output:
```
Checking dist/comp-leo-0.1.0.tar.gz: PASSED
Checking dist/comp_leo-0.1.0-py3-none-any.whl: PASSED
```

## Step 6: Upload to PyPI

```bash
twine upload dist/*
```

You'll see:
```
Uploading distributions to https://upload.pypi.org/legacy/
Uploading comp_leo-0.1.0-py3-none-any.whl
100% ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━ 
Uploading comp-leo-0.1.0.tar.gz
100% ━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━

View at:
https://pypi.org/project/comp-leo/0.1.0/
```

## Step 7: Verify Installation

```bash
# In a new terminal/environment
pip3 install comp-leo

# Test it
comp-leo --version
comp-leo --help
```

## Step 8: Create GitHub Release

```bash
git tag v0.1.0
git push origin v0.1.0
```

Then create release on GitHub:
- Go to: https://github.com/compiledger/comp-leo-sdk/releases/new
- Tag: v0.1.0
- Title: "Comp-LEO SDK v0.1.0 - Initial Release"
- Description: Copy from NEXT_STEPS.md marketing section

## Troubleshooting

**Error: "File already exists"**
```bash
# Version already published, bump version in pyproject.toml
# Change version = "0.1.0" to "0.1.1"
# Then rebuild and upload
```

**Error: "Invalid credentials"**
```bash
# Verify ~/.pypirc has correct token
# Make sure token starts with "pypi-"
cat ~/.pypirc
```

**Error: "Package name already taken"**
```bash
# Change name in pyproject.toml if needed
# Current: "comp-leo" should be available
```

## Post-Publication Checklist

- [ ] Package appears on PyPI: https://pypi.org/project/comp-leo/
- [ ] Install works: `pip install comp-leo`
- [ ] Command works: `comp-leo --version`
- [ ] Create GitHub release
- [ ] Update README with PyPI badge
- [ ] Announce on Aleo Forum
- [ ] Tweet announcement
- [ ] Post on Discord

## Quick Commands (Copy-Paste)

```bash
# Setup credentials
cat > ~/.pypirc << 'EOF'
[pypi]
username = __token__
password = pypi-AgEIcHlwaS5vcmcCJDAxMDk4OTZlLWQxM2YtNDdiNy04MWZkLWEzYjY3ZGUyZTQ4YQACKlszLCIwMGIxOTcwOC0zMDY3LTQzNDItYjQwYi0zNWIwYWZkZTQ5YjgiXQAABiA4wjtXtAkUdL1TbZtoRjhndEsKSbs4SjdQPMqTvEzpFA
EOF
chmod 600 ~/.pypirc

# Install tools
pip3 install --upgrade build twine

# Build and publish
cd /Users/satyamsinghal/Desktop/Products/Aleo\ Certi/comp-leo-sdk
rm -rf build/ dist/ *.egg-info
python3 -m build
twine check dist/*
twine upload dist/*

# Verify
pip3 install comp-leo
comp-leo --version
```

🚀 **You're ready to publish!**
