import grpc
import json
import time
import requests
import qbit_pb2

from google.protobuf.json_format import MessageToDict


def create_get_auth(access_token):

    def get_auth_token(context, callback):
        callback([('authorization', access_token)], None)

    return get_auth_token

# Client class takes care of authentication process in order to use our services
#
# Example -
# from qbit import client
# qbit_client = client('./qbit/license.json')
# qbit_client.stub has all the grpc functions 1qbit has
class grpc_channel(object):

    def __init__(self,
                 license=None,
                 client_id=None,
                 client_secret=None,
                 url=None):
        if not license and (not client_id or not client_secret):
            raise Exception("Please provide either license file or client_id and client_secret")

        if license:
            with open(license) as data_file:
                data = json.load(data_file)
            client_id = data["client_id"]
            client_secret = data["client_secret"]
        else:
            client_id = client_id
            client_secret = client_secret

        url = url if url else "https://1qbit.auth0.com/oauth/token"

        req_dict = {
            "client_id": client_id,
            "client_secret": client_secret,
            "grant_type": "client_credentials",
            "audience": "http://api.1qb.it"
        }
        try:
            response = requests.post(url, json=req_dict).json()
        except Exception as e:
            raise Exception("Request has Failed: ", e.message)

        if response.has_key("error"):
            if response.has_key("error_description"):
                raise Exception(response["error"], ": ",
                                response["error_description"])
            raise Exception(response)
        elif response.has_key("access_token"):
            token = response["access_token"]

        root_certs = str(requests.get('http://api.1qb.it/ca.pem').text)
        transport_creds = grpc.ssl_channel_credentials(
            root_certificates=root_certs)
        auth_creds = grpc.metadata_call_credentials(create_get_auth(token))
        channel_creds = grpc.composite_channel_credentials(
            transport_creds, auth_creds)
        self._channel = grpc.secure_channel('grpc.1qb.it', channel_creds)


class client(grpc_channel):

    def __init__(self,
                 license=None,
                 client_id=None,
                 client_secret=None,
                 url=None):

        super(client, self).__init__(license, client_id, client_secret, url)

        self.stub = qbit_pb2.QbitStub(self._channel)
