# Finance Banking Agent Template

A lightweight banking conversational agent template for the fictional **Fenlo Bank** that handles account management, card services, and money transfers.

## 🚀 What's Included

This template provides a banking assistant with:
- **Account Management**: Balance checking, account selection, and validation
- **Card Services**: Card blocking, status management, and security features  
- **Money Transfers**: Payee management, fund transfers, and payment scheduling
- **Banking Knowledge**: FAQ system with comprehensive banking documentation
- **Security Features**: Account verification, sufficient funds checking, and secure transactions

## 📁 Directory Structure

```
├── actions/         # Custom Python logic for banking operations
├── data/            # Banking conversation flows and training data
├── domain/          # Banking agent configuration
├── csvs/            # Mock database for testing
├── docs/            # Basic knowledge base and FAQ documents
├── prompts/         # LLM prompts for enhanced banking responses
└── config.yml       # Training pipeline configuration
```

