# coding=utf-8
"""
Setup for scikit-surgeryspeech
"""

from setuptools import setup, find_packages
import versioneer
import os

# Get the long description
with open('README.rst') as f:
    long_description = f.read()

# Read the docs can't install pyaudio
in_rtd_build = os.getenv('IN_READTHEDOCS')
if in_rtd_build == 'true':
    install_requires = [
                'pyaudio',
                'SpeechRecognition',
                'google-api-python-client',
                'oauth2client',
                'PySide2',
                'scikit-surgerycore',
                'pvporcupine<2.0.0'
            ]
else:
    install_requires = [
            'pyaudio',
            'SpeechRecognition',
            'google-api-python-client',
            'oauth2client',
            'PySide2',
            'scikit-surgerycore',
            'pvporcupine'
        ]

    setup(
        name='scikit-surgeryspeech',
        version=versioneer.get_version(),
        cmdclass=versioneer.get_cmdclass(),
        description='Interface to speech services for image-guided surgery.',
        long_description=long_description,
        long_description_content_type='text/x-rst',
        url='https://github.com/SciKit-Surgery/scikit-surgeryspeech',
        author='Steve Thompson',
        author_email='s.thompson@ucl.ac.uk',
        license='BSD-3 license',
        classifiers=[
            'Development Status :: 3 - Alpha',

            'Intended Audience :: Developers',
            'Intended Audience :: Healthcare Industry',
            'Intended Audience :: Information Technology',
            'Intended Audience :: Science/Research',


            'License :: OSI Approved :: BSD License',


            'Programming Language :: Python',
            'Programming Language :: Python :: 2',
            'Programming Language :: Python :: 3',

            'Topic :: Scientific/Engineering :: Information Analysis',
            'Topic :: Scientific/Engineering :: Medical Science Apps.',
        ],

        keywords='medical imaging',

        packages=find_packages(
            exclude=[
                'docs',
                'tests',
            ]
        ),


            
        install_requires=install_requires,

        entry_points={
            'console_scripts': [
                'sksurgeryspeech=sksurgeryspeech.__main__:main',
            ],
        },
    )
