# -*- coding: utf8 -*-
# Copyright (c) 2017-2025 Tencent. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AcquireClusterAdminRoleRequest(AbstractModel):
    r"""AcquireClusterAdminRole请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AcquireClusterAdminRoleResponse(AbstractModel):
    r"""AcquireClusterAdminRole返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddClusterCIDRRequest(AbstractModel):
    r"""AddClusterCIDR请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterCIDRs: 增加的ClusterCIDR
        :type ClusterCIDRs: list of str
        :param _IgnoreClusterCIDRConflict: 是否忽略ClusterCIDR与VPC路由表的冲突
        :type IgnoreClusterCIDRConflict: bool
        """
        self._ClusterId = None
        self._ClusterCIDRs = None
        self._IgnoreClusterCIDRConflict = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterCIDRs(self):
        r"""增加的ClusterCIDR
        :rtype: list of str
        """
        return self._ClusterCIDRs

    @ClusterCIDRs.setter
    def ClusterCIDRs(self, ClusterCIDRs):
        self._ClusterCIDRs = ClusterCIDRs

    @property
    def IgnoreClusterCIDRConflict(self):
        r"""是否忽略ClusterCIDR与VPC路由表的冲突
        :rtype: bool
        """
        return self._IgnoreClusterCIDRConflict

    @IgnoreClusterCIDRConflict.setter
    def IgnoreClusterCIDRConflict(self, IgnoreClusterCIDRConflict):
        self._IgnoreClusterCIDRConflict = IgnoreClusterCIDRConflict


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterCIDRs = params.get("ClusterCIDRs")
        self._IgnoreClusterCIDRConflict = params.get("IgnoreClusterCIDRConflict")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddClusterCIDRResponse(AbstractModel):
    r"""AddClusterCIDR返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddExistedInstancesRequest(AbstractModel):
    r"""AddExistedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceIds: 实例列表，不支持竞价实例
        :type InstanceIds: list of str
        :param _InstanceAdvancedSettings: 实例额外需要设置参数信息(默认值)
        :type InstanceAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _EnhancedService: 增强服务。通过该参数可以指定是否开启云安全、云监控等服务。若不指定该参数，则默认开启云监控、云安全服务。
        :type EnhancedService: :class:`tencentcloud.tke.v20180525.models.EnhancedService`
        :param _LoginSettings: 节点登录信息（目前仅支持使用Password或者单个KeyIds）
        :type LoginSettings: :class:`tencentcloud.tke.v20180525.models.LoginSettings`
        :param _HostName: 重装系统时，可以指定修改实例的HostName(集群为HostName模式时，此参数必传，规则名称除不支持大写字符外与[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口HostName一致)
        :type HostName: str
        :param _SecurityGroupIds: 实例所属安全组。该参数可以通过调用 DescribeSecurityGroups 的返回值中的sgId字段来获取。若不指定该参数，则绑定默认安全组。（目前仅支持设置单个sgId）
        :type SecurityGroupIds: list of str
        :param _NodePool: 节点池选项
        :type NodePool: :class:`tencentcloud.tke.v20180525.models.NodePoolOption`
        :param _SkipValidateOptions: 校验规则相关选项，可配置跳过某些校验规则。目前支持GlobalRouteCIDRCheck（跳过GlobalRouter的相关校验），VpcCniCIDRCheck（跳过VpcCni相关校验）
        :type SkipValidateOptions: list of str
        :param _InstanceAdvancedSettingsOverrides: 参数InstanceAdvancedSettingsOverride数组用于定制化地配置各台instance，与InstanceIds顺序对应。当传入InstanceAdvancedSettingsOverrides数组时，将覆盖默认参数InstanceAdvancedSettings；当没有传入参数InstanceAdvancedSettingsOverrides时，InstanceAdvancedSettings参数对每台instance生效。参数InstanceAdvancedSettingsOverride数组的长度应与InstanceIds数组一致；当长度大于InstanceIds数组长度时将报错；当长度小于InstanceIds数组时，没有对应配置的instance将使用默认配置。
        :type InstanceAdvancedSettingsOverrides: list of InstanceAdvancedSettings
        :param _ImageId: 节点镜像
        :type ImageId: str
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._InstanceAdvancedSettings = None
        self._EnhancedService = None
        self._LoginSettings = None
        self._HostName = None
        self._SecurityGroupIds = None
        self._NodePool = None
        self._SkipValidateOptions = None
        self._InstanceAdvancedSettingsOverrides = None
        self._ImageId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""实例列表，不支持竞价实例
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def InstanceAdvancedSettings(self):
        r"""实例额外需要设置参数信息(默认值)
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def EnhancedService(self):
        r"""增强服务。通过该参数可以指定是否开启云安全、云监控等服务。若不指定该参数，则默认开启云监控、云安全服务。
        :rtype: :class:`tencentcloud.tke.v20180525.models.EnhancedService`
        """
        return self._EnhancedService

    @EnhancedService.setter
    def EnhancedService(self, EnhancedService):
        self._EnhancedService = EnhancedService

    @property
    def LoginSettings(self):
        r"""节点登录信息（目前仅支持使用Password或者单个KeyIds）
        :rtype: :class:`tencentcloud.tke.v20180525.models.LoginSettings`
        """
        return self._LoginSettings

    @LoginSettings.setter
    def LoginSettings(self, LoginSettings):
        self._LoginSettings = LoginSettings

    @property
    def HostName(self):
        r"""重装系统时，可以指定修改实例的HostName(集群为HostName模式时，此参数必传，规则名称除不支持大写字符外与[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口HostName一致)
        :rtype: str
        """
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def SecurityGroupIds(self):
        r"""实例所属安全组。该参数可以通过调用 DescribeSecurityGroups 的返回值中的sgId字段来获取。若不指定该参数，则绑定默认安全组。（目前仅支持设置单个sgId）
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def NodePool(self):
        r"""节点池选项
        :rtype: :class:`tencentcloud.tke.v20180525.models.NodePoolOption`
        """
        return self._NodePool

    @NodePool.setter
    def NodePool(self, NodePool):
        self._NodePool = NodePool

    @property
    def SkipValidateOptions(self):
        r"""校验规则相关选项，可配置跳过某些校验规则。目前支持GlobalRouteCIDRCheck（跳过GlobalRouter的相关校验），VpcCniCIDRCheck（跳过VpcCni相关校验）
        :rtype: list of str
        """
        return self._SkipValidateOptions

    @SkipValidateOptions.setter
    def SkipValidateOptions(self, SkipValidateOptions):
        self._SkipValidateOptions = SkipValidateOptions

    @property
    def InstanceAdvancedSettingsOverrides(self):
        r"""参数InstanceAdvancedSettingsOverride数组用于定制化地配置各台instance，与InstanceIds顺序对应。当传入InstanceAdvancedSettingsOverrides数组时，将覆盖默认参数InstanceAdvancedSettings；当没有传入参数InstanceAdvancedSettingsOverrides时，InstanceAdvancedSettings参数对每台instance生效。参数InstanceAdvancedSettingsOverride数组的长度应与InstanceIds数组一致；当长度大于InstanceIds数组长度时将报错；当长度小于InstanceIds数组时，没有对应配置的instance将使用默认配置。
        :rtype: list of InstanceAdvancedSettings
        """
        return self._InstanceAdvancedSettingsOverrides

    @InstanceAdvancedSettingsOverrides.setter
    def InstanceAdvancedSettingsOverrides(self, InstanceAdvancedSettingsOverrides):
        self._InstanceAdvancedSettingsOverrides = InstanceAdvancedSettingsOverrides

    @property
    def ImageId(self):
        r"""节点镜像
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        if params.get("EnhancedService") is not None:
            self._EnhancedService = EnhancedService()
            self._EnhancedService._deserialize(params.get("EnhancedService"))
        if params.get("LoginSettings") is not None:
            self._LoginSettings = LoginSettings()
            self._LoginSettings._deserialize(params.get("LoginSettings"))
        self._HostName = params.get("HostName")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("NodePool") is not None:
            self._NodePool = NodePoolOption()
            self._NodePool._deserialize(params.get("NodePool"))
        self._SkipValidateOptions = params.get("SkipValidateOptions")
        if params.get("InstanceAdvancedSettingsOverrides") is not None:
            self._InstanceAdvancedSettingsOverrides = []
            for item in params.get("InstanceAdvancedSettingsOverrides"):
                obj = InstanceAdvancedSettings()
                obj._deserialize(item)
                self._InstanceAdvancedSettingsOverrides.append(obj)
        self._ImageId = params.get("ImageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddExistedInstancesResponse(AbstractModel):
    r"""AddExistedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailedInstanceIds: 失败的节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedInstanceIds: list of str
        :param _SuccInstanceIds: 成功的节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccInstanceIds: list of str
        :param _TimeoutInstanceIds: 超时未返回出来节点的ID(可能失败，也可能成功)
注意：此字段可能返回 null，表示取不到有效值。
        :type TimeoutInstanceIds: list of str
        :param _FailedReasons: 失败的节点的失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedReasons: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailedInstanceIds = None
        self._SuccInstanceIds = None
        self._TimeoutInstanceIds = None
        self._FailedReasons = None
        self._RequestId = None

    @property
    def FailedInstanceIds(self):
        r"""失败的节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._FailedInstanceIds

    @FailedInstanceIds.setter
    def FailedInstanceIds(self, FailedInstanceIds):
        self._FailedInstanceIds = FailedInstanceIds

    @property
    def SuccInstanceIds(self):
        r"""成功的节点ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SuccInstanceIds

    @SuccInstanceIds.setter
    def SuccInstanceIds(self, SuccInstanceIds):
        self._SuccInstanceIds = SuccInstanceIds

    @property
    def TimeoutInstanceIds(self):
        r"""超时未返回出来节点的ID(可能失败，也可能成功)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._TimeoutInstanceIds

    @TimeoutInstanceIds.setter
    def TimeoutInstanceIds(self, TimeoutInstanceIds):
        self._TimeoutInstanceIds = TimeoutInstanceIds

    @property
    def FailedReasons(self):
        r"""失败的节点的失败原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._FailedReasons

    @FailedReasons.setter
    def FailedReasons(self, FailedReasons):
        self._FailedReasons = FailedReasons

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FailedInstanceIds = params.get("FailedInstanceIds")
        self._SuccInstanceIds = params.get("SuccInstanceIds")
        self._TimeoutInstanceIds = params.get("TimeoutInstanceIds")
        self._FailedReasons = params.get("FailedReasons")
        self._RequestId = params.get("RequestId")


class AddNodeToNodePoolRequest(AbstractModel):
    r"""AddNodeToNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _NodePoolId: 节点池id
        :type NodePoolId: str
        :param _InstanceIds: 节点id
        :type InstanceIds: list of str
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._InstanceIds = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池id
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def InstanceIds(self):
        r"""节点id
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNodeToNodePoolResponse(AbstractModel):
    r"""AddNodeToNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddVpcCniSubnetsRequest(AbstractModel):
    r"""AddVpcCniSubnets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _SubnetIds: 为集群容器网络增加的子网列表
        :type SubnetIds: list of str
        :param _VpcId: 集群所属的VPC的ID
        :type VpcId: str
        :param _SkipAddingNonMasqueradeCIDRs: 是否同步添加 vpc 网段到 ip-masq-agent-config 的 NonMasqueradeCIDRs 字段，默认 false 会同步添加
        :type SkipAddingNonMasqueradeCIDRs: bool
        """
        self._ClusterId = None
        self._SubnetIds = None
        self._VpcId = None
        self._SkipAddingNonMasqueradeCIDRs = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SubnetIds(self):
        r"""为集群容器网络增加的子网列表
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def VpcId(self):
        r"""集群所属的VPC的ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SkipAddingNonMasqueradeCIDRs(self):
        r"""是否同步添加 vpc 网段到 ip-masq-agent-config 的 NonMasqueradeCIDRs 字段，默认 false 会同步添加
        :rtype: bool
        """
        return self._SkipAddingNonMasqueradeCIDRs

    @SkipAddingNonMasqueradeCIDRs.setter
    def SkipAddingNonMasqueradeCIDRs(self, SkipAddingNonMasqueradeCIDRs):
        self._SkipAddingNonMasqueradeCIDRs = SkipAddingNonMasqueradeCIDRs


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SubnetIds = params.get("SubnetIds")
        self._VpcId = params.get("VpcId")
        self._SkipAddingNonMasqueradeCIDRs = params.get("SkipAddingNonMasqueradeCIDRs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddVpcCniSubnetsResponse(AbstractModel):
    r"""AddVpcCniSubnets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Addon(AbstractModel):
    r"""addon的具体描述

    """

    def __init__(self):
        r"""
        :param _AddonName: addon名称
        :type AddonName: str
        :param _AddonVersion: addon的版本
        :type AddonVersion: str
        :param _RawValues: addon的参数，是一个json格式的base64转码后的字符串
        :type RawValues: str
        :param _Phase: addon的状态
        :type Phase: str
        :param _Reason: addon失败的原因
        :type Reason: str
        :param _CreateTime: addon的创建时间
        :type CreateTime: str
        """
        self._AddonName = None
        self._AddonVersion = None
        self._RawValues = None
        self._Phase = None
        self._Reason = None
        self._CreateTime = None

    @property
    def AddonName(self):
        r"""addon名称
        :rtype: str
        """
        return self._AddonName

    @AddonName.setter
    def AddonName(self, AddonName):
        self._AddonName = AddonName

    @property
    def AddonVersion(self):
        r"""addon的版本
        :rtype: str
        """
        return self._AddonVersion

    @AddonVersion.setter
    def AddonVersion(self, AddonVersion):
        self._AddonVersion = AddonVersion

    @property
    def RawValues(self):
        r"""addon的参数，是一个json格式的base64转码后的字符串
        :rtype: str
        """
        return self._RawValues

    @RawValues.setter
    def RawValues(self, RawValues):
        self._RawValues = RawValues

    @property
    def Phase(self):
        r"""addon的状态
        :rtype: str
        """
        return self._Phase

    @Phase.setter
    def Phase(self, Phase):
        self._Phase = Phase

    @property
    def Reason(self):
        r"""addon失败的原因
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def CreateTime(self):
        r"""addon的创建时间
        :rtype: str
        """
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime


    def _deserialize(self, params):
        self._AddonName = params.get("AddonName")
        self._AddonVersion = params.get("AddonVersion")
        self._RawValues = params.get("RawValues")
        self._Phase = params.get("Phase")
        self._Reason = params.get("Reason")
        self._CreateTime = params.get("CreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnnotationValue(AbstractModel):
    r"""注释

    """

    def __init__(self):
        r"""
        :param _Name: 注释键
        :type Name: str
        :param _Value: 注释值
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        r"""注释键
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""注释值
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AppChart(AbstractModel):
    r"""app所支持的chart

    """

    def __init__(self):
        r"""
        :param _Name: chart名称
        :type Name: str
        :param _Label: chart的标签
        :type Label: str
        :param _LatestVersion: chart的版本
        :type LatestVersion: str
        """
        self._Name = None
        self._Label = None
        self._LatestVersion = None

    @property
    def Name(self):
        r"""chart名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Label(self):
        r"""chart的标签
        :rtype: str
        """
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def LatestVersion(self):
        r"""chart的版本
        :rtype: str
        """
        return self._LatestVersion

    @LatestVersion.setter
    def LatestVersion(self, LatestVersion):
        self._LatestVersion = LatestVersion


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Label = params.get("Label")
        self._LatestVersion = params.get("LatestVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoScalingGroupRange(AbstractModel):
    r"""集群关联的伸缩组最大实例数最小值实例数

    """

    def __init__(self):
        r"""
        :param _MinSize: 伸缩组最小实例数
        :type MinSize: int
        :param _MaxSize: 伸缩组最大实例数
        :type MaxSize: int
        """
        self._MinSize = None
        self._MaxSize = None

    @property
    def MinSize(self):
        r"""伸缩组最小实例数
        :rtype: int
        """
        return self._MinSize

    @MinSize.setter
    def MinSize(self, MinSize):
        self._MinSize = MinSize

    @property
    def MaxSize(self):
        r"""伸缩组最大实例数
        :rtype: int
        """
        return self._MaxSize

    @MaxSize.setter
    def MaxSize(self, MaxSize):
        self._MaxSize = MaxSize


    def _deserialize(self, params):
        self._MinSize = params.get("MinSize")
        self._MaxSize = params.get("MaxSize")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoUpgradeClusterLevel(AbstractModel):
    r"""自动变配集群等级

    """

    def __init__(self):
        r"""
        :param _IsAutoUpgrade: 是否开启自动变配集群等级
        :type IsAutoUpgrade: bool
        """
        self._IsAutoUpgrade = None

    @property
    def IsAutoUpgrade(self):
        r"""是否开启自动变配集群等级
        :rtype: bool
        """
        return self._IsAutoUpgrade

    @IsAutoUpgrade.setter
    def IsAutoUpgrade(self, IsAutoUpgrade):
        self._IsAutoUpgrade = IsAutoUpgrade


    def _deserialize(self, params):
        self._IsAutoUpgrade = params.get("IsAutoUpgrade")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoscalingAdded(AbstractModel):
    r"""自动扩缩容的节点

    """

    def __init__(self):
        r"""
        :param _Joining: 正在加入中的节点数量
        :type Joining: int
        :param _Initializing: 初始化中的节点数量
        :type Initializing: int
        :param _Normal: 正常的节点数量
        :type Normal: int
        :param _Total: 节点总数
        :type Total: int
        """
        self._Joining = None
        self._Initializing = None
        self._Normal = None
        self._Total = None

    @property
    def Joining(self):
        r"""正在加入中的节点数量
        :rtype: int
        """
        return self._Joining

    @Joining.setter
    def Joining(self, Joining):
        self._Joining = Joining

    @property
    def Initializing(self):
        r"""初始化中的节点数量
        :rtype: int
        """
        return self._Initializing

    @Initializing.setter
    def Initializing(self, Initializing):
        self._Initializing = Initializing

    @property
    def Normal(self):
        r"""正常的节点数量
        :rtype: int
        """
        return self._Normal

    @Normal.setter
    def Normal(self, Normal):
        self._Normal = Normal

    @property
    def Total(self):
        r"""节点总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Joining = params.get("Joining")
        self._Initializing = params.get("Initializing")
        self._Normal = params.get("Normal")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BackupStorageLocation(AbstractModel):
    r"""仓储仓库信息

    """

    def __init__(self):
        r"""
        :param _Name: 备份仓库名称	
        :type Name: str
        :param _StorageRegion: 存储仓库所属地域，比如COS广州(ap-guangzhou)	
        :type StorageRegion: str
        :param _Provider: 存储服务提供方，默认腾讯云	
        :type Provider: str
        :param _Bucket: 对象存储桶名称，如果是COS必须是tke-backup-前缀开头	
        :type Bucket: str
        :param _Path: 对象存储桶路径
        :type Path: str
        :param _State: 存储仓库状态
- Available: 可用
- Unavailable: 不可用
        :type State: str
        :param _Message: 详细状态信息	
        :type Message: str
        :param _LastValidationTime: 最后一次检查时间	
        :type LastValidationTime: str
        """
        self._Name = None
        self._StorageRegion = None
        self._Provider = None
        self._Bucket = None
        self._Path = None
        self._State = None
        self._Message = None
        self._LastValidationTime = None

    @property
    def Name(self):
        r"""备份仓库名称	
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def StorageRegion(self):
        r"""存储仓库所属地域，比如COS广州(ap-guangzhou)	
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def Provider(self):
        r"""存储服务提供方，默认腾讯云	
        :rtype: str
        """
        return self._Provider

    @Provider.setter
    def Provider(self, Provider):
        self._Provider = Provider

    @property
    def Bucket(self):
        r"""对象存储桶名称，如果是COS必须是tke-backup-前缀开头	
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Path(self):
        r"""对象存储桶路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def State(self):
        r"""存储仓库状态
- Available: 可用
- Unavailable: 不可用
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def Message(self):
        r"""详细状态信息	
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def LastValidationTime(self):
        r"""最后一次检查时间	
        :rtype: str
        """
        return self._LastValidationTime

    @LastValidationTime.setter
    def LastValidationTime(self, LastValidationTime):
        self._LastValidationTime = LastValidationTime


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._StorageRegion = params.get("StorageRegion")
        self._Provider = params.get("Provider")
        self._Bucket = params.get("Bucket")
        self._Path = params.get("Path")
        self._State = params.get("State")
        self._Message = params.get("Message")
        self._LastValidationTime = params.get("LastValidationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CUDNN(AbstractModel):
    r"""cuDNN的版本信息

    """

    def __init__(self):
        r"""
        :param _Name: cuDNN的名字
        :type Name: str
        :param _Version: cuDNN的版本
        :type Version: str
        :param _DevName: cuDNN的Dev名字
        :type DevName: str
        :param _DocName: cuDNN的Doc名字
        :type DocName: str
        """
        self._Name = None
        self._Version = None
        self._DevName = None
        self._DocName = None

    @property
    def Name(self):
        r"""cuDNN的名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        r"""cuDNN的版本
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def DevName(self):
        r"""cuDNN的Dev名字
        :rtype: str
        """
        return self._DevName

    @DevName.setter
    def DevName(self, DevName):
        self._DevName = DevName

    @property
    def DocName(self):
        r"""cuDNN的Doc名字
        :rtype: str
        """
        return self._DocName

    @DocName.setter
    def DocName(self, DocName):
        self._DocName = DocName


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        self._DevName = params.get("DevName")
        self._DocName = params.get("DocName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelClusterReleaseRequest(AbstractModel):
    r"""CancelClusterRelease请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ID: 应用ID
        :type ID: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        """
        self._ID = None
        self._ClusterId = None
        self._ClusterType = None

    @property
    def ID(self):
        r"""应用ID
        :rtype: str
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ID = params.get("ID")
        self._ClusterId = params.get("ClusterId")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CancelClusterReleaseResponse(AbstractModel):
    r"""CancelClusterRelease返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Release: 应用信息
        :type Release: :class:`tencentcloud.tke.v20180525.models.PendingRelease`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Release = None
        self._RequestId = None

    @property
    def Release(self):
        r"""应用信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.PendingRelease`
        """
        return self._Release

    @Release.setter
    def Release(self, Release):
        self._Release = Release

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Release") is not None:
            self._Release = PendingRelease()
            self._Release._deserialize(params.get("Release"))
        self._RequestId = params.get("RequestId")


class Capabilities(AbstractModel):
    r"""cloudrun安全特性能力

    """

    def __init__(self):
        r"""
        :param _Add: 启用安全能力项列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Add: list of str
        :param _Drop: 禁用安全能力向列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Drop: list of str
        """
        self._Add = None
        self._Drop = None

    @property
    def Add(self):
        r"""启用安全能力项列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Add

    @Add.setter
    def Add(self, Add):
        self._Add = Add

    @property
    def Drop(self):
        r"""禁用安全能力向列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Drop

    @Drop.setter
    def Drop(self, Drop):
        self._Drop = Drop


    def _deserialize(self, params):
        self._Add = params.get("Add")
        self._Drop = params.get("Drop")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CbsVolume(AbstractModel):
    r"""EKS Instance CBS volume

    """

    def __init__(self):
        r"""
        :param _CbsDiskId: 腾讯云cbs盘Id
        :type CbsDiskId: str
        :param _Name: cbs volume 数据卷名称
        :type Name: str
        """
        self._CbsDiskId = None
        self._Name = None

    @property
    def CbsDiskId(self):
        r"""腾讯云cbs盘Id
        :rtype: str
        """
        return self._CbsDiskId

    @CbsDiskId.setter
    def CbsDiskId(self, CbsDiskId):
        self._CbsDiskId = CbsDiskId

    @property
    def Name(self):
        r"""cbs volume 数据卷名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._CbsDiskId = params.get("CbsDiskId")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckEdgeClusterCIDRRequest(AbstractModel):
    r"""CheckEdgeClusterCIDR请求参数结构体

    """

    def __init__(self):
        r"""
        :param _VpcId: 集群的vpc-id
        :type VpcId: str
        :param _PodCIDR: 集群的pod CIDR
        :type PodCIDR: str
        :param _ServiceCIDR: 集群的service CIDR
        :type ServiceCIDR: str
        """
        self._VpcId = None
        self._PodCIDR = None
        self._ServiceCIDR = None

    @property
    def VpcId(self):
        r"""集群的vpc-id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PodCIDR(self):
        r"""集群的pod CIDR
        :rtype: str
        """
        return self._PodCIDR

    @PodCIDR.setter
    def PodCIDR(self, PodCIDR):
        self._PodCIDR = PodCIDR

    @property
    def ServiceCIDR(self):
        r"""集群的service CIDR
        :rtype: str
        """
        return self._ServiceCIDR

    @ServiceCIDR.setter
    def ServiceCIDR(self, ServiceCIDR):
        self._ServiceCIDR = ServiceCIDR


    def _deserialize(self, params):
        self._VpcId = params.get("VpcId")
        self._PodCIDR = params.get("PodCIDR")
        self._ServiceCIDR = params.get("ServiceCIDR")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckEdgeClusterCIDRResponse(AbstractModel):
    r"""CheckEdgeClusterCIDR返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ConflictCode: 返回码，具体如下
-1 内部错误
0 没冲突
1 vpc 和 serviceCIDR 冲突
2 vpc 和 podCIDR 冲突
3 serviceCIDR  和 podCIDR 冲突
        :type ConflictCode: int
        :param _ConflictMsg: CIDR冲突描述信息。
        :type ConflictMsg: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ConflictCode = None
        self._ConflictMsg = None
        self._RequestId = None

    @property
    def ConflictCode(self):
        r"""返回码，具体如下
-1 内部错误
0 没冲突
1 vpc 和 serviceCIDR 冲突
2 vpc 和 podCIDR 冲突
3 serviceCIDR  和 podCIDR 冲突
        :rtype: int
        """
        return self._ConflictCode

    @ConflictCode.setter
    def ConflictCode(self, ConflictCode):
        self._ConflictCode = ConflictCode

    @property
    def ConflictMsg(self):
        r"""CIDR冲突描述信息。
        :rtype: str
        """
        return self._ConflictMsg

    @ConflictMsg.setter
    def ConflictMsg(self, ConflictMsg):
        self._ConflictMsg = ConflictMsg

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ConflictCode = params.get("ConflictCode")
        self._ConflictMsg = params.get("ConflictMsg")
        self._RequestId = params.get("RequestId")


class CheckInstancesUpgradeAbleRequest(AbstractModel):
    r"""CheckInstancesUpgradeAble请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceIds: 节点列表，空为全部节点
        :type InstanceIds: list of str
        :param _UpgradeType: 升级类型，枚举值：reset(重装升级，支持大版本和小版本)，hot(原地滚动小版本升级)，major(原地滚动大版本升级)
        :type UpgradeType: str
        :param _Offset: 分页Offset
        :type Offset: int
        :param _Limit: 分页Limit
        :type Limit: int
        :param _Filter: 过滤
        :type Filter: list of Filter
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._UpgradeType = None
        self._Offset = None
        self._Limit = None
        self._Filter = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""节点列表，空为全部节点
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def UpgradeType(self):
        r"""升级类型，枚举值：reset(重装升级，支持大版本和小版本)，hot(原地滚动小版本升级)，major(原地滚动大版本升级)
        :rtype: str
        """
        return self._UpgradeType

    @UpgradeType.setter
    def UpgradeType(self, UpgradeType):
        self._UpgradeType = UpgradeType

    @property
    def Offset(self):
        r"""分页Offset
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页Limit
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filter(self):
        r"""过滤
        :rtype: list of Filter
        """
        return self._Filter

    @Filter.setter
    def Filter(self, Filter):
        self._Filter = Filter


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        self._UpgradeType = params.get("UpgradeType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filter") is not None:
            self._Filter = []
            for item in params.get("Filter"):
                obj = Filter()
                obj._deserialize(item)
                self._Filter.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckInstancesUpgradeAbleResponse(AbstractModel):
    r"""CheckInstancesUpgradeAble返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterVersion: 集群master当前小版本
        :type ClusterVersion: str
        :param _LatestVersion: 集群master对应的大版本目前最新小版本
        :type LatestVersion: str
        :param _UpgradeAbleInstances: 可升级节点列表
        :type UpgradeAbleInstances: list of UpgradeAbleInstancesItem
        :param _Total: 总数
        :type Total: int
        :param _UnavailableVersionReason: 不可升级原因
注意：此字段可能返回 null，表示取不到有效值。
        :type UnavailableVersionReason: list of UnavailableReason
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterVersion = None
        self._LatestVersion = None
        self._UpgradeAbleInstances = None
        self._Total = None
        self._UnavailableVersionReason = None
        self._RequestId = None

    @property
    def ClusterVersion(self):
        r"""集群master当前小版本
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def LatestVersion(self):
        r"""集群master对应的大版本目前最新小版本
        :rtype: str
        """
        return self._LatestVersion

    @LatestVersion.setter
    def LatestVersion(self, LatestVersion):
        self._LatestVersion = LatestVersion

    @property
    def UpgradeAbleInstances(self):
        r"""可升级节点列表
        :rtype: list of UpgradeAbleInstancesItem
        """
        return self._UpgradeAbleInstances

    @UpgradeAbleInstances.setter
    def UpgradeAbleInstances(self, UpgradeAbleInstances):
        self._UpgradeAbleInstances = UpgradeAbleInstances

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def UnavailableVersionReason(self):
        r"""不可升级原因
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of UnavailableReason
        """
        return self._UnavailableVersionReason

    @UnavailableVersionReason.setter
    def UnavailableVersionReason(self, UnavailableVersionReason):
        self._UnavailableVersionReason = UnavailableVersionReason

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterVersion = params.get("ClusterVersion")
        self._LatestVersion = params.get("LatestVersion")
        if params.get("UpgradeAbleInstances") is not None:
            self._UpgradeAbleInstances = []
            for item in params.get("UpgradeAbleInstances"):
                obj = UpgradeAbleInstancesItem()
                obj._deserialize(item)
                self._UpgradeAbleInstances.append(obj)
        self._Total = params.get("Total")
        if params.get("UnavailableVersionReason") is not None:
            self._UnavailableVersionReason = []
            for item in params.get("UnavailableVersionReason"):
                obj = UnavailableReason()
                obj._deserialize(item)
                self._UnavailableVersionReason.append(obj)
        self._RequestId = params.get("RequestId")


class Cluster(AbstractModel):
    r"""集群信息结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterDescription: 集群描述
        :type ClusterDescription: str
        :param _ClusterVersion: 集群版本（默认值为1.10.5）
        :type ClusterVersion: str
        :param _ClusterOs: 集群系统。centos7.2x86_64 或者 ubuntu16.04.1 LTSx86_64，默认取值为ubuntu16.04.1 LTSx86_64
        :type ClusterOs: str
        :param _ClusterType: 集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER。
        :type ClusterType: str
        :param _ClusterNetworkSettings: 集群网络相关参数
        :type ClusterNetworkSettings: :class:`tencentcloud.tke.v20180525.models.ClusterNetworkSettings`
        :param _ClusterNodeNum: 集群当前node数量
        :type ClusterNodeNum: int
        :param _ProjectId: 集群所属的项目ID
        :type ProjectId: int
        :param _TagSpecification: 标签描述列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSpecification: list of TagSpecification
        :param _ClusterStatus: 集群状态 (Trading 集群开通中,Creating 创建中,Running 运行中,Deleting 删除中,Idling 闲置中,Recovering 唤醒中,Scaling 规模调整中,Upgrading 升级中,WaittingForConnect 等待注册,Trading 集群开通中,Isolated 欠费隔离中,Pause 集群升级暂停,NodeUpgrading 节点升级中,RuntimeUpgrading 节点运行时升级中,MasterScaling Master扩缩容中,ClusterLevelUpgrading 调整规格中,ResourceIsolate 隔离中,ResourceIsolated 已隔离,ResourceReverse 冲正中,Abnormal 异常)
        :type ClusterStatus: str
        :param _Property: 集群属性(包括集群不同属性的MAP，属性字段包括NodeNameType (lan-ip模式和hostname 模式，默认无lan-ip模式))
        :type Property: str
        :param _ClusterMaterNodeNum: 集群当前master数量
        :type ClusterMaterNodeNum: int
        :param _ImageId: 集群使用镜像id
        :type ImageId: str
        :param _OsCustomizeType: OsCustomizeType 系统定制类型
        :type OsCustomizeType: str
        :param _ContainerRuntime: 集群运行环境docker或container
        :type ContainerRuntime: str
        :param _CreatedTime: 创建时间
        :type CreatedTime: str
        :param _DeletionProtection: 删除保护开关
        :type DeletionProtection: bool
        :param _EnableExternalNode: 集群是否开启第三方节点支持
        :type EnableExternalNode: bool
        :param _ClusterLevel: 集群等级，针对托管集群生效
        :type ClusterLevel: str
        :param _AutoUpgradeClusterLevel: 自动变配集群等级，针对托管集群生效
        :type AutoUpgradeClusterLevel: bool
        :param _QGPUShareEnable: 是否开启QGPU共享
        :type QGPUShareEnable: bool
        :param _RuntimeVersion: 运行时版本
        :type RuntimeVersion: str
        :param _ClusterEtcdNodeNum: 集群当前etcd数量
        :type ClusterEtcdNodeNum: int
        :param _CdcId: 本地专用集群Id
        :type CdcId: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterDescription = None
        self._ClusterVersion = None
        self._ClusterOs = None
        self._ClusterType = None
        self._ClusterNetworkSettings = None
        self._ClusterNodeNum = None
        self._ProjectId = None
        self._TagSpecification = None
        self._ClusterStatus = None
        self._Property = None
        self._ClusterMaterNodeNum = None
        self._ImageId = None
        self._OsCustomizeType = None
        self._ContainerRuntime = None
        self._CreatedTime = None
        self._DeletionProtection = None
        self._EnableExternalNode = None
        self._ClusterLevel = None
        self._AutoUpgradeClusterLevel = None
        self._QGPUShareEnable = None
        self._RuntimeVersion = None
        self._ClusterEtcdNodeNum = None
        self._CdcId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterDescription(self):
        r"""集群描述
        :rtype: str
        """
        return self._ClusterDescription

    @ClusterDescription.setter
    def ClusterDescription(self, ClusterDescription):
        self._ClusterDescription = ClusterDescription

    @property
    def ClusterVersion(self):
        r"""集群版本（默认值为1.10.5）
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ClusterOs(self):
        r"""集群系统。centos7.2x86_64 或者 ubuntu16.04.1 LTSx86_64，默认取值为ubuntu16.04.1 LTSx86_64
        :rtype: str
        """
        return self._ClusterOs

    @ClusterOs.setter
    def ClusterOs(self, ClusterOs):
        self._ClusterOs = ClusterOs

    @property
    def ClusterType(self):
        r"""集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterNetworkSettings(self):
        r"""集群网络相关参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterNetworkSettings`
        """
        return self._ClusterNetworkSettings

    @ClusterNetworkSettings.setter
    def ClusterNetworkSettings(self, ClusterNetworkSettings):
        self._ClusterNetworkSettings = ClusterNetworkSettings

    @property
    def ClusterNodeNum(self):
        r"""集群当前node数量
        :rtype: int
        """
        return self._ClusterNodeNum

    @ClusterNodeNum.setter
    def ClusterNodeNum(self, ClusterNodeNum):
        self._ClusterNodeNum = ClusterNodeNum

    @property
    def ProjectId(self):
        r"""集群所属的项目ID
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TagSpecification(self):
        r"""标签描述列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TagSpecification
        """
        return self._TagSpecification

    @TagSpecification.setter
    def TagSpecification(self, TagSpecification):
        self._TagSpecification = TagSpecification

    @property
    def ClusterStatus(self):
        r"""集群状态 (Trading 集群开通中,Creating 创建中,Running 运行中,Deleting 删除中,Idling 闲置中,Recovering 唤醒中,Scaling 规模调整中,Upgrading 升级中,WaittingForConnect 等待注册,Trading 集群开通中,Isolated 欠费隔离中,Pause 集群升级暂停,NodeUpgrading 节点升级中,RuntimeUpgrading 节点运行时升级中,MasterScaling Master扩缩容中,ClusterLevelUpgrading 调整规格中,ResourceIsolate 隔离中,ResourceIsolated 已隔离,ResourceReverse 冲正中,Abnormal 异常)
        :rtype: str
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def Property(self):
        r"""集群属性(包括集群不同属性的MAP，属性字段包括NodeNameType (lan-ip模式和hostname 模式，默认无lan-ip模式))
        :rtype: str
        """
        return self._Property

    @Property.setter
    def Property(self, Property):
        self._Property = Property

    @property
    def ClusterMaterNodeNum(self):
        r"""集群当前master数量
        :rtype: int
        """
        return self._ClusterMaterNodeNum

    @ClusterMaterNodeNum.setter
    def ClusterMaterNodeNum(self, ClusterMaterNodeNum):
        self._ClusterMaterNodeNum = ClusterMaterNodeNum

    @property
    def ImageId(self):
        r"""集群使用镜像id
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def OsCustomizeType(self):
        r"""OsCustomizeType 系统定制类型
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType

    @property
    def ContainerRuntime(self):
        r"""集群运行环境docker或container
        :rtype: str
        """
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def CreatedTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def DeletionProtection(self):
        r"""删除保护开关
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection

    @property
    def EnableExternalNode(self):
        r"""集群是否开启第三方节点支持
        :rtype: bool
        """
        return self._EnableExternalNode

    @EnableExternalNode.setter
    def EnableExternalNode(self, EnableExternalNode):
        self._EnableExternalNode = EnableExternalNode

    @property
    def ClusterLevel(self):
        r"""集群等级，针对托管集群生效
        :rtype: str
        """
        return self._ClusterLevel

    @ClusterLevel.setter
    def ClusterLevel(self, ClusterLevel):
        self._ClusterLevel = ClusterLevel

    @property
    def AutoUpgradeClusterLevel(self):
        r"""自动变配集群等级，针对托管集群生效
        :rtype: bool
        """
        return self._AutoUpgradeClusterLevel

    @AutoUpgradeClusterLevel.setter
    def AutoUpgradeClusterLevel(self, AutoUpgradeClusterLevel):
        self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel

    @property
    def QGPUShareEnable(self):
        r"""是否开启QGPU共享
        :rtype: bool
        """
        return self._QGPUShareEnable

    @QGPUShareEnable.setter
    def QGPUShareEnable(self, QGPUShareEnable):
        self._QGPUShareEnable = QGPUShareEnable

    @property
    def RuntimeVersion(self):
        r"""运行时版本
        :rtype: str
        """
        return self._RuntimeVersion

    @RuntimeVersion.setter
    def RuntimeVersion(self, RuntimeVersion):
        self._RuntimeVersion = RuntimeVersion

    @property
    def ClusterEtcdNodeNum(self):
        r"""集群当前etcd数量
        :rtype: int
        """
        return self._ClusterEtcdNodeNum

    @ClusterEtcdNodeNum.setter
    def ClusterEtcdNodeNum(self, ClusterEtcdNodeNum):
        self._ClusterEtcdNodeNum = ClusterEtcdNodeNum

    @property
    def CdcId(self):
        r"""本地专用集群Id
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterDescription = params.get("ClusterDescription")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ClusterOs = params.get("ClusterOs")
        self._ClusterType = params.get("ClusterType")
        if params.get("ClusterNetworkSettings") is not None:
            self._ClusterNetworkSettings = ClusterNetworkSettings()
            self._ClusterNetworkSettings._deserialize(params.get("ClusterNetworkSettings"))
        self._ClusterNodeNum = params.get("ClusterNodeNum")
        self._ProjectId = params.get("ProjectId")
        if params.get("TagSpecification") is not None:
            self._TagSpecification = []
            for item in params.get("TagSpecification"):
                obj = TagSpecification()
                obj._deserialize(item)
                self._TagSpecification.append(obj)
        self._ClusterStatus = params.get("ClusterStatus")
        self._Property = params.get("Property")
        self._ClusterMaterNodeNum = params.get("ClusterMaterNodeNum")
        self._ImageId = params.get("ImageId")
        self._OsCustomizeType = params.get("OsCustomizeType")
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._CreatedTime = params.get("CreatedTime")
        self._DeletionProtection = params.get("DeletionProtection")
        self._EnableExternalNode = params.get("EnableExternalNode")
        self._ClusterLevel = params.get("ClusterLevel")
        self._AutoUpgradeClusterLevel = params.get("AutoUpgradeClusterLevel")
        self._QGPUShareEnable = params.get("QGPUShareEnable")
        self._RuntimeVersion = params.get("RuntimeVersion")
        self._ClusterEtcdNodeNum = params.get("ClusterEtcdNodeNum")
        self._CdcId = params.get("CdcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterAdvancedSettings(AbstractModel):
    r"""集群高级配置

    """

    def __init__(self):
        r"""
        :param _AsEnabled: 是否启用集群节点自动扩缩容(创建集群流程不支持开启此功能)
        :type AsEnabled: bool
        :param _AuditEnabled: 是否开启审计开关
        :type AuditEnabled: bool
        :param _AuditLogTopicId: 审计日志上传到的topic
        :type AuditLogTopicId: str
        :param _AuditLogsetId: 审计日志上传到的logset日志集
        :type AuditLogsetId: str
        :param _BasePodNumber: 自定义模式下的基础pod数量
        :type BasePodNumber: int
        :param _CiliumMode: 启用 CiliumMode 的模式，空值表示不启用，“clusterIP” 表示启用 Cilium 支持 ClusterIP
        :type CiliumMode: str
        :param _ContainerRuntime: 集群使用的runtime类型，包括"docker"和"containerd"两种类型，默认为"docker"
        :type ContainerRuntime: str
        :param _DataPlaneV2: 是否启用 DataPlaneV2（cilium替代kube-proxy） 
        :type DataPlaneV2: bool
        :param _DeletionProtection: 是否启用集群删除保护
        :type DeletionProtection: bool
        :param _EnableCustomizedPodCIDR: 是否开节点podCIDR大小的自定义模式
        :type EnableCustomizedPodCIDR: bool
        :param _EtcdOverrideConfigs: 元数据拆分存储Etcd配置
        :type EtcdOverrideConfigs: list of EtcdOverrideConfig
        :param _ExtraArgs: 集群自定义参数
        :type ExtraArgs: :class:`tencentcloud.tke.v20180525.models.ClusterExtraArgs`
        :param _IPVS: 是否启用IPVS
        :type IPVS: bool
        :param _IsDualStack: 集群VPC-CNI模式下是否是双栈集群，默认false，表明非双栈集群。
        :type IsDualStack: bool
        :param _IsNonStaticIpMode: 集群VPC-CNI模式是否为非固定IP，默认: FALSE 固定IP。
        :type IsNonStaticIpMode: bool
        :param _KubeProxyMode: 集群的网络代理模型，目前tke集群支持的网络代理模式有三种：iptables,ipvs,ipvs-bpf，此参数仅在使用ipvs-bpf模式时使用，三种网络模式的参数设置关系如下：
iptables模式：IPVS和KubeProxyMode都不设置
ipvs模式: 设置IPVS为true, KubeProxyMode不设置
ipvs-bpf模式: 设置KubeProxyMode为kube-proxy-bpf
使用ipvs-bpf的网络模式需要满足以下条件：
1. 集群版本必须为1.14及以上；
2. 系统镜像必须是: Tencent Linux 2.4；
        :type KubeProxyMode: str
        :param _NetworkType: 集群网络类型，默认为GR。
- GR: 全局路由
- VPC-CNI: VPC-CNI模式
- CiliumOverlay: CiliumOverlay模式
        :type NetworkType: str
        :param _NodeNameType: 集群中节点NodeName类型（包括 hostname,lan-ip两种形式，默认为lan-ip。如果开启了hostname模式，创建节点时需要设置HostName参数，并且InstanceName需要和HostName一致）
        :type NodeNameType: str
        :param _QGPUShareEnable: 是否开启QGPU共享
        :type QGPUShareEnable: bool
        :param _RuntimeVersion: 运行时版本
        :type RuntimeVersion: str
        :param _VpcCniType: 区分共享网卡多IP模式和独立网卡模式，共享网卡多 IP 模式填写"tke-route-eni"，独立网卡模式填写"tke-direct-eni"，默认为共享网卡模式
        :type VpcCniType: str
        """
        self._AsEnabled = None
        self._AuditEnabled = None
        self._AuditLogTopicId = None
        self._AuditLogsetId = None
        self._BasePodNumber = None
        self._CiliumMode = None
        self._ContainerRuntime = None
        self._DataPlaneV2 = None
        self._DeletionProtection = None
        self._EnableCustomizedPodCIDR = None
        self._EtcdOverrideConfigs = None
        self._ExtraArgs = None
        self._IPVS = None
        self._IsDualStack = None
        self._IsNonStaticIpMode = None
        self._KubeProxyMode = None
        self._NetworkType = None
        self._NodeNameType = None
        self._QGPUShareEnable = None
        self._RuntimeVersion = None
        self._VpcCniType = None

    @property
    def AsEnabled(self):
        r"""是否启用集群节点自动扩缩容(创建集群流程不支持开启此功能)
        :rtype: bool
        """
        return self._AsEnabled

    @AsEnabled.setter
    def AsEnabled(self, AsEnabled):
        self._AsEnabled = AsEnabled

    @property
    def AuditEnabled(self):
        r"""是否开启审计开关
        :rtype: bool
        """
        return self._AuditEnabled

    @AuditEnabled.setter
    def AuditEnabled(self, AuditEnabled):
        self._AuditEnabled = AuditEnabled

    @property
    def AuditLogTopicId(self):
        r"""审计日志上传到的topic
        :rtype: str
        """
        return self._AuditLogTopicId

    @AuditLogTopicId.setter
    def AuditLogTopicId(self, AuditLogTopicId):
        self._AuditLogTopicId = AuditLogTopicId

    @property
    def AuditLogsetId(self):
        r"""审计日志上传到的logset日志集
        :rtype: str
        """
        return self._AuditLogsetId

    @AuditLogsetId.setter
    def AuditLogsetId(self, AuditLogsetId):
        self._AuditLogsetId = AuditLogsetId

    @property
    def BasePodNumber(self):
        r"""自定义模式下的基础pod数量
        :rtype: int
        """
        return self._BasePodNumber

    @BasePodNumber.setter
    def BasePodNumber(self, BasePodNumber):
        self._BasePodNumber = BasePodNumber

    @property
    def CiliumMode(self):
        r"""启用 CiliumMode 的模式，空值表示不启用，“clusterIP” 表示启用 Cilium 支持 ClusterIP
        :rtype: str
        """
        return self._CiliumMode

    @CiliumMode.setter
    def CiliumMode(self, CiliumMode):
        self._CiliumMode = CiliumMode

    @property
    def ContainerRuntime(self):
        r"""集群使用的runtime类型，包括"docker"和"containerd"两种类型，默认为"docker"
        :rtype: str
        """
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def DataPlaneV2(self):
        r"""是否启用 DataPlaneV2（cilium替代kube-proxy） 
        :rtype: bool
        """
        return self._DataPlaneV2

    @DataPlaneV2.setter
    def DataPlaneV2(self, DataPlaneV2):
        self._DataPlaneV2 = DataPlaneV2

    @property
    def DeletionProtection(self):
        r"""是否启用集群删除保护
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection

    @property
    def EnableCustomizedPodCIDR(self):
        r"""是否开节点podCIDR大小的自定义模式
        :rtype: bool
        """
        return self._EnableCustomizedPodCIDR

    @EnableCustomizedPodCIDR.setter
    def EnableCustomizedPodCIDR(self, EnableCustomizedPodCIDR):
        self._EnableCustomizedPodCIDR = EnableCustomizedPodCIDR

    @property
    def EtcdOverrideConfigs(self):
        r"""元数据拆分存储Etcd配置
        :rtype: list of EtcdOverrideConfig
        """
        return self._EtcdOverrideConfigs

    @EtcdOverrideConfigs.setter
    def EtcdOverrideConfigs(self, EtcdOverrideConfigs):
        self._EtcdOverrideConfigs = EtcdOverrideConfigs

    @property
    def ExtraArgs(self):
        r"""集群自定义参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterExtraArgs`
        """
        return self._ExtraArgs

    @ExtraArgs.setter
    def ExtraArgs(self, ExtraArgs):
        self._ExtraArgs = ExtraArgs

    @property
    def IPVS(self):
        r"""是否启用IPVS
        :rtype: bool
        """
        return self._IPVS

    @IPVS.setter
    def IPVS(self, IPVS):
        self._IPVS = IPVS

    @property
    def IsDualStack(self):
        r"""集群VPC-CNI模式下是否是双栈集群，默认false，表明非双栈集群。
        :rtype: bool
        """
        return self._IsDualStack

    @IsDualStack.setter
    def IsDualStack(self, IsDualStack):
        self._IsDualStack = IsDualStack

    @property
    def IsNonStaticIpMode(self):
        r"""集群VPC-CNI模式是否为非固定IP，默认: FALSE 固定IP。
        :rtype: bool
        """
        return self._IsNonStaticIpMode

    @IsNonStaticIpMode.setter
    def IsNonStaticIpMode(self, IsNonStaticIpMode):
        self._IsNonStaticIpMode = IsNonStaticIpMode

    @property
    def KubeProxyMode(self):
        r"""集群的网络代理模型，目前tke集群支持的网络代理模式有三种：iptables,ipvs,ipvs-bpf，此参数仅在使用ipvs-bpf模式时使用，三种网络模式的参数设置关系如下：
iptables模式：IPVS和KubeProxyMode都不设置
ipvs模式: 设置IPVS为true, KubeProxyMode不设置
ipvs-bpf模式: 设置KubeProxyMode为kube-proxy-bpf
使用ipvs-bpf的网络模式需要满足以下条件：
1. 集群版本必须为1.14及以上；
2. 系统镜像必须是: Tencent Linux 2.4；
        :rtype: str
        """
        return self._KubeProxyMode

    @KubeProxyMode.setter
    def KubeProxyMode(self, KubeProxyMode):
        self._KubeProxyMode = KubeProxyMode

    @property
    def NetworkType(self):
        r"""集群网络类型，默认为GR。
- GR: 全局路由
- VPC-CNI: VPC-CNI模式
- CiliumOverlay: CiliumOverlay模式
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def NodeNameType(self):
        r"""集群中节点NodeName类型（包括 hostname,lan-ip两种形式，默认为lan-ip。如果开启了hostname模式，创建节点时需要设置HostName参数，并且InstanceName需要和HostName一致）
        :rtype: str
        """
        return self._NodeNameType

    @NodeNameType.setter
    def NodeNameType(self, NodeNameType):
        self._NodeNameType = NodeNameType

    @property
    def QGPUShareEnable(self):
        r"""是否开启QGPU共享
        :rtype: bool
        """
        return self._QGPUShareEnable

    @QGPUShareEnable.setter
    def QGPUShareEnable(self, QGPUShareEnable):
        self._QGPUShareEnable = QGPUShareEnable

    @property
    def RuntimeVersion(self):
        r"""运行时版本
        :rtype: str
        """
        return self._RuntimeVersion

    @RuntimeVersion.setter
    def RuntimeVersion(self, RuntimeVersion):
        self._RuntimeVersion = RuntimeVersion

    @property
    def VpcCniType(self):
        r"""区分共享网卡多IP模式和独立网卡模式，共享网卡多 IP 模式填写"tke-route-eni"，独立网卡模式填写"tke-direct-eni"，默认为共享网卡模式
        :rtype: str
        """
        return self._VpcCniType

    @VpcCniType.setter
    def VpcCniType(self, VpcCniType):
        self._VpcCniType = VpcCniType


    def _deserialize(self, params):
        self._AsEnabled = params.get("AsEnabled")
        self._AuditEnabled = params.get("AuditEnabled")
        self._AuditLogTopicId = params.get("AuditLogTopicId")
        self._AuditLogsetId = params.get("AuditLogsetId")
        self._BasePodNumber = params.get("BasePodNumber")
        self._CiliumMode = params.get("CiliumMode")
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._DataPlaneV2 = params.get("DataPlaneV2")
        self._DeletionProtection = params.get("DeletionProtection")
        self._EnableCustomizedPodCIDR = params.get("EnableCustomizedPodCIDR")
        if params.get("EtcdOverrideConfigs") is not None:
            self._EtcdOverrideConfigs = []
            for item in params.get("EtcdOverrideConfigs"):
                obj = EtcdOverrideConfig()
                obj._deserialize(item)
                self._EtcdOverrideConfigs.append(obj)
        if params.get("ExtraArgs") is not None:
            self._ExtraArgs = ClusterExtraArgs()
            self._ExtraArgs._deserialize(params.get("ExtraArgs"))
        self._IPVS = params.get("IPVS")
        self._IsDualStack = params.get("IsDualStack")
        self._IsNonStaticIpMode = params.get("IsNonStaticIpMode")
        self._KubeProxyMode = params.get("KubeProxyMode")
        self._NetworkType = params.get("NetworkType")
        self._NodeNameType = params.get("NodeNameType")
        self._QGPUShareEnable = params.get("QGPUShareEnable")
        self._RuntimeVersion = params.get("RuntimeVersion")
        self._VpcCniType = params.get("VpcCniType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterAsGroup(AbstractModel):
    r"""集群关联的伸缩组信息

    """

    def __init__(self):
        r"""
        :param _AutoScalingGroupId: 伸缩组ID
        :type AutoScalingGroupId: str
        :param _Status: 伸缩组状态(开启 enabled 开启中 enabling 关闭 disabled 关闭中 disabling 更新中 updating 删除中 deleting 开启缩容中 scaleDownEnabling 关闭缩容中 scaleDownDisabling)
        :type Status: str
        :param _IsUnschedulable: 节点是否设置成不可调度
        :type IsUnschedulable: bool
        :param _Labels: 伸缩组的label列表
        :type Labels: list of Label
        :param _CreatedTime: 创建时间
        :type CreatedTime: str
        """
        self._AutoScalingGroupId = None
        self._Status = None
        self._IsUnschedulable = None
        self._Labels = None
        self._CreatedTime = None

    @property
    def AutoScalingGroupId(self):
        r"""伸缩组ID
        :rtype: str
        """
        return self._AutoScalingGroupId

    @AutoScalingGroupId.setter
    def AutoScalingGroupId(self, AutoScalingGroupId):
        self._AutoScalingGroupId = AutoScalingGroupId

    @property
    def Status(self):
        r"""伸缩组状态(开启 enabled 开启中 enabling 关闭 disabled 关闭中 disabling 更新中 updating 删除中 deleting 开启缩容中 scaleDownEnabling 关闭缩容中 scaleDownDisabling)
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsUnschedulable(self):
        r"""节点是否设置成不可调度
        :rtype: bool
        """
        return self._IsUnschedulable

    @IsUnschedulable.setter
    def IsUnschedulable(self, IsUnschedulable):
        self._IsUnschedulable = IsUnschedulable

    @property
    def Labels(self):
        r"""伸缩组的label列表
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def CreatedTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime


    def _deserialize(self, params):
        self._AutoScalingGroupId = params.get("AutoScalingGroupId")
        self._Status = params.get("Status")
        self._IsUnschedulable = params.get("IsUnschedulable")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        self._CreatedTime = params.get("CreatedTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterAsGroupAttribute(AbstractModel):
    r"""集群伸缩组属性

    """

    def __init__(self):
        r"""
        :param _AutoScalingGroupId: 伸缩组ID
        :type AutoScalingGroupId: str
        :param _AutoScalingGroupEnabled: 是否开启
        :type AutoScalingGroupEnabled: bool
        :param _AutoScalingGroupRange: 伸缩组最大最小实例数
        :type AutoScalingGroupRange: :class:`tencentcloud.tke.v20180525.models.AutoScalingGroupRange`
        """
        self._AutoScalingGroupId = None
        self._AutoScalingGroupEnabled = None
        self._AutoScalingGroupRange = None

    @property
    def AutoScalingGroupId(self):
        r"""伸缩组ID
        :rtype: str
        """
        return self._AutoScalingGroupId

    @AutoScalingGroupId.setter
    def AutoScalingGroupId(self, AutoScalingGroupId):
        self._AutoScalingGroupId = AutoScalingGroupId

    @property
    def AutoScalingGroupEnabled(self):
        r"""是否开启
        :rtype: bool
        """
        return self._AutoScalingGroupEnabled

    @AutoScalingGroupEnabled.setter
    def AutoScalingGroupEnabled(self, AutoScalingGroupEnabled):
        self._AutoScalingGroupEnabled = AutoScalingGroupEnabled

    @property
    def AutoScalingGroupRange(self):
        r"""伸缩组最大最小实例数
        :rtype: :class:`tencentcloud.tke.v20180525.models.AutoScalingGroupRange`
        """
        return self._AutoScalingGroupRange

    @AutoScalingGroupRange.setter
    def AutoScalingGroupRange(self, AutoScalingGroupRange):
        self._AutoScalingGroupRange = AutoScalingGroupRange


    def _deserialize(self, params):
        self._AutoScalingGroupId = params.get("AutoScalingGroupId")
        self._AutoScalingGroupEnabled = params.get("AutoScalingGroupEnabled")
        if params.get("AutoScalingGroupRange") is not None:
            self._AutoScalingGroupRange = AutoScalingGroupRange()
            self._AutoScalingGroupRange._deserialize(params.get("AutoScalingGroupRange"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterAsGroupOption(AbstractModel):
    r"""集群弹性伸缩配置

    """

    def __init__(self):
        r"""
        :param _IsScaleDownEnabled: 是否开启缩容
注意：此字段可能返回 null，表示取不到有效值。
        :type IsScaleDownEnabled: bool
        :param _Expander: 多伸缩组情况下扩容选择算法(random 随机选择，most-pods 最多类型的Pod least-waste 最少的资源浪费，默认为random)
        :type Expander: str
        :param _MaxEmptyBulkDelete: 最大并发缩容数
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxEmptyBulkDelete: int
        :param _ScaleDownDelay: 集群扩容后多少分钟开始判断缩容（默认为10分钟）
注意：此字段可能返回 null，表示取不到有效值。
        :type ScaleDownDelay: int
        :param _ScaleDownUnneededTime: 节点连续空闲多少分钟后被缩容（默认为 10分钟）
注意：此字段可能返回 null，表示取不到有效值。
        :type ScaleDownUnneededTime: int
        :param _ScaleDownUtilizationThreshold: 节点资源使用量低于多少(百分比)时认为空闲(默认: 50(百分比))
注意：此字段可能返回 null，表示取不到有效值。
        :type ScaleDownUtilizationThreshold: int
        :param _SkipNodesWithLocalStorage: 含有本地存储Pod的节点是否不缩容(默认： true)
注意：此字段可能返回 null，表示取不到有效值。
        :type SkipNodesWithLocalStorage: bool
        :param _SkipNodesWithSystemPods: 含有kube-system namespace下非DaemonSet管理的Pod的节点是否不缩容 (默认： true)
注意：此字段可能返回 null，表示取不到有效值。
        :type SkipNodesWithSystemPods: bool
        :param _IgnoreDaemonSetsUtilization: 计算资源使用量时是否默认忽略DaemonSet的实例(默认值: False，不忽略)
注意：此字段可能返回 null，表示取不到有效值。
        :type IgnoreDaemonSetsUtilization: bool
        :param _OkTotalUnreadyCount: CA做健康性判断的个数，默认3，即超过OkTotalUnreadyCount个数后，CA会进行健康性判断。
注意：此字段可能返回 null，表示取不到有效值。
        :type OkTotalUnreadyCount: int
        :param _MaxTotalUnreadyPercentage: 未就绪节点的最大百分比，此后CA会停止操作
注意：此字段可能返回 null，表示取不到有效值。
        :type MaxTotalUnreadyPercentage: int
        :param _ScaleDownUnreadyTime: 表示未准备就绪的节点在有资格进行缩减之前应该停留多长时间
注意：此字段可能返回 null，表示取不到有效值。
        :type ScaleDownUnreadyTime: int
        :param _UnregisteredNodeRemovalTime: CA删除未在Kubernetes中注册的节点之前等待的时间
注意：此字段可能返回 null，表示取不到有效值。
        :type UnregisteredNodeRemovalTime: int
        """
        self._IsScaleDownEnabled = None
        self._Expander = None
        self._MaxEmptyBulkDelete = None
        self._ScaleDownDelay = None
        self._ScaleDownUnneededTime = None
        self._ScaleDownUtilizationThreshold = None
        self._SkipNodesWithLocalStorage = None
        self._SkipNodesWithSystemPods = None
        self._IgnoreDaemonSetsUtilization = None
        self._OkTotalUnreadyCount = None
        self._MaxTotalUnreadyPercentage = None
        self._ScaleDownUnreadyTime = None
        self._UnregisteredNodeRemovalTime = None

    @property
    def IsScaleDownEnabled(self):
        r"""是否开启缩容
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IsScaleDownEnabled

    @IsScaleDownEnabled.setter
    def IsScaleDownEnabled(self, IsScaleDownEnabled):
        self._IsScaleDownEnabled = IsScaleDownEnabled

    @property
    def Expander(self):
        r"""多伸缩组情况下扩容选择算法(random 随机选择，most-pods 最多类型的Pod least-waste 最少的资源浪费，默认为random)
        :rtype: str
        """
        return self._Expander

    @Expander.setter
    def Expander(self, Expander):
        self._Expander = Expander

    @property
    def MaxEmptyBulkDelete(self):
        r"""最大并发缩容数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxEmptyBulkDelete

    @MaxEmptyBulkDelete.setter
    def MaxEmptyBulkDelete(self, MaxEmptyBulkDelete):
        self._MaxEmptyBulkDelete = MaxEmptyBulkDelete

    @property
    def ScaleDownDelay(self):
        r"""集群扩容后多少分钟开始判断缩容（默认为10分钟）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ScaleDownDelay

    @ScaleDownDelay.setter
    def ScaleDownDelay(self, ScaleDownDelay):
        self._ScaleDownDelay = ScaleDownDelay

    @property
    def ScaleDownUnneededTime(self):
        r"""节点连续空闲多少分钟后被缩容（默认为 10分钟）
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ScaleDownUnneededTime

    @ScaleDownUnneededTime.setter
    def ScaleDownUnneededTime(self, ScaleDownUnneededTime):
        self._ScaleDownUnneededTime = ScaleDownUnneededTime

    @property
    def ScaleDownUtilizationThreshold(self):
        r"""节点资源使用量低于多少(百分比)时认为空闲(默认: 50(百分比))
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ScaleDownUtilizationThreshold

    @ScaleDownUtilizationThreshold.setter
    def ScaleDownUtilizationThreshold(self, ScaleDownUtilizationThreshold):
        self._ScaleDownUtilizationThreshold = ScaleDownUtilizationThreshold

    @property
    def SkipNodesWithLocalStorage(self):
        r"""含有本地存储Pod的节点是否不缩容(默认： true)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._SkipNodesWithLocalStorage

    @SkipNodesWithLocalStorage.setter
    def SkipNodesWithLocalStorage(self, SkipNodesWithLocalStorage):
        self._SkipNodesWithLocalStorage = SkipNodesWithLocalStorage

    @property
    def SkipNodesWithSystemPods(self):
        r"""含有kube-system namespace下非DaemonSet管理的Pod的节点是否不缩容 (默认： true)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._SkipNodesWithSystemPods

    @SkipNodesWithSystemPods.setter
    def SkipNodesWithSystemPods(self, SkipNodesWithSystemPods):
        self._SkipNodesWithSystemPods = SkipNodesWithSystemPods

    @property
    def IgnoreDaemonSetsUtilization(self):
        r"""计算资源使用量时是否默认忽略DaemonSet的实例(默认值: False，不忽略)
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._IgnoreDaemonSetsUtilization

    @IgnoreDaemonSetsUtilization.setter
    def IgnoreDaemonSetsUtilization(self, IgnoreDaemonSetsUtilization):
        self._IgnoreDaemonSetsUtilization = IgnoreDaemonSetsUtilization

    @property
    def OkTotalUnreadyCount(self):
        r"""CA做健康性判断的个数，默认3，即超过OkTotalUnreadyCount个数后，CA会进行健康性判断。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._OkTotalUnreadyCount

    @OkTotalUnreadyCount.setter
    def OkTotalUnreadyCount(self, OkTotalUnreadyCount):
        self._OkTotalUnreadyCount = OkTotalUnreadyCount

    @property
    def MaxTotalUnreadyPercentage(self):
        r"""未就绪节点的最大百分比，此后CA会停止操作
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._MaxTotalUnreadyPercentage

    @MaxTotalUnreadyPercentage.setter
    def MaxTotalUnreadyPercentage(self, MaxTotalUnreadyPercentage):
        self._MaxTotalUnreadyPercentage = MaxTotalUnreadyPercentage

    @property
    def ScaleDownUnreadyTime(self):
        r"""表示未准备就绪的节点在有资格进行缩减之前应该停留多长时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ScaleDownUnreadyTime

    @ScaleDownUnreadyTime.setter
    def ScaleDownUnreadyTime(self, ScaleDownUnreadyTime):
        self._ScaleDownUnreadyTime = ScaleDownUnreadyTime

    @property
    def UnregisteredNodeRemovalTime(self):
        r"""CA删除未在Kubernetes中注册的节点之前等待的时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._UnregisteredNodeRemovalTime

    @UnregisteredNodeRemovalTime.setter
    def UnregisteredNodeRemovalTime(self, UnregisteredNodeRemovalTime):
        self._UnregisteredNodeRemovalTime = UnregisteredNodeRemovalTime


    def _deserialize(self, params):
        self._IsScaleDownEnabled = params.get("IsScaleDownEnabled")
        self._Expander = params.get("Expander")
        self._MaxEmptyBulkDelete = params.get("MaxEmptyBulkDelete")
        self._ScaleDownDelay = params.get("ScaleDownDelay")
        self._ScaleDownUnneededTime = params.get("ScaleDownUnneededTime")
        self._ScaleDownUtilizationThreshold = params.get("ScaleDownUtilizationThreshold")
        self._SkipNodesWithLocalStorage = params.get("SkipNodesWithLocalStorage")
        self._SkipNodesWithSystemPods = params.get("SkipNodesWithSystemPods")
        self._IgnoreDaemonSetsUtilization = params.get("IgnoreDaemonSetsUtilization")
        self._OkTotalUnreadyCount = params.get("OkTotalUnreadyCount")
        self._MaxTotalUnreadyPercentage = params.get("MaxTotalUnreadyPercentage")
        self._ScaleDownUnreadyTime = params.get("ScaleDownUnreadyTime")
        self._UnregisteredNodeRemovalTime = params.get("UnregisteredNodeRemovalTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterBasicSettings(AbstractModel):
    r"""描述集群的基本配置信息

    """

    def __init__(self):
        r"""
        :param _ClusterOs: 集群操作系统，支持设置公共镜像(字段传相应镜像Name)和自定义镜像(字段传相应镜像ID)，详情参考：https://cloud.tencent.com/document/product/457/68289
        :type ClusterOs: str
        :param _ClusterVersion: 集群版本,默认值为1.10.5
        :type ClusterVersion: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterDescription: 集群描述
        :type ClusterDescription: str
        :param _VpcId: 私有网络ID，形如vpc-e55paxnt。创建托管空集群时必传。
        :type VpcId: str
        :param _ProjectId: 集群内新增资源所属项目ID。
        :type ProjectId: int
        :param _TagSpecification: 标签描述列表。通过指定该参数可以同时绑定标签到相应的资源实例，当前仅支持绑定标签到集群实例。
        :type TagSpecification: list of TagSpecification
        :param _OsCustomizeType: 容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :type OsCustomizeType: str
        :param _NeedWorkSecurityGroup: 是否开启节点的默认安全组(默认: 否，Alpha特性)
        :type NeedWorkSecurityGroup: bool
        :param _SubnetId: 控制面子网信息，仅在以下场景使用时要求必填。
- 容器网络插件为CiliumOverlay时，TKE会从该子网获取2个IP用来创建内网负载均衡。
- 创建支持CDC的托管集群，且网络插件为VPC-CNI时，要求预留至少12个IP。
        :type SubnetId: str
        :param _ClusterLevel: 集群等级，针对托管集群生效
        :type ClusterLevel: str
        :param _AutoUpgradeClusterLevel: 自动变配集群等级，针对托管集群生效
        :type AutoUpgradeClusterLevel: :class:`tencentcloud.tke.v20180525.models.AutoUpgradeClusterLevel`
        """
        self._ClusterOs = None
        self._ClusterVersion = None
        self._ClusterName = None
        self._ClusterDescription = None
        self._VpcId = None
        self._ProjectId = None
        self._TagSpecification = None
        self._OsCustomizeType = None
        self._NeedWorkSecurityGroup = None
        self._SubnetId = None
        self._ClusterLevel = None
        self._AutoUpgradeClusterLevel = None

    @property
    def ClusterOs(self):
        r"""集群操作系统，支持设置公共镜像(字段传相应镜像Name)和自定义镜像(字段传相应镜像ID)，详情参考：https://cloud.tencent.com/document/product/457/68289
        :rtype: str
        """
        return self._ClusterOs

    @ClusterOs.setter
    def ClusterOs(self, ClusterOs):
        self._ClusterOs = ClusterOs

    @property
    def ClusterVersion(self):
        r"""集群版本,默认值为1.10.5
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterDescription(self):
        r"""集群描述
        :rtype: str
        """
        return self._ClusterDescription

    @ClusterDescription.setter
    def ClusterDescription(self, ClusterDescription):
        self._ClusterDescription = ClusterDescription

    @property
    def VpcId(self):
        r"""私有网络ID，形如vpc-e55paxnt。创建托管空集群时必传。
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ProjectId(self):
        r"""集群内新增资源所属项目ID。
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def TagSpecification(self):
        r"""标签描述列表。通过指定该参数可以同时绑定标签到相应的资源实例，当前仅支持绑定标签到集群实例。
        :rtype: list of TagSpecification
        """
        return self._TagSpecification

    @TagSpecification.setter
    def TagSpecification(self, TagSpecification):
        self._TagSpecification = TagSpecification

    @property
    def OsCustomizeType(self):
        r"""容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType

    @property
    def NeedWorkSecurityGroup(self):
        r"""是否开启节点的默认安全组(默认: 否，Alpha特性)
        :rtype: bool
        """
        return self._NeedWorkSecurityGroup

    @NeedWorkSecurityGroup.setter
    def NeedWorkSecurityGroup(self, NeedWorkSecurityGroup):
        self._NeedWorkSecurityGroup = NeedWorkSecurityGroup

    @property
    def SubnetId(self):
        r"""控制面子网信息，仅在以下场景使用时要求必填。
- 容器网络插件为CiliumOverlay时，TKE会从该子网获取2个IP用来创建内网负载均衡。
- 创建支持CDC的托管集群，且网络插件为VPC-CNI时，要求预留至少12个IP。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def ClusterLevel(self):
        r"""集群等级，针对托管集群生效
        :rtype: str
        """
        return self._ClusterLevel

    @ClusterLevel.setter
    def ClusterLevel(self, ClusterLevel):
        self._ClusterLevel = ClusterLevel

    @property
    def AutoUpgradeClusterLevel(self):
        r"""自动变配集群等级，针对托管集群生效
        :rtype: :class:`tencentcloud.tke.v20180525.models.AutoUpgradeClusterLevel`
        """
        return self._AutoUpgradeClusterLevel

    @AutoUpgradeClusterLevel.setter
    def AutoUpgradeClusterLevel(self, AutoUpgradeClusterLevel):
        self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel


    def _deserialize(self, params):
        self._ClusterOs = params.get("ClusterOs")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ClusterName = params.get("ClusterName")
        self._ClusterDescription = params.get("ClusterDescription")
        self._VpcId = params.get("VpcId")
        self._ProjectId = params.get("ProjectId")
        if params.get("TagSpecification") is not None:
            self._TagSpecification = []
            for item in params.get("TagSpecification"):
                obj = TagSpecification()
                obj._deserialize(item)
                self._TagSpecification.append(obj)
        self._OsCustomizeType = params.get("OsCustomizeType")
        self._NeedWorkSecurityGroup = params.get("NeedWorkSecurityGroup")
        self._SubnetId = params.get("SubnetId")
        self._ClusterLevel = params.get("ClusterLevel")
        if params.get("AutoUpgradeClusterLevel") is not None:
            self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel()
            self._AutoUpgradeClusterLevel._deserialize(params.get("AutoUpgradeClusterLevel"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCIDRSettings(AbstractModel):
    r"""集群容器网络相关参数

    """

    def __init__(self):
        r"""
        :param _ClusterCIDR: 用于分配集群容器和服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突。且网段范围必须在内网网段内，例如:10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16。
        :type ClusterCIDR: str
        :param _IgnoreClusterCIDRConflict: 是否忽略 ClusterCIDR 冲突错误, 默认不忽略
        :type IgnoreClusterCIDRConflict: bool
        :param _MaxNodePodNum: 集群中每个Node上最大的Pod数量。取值范围16～256。不为2的幂值时会向上取最接近的2的幂值。
        :type MaxNodePodNum: int
        :param _MaxClusterServiceNum: 集群最大的service数量。取值范围32～32768，不为2的幂值时会向上取最接近的2的幂值。默认值256
        :type MaxClusterServiceNum: int
        :param _ServiceCIDR: 用于分配集群服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突。且网段范围必须在内网网段内，例如:10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16。
        :type ServiceCIDR: str
        :param _EniSubnetIds: VPC-CNI网络模式下，弹性网卡的子网Id。
        :type EniSubnetIds: list of str
        :param _ClaimExpiredSeconds: VPC-CNI网络模式下，弹性网卡IP的回收时间，取值范围[300,15768000)
        :type ClaimExpiredSeconds: int
        :param _IgnoreServiceCIDRConflict: 是否忽略 ServiceCIDR 冲突错误, 仅在 VPC-CNI 模式生效，默认不忽略
        :type IgnoreServiceCIDRConflict: bool
        """
        self._ClusterCIDR = None
        self._IgnoreClusterCIDRConflict = None
        self._MaxNodePodNum = None
        self._MaxClusterServiceNum = None
        self._ServiceCIDR = None
        self._EniSubnetIds = None
        self._ClaimExpiredSeconds = None
        self._IgnoreServiceCIDRConflict = None

    @property
    def ClusterCIDR(self):
        r"""用于分配集群容器和服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突。且网段范围必须在内网网段内，例如:10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16。
        :rtype: str
        """
        return self._ClusterCIDR

    @ClusterCIDR.setter
    def ClusterCIDR(self, ClusterCIDR):
        self._ClusterCIDR = ClusterCIDR

    @property
    def IgnoreClusterCIDRConflict(self):
        r"""是否忽略 ClusterCIDR 冲突错误, 默认不忽略
        :rtype: bool
        """
        return self._IgnoreClusterCIDRConflict

    @IgnoreClusterCIDRConflict.setter
    def IgnoreClusterCIDRConflict(self, IgnoreClusterCIDRConflict):
        self._IgnoreClusterCIDRConflict = IgnoreClusterCIDRConflict

    @property
    def MaxNodePodNum(self):
        r"""集群中每个Node上最大的Pod数量。取值范围16～256。不为2的幂值时会向上取最接近的2的幂值。
        :rtype: int
        """
        return self._MaxNodePodNum

    @MaxNodePodNum.setter
    def MaxNodePodNum(self, MaxNodePodNum):
        self._MaxNodePodNum = MaxNodePodNum

    @property
    def MaxClusterServiceNum(self):
        r"""集群最大的service数量。取值范围32～32768，不为2的幂值时会向上取最接近的2的幂值。默认值256
        :rtype: int
        """
        return self._MaxClusterServiceNum

    @MaxClusterServiceNum.setter
    def MaxClusterServiceNum(self, MaxClusterServiceNum):
        self._MaxClusterServiceNum = MaxClusterServiceNum

    @property
    def ServiceCIDR(self):
        r"""用于分配集群服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突。且网段范围必须在内网网段内，例如:10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16。
        :rtype: str
        """
        return self._ServiceCIDR

    @ServiceCIDR.setter
    def ServiceCIDR(self, ServiceCIDR):
        self._ServiceCIDR = ServiceCIDR

    @property
    def EniSubnetIds(self):
        r"""VPC-CNI网络模式下，弹性网卡的子网Id。
        :rtype: list of str
        """
        return self._EniSubnetIds

    @EniSubnetIds.setter
    def EniSubnetIds(self, EniSubnetIds):
        self._EniSubnetIds = EniSubnetIds

    @property
    def ClaimExpiredSeconds(self):
        r"""VPC-CNI网络模式下，弹性网卡IP的回收时间，取值范围[300,15768000)
        :rtype: int
        """
        return self._ClaimExpiredSeconds

    @ClaimExpiredSeconds.setter
    def ClaimExpiredSeconds(self, ClaimExpiredSeconds):
        self._ClaimExpiredSeconds = ClaimExpiredSeconds

    @property
    def IgnoreServiceCIDRConflict(self):
        r"""是否忽略 ServiceCIDR 冲突错误, 仅在 VPC-CNI 模式生效，默认不忽略
        :rtype: bool
        """
        return self._IgnoreServiceCIDRConflict

    @IgnoreServiceCIDRConflict.setter
    def IgnoreServiceCIDRConflict(self, IgnoreServiceCIDRConflict):
        self._IgnoreServiceCIDRConflict = IgnoreServiceCIDRConflict


    def _deserialize(self, params):
        self._ClusterCIDR = params.get("ClusterCIDR")
        self._IgnoreClusterCIDRConflict = params.get("IgnoreClusterCIDRConflict")
        self._MaxNodePodNum = params.get("MaxNodePodNum")
        self._MaxClusterServiceNum = params.get("MaxClusterServiceNum")
        self._ServiceCIDR = params.get("ServiceCIDR")
        self._EniSubnetIds = params.get("EniSubnetIds")
        self._ClaimExpiredSeconds = params.get("ClaimExpiredSeconds")
        self._IgnoreServiceCIDRConflict = params.get("IgnoreServiceCIDRConflict")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCondition(AbstractModel):
    r"""集群创建过程

    """

    def __init__(self):
        r"""
        :param _Type: 集群创建过程类型
        :type Type: str
        :param _Status: 集群创建过程状态
        :type Status: str
        :param _LastProbeTime: 最后一次探测到该状态的时间
        :type LastProbeTime: str
        :param _LastTransitionTime: 最后一次转换到该过程的时间
        :type LastTransitionTime: str
        :param _Reason: 转换到该过程的简明原因
        :type Reason: str
        :param _Message: 转换到该过程的更多信息
        :type Message: str
        """
        self._Type = None
        self._Status = None
        self._LastProbeTime = None
        self._LastTransitionTime = None
        self._Reason = None
        self._Message = None

    @property
    def Type(self):
        r"""集群创建过程类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        r"""集群创建过程状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def LastProbeTime(self):
        r"""最后一次探测到该状态的时间
        :rtype: str
        """
        return self._LastProbeTime

    @LastProbeTime.setter
    def LastProbeTime(self, LastProbeTime):
        self._LastProbeTime = LastProbeTime

    @property
    def LastTransitionTime(self):
        r"""最后一次转换到该过程的时间
        :rtype: str
        """
        return self._LastTransitionTime

    @LastTransitionTime.setter
    def LastTransitionTime(self, LastTransitionTime):
        self._LastTransitionTime = LastTransitionTime

    @property
    def Reason(self):
        r"""转换到该过程的简明原因
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Message(self):
        r"""转换到该过程的更多信息
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        self._LastProbeTime = params.get("LastProbeTime")
        self._LastTransitionTime = params.get("LastTransitionTime")
        self._Reason = params.get("Reason")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCredential(AbstractModel):
    r"""接入k8s 的认证信息

    """

    def __init__(self):
        r"""
        :param _CACert: CA 根证书
        :type CACert: str
        :param _Token: 认证用的Token
        :type Token: str
        """
        self._CACert = None
        self._Token = None

    @property
    def CACert(self):
        r"""CA 根证书
        :rtype: str
        """
        return self._CACert

    @CACert.setter
    def CACert(self, CACert):
        self._CACert = CACert

    @property
    def Token(self):
        r"""认证用的Token
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token


    def _deserialize(self, params):
        self._CACert = params.get("CACert")
        self._Token = params.get("Token")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterExtraArgs(AbstractModel):
    r"""集群master自定义参数

    """

    def __init__(self):
        r"""
        :param _Etcd: etcd自定义参数，只支持独立集群
注意：此字段可能返回 null，表示取不到有效值。
        :type Etcd: list of str
        :param _KubeAPIServer: kube-apiserver自定义参数，参数格式为["k1=v1", "k1=v2"]， 例如["max-requests-inflight=500","feature-gates=PodShareProcessNamespace=true,DynamicKubeletConfig=true"]
注意：此字段可能返回 null，表示取不到有效值。
        :type KubeAPIServer: list of str
        :param _KubeControllerManager: kube-controller-manager自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :type KubeControllerManager: list of str
        :param _KubeScheduler: kube-scheduler自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :type KubeScheduler: list of str
        """
        self._Etcd = None
        self._KubeAPIServer = None
        self._KubeControllerManager = None
        self._KubeScheduler = None

    @property
    def Etcd(self):
        r"""etcd自定义参数，只支持独立集群
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Etcd

    @Etcd.setter
    def Etcd(self, Etcd):
        self._Etcd = Etcd

    @property
    def KubeAPIServer(self):
        r"""kube-apiserver自定义参数，参数格式为["k1=v1", "k1=v2"]， 例如["max-requests-inflight=500","feature-gates=PodShareProcessNamespace=true,DynamicKubeletConfig=true"]
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._KubeAPIServer

    @KubeAPIServer.setter
    def KubeAPIServer(self, KubeAPIServer):
        self._KubeAPIServer = KubeAPIServer

    @property
    def KubeControllerManager(self):
        r"""kube-controller-manager自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._KubeControllerManager

    @KubeControllerManager.setter
    def KubeControllerManager(self, KubeControllerManager):
        self._KubeControllerManager = KubeControllerManager

    @property
    def KubeScheduler(self):
        r"""kube-scheduler自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._KubeScheduler

    @KubeScheduler.setter
    def KubeScheduler(self, KubeScheduler):
        self._KubeScheduler = KubeScheduler


    def _deserialize(self, params):
        self._Etcd = params.get("Etcd")
        self._KubeAPIServer = params.get("KubeAPIServer")
        self._KubeControllerManager = params.get("KubeControllerManager")
        self._KubeScheduler = params.get("KubeScheduler")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterInternalLB(AbstractModel):
    r"""弹性容器集群内网访问LB信息

    """

    def __init__(self):
        r"""
        :param _Enabled: 是否开启内网访问LB
        :type Enabled: bool
        :param _SubnetId: 内网访问LB关联的子网Id
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetId: str
        """
        self._Enabled = None
        self._SubnetId = None

    @property
    def Enabled(self):
        r"""是否开启内网访问LB
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def SubnetId(self):
        r"""内网访问LB关联的子网Id
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterLevelAttribute(AbstractModel):
    r"""托管集群等级属性

    """

    def __init__(self):
        r"""
        :param _Name: 集群等级
        :type Name: str
        :param _Alias: 等级名称
        :type Alias: str
        :param _NodeCount: 节点数量
        :type NodeCount: int
        :param _PodCount: Pod数量
        :type PodCount: int
        :param _ConfigMapCount: Configmap数量
        :type ConfigMapCount: int
        :param _RSCount: ReplicaSets数量
        :type RSCount: int
        :param _CRDCount: CRD数量
        :type CRDCount: int
        :param _Enable: 是否启用
        :type Enable: bool
        :param _OtherCount: 其他资源数量
        :type OtherCount: int
        """
        self._Name = None
        self._Alias = None
        self._NodeCount = None
        self._PodCount = None
        self._ConfigMapCount = None
        self._RSCount = None
        self._CRDCount = None
        self._Enable = None
        self._OtherCount = None

    @property
    def Name(self):
        r"""集群等级
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Alias(self):
        r"""等级名称
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def NodeCount(self):
        r"""节点数量
        :rtype: int
        """
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def PodCount(self):
        r"""Pod数量
        :rtype: int
        """
        return self._PodCount

    @PodCount.setter
    def PodCount(self, PodCount):
        self._PodCount = PodCount

    @property
    def ConfigMapCount(self):
        r"""Configmap数量
        :rtype: int
        """
        return self._ConfigMapCount

    @ConfigMapCount.setter
    def ConfigMapCount(self, ConfigMapCount):
        self._ConfigMapCount = ConfigMapCount

    @property
    def RSCount(self):
        r"""ReplicaSets数量
        :rtype: int
        """
        return self._RSCount

    @RSCount.setter
    def RSCount(self, RSCount):
        self._RSCount = RSCount

    @property
    def CRDCount(self):
        r"""CRD数量
        :rtype: int
        """
        return self._CRDCount

    @CRDCount.setter
    def CRDCount(self, CRDCount):
        self._CRDCount = CRDCount

    @property
    def Enable(self):
        r"""是否启用
        :rtype: bool
        """
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def OtherCount(self):
        r"""其他资源数量
        :rtype: int
        """
        return self._OtherCount

    @OtherCount.setter
    def OtherCount(self, OtherCount):
        self._OtherCount = OtherCount


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Alias = params.get("Alias")
        self._NodeCount = params.get("NodeCount")
        self._PodCount = params.get("PodCount")
        self._ConfigMapCount = params.get("ConfigMapCount")
        self._RSCount = params.get("RSCount")
        self._CRDCount = params.get("CRDCount")
        self._Enable = params.get("Enable")
        self._OtherCount = params.get("OtherCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterLevelChangeRecord(AbstractModel):
    r"""集群等级变配记录

    """

    def __init__(self):
        r"""
        :param _ID: 记录ID
        :type ID: str
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _Status: 变配状态：trading 发货中,upgrading 变配中,success 变配成功,failed 变配失败。
        :type Status: str
        :param _Message: 状态描述
        :type Message: str
        :param _OldLevel: 变配前规模
        :type OldLevel: str
        :param _NewLevel: 变配后规模
        :type NewLevel: str
        :param _TriggerType: 变配触发类型：manual 手动,auto 自动
        :type TriggerType: str
        :param _CreatedAt: 创建时间
        :type CreatedAt: str
        :param _StartedAt: 开始时间
        :type StartedAt: str
        :param _EndedAt: 结束时间
        :type EndedAt: str
        """
        self._ID = None
        self._ClusterID = None
        self._Status = None
        self._Message = None
        self._OldLevel = None
        self._NewLevel = None
        self._TriggerType = None
        self._CreatedAt = None
        self._StartedAt = None
        self._EndedAt = None

    @property
    def ID(self):
        r"""记录ID
        :rtype: str
        """
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID

    @property
    def ClusterID(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def Status(self):
        r"""变配状态：trading 发货中,upgrading 变配中,success 变配成功,failed 变配失败。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Message(self):
        r"""状态描述
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def OldLevel(self):
        r"""变配前规模
        :rtype: str
        """
        return self._OldLevel

    @OldLevel.setter
    def OldLevel(self, OldLevel):
        self._OldLevel = OldLevel

    @property
    def NewLevel(self):
        r"""变配后规模
        :rtype: str
        """
        return self._NewLevel

    @NewLevel.setter
    def NewLevel(self, NewLevel):
        self._NewLevel = NewLevel

    @property
    def TriggerType(self):
        r"""变配触发类型：manual 手动,auto 自动
        :rtype: str
        """
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def CreatedAt(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreatedAt

    @CreatedAt.setter
    def CreatedAt(self, CreatedAt):
        self._CreatedAt = CreatedAt

    @property
    def StartedAt(self):
        r"""开始时间
        :rtype: str
        """
        return self._StartedAt

    @StartedAt.setter
    def StartedAt(self, StartedAt):
        self._StartedAt = StartedAt

    @property
    def EndedAt(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndedAt

    @EndedAt.setter
    def EndedAt(self, EndedAt):
        self._EndedAt = EndedAt


    def _deserialize(self, params):
        self._ID = params.get("ID")
        self._ClusterID = params.get("ClusterID")
        self._Status = params.get("Status")
        self._Message = params.get("Message")
        self._OldLevel = params.get("OldLevel")
        self._NewLevel = params.get("NewLevel")
        self._TriggerType = params.get("TriggerType")
        self._CreatedAt = params.get("CreatedAt")
        self._StartedAt = params.get("StartedAt")
        self._EndedAt = params.get("EndedAt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterNetworkSettings(AbstractModel):
    r"""集群网络相关的参数

    """

    def __init__(self):
        r"""
        :param _ClusterCIDR: 用于分配集群容器和服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突
        :type ClusterCIDR: str
        :param _IgnoreClusterCIDRConflict: 是否忽略 ClusterCIDR 冲突错误, 默认不忽略
        :type IgnoreClusterCIDRConflict: bool
        :param _MaxNodePodNum: 集群中每个Node上最大的Pod数量(默认为256)
        :type MaxNodePodNum: int
        :param _MaxClusterServiceNum: 集群最大的service数量(默认为256)
        :type MaxClusterServiceNum: int
        :param _Ipvs: 是否启用IPVS(默认不开启)
        :type Ipvs: bool
        :param _VpcId: 集群的VPCID（如果创建空集群，为必传值，否则自动设置为和集群的节点保持一致）
        :type VpcId: str
        :param _Cni: 网络插件是否启用CNI(默认开启)
        :type Cni: bool
        :param _KubeProxyMode: service的网络模式，当前参数只适用于ipvs+bpf模式
        :type KubeProxyMode: str
        :param _ServiceCIDR: 用于分配service的IP range，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突
        :type ServiceCIDR: str
        :param _Subnets: 集群关联的容器子网
注意：此字段可能返回 null，表示取不到有效值。
        :type Subnets: list of str
        :param _IgnoreServiceCIDRConflict: 是否忽略 ServiceCIDR 冲突错误, 仅在 VPC-CNI 模式生效，默认不忽略
        :type IgnoreServiceCIDRConflict: bool
        :param _IsDualStack: 集群VPC-CNI模式是否为非双栈集群，默认false，非双栈。
        :type IsDualStack: bool
        :param _Ipv6ServiceCIDR: 用于分配service的IP range，由系统自动分配
        :type Ipv6ServiceCIDR: str
        :param _CiliumMode: 集群Cilium Mode配置
- clusterIP
        :type CiliumMode: str
        :param _SubnetId: 控制面子网信息，仅在以下场景返回。
- 容器网络插件为CiliumOverlay。
- 支持CDC的托管集群，且网络插件为VPC-CNI。
        :type SubnetId: str
        :param _DataPlaneV2: 是否启用了 DataPlaneV2（cilium替代kube-proxy）
        :type DataPlaneV2: bool
        """
        self._ClusterCIDR = None
        self._IgnoreClusterCIDRConflict = None
        self._MaxNodePodNum = None
        self._MaxClusterServiceNum = None
        self._Ipvs = None
        self._VpcId = None
        self._Cni = None
        self._KubeProxyMode = None
        self._ServiceCIDR = None
        self._Subnets = None
        self._IgnoreServiceCIDRConflict = None
        self._IsDualStack = None
        self._Ipv6ServiceCIDR = None
        self._CiliumMode = None
        self._SubnetId = None
        self._DataPlaneV2 = None

    @property
    def ClusterCIDR(self):
        r"""用于分配集群容器和服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突
        :rtype: str
        """
        return self._ClusterCIDR

    @ClusterCIDR.setter
    def ClusterCIDR(self, ClusterCIDR):
        self._ClusterCIDR = ClusterCIDR

    @property
    def IgnoreClusterCIDRConflict(self):
        r"""是否忽略 ClusterCIDR 冲突错误, 默认不忽略
        :rtype: bool
        """
        return self._IgnoreClusterCIDRConflict

    @IgnoreClusterCIDRConflict.setter
    def IgnoreClusterCIDRConflict(self, IgnoreClusterCIDRConflict):
        self._IgnoreClusterCIDRConflict = IgnoreClusterCIDRConflict

    @property
    def MaxNodePodNum(self):
        r"""集群中每个Node上最大的Pod数量(默认为256)
        :rtype: int
        """
        return self._MaxNodePodNum

    @MaxNodePodNum.setter
    def MaxNodePodNum(self, MaxNodePodNum):
        self._MaxNodePodNum = MaxNodePodNum

    @property
    def MaxClusterServiceNum(self):
        r"""集群最大的service数量(默认为256)
        :rtype: int
        """
        return self._MaxClusterServiceNum

    @MaxClusterServiceNum.setter
    def MaxClusterServiceNum(self, MaxClusterServiceNum):
        self._MaxClusterServiceNum = MaxClusterServiceNum

    @property
    def Ipvs(self):
        r"""是否启用IPVS(默认不开启)
        :rtype: bool
        """
        return self._Ipvs

    @Ipvs.setter
    def Ipvs(self, Ipvs):
        self._Ipvs = Ipvs

    @property
    def VpcId(self):
        r"""集群的VPCID（如果创建空集群，为必传值，否则自动设置为和集群的节点保持一致）
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Cni(self):
        r"""网络插件是否启用CNI(默认开启)
        :rtype: bool
        """
        return self._Cni

    @Cni.setter
    def Cni(self, Cni):
        self._Cni = Cni

    @property
    def KubeProxyMode(self):
        r"""service的网络模式，当前参数只适用于ipvs+bpf模式
        :rtype: str
        """
        return self._KubeProxyMode

    @KubeProxyMode.setter
    def KubeProxyMode(self, KubeProxyMode):
        self._KubeProxyMode = KubeProxyMode

    @property
    def ServiceCIDR(self):
        r"""用于分配service的IP range，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突
        :rtype: str
        """
        return self._ServiceCIDR

    @ServiceCIDR.setter
    def ServiceCIDR(self, ServiceCIDR):
        self._ServiceCIDR = ServiceCIDR

    @property
    def Subnets(self):
        r"""集群关联的容器子网
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Subnets

    @Subnets.setter
    def Subnets(self, Subnets):
        self._Subnets = Subnets

    @property
    def IgnoreServiceCIDRConflict(self):
        r"""是否忽略 ServiceCIDR 冲突错误, 仅在 VPC-CNI 模式生效，默认不忽略
        :rtype: bool
        """
        return self._IgnoreServiceCIDRConflict

    @IgnoreServiceCIDRConflict.setter
    def IgnoreServiceCIDRConflict(self, IgnoreServiceCIDRConflict):
        self._IgnoreServiceCIDRConflict = IgnoreServiceCIDRConflict

    @property
    def IsDualStack(self):
        r"""集群VPC-CNI模式是否为非双栈集群，默认false，非双栈。
        :rtype: bool
        """
        return self._IsDualStack

    @IsDualStack.setter
    def IsDualStack(self, IsDualStack):
        self._IsDualStack = IsDualStack

    @property
    def Ipv6ServiceCIDR(self):
        r"""用于分配service的IP range，由系统自动分配
        :rtype: str
        """
        return self._Ipv6ServiceCIDR

    @Ipv6ServiceCIDR.setter
    def Ipv6ServiceCIDR(self, Ipv6ServiceCIDR):
        self._Ipv6ServiceCIDR = Ipv6ServiceCIDR

    @property
    def CiliumMode(self):
        r"""集群Cilium Mode配置
- clusterIP
        :rtype: str
        """
        return self._CiliumMode

    @CiliumMode.setter
    def CiliumMode(self, CiliumMode):
        self._CiliumMode = CiliumMode

    @property
    def SubnetId(self):
        r"""控制面子网信息，仅在以下场景返回。
- 容器网络插件为CiliumOverlay。
- 支持CDC的托管集群，且网络插件为VPC-CNI。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def DataPlaneV2(self):
        r"""是否启用了 DataPlaneV2（cilium替代kube-proxy）
        :rtype: bool
        """
        return self._DataPlaneV2

    @DataPlaneV2.setter
    def DataPlaneV2(self, DataPlaneV2):
        self._DataPlaneV2 = DataPlaneV2


    def _deserialize(self, params):
        self._ClusterCIDR = params.get("ClusterCIDR")
        self._IgnoreClusterCIDRConflict = params.get("IgnoreClusterCIDRConflict")
        self._MaxNodePodNum = params.get("MaxNodePodNum")
        self._MaxClusterServiceNum = params.get("MaxClusterServiceNum")
        self._Ipvs = params.get("Ipvs")
        self._VpcId = params.get("VpcId")
        self._Cni = params.get("Cni")
        self._KubeProxyMode = params.get("KubeProxyMode")
        self._ServiceCIDR = params.get("ServiceCIDR")
        self._Subnets = params.get("Subnets")
        self._IgnoreServiceCIDRConflict = params.get("IgnoreServiceCIDRConflict")
        self._IsDualStack = params.get("IsDualStack")
        self._Ipv6ServiceCIDR = params.get("Ipv6ServiceCIDR")
        self._CiliumMode = params.get("CiliumMode")
        self._SubnetId = params.get("SubnetId")
        self._DataPlaneV2 = params.get("DataPlaneV2")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterProperty(AbstractModel):
    r"""集群属性

    """

    def __init__(self):
        r"""
        :param _NodeNameType: 节点hostname命名模式
        :type NodeNameType: str
        """
        self._NodeNameType = None

    @property
    def NodeNameType(self):
        r"""节点hostname命名模式
        :rtype: str
        """
        return self._NodeNameType

    @NodeNameType.setter
    def NodeNameType(self, NodeNameType):
        self._NodeNameType = NodeNameType


    def _deserialize(self, params):
        self._NodeNameType = params.get("NodeNameType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterPublicLB(AbstractModel):
    r"""弹性容器集群公网访问负载均衡信息

    """

    def __init__(self):
        r"""
        :param _Enabled: 是否开启公网访问LB
        :type Enabled: bool
        :param _AllowFromCidrs: 允许访问的来源CIDR列表
        :type AllowFromCidrs: list of str
        :param _SecurityPolicies: 安全策略放通单个IP或CIDR(例如: "192.168.1.0/24",默认为拒绝所有)
        :type SecurityPolicies: list of str
        :param _ExtraParam: 外网访问相关的扩展参数，格式为json
        :type ExtraParam: str
        :param _SecurityGroup: 新内外网功能，需要传递安全组
        :type SecurityGroup: str
        """
        self._Enabled = None
        self._AllowFromCidrs = None
        self._SecurityPolicies = None
        self._ExtraParam = None
        self._SecurityGroup = None

    @property
    def Enabled(self):
        r"""是否开启公网访问LB
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def AllowFromCidrs(self):
        r"""允许访问的来源CIDR列表
        :rtype: list of str
        """
        return self._AllowFromCidrs

    @AllowFromCidrs.setter
    def AllowFromCidrs(self, AllowFromCidrs):
        self._AllowFromCidrs = AllowFromCidrs

    @property
    def SecurityPolicies(self):
        r"""安全策略放通单个IP或CIDR(例如: "192.168.1.0/24",默认为拒绝所有)
        :rtype: list of str
        """
        return self._SecurityPolicies

    @SecurityPolicies.setter
    def SecurityPolicies(self, SecurityPolicies):
        self._SecurityPolicies = SecurityPolicies

    @property
    def ExtraParam(self):
        r"""外网访问相关的扩展参数，格式为json
        :rtype: str
        """
        return self._ExtraParam

    @ExtraParam.setter
    def ExtraParam(self, ExtraParam):
        self._ExtraParam = ExtraParam

    @property
    def SecurityGroup(self):
        r"""新内外网功能，需要传递安全组
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        self._AllowFromCidrs = params.get("AllowFromCidrs")
        self._SecurityPolicies = params.get("SecurityPolicies")
        self._ExtraParam = params.get("ExtraParam")
        self._SecurityGroup = params.get("SecurityGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterStatus(AbstractModel):
    r"""集群状态信息

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _ClusterState: 集群状态
        :type ClusterState: str
        :param _ClusterInstanceState: 集群下机器实例的状态
        :type ClusterInstanceState: str
        :param _ClusterBMonitor: 集群是否开启监控
        :type ClusterBMonitor: bool
        :param _ClusterInitNodeNum: 集群创建中的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :type ClusterInitNodeNum: int
        :param _ClusterRunningNodeNum: 集群运行中的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :type ClusterRunningNodeNum: int
        :param _ClusterFailedNodeNum: 集群异常的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :type ClusterFailedNodeNum: int
        :param _ClusterClosedNodeNum: 集群已关机的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :type ClusterClosedNodeNum: int
        :param _ClusterClosingNodeNum: 集群关机中的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :type ClusterClosingNodeNum: int
        :param _ClusterDeletionProtection: 集群是否开启删除保护
        :type ClusterDeletionProtection: bool
        :param _ClusterAuditEnabled: 集群是否可审计
        :type ClusterAuditEnabled: bool
        """
        self._ClusterId = None
        self._ClusterState = None
        self._ClusterInstanceState = None
        self._ClusterBMonitor = None
        self._ClusterInitNodeNum = None
        self._ClusterRunningNodeNum = None
        self._ClusterFailedNodeNum = None
        self._ClusterClosedNodeNum = None
        self._ClusterClosingNodeNum = None
        self._ClusterDeletionProtection = None
        self._ClusterAuditEnabled = None

    @property
    def ClusterId(self):
        r"""集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterState(self):
        r"""集群状态
        :rtype: str
        """
        return self._ClusterState

    @ClusterState.setter
    def ClusterState(self, ClusterState):
        self._ClusterState = ClusterState

    @property
    def ClusterInstanceState(self):
        r"""集群下机器实例的状态
        :rtype: str
        """
        return self._ClusterInstanceState

    @ClusterInstanceState.setter
    def ClusterInstanceState(self, ClusterInstanceState):
        self._ClusterInstanceState = ClusterInstanceState

    @property
    def ClusterBMonitor(self):
        r"""集群是否开启监控
        :rtype: bool
        """
        return self._ClusterBMonitor

    @ClusterBMonitor.setter
    def ClusterBMonitor(self, ClusterBMonitor):
        self._ClusterBMonitor = ClusterBMonitor

    @property
    def ClusterInitNodeNum(self):
        r"""集群创建中的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :rtype: int
        """
        return self._ClusterInitNodeNum

    @ClusterInitNodeNum.setter
    def ClusterInitNodeNum(self, ClusterInitNodeNum):
        self._ClusterInitNodeNum = ClusterInitNodeNum

    @property
    def ClusterRunningNodeNum(self):
        r"""集群运行中的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :rtype: int
        """
        return self._ClusterRunningNodeNum

    @ClusterRunningNodeNum.setter
    def ClusterRunningNodeNum(self, ClusterRunningNodeNum):
        self._ClusterRunningNodeNum = ClusterRunningNodeNum

    @property
    def ClusterFailedNodeNum(self):
        r"""集群异常的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :rtype: int
        """
        return self._ClusterFailedNodeNum

    @ClusterFailedNodeNum.setter
    def ClusterFailedNodeNum(self, ClusterFailedNodeNum):
        self._ClusterFailedNodeNum = ClusterFailedNodeNum

    @property
    def ClusterClosedNodeNum(self):
        r"""集群已关机的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :rtype: int
        """
        return self._ClusterClosedNodeNum

    @ClusterClosedNodeNum.setter
    def ClusterClosedNodeNum(self, ClusterClosedNodeNum):
        self._ClusterClosedNodeNum = ClusterClosedNodeNum

    @property
    def ClusterClosingNodeNum(self):
        r"""集群关机中的节点数，-1表示获取节点状态超时，-2表示获取节点状态失败
        :rtype: int
        """
        return self._ClusterClosingNodeNum

    @ClusterClosingNodeNum.setter
    def ClusterClosingNodeNum(self, ClusterClosingNodeNum):
        self._ClusterClosingNodeNum = ClusterClosingNodeNum

    @property
    def ClusterDeletionProtection(self):
        r"""集群是否开启删除保护
        :rtype: bool
        """
        return self._ClusterDeletionProtection

    @ClusterDeletionProtection.setter
    def ClusterDeletionProtection(self, ClusterDeletionProtection):
        self._ClusterDeletionProtection = ClusterDeletionProtection

    @property
    def ClusterAuditEnabled(self):
        r"""集群是否可审计
        :rtype: bool
        """
        return self._ClusterAuditEnabled

    @ClusterAuditEnabled.setter
    def ClusterAuditEnabled(self, ClusterAuditEnabled):
        self._ClusterAuditEnabled = ClusterAuditEnabled


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterState = params.get("ClusterState")
        self._ClusterInstanceState = params.get("ClusterInstanceState")
        self._ClusterBMonitor = params.get("ClusterBMonitor")
        self._ClusterInitNodeNum = params.get("ClusterInitNodeNum")
        self._ClusterRunningNodeNum = params.get("ClusterRunningNodeNum")
        self._ClusterFailedNodeNum = params.get("ClusterFailedNodeNum")
        self._ClusterClosedNodeNum = params.get("ClusterClosedNodeNum")
        self._ClusterClosingNodeNum = params.get("ClusterClosingNodeNum")
        self._ClusterDeletionProtection = params.get("ClusterDeletionProtection")
        self._ClusterAuditEnabled = params.get("ClusterAuditEnabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterVersion(AbstractModel):
    r"""集群版本信息

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Versions: 集群主版本号列表，例如1.18.4
        :type Versions: list of str
        """
        self._ClusterId = None
        self._Versions = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Versions(self):
        r"""集群主版本号列表，例如1.18.4
        :rtype: list of str
        """
        return self._Versions

    @Versions.setter
    def Versions(self, Versions):
        self._Versions = Versions


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Versions = params.get("Versions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommonName(AbstractModel):
    r"""账户UIN与客户端证书CommonName的映射

    """

    def __init__(self):
        r"""
        :param _SubaccountUin: 子账户UIN
        :type SubaccountUin: str
        :param _CN: 子账户客户端证书中的CommonName字段
        :type CN: str
        """
        self._SubaccountUin = None
        self._CN = None

    @property
    def SubaccountUin(self):
        r"""子账户UIN
        :rtype: str
        """
        return self._SubaccountUin

    @SubaccountUin.setter
    def SubaccountUin(self, SubaccountUin):
        self._SubaccountUin = SubaccountUin

    @property
    def CN(self):
        r"""子账户客户端证书中的CommonName字段
        :rtype: str
        """
        return self._CN

    @CN.setter
    def CN(self, CN):
        self._CN = CN


    def _deserialize(self, params):
        self._SubaccountUin = params.get("SubaccountUin")
        self._CN = params.get("CN")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Container(AbstractModel):
    r"""EKS Instance Container容器

    """

    def __init__(self):
        r"""
        :param _Image: 镜像
        :type Image: str
        :param _Name: 容器名
        :type Name: str
        :param _Args: 容器启动参数
        :type Args: list of str
        :param _Commands: 容器启动命令
        :type Commands: list of str
        :param _Cpu: CPU，制改容器最多可使用的核数，该值不可超过容器实例的总核数。单位：核。
        :type Cpu: float
        :param _CurrentState: 当前状态
        :type CurrentState: :class:`tencentcloud.tke.v20180525.models.ContainerState`
        :param _EnvironmentVars: 容器内操作系统的环境变量
        :type EnvironmentVars: list of EnvironmentVariable
        :param _GpuLimit: Gpu限制
注意：此字段可能返回 null，表示取不到有效值。
        :type GpuLimit: int
        :param _LivenessProbe: 存活探针
注意：此字段可能返回 null，表示取不到有效值。
        :type LivenessProbe: :class:`tencentcloud.tke.v20180525.models.LivenessOrReadinessProbe`
        :param _Memory: 内存，限制该容器最多可使用的内存值，该值不可超过容器实例的总内存值。单位：GiB
        :type Memory: float
        :param _ReadinessProbe: 就绪探针
注意：此字段可能返回 null，表示取不到有效值。
        :type ReadinessProbe: :class:`tencentcloud.tke.v20180525.models.LivenessOrReadinessProbe`
        :param _RestartCount: 重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :type RestartCount: int
        :param _SecurityContext: 容器的安全上下文
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityContext: :class:`tencentcloud.tke.v20180525.models.SecurityContext`
        :param _VolumeMounts: 数据卷挂载信息
注意：此字段可能返回 null，表示取不到有效值。
        :type VolumeMounts: list of VolumeMount
        :param _WorkingDir: 容器工作目录
        :type WorkingDir: str
        """
        self._Image = None
        self._Name = None
        self._Args = None
        self._Commands = None
        self._Cpu = None
        self._CurrentState = None
        self._EnvironmentVars = None
        self._GpuLimit = None
        self._LivenessProbe = None
        self._Memory = None
        self._ReadinessProbe = None
        self._RestartCount = None
        self._SecurityContext = None
        self._VolumeMounts = None
        self._WorkingDir = None

    @property
    def Image(self):
        r"""镜像
        :rtype: str
        """
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image

    @property
    def Name(self):
        r"""容器名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Args(self):
        r"""容器启动参数
        :rtype: list of str
        """
        return self._Args

    @Args.setter
    def Args(self, Args):
        self._Args = Args

    @property
    def Commands(self):
        r"""容器启动命令
        :rtype: list of str
        """
        return self._Commands

    @Commands.setter
    def Commands(self, Commands):
        self._Commands = Commands

    @property
    def Cpu(self):
        r"""CPU，制改容器最多可使用的核数，该值不可超过容器实例的总核数。单位：核。
        :rtype: float
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def CurrentState(self):
        r"""当前状态
        :rtype: :class:`tencentcloud.tke.v20180525.models.ContainerState`
        """
        return self._CurrentState

    @CurrentState.setter
    def CurrentState(self, CurrentState):
        self._CurrentState = CurrentState

    @property
    def EnvironmentVars(self):
        r"""容器内操作系统的环境变量
        :rtype: list of EnvironmentVariable
        """
        return self._EnvironmentVars

    @EnvironmentVars.setter
    def EnvironmentVars(self, EnvironmentVars):
        self._EnvironmentVars = EnvironmentVars

    @property
    def GpuLimit(self):
        r"""Gpu限制
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._GpuLimit

    @GpuLimit.setter
    def GpuLimit(self, GpuLimit):
        self._GpuLimit = GpuLimit

    @property
    def LivenessProbe(self):
        r"""存活探针
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.LivenessOrReadinessProbe`
        """
        return self._LivenessProbe

    @LivenessProbe.setter
    def LivenessProbe(self, LivenessProbe):
        self._LivenessProbe = LivenessProbe

    @property
    def Memory(self):
        r"""内存，限制该容器最多可使用的内存值，该值不可超过容器实例的总内存值。单位：GiB
        :rtype: float
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def ReadinessProbe(self):
        r"""就绪探针
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.LivenessOrReadinessProbe`
        """
        return self._ReadinessProbe

    @ReadinessProbe.setter
    def ReadinessProbe(self, ReadinessProbe):
        self._ReadinessProbe = ReadinessProbe

    @property
    def RestartCount(self):
        r"""重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RestartCount

    @RestartCount.setter
    def RestartCount(self, RestartCount):
        self._RestartCount = RestartCount

    @property
    def SecurityContext(self):
        r"""容器的安全上下文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.SecurityContext`
        """
        return self._SecurityContext

    @SecurityContext.setter
    def SecurityContext(self, SecurityContext):
        self._SecurityContext = SecurityContext

    @property
    def VolumeMounts(self):
        r"""数据卷挂载信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of VolumeMount
        """
        return self._VolumeMounts

    @VolumeMounts.setter
    def VolumeMounts(self, VolumeMounts):
        self._VolumeMounts = VolumeMounts

    @property
    def WorkingDir(self):
        r"""容器工作目录
        :rtype: str
        """
        return self._WorkingDir

    @WorkingDir.setter
    def WorkingDir(self, WorkingDir):
        self._WorkingDir = WorkingDir


    def _deserialize(self, params):
        self._Image = params.get("Image")
        self._Name = params.get("Name")
        self._Args = params.get("Args")
        self._Commands = params.get("Commands")
        self._Cpu = params.get("Cpu")
        if params.get("CurrentState") is not None:
            self._CurrentState = ContainerState()
            self._CurrentState._deserialize(params.get("CurrentState"))
        if params.get("EnvironmentVars") is not None:
            self._EnvironmentVars = []
            for item in params.get("EnvironmentVars"):
                obj = EnvironmentVariable()
                obj._deserialize(item)
                self._EnvironmentVars.append(obj)
        self._GpuLimit = params.get("GpuLimit")
        if params.get("LivenessProbe") is not None:
            self._LivenessProbe = LivenessOrReadinessProbe()
            self._LivenessProbe._deserialize(params.get("LivenessProbe"))
        self._Memory = params.get("Memory")
        if params.get("ReadinessProbe") is not None:
            self._ReadinessProbe = LivenessOrReadinessProbe()
            self._ReadinessProbe._deserialize(params.get("ReadinessProbe"))
        self._RestartCount = params.get("RestartCount")
        if params.get("SecurityContext") is not None:
            self._SecurityContext = SecurityContext()
            self._SecurityContext._deserialize(params.get("SecurityContext"))
        if params.get("VolumeMounts") is not None:
            self._VolumeMounts = []
            for item in params.get("VolumeMounts"):
                obj = VolumeMount()
                obj._deserialize(item)
                self._VolumeMounts.append(obj)
        self._WorkingDir = params.get("WorkingDir")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerState(AbstractModel):
    r"""容器状态

    """

    def __init__(self):
        r"""
        :param _ExitCode: 容器运行退出码
注意：此字段可能返回 null，表示取不到有效值。
        :type ExitCode: int
        :param _FinishTime: 容器运行结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :type FinishTime: str
        :param _Message: 容器状态信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Message: str
        :param _Reason: 容器状态 Reason
注意：此字段可能返回 null，表示取不到有效值。
        :type Reason: str
        :param _RestartCount: 容器重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :type RestartCount: int
        :param _StartTime: 容器运行开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :type StartTime: str
        :param _State: 容器状态：created, running, exited, unknown
        :type State: str
        """
        self._ExitCode = None
        self._FinishTime = None
        self._Message = None
        self._Reason = None
        self._RestartCount = None
        self._StartTime = None
        self._State = None

    @property
    def ExitCode(self):
        r"""容器运行退出码
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._ExitCode

    @ExitCode.setter
    def ExitCode(self, ExitCode):
        self._ExitCode = ExitCode

    @property
    def FinishTime(self):
        r"""容器运行结束时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def Message(self):
        r"""容器状态信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Reason(self):
        r"""容器状态 Reason
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def RestartCount(self):
        r"""容器重启次数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._RestartCount

    @RestartCount.setter
    def RestartCount(self, RestartCount):
        self._RestartCount = RestartCount

    @property
    def StartTime(self):
        r"""容器运行开始时间
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def State(self):
        r"""容器状态：created, running, exited, unknown
        :rtype: str
        """
        return self._State

    @State.setter
    def State(self, State):
        self._State = State


    def _deserialize(self, params):
        self._ExitCode = params.get("ExitCode")
        self._FinishTime = params.get("FinishTime")
        self._Message = params.get("Message")
        self._Reason = params.get("Reason")
        self._RestartCount = params.get("RestartCount")
        self._StartTime = params.get("StartTime")
        self._State = params.get("State")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ControllerStatus(AbstractModel):
    r"""集群中控制器的状态描述

    """

    def __init__(self):
        r"""
        :param _Name: 控制器的名字
        :type Name: str
        :param _Enabled: 控制器是否开启
        :type Enabled: bool
        """
        self._Name = None
        self._Enabled = None

    @property
    def Name(self):
        r"""控制器的名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Enabled(self):
        r"""控制器是否开启
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBackupStorageLocationRequest(AbstractModel):
    r"""CreateBackupStorageLocation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _StorageRegion: 存储仓库所属地域，比如COS广州(ap-guangzhou)
        :type StorageRegion: str
        :param _Bucket: 对象存储桶名称，如果是COS必须是tke-backup前缀开头
        :type Bucket: str
        :param _Name: 备份仓库名称
        :type Name: str
        :param _Provider: 存储服务提供方，默认腾讯云
        :type Provider: str
        :param _Path: 对象存储桶路径
        :type Path: str
        """
        self._StorageRegion = None
        self._Bucket = None
        self._Name = None
        self._Provider = None
        self._Path = None

    @property
    def StorageRegion(self):
        r"""存储仓库所属地域，比如COS广州(ap-guangzhou)
        :rtype: str
        """
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def Bucket(self):
        r"""对象存储桶名称，如果是COS必须是tke-backup前缀开头
        :rtype: str
        """
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Name(self):
        r"""备份仓库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Provider(self):
        r"""存储服务提供方，默认腾讯云
        :rtype: str
        """
        return self._Provider

    @Provider.setter
    def Provider(self, Provider):
        self._Provider = Provider

    @property
    def Path(self):
        r"""对象存储桶路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        self._StorageRegion = params.get("StorageRegion")
        self._Bucket = params.get("Bucket")
        self._Name = params.get("Name")
        self._Provider = params.get("Provider")
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateBackupStorageLocationResponse(AbstractModel):
    r"""CreateBackupStorageLocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateCLSLogConfigRequest(AbstractModel):
    r"""CreateCLSLogConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _LogConfig: 日志采集配置的json表达
        :type LogConfig: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _LogsetId: CLS日志集ID
        :type LogsetId: str
        :param _ClusterType: 当前集群类型支持tke、eks
        :type ClusterType: str
        """
        self._LogConfig = None
        self._ClusterId = None
        self._LogsetId = None
        self._ClusterType = None

    @property
    def LogConfig(self):
        r"""日志采集配置的json表达
        :rtype: str
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def LogsetId(self):
        r"""CLS日志集ID
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def ClusterType(self):
        r"""当前集群类型支持tke、eks
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._LogConfig = params.get("LogConfig")
        self._ClusterId = params.get("ClusterId")
        self._LogsetId = params.get("LogsetId")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCLSLogConfigResponse(AbstractModel):
    r"""CreateCLSLogConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClusterEndpointRequest(AbstractModel):
    r"""CreateClusterEndpoint请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _SubnetId: 集群端口所在的子网ID  (仅在开启非外网访问时需要填，必须为集群所在VPC内的子网)
        :type SubnetId: str
        :param _IsExtranet: 是否为外网访问（TRUE 外网访问 FALSE 内网访问，默认值： FALSE）
        :type IsExtranet: bool
        :param _Domain: 设置域名
        :type Domain: str
        :param _SecurityGroup: 使用的安全组，只有外网访问需要传递（开启外网访问且不使用已有clb时必传）
        :type SecurityGroup: str
        :param _ExtensiveParameters: 创建lb参数，只有外网访问需要设置，是一个json格式化后的字符串：{"InternetAccessible":{"InternetChargeType":"TRAFFIC_POSTPAID_BY_HOUR","InternetMaxBandwidthOut":200},"VipIsp":"","BandwidthPackageId":""}。
各个参数意义：
InternetAccessible.InternetChargeType含义：TRAFFIC_POSTPAID_BY_HOUR按流量按小时后计费;BANDWIDTH_POSTPAID_BY_HOUR 按带宽按小时后计费;InternetAccessible.BANDWIDTH_PACKAGE 按带宽包计费。
InternetMaxBandwidthOut含义：最大出带宽，单位Mbps，范围支持0到2048，默认值10。
VipIsp含义：CMCC | CTCC | CUCC，分别对应 移动 | 电信 | 联通，如果不指定本参数，则默认使用BGP。可通过 DescribeSingleIsp 接口查询一个地域所支持的Isp。如果指定运营商，则网络计费式只能使用按带宽包计费BANDWIDTH_PACKAGE。
BandwidthPackageId含义：带宽包ID，指定此参数时，网络计费方式InternetAccessible.InternetChargeType只支持按带宽包计费BANDWIDTH_PACKAGE。
        :type ExtensiveParameters: str
        :param _ExistedLoadBalancerId: 使用已有clb开启内网或外网访问
        :type ExistedLoadBalancerId: str
        """
        self._ClusterId = None
        self._SubnetId = None
        self._IsExtranet = None
        self._Domain = None
        self._SecurityGroup = None
        self._ExtensiveParameters = None
        self._ExistedLoadBalancerId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SubnetId(self):
        r"""集群端口所在的子网ID  (仅在开启非外网访问时需要填，必须为集群所在VPC内的子网)
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def IsExtranet(self):
        r"""是否为外网访问（TRUE 外网访问 FALSE 内网访问，默认值： FALSE）
        :rtype: bool
        """
        return self._IsExtranet

    @IsExtranet.setter
    def IsExtranet(self, IsExtranet):
        self._IsExtranet = IsExtranet

    @property
    def Domain(self):
        r"""设置域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SecurityGroup(self):
        r"""使用的安全组，只有外网访问需要传递（开启外网访问且不使用已有clb时必传）
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def ExtensiveParameters(self):
        r"""创建lb参数，只有外网访问需要设置，是一个json格式化后的字符串：{"InternetAccessible":{"InternetChargeType":"TRAFFIC_POSTPAID_BY_HOUR","InternetMaxBandwidthOut":200},"VipIsp":"","BandwidthPackageId":""}。
各个参数意义：
InternetAccessible.InternetChargeType含义：TRAFFIC_POSTPAID_BY_HOUR按流量按小时后计费;BANDWIDTH_POSTPAID_BY_HOUR 按带宽按小时后计费;InternetAccessible.BANDWIDTH_PACKAGE 按带宽包计费。
InternetMaxBandwidthOut含义：最大出带宽，单位Mbps，范围支持0到2048，默认值10。
VipIsp含义：CMCC | CTCC | CUCC，分别对应 移动 | 电信 | 联通，如果不指定本参数，则默认使用BGP。可通过 DescribeSingleIsp 接口查询一个地域所支持的Isp。如果指定运营商，则网络计费式只能使用按带宽包计费BANDWIDTH_PACKAGE。
BandwidthPackageId含义：带宽包ID，指定此参数时，网络计费方式InternetAccessible.InternetChargeType只支持按带宽包计费BANDWIDTH_PACKAGE。
        :rtype: str
        """
        return self._ExtensiveParameters

    @ExtensiveParameters.setter
    def ExtensiveParameters(self, ExtensiveParameters):
        self._ExtensiveParameters = ExtensiveParameters

    @property
    def ExistedLoadBalancerId(self):
        r"""使用已有clb开启内网或外网访问
        :rtype: str
        """
        return self._ExistedLoadBalancerId

    @ExistedLoadBalancerId.setter
    def ExistedLoadBalancerId(self, ExistedLoadBalancerId):
        self._ExistedLoadBalancerId = ExistedLoadBalancerId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SubnetId = params.get("SubnetId")
        self._IsExtranet = params.get("IsExtranet")
        self._Domain = params.get("Domain")
        self._SecurityGroup = params.get("SecurityGroup")
        self._ExtensiveParameters = params.get("ExtensiveParameters")
        self._ExistedLoadBalancerId = params.get("ExistedLoadBalancerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterEndpointResponse(AbstractModel):
    r"""CreateClusterEndpoint返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClusterEndpointVipRequest(AbstractModel):
    r"""CreateClusterEndpointVip请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _SecurityPolicies: 安全策略放通单个IP或CIDR(例如: "192.168.1.0/24",默认为拒绝所有)
        :type SecurityPolicies: list of str
        """
        self._ClusterId = None
        self._SecurityPolicies = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SecurityPolicies(self):
        r"""安全策略放通单个IP或CIDR(例如: "192.168.1.0/24",默认为拒绝所有)
        :rtype: list of str
        """
        return self._SecurityPolicies

    @SecurityPolicies.setter
    def SecurityPolicies(self, SecurityPolicies):
        self._SecurityPolicies = SecurityPolicies


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SecurityPolicies = params.get("SecurityPolicies")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterEndpointVipResponse(AbstractModel):
    r"""CreateClusterEndpointVip返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestFlowId: 请求任务的FlowId
        :type RequestFlowId: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestFlowId = None
        self._RequestId = None

    @property
    def RequestFlowId(self):
        r"""请求任务的FlowId
        :rtype: int
        """
        return self._RequestFlowId

    @RequestFlowId.setter
    def RequestFlowId(self, RequestFlowId):
        self._RequestFlowId = RequestFlowId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestFlowId = params.get("RequestFlowId")
        self._RequestId = params.get("RequestId")


class CreateClusterInstancesRequest(AbstractModel):
    r"""CreateClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
        :type ClusterId: str
        :param _RunInstancePara: CVM创建透传参数，json化字符串格式，如需要保证扩展集群节点请求幂等性需要在此参数添加ClientToken字段，详见[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口。
        :type RunInstancePara: str
        :param _InstanceAdvancedSettings: 实例额外需要设置参数信息
        :type InstanceAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _SkipValidateOptions: 校验规则相关选项，可配置跳过某些校验规则。目前支持GlobalRouteCIDRCheck（跳过GlobalRouter的相关校验），VpcCniCIDRCheck（跳过VpcCni相关校验）
        :type SkipValidateOptions: list of str
        """
        self._ClusterId = None
        self._RunInstancePara = None
        self._InstanceAdvancedSettings = None
        self._SkipValidateOptions = None

    @property
    def ClusterId(self):
        r"""集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RunInstancePara(self):
        r"""CVM创建透传参数，json化字符串格式，如需要保证扩展集群节点请求幂等性需要在此参数添加ClientToken字段，详见[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口。
        :rtype: str
        """
        return self._RunInstancePara

    @RunInstancePara.setter
    def RunInstancePara(self, RunInstancePara):
        self._RunInstancePara = RunInstancePara

    @property
    def InstanceAdvancedSettings(self):
        r"""实例额外需要设置参数信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def SkipValidateOptions(self):
        r"""校验规则相关选项，可配置跳过某些校验规则。目前支持GlobalRouteCIDRCheck（跳过GlobalRouter的相关校验），VpcCniCIDRCheck（跳过VpcCni相关校验）
        :rtype: list of str
        """
        return self._SkipValidateOptions

    @SkipValidateOptions.setter
    def SkipValidateOptions(self, SkipValidateOptions):
        self._SkipValidateOptions = SkipValidateOptions


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RunInstancePara = params.get("RunInstancePara")
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        self._SkipValidateOptions = params.get("SkipValidateOptions")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterInstancesResponse(AbstractModel):
    r"""CreateClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceIdSet: 节点实例ID
        :type InstanceIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceIdSet = None
        self._RequestId = None

    @property
    def InstanceIdSet(self):
        r"""节点实例ID
        :rtype: list of str
        """
        return self._InstanceIdSet

    @InstanceIdSet.setter
    def InstanceIdSet(self, InstanceIdSet):
        self._InstanceIdSet = InstanceIdSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceIdSet = params.get("InstanceIdSet")
        self._RequestId = params.get("RequestId")


class CreateClusterNodePoolRequest(AbstractModel):
    r"""CreateClusterNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: cluster id
        :type ClusterId: str
        :param _AutoScalingGroupPara: AutoScalingGroupPara AS组参数，参考 https://cloud.tencent.com/document/product/377/20440
        :type AutoScalingGroupPara: str
        :param _LaunchConfigurePara: LaunchConfigurePara 运行参数，参考 https://cloud.tencent.com/document/product/377/20447
        :type LaunchConfigurePara: str
        :param _InstanceAdvancedSettings: InstanceAdvancedSettings
        :type InstanceAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _EnableAutoscale: 是否启用自动伸缩
        :type EnableAutoscale: bool
        :param _Name: 节点池名称
        :type Name: str
        :param _Labels: Labels标签
        :type Labels: list of Label
        :param _Taints: Taints互斥
        :type Taints: list of Taint
        :param _Annotations: 节点Annotation 列表
        :type Annotations: list of AnnotationValue
        :param _ContainerRuntime: 节点池纬度运行时类型及版本
        :type ContainerRuntime: str
        :param _RuntimeVersion: 运行时版本
        :type RuntimeVersion: str
        :param _NodePoolOs: 节点池os，当为自定义镜像时，传镜像id；否则为公共镜像的osName
        :type NodePoolOs: str
        :param _OsCustomizeType: 容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :type OsCustomizeType: str
        :param _Tags: 资源标签
        :type Tags: list of Tag
        :param _DeletionProtection: 删除保护开关
        :type DeletionProtection: bool
        """
        self._ClusterId = None
        self._AutoScalingGroupPara = None
        self._LaunchConfigurePara = None
        self._InstanceAdvancedSettings = None
        self._EnableAutoscale = None
        self._Name = None
        self._Labels = None
        self._Taints = None
        self._Annotations = None
        self._ContainerRuntime = None
        self._RuntimeVersion = None
        self._NodePoolOs = None
        self._OsCustomizeType = None
        self._Tags = None
        self._DeletionProtection = None

    @property
    def ClusterId(self):
        r"""cluster id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AutoScalingGroupPara(self):
        r"""AutoScalingGroupPara AS组参数，参考 https://cloud.tencent.com/document/product/377/20440
        :rtype: str
        """
        return self._AutoScalingGroupPara

    @AutoScalingGroupPara.setter
    def AutoScalingGroupPara(self, AutoScalingGroupPara):
        self._AutoScalingGroupPara = AutoScalingGroupPara

    @property
    def LaunchConfigurePara(self):
        r"""LaunchConfigurePara 运行参数，参考 https://cloud.tencent.com/document/product/377/20447
        :rtype: str
        """
        return self._LaunchConfigurePara

    @LaunchConfigurePara.setter
    def LaunchConfigurePara(self, LaunchConfigurePara):
        self._LaunchConfigurePara = LaunchConfigurePara

    @property
    def InstanceAdvancedSettings(self):
        r"""InstanceAdvancedSettings
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def EnableAutoscale(self):
        r"""是否启用自动伸缩
        :rtype: bool
        """
        return self._EnableAutoscale

    @EnableAutoscale.setter
    def EnableAutoscale(self, EnableAutoscale):
        self._EnableAutoscale = EnableAutoscale

    @property
    def Name(self):
        r"""节点池名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Labels(self):
        r"""Labels标签
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Taints(self):
        r"""Taints互斥
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def Annotations(self):
        r"""节点Annotation 列表
        :rtype: list of AnnotationValue
        """
        return self._Annotations

    @Annotations.setter
    def Annotations(self, Annotations):
        self._Annotations = Annotations

    @property
    def ContainerRuntime(self):
        r"""节点池纬度运行时类型及版本
        :rtype: str
        """
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def RuntimeVersion(self):
        r"""运行时版本
        :rtype: str
        """
        return self._RuntimeVersion

    @RuntimeVersion.setter
    def RuntimeVersion(self, RuntimeVersion):
        self._RuntimeVersion = RuntimeVersion

    @property
    def NodePoolOs(self):
        r"""节点池os，当为自定义镜像时，传镜像id；否则为公共镜像的osName
        :rtype: str
        """
        return self._NodePoolOs

    @NodePoolOs.setter
    def NodePoolOs(self, NodePoolOs):
        self._NodePoolOs = NodePoolOs

    @property
    def OsCustomizeType(self):
        r"""容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType

    @property
    def Tags(self):
        r"""资源标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DeletionProtection(self):
        r"""删除保护开关
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AutoScalingGroupPara = params.get("AutoScalingGroupPara")
        self._LaunchConfigurePara = params.get("LaunchConfigurePara")
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        self._EnableAutoscale = params.get("EnableAutoscale")
        self._Name = params.get("Name")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Taints") is not None:
            self._Taints = []
            for item in params.get("Taints"):
                obj = Taint()
                obj._deserialize(item)
                self._Taints.append(obj)
        if params.get("Annotations") is not None:
            self._Annotations = []
            for item in params.get("Annotations"):
                obj = AnnotationValue()
                obj._deserialize(item)
                self._Annotations.append(obj)
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._RuntimeVersion = params.get("RuntimeVersion")
        self._NodePoolOs = params.get("NodePoolOs")
        self._OsCustomizeType = params.get("OsCustomizeType")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._DeletionProtection = params.get("DeletionProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterNodePoolResponse(AbstractModel):
    r"""CreateClusterNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodePoolId: 节点池id
        :type NodePoolId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodePoolId = None
        self._RequestId = None

    @property
    def NodePoolId(self):
        r"""节点池id
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NodePoolId = params.get("NodePoolId")
        self._RequestId = params.get("RequestId")


class CreateClusterReleaseRequest(AbstractModel):
    r"""CreateClusterRelease请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Name: 应用名称
        :type Name: str
        :param _Namespace: 应用命名空间
        :type Namespace: str
        :param _Chart: 制品名称或从第三方repo 安装chart时，制品压缩包下载地址, 不支持重定向类型chart 地址，结尾为*.tgz
        :type Chart: str
        :param _Values: 自定义参数
        :type Values: :class:`tencentcloud.tke.v20180525.models.ReleaseValues`
        :param _ChartFrom: 制品来源，范围：tke-market 或 other默认值：tke-market。
        :type ChartFrom: str
        :param _ChartVersion: 制品版本
        :type ChartVersion: str
        :param _ChartRepoURL: 制品仓库URL地址
        :type ChartRepoURL: str
        :param _Username: 制品访问用户名
        :type Username: str
        :param _Password: 制品访问密码
        :type Password: str
        :param _ChartNamespace: 制品命名空间，ChartFrom为tke-market时ChartNamespace不为空，值为DescribeProducts接口反馈的Namespace
        :type ChartNamespace: str
        :param _ClusterType: 集群类型，支持传 tke, eks, tkeedge, external(注册集群）
        :type ClusterType: str
        """
        self._ClusterId = None
        self._Name = None
        self._Namespace = None
        self._Chart = None
        self._Values = None
        self._ChartFrom = None
        self._ChartVersion = None
        self._ChartRepoURL = None
        self._Username = None
        self._Password = None
        self._ChartNamespace = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Name(self):
        r"""应用名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Namespace(self):
        r"""应用命名空间
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Chart(self):
        r"""制品名称或从第三方repo 安装chart时，制品压缩包下载地址, 不支持重定向类型chart 地址，结尾为*.tgz
        :rtype: str
        """
        return self._Chart

    @Chart.setter
    def Chart(self, Chart):
        self._Chart = Chart

    @property
    def Values(self):
        r"""自定义参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.ReleaseValues`
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ChartFrom(self):
        r"""制品来源，范围：tke-market 或 other默认值：tke-market。
        :rtype: str
        """
        return self._ChartFrom

    @ChartFrom.setter
    def ChartFrom(self, ChartFrom):
        self._ChartFrom = ChartFrom

    @property
    def ChartVersion(self):
        r"""制品版本
        :rtype: str
        """
        return self._ChartVersion

    @ChartVersion.setter
    def ChartVersion(self, ChartVersion):
        self._ChartVersion = ChartVersion

    @property
    def ChartRepoURL(self):
        r"""制品仓库URL地址
        :rtype: str
        """
        return self._ChartRepoURL

    @ChartRepoURL.setter
    def ChartRepoURL(self, ChartRepoURL):
        self._ChartRepoURL = ChartRepoURL

    @property
    def Username(self):
        r"""制品访问用户名
        :rtype: str
        """
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        r"""制品访问密码
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def ChartNamespace(self):
        r"""制品命名空间，ChartFrom为tke-market时ChartNamespace不为空，值为DescribeProducts接口反馈的Namespace
        :rtype: str
        """
        return self._ChartNamespace

    @ChartNamespace.setter
    def ChartNamespace(self, ChartNamespace):
        self._ChartNamespace = ChartNamespace

    @property
    def ClusterType(self):
        r"""集群类型，支持传 tke, eks, tkeedge, external(注册集群）
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Name = params.get("Name")
        self._Namespace = params.get("Namespace")
        self._Chart = params.get("Chart")
        if params.get("Values") is not None:
            self._Values = ReleaseValues()
            self._Values._deserialize(params.get("Values"))
        self._ChartFrom = params.get("ChartFrom")
        self._ChartVersion = params.get("ChartVersion")
        self._ChartRepoURL = params.get("ChartRepoURL")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        self._ChartNamespace = params.get("ChartNamespace")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterReleaseResponse(AbstractModel):
    r"""CreateClusterRelease返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Release: 应用详情
        :type Release: :class:`tencentcloud.tke.v20180525.models.PendingRelease`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Release = None
        self._RequestId = None

    @property
    def Release(self):
        r"""应用详情
        :rtype: :class:`tencentcloud.tke.v20180525.models.PendingRelease`
        """
        return self._Release

    @Release.setter
    def Release(self, Release):
        self._Release = Release

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Release") is not None:
            self._Release = PendingRelease()
            self._Release._deserialize(params.get("Release"))
        self._RequestId = params.get("RequestId")


class CreateClusterRequest(AbstractModel):
    r"""CreateCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterType: 集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER。
        :type ClusterType: str
        :param _ClusterCIDRSettings: 集群容器网络配置信息
        :type ClusterCIDRSettings: :class:`tencentcloud.tke.v20180525.models.ClusterCIDRSettings`
        :param _RunInstancesForNode: CVM创建透传参数，json化字符串格式，详见[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口。总机型(包括地域)数量不超过10个，相同机型(地域)购买多台机器可以通过设置参数中RunInstances中InstanceCount来实现。
        :type RunInstancesForNode: list of RunInstancesForNode
        :param _ClusterBasicSettings: 集群的基本配置信息
        :type ClusterBasicSettings: :class:`tencentcloud.tke.v20180525.models.ClusterBasicSettings`
        :param _ClusterAdvancedSettings: 集群高级配置信息
        :type ClusterAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.ClusterAdvancedSettings`
        :param _InstanceAdvancedSettings: 节点高级配置信息
        :type InstanceAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _ExistedInstancesForNode: 已存在实例的配置信息。所有实例必须在同一个VPC中，最大数量不超过100，不支持添加竞价实例。
        :type ExistedInstancesForNode: list of ExistedInstancesForNode
        :param _InstanceDataDiskMountSettings: CVM类型和其对应的数据盘挂载配置信息
        :type InstanceDataDiskMountSettings: list of InstanceDataDiskMountSetting
        :param _ExtensionAddons: 需要安装的扩展组件信息
        :type ExtensionAddons: list of ExtensionAddon
        :param _CdcId: 本地专用集群Id
        :type CdcId: str
        :param _DisableAddons: 屏蔽安装指定Addon组件，填写相应的AddonName
        :type DisableAddons: list of str
        """
        self._ClusterType = None
        self._ClusterCIDRSettings = None
        self._RunInstancesForNode = None
        self._ClusterBasicSettings = None
        self._ClusterAdvancedSettings = None
        self._InstanceAdvancedSettings = None
        self._ExistedInstancesForNode = None
        self._InstanceDataDiskMountSettings = None
        self._ExtensionAddons = None
        self._CdcId = None
        self._DisableAddons = None

    @property
    def ClusterType(self):
        r"""集群类型，托管集群：MANAGED_CLUSTER，独立集群：INDEPENDENT_CLUSTER。
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterCIDRSettings(self):
        r"""集群容器网络配置信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterCIDRSettings`
        """
        return self._ClusterCIDRSettings

    @ClusterCIDRSettings.setter
    def ClusterCIDRSettings(self, ClusterCIDRSettings):
        self._ClusterCIDRSettings = ClusterCIDRSettings

    @property
    def RunInstancesForNode(self):
        r"""CVM创建透传参数，json化字符串格式，详见[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口。总机型(包括地域)数量不超过10个，相同机型(地域)购买多台机器可以通过设置参数中RunInstances中InstanceCount来实现。
        :rtype: list of RunInstancesForNode
        """
        return self._RunInstancesForNode

    @RunInstancesForNode.setter
    def RunInstancesForNode(self, RunInstancesForNode):
        self._RunInstancesForNode = RunInstancesForNode

    @property
    def ClusterBasicSettings(self):
        r"""集群的基本配置信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterBasicSettings`
        """
        return self._ClusterBasicSettings

    @ClusterBasicSettings.setter
    def ClusterBasicSettings(self, ClusterBasicSettings):
        self._ClusterBasicSettings = ClusterBasicSettings

    @property
    def ClusterAdvancedSettings(self):
        r"""集群高级配置信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterAdvancedSettings`
        """
        return self._ClusterAdvancedSettings

    @ClusterAdvancedSettings.setter
    def ClusterAdvancedSettings(self, ClusterAdvancedSettings):
        self._ClusterAdvancedSettings = ClusterAdvancedSettings

    @property
    def InstanceAdvancedSettings(self):
        r"""节点高级配置信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def ExistedInstancesForNode(self):
        r"""已存在实例的配置信息。所有实例必须在同一个VPC中，最大数量不超过100，不支持添加竞价实例。
        :rtype: list of ExistedInstancesForNode
        """
        return self._ExistedInstancesForNode

    @ExistedInstancesForNode.setter
    def ExistedInstancesForNode(self, ExistedInstancesForNode):
        self._ExistedInstancesForNode = ExistedInstancesForNode

    @property
    def InstanceDataDiskMountSettings(self):
        r"""CVM类型和其对应的数据盘挂载配置信息
        :rtype: list of InstanceDataDiskMountSetting
        """
        return self._InstanceDataDiskMountSettings

    @InstanceDataDiskMountSettings.setter
    def InstanceDataDiskMountSettings(self, InstanceDataDiskMountSettings):
        self._InstanceDataDiskMountSettings = InstanceDataDiskMountSettings

    @property
    def ExtensionAddons(self):
        r"""需要安装的扩展组件信息
        :rtype: list of ExtensionAddon
        """
        return self._ExtensionAddons

    @ExtensionAddons.setter
    def ExtensionAddons(self, ExtensionAddons):
        self._ExtensionAddons = ExtensionAddons

    @property
    def CdcId(self):
        r"""本地专用集群Id
        :rtype: str
        """
        return self._CdcId

    @CdcId.setter
    def CdcId(self, CdcId):
        self._CdcId = CdcId

    @property
    def DisableAddons(self):
        r"""屏蔽安装指定Addon组件，填写相应的AddonName
        :rtype: list of str
        """
        return self._DisableAddons

    @DisableAddons.setter
    def DisableAddons(self, DisableAddons):
        self._DisableAddons = DisableAddons


    def _deserialize(self, params):
        self._ClusterType = params.get("ClusterType")
        if params.get("ClusterCIDRSettings") is not None:
            self._ClusterCIDRSettings = ClusterCIDRSettings()
            self._ClusterCIDRSettings._deserialize(params.get("ClusterCIDRSettings"))
        if params.get("RunInstancesForNode") is not None:
            self._RunInstancesForNode = []
            for item in params.get("RunInstancesForNode"):
                obj = RunInstancesForNode()
                obj._deserialize(item)
                self._RunInstancesForNode.append(obj)
        if params.get("ClusterBasicSettings") is not None:
            self._ClusterBasicSettings = ClusterBasicSettings()
            self._ClusterBasicSettings._deserialize(params.get("ClusterBasicSettings"))
        if params.get("ClusterAdvancedSettings") is not None:
            self._ClusterAdvancedSettings = ClusterAdvancedSettings()
            self._ClusterAdvancedSettings._deserialize(params.get("ClusterAdvancedSettings"))
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        if params.get("ExistedInstancesForNode") is not None:
            self._ExistedInstancesForNode = []
            for item in params.get("ExistedInstancesForNode"):
                obj = ExistedInstancesForNode()
                obj._deserialize(item)
                self._ExistedInstancesForNode.append(obj)
        if params.get("InstanceDataDiskMountSettings") is not None:
            self._InstanceDataDiskMountSettings = []
            for item in params.get("InstanceDataDiskMountSettings"):
                obj = InstanceDataDiskMountSetting()
                obj._deserialize(item)
                self._InstanceDataDiskMountSettings.append(obj)
        if params.get("ExtensionAddons") is not None:
            self._ExtensionAddons = []
            for item in params.get("ExtensionAddons"):
                obj = ExtensionAddon()
                obj._deserialize(item)
                self._ExtensionAddons.append(obj)
        self._CdcId = params.get("CdcId")
        self._DisableAddons = params.get("DisableAddons")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterResponse(AbstractModel):
    r"""CreateCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class CreateClusterRouteRequest(AbstractModel):
    r"""CreateClusterRoute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableName: 路由表名称。
        :type RouteTableName: str
        :param _DestinationCidrBlock: 目的节点的 PodCIDR
        :type DestinationCidrBlock: str
        :param _GatewayIp: 下一跳地址，即目的节点的内网 IP 地址
        :type GatewayIp: str
        """
        self._RouteTableName = None
        self._DestinationCidrBlock = None
        self._GatewayIp = None

    @property
    def RouteTableName(self):
        r"""路由表名称。
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def DestinationCidrBlock(self):
        r"""目的节点的 PodCIDR
        :rtype: str
        """
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock

    @property
    def GatewayIp(self):
        r"""下一跳地址，即目的节点的内网 IP 地址
        :rtype: str
        """
        return self._GatewayIp

    @GatewayIp.setter
    def GatewayIp(self, GatewayIp):
        self._GatewayIp = GatewayIp


    def _deserialize(self, params):
        self._RouteTableName = params.get("RouteTableName")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        self._GatewayIp = params.get("GatewayIp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterRouteResponse(AbstractModel):
    r"""CreateClusterRoute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClusterRouteTableRequest(AbstractModel):
    r"""CreateClusterRouteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableName: 路由表名称，一般为集群ID
        :type RouteTableName: str
        :param _RouteTableCidrBlock: 路由表CIDR
        :type RouteTableCidrBlock: str
        :param _VpcId: 路由表绑定的VPC
        :type VpcId: str
        :param _IgnoreClusterCidrConflict: 是否忽略CIDR与 vpc 路由表的冲突， 0 表示不忽略，1表示忽略。默认不忽略
        :type IgnoreClusterCidrConflict: int
        """
        self._RouteTableName = None
        self._RouteTableCidrBlock = None
        self._VpcId = None
        self._IgnoreClusterCidrConflict = None

    @property
    def RouteTableName(self):
        r"""路由表名称，一般为集群ID
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def RouteTableCidrBlock(self):
        r"""路由表CIDR
        :rtype: str
        """
        return self._RouteTableCidrBlock

    @RouteTableCidrBlock.setter
    def RouteTableCidrBlock(self, RouteTableCidrBlock):
        self._RouteTableCidrBlock = RouteTableCidrBlock

    @property
    def VpcId(self):
        r"""路由表绑定的VPC
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def IgnoreClusterCidrConflict(self):
        r"""是否忽略CIDR与 vpc 路由表的冲突， 0 表示不忽略，1表示忽略。默认不忽略
        :rtype: int
        """
        return self._IgnoreClusterCidrConflict

    @IgnoreClusterCidrConflict.setter
    def IgnoreClusterCidrConflict(self, IgnoreClusterCidrConflict):
        self._IgnoreClusterCidrConflict = IgnoreClusterCidrConflict


    def _deserialize(self, params):
        self._RouteTableName = params.get("RouteTableName")
        self._RouteTableCidrBlock = params.get("RouteTableCidrBlock")
        self._VpcId = params.get("VpcId")
        self._IgnoreClusterCidrConflict = params.get("IgnoreClusterCidrConflict")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterRouteTableResponse(AbstractModel):
    r"""CreateClusterRouteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClusterVirtualNodePoolRequest(AbstractModel):
    r"""CreateClusterVirtualNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _Name: 节点池名称
        :type Name: str
        :param _SubnetIds: 子网ID列表
        :type SubnetIds: list of str
        :param _SecurityGroupIds: 安全组ID列表，必选参数
        :type SecurityGroupIds: list of str
        :param _Labels: 虚拟节点label
        :type Labels: list of Label
        :param _Taints: 虚拟节点taint
        :type Taints: list of Taint
        :param _VirtualNodes: 节点列表
        :type VirtualNodes: list of VirtualNodeSpec
        :param _DeletionProtection: 删除保护开关，默认关闭
        :type DeletionProtection: bool
        :param _OS: 节点池操作系统：
- linux（默认）
- windows
        :type OS: str
        """
        self._ClusterId = None
        self._Name = None
        self._SubnetIds = None
        self._SecurityGroupIds = None
        self._Labels = None
        self._Taints = None
        self._VirtualNodes = None
        self._DeletionProtection = None
        self._OS = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Name(self):
        r"""节点池名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubnetIds(self):
        r"""子网ID列表
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def SecurityGroupIds(self):
        r"""安全组ID列表，必选参数
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Labels(self):
        r"""虚拟节点label
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Taints(self):
        r"""虚拟节点taint
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def VirtualNodes(self):
        r"""节点列表
        :rtype: list of VirtualNodeSpec
        """
        return self._VirtualNodes

    @VirtualNodes.setter
    def VirtualNodes(self, VirtualNodes):
        self._VirtualNodes = VirtualNodes

    @property
    def DeletionProtection(self):
        r"""删除保护开关，默认关闭
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection

    @property
    def OS(self):
        r"""节点池操作系统：
- linux（默认）
- windows
        :rtype: str
        """
        return self._OS

    @OS.setter
    def OS(self, OS):
        self._OS = OS


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Name = params.get("Name")
        self._SubnetIds = params.get("SubnetIds")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Taints") is not None:
            self._Taints = []
            for item in params.get("Taints"):
                obj = Taint()
                obj._deserialize(item)
                self._Taints.append(obj)
        if params.get("VirtualNodes") is not None:
            self._VirtualNodes = []
            for item in params.get("VirtualNodes"):
                obj = VirtualNodeSpec()
                obj._deserialize(item)
                self._VirtualNodes.append(obj)
        self._DeletionProtection = params.get("DeletionProtection")
        self._OS = params.get("OS")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterVirtualNodePoolResponse(AbstractModel):
    r"""CreateClusterVirtualNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodePoolId: 节点池ID
        :type NodePoolId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodePoolId = None
        self._RequestId = None

    @property
    def NodePoolId(self):
        r"""节点池ID
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NodePoolId = params.get("NodePoolId")
        self._RequestId = params.get("RequestId")


class CreateClusterVirtualNodeRequest(AbstractModel):
    r"""CreateClusterVirtualNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _NodePoolId: 虚拟节点所属节点池，通过DescribeNodePools接口获取
        :type NodePoolId: str
        :param _SubnetId: 虚拟节点所属子网，SubnetId、SubnetIds、VirtualNodes必选一个。
        :type SubnetId: str
        :param _SubnetIds: 虚拟节点子网ID列表，SubnetId、SubnetIds、VirtualNodes必选一个。
        :type SubnetIds: list of str
        :param _VirtualNodes: 虚拟节点列表，SubnetId、SubnetIds、VirtualNodes必选一个。
        :type VirtualNodes: list of VirtualNodeSpec
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._SubnetId = None
        self._SubnetIds = None
        self._VirtualNodes = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""虚拟节点所属节点池，通过DescribeNodePools接口获取
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def SubnetId(self):
        r"""虚拟节点所属子网，SubnetId、SubnetIds、VirtualNodes必选一个。
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def SubnetIds(self):
        r"""虚拟节点子网ID列表，SubnetId、SubnetIds、VirtualNodes必选一个。
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def VirtualNodes(self):
        r"""虚拟节点列表，SubnetId、SubnetIds、VirtualNodes必选一个。
        :rtype: list of VirtualNodeSpec
        """
        return self._VirtualNodes

    @VirtualNodes.setter
    def VirtualNodes(self, VirtualNodes):
        self._VirtualNodes = VirtualNodes


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._SubnetId = params.get("SubnetId")
        self._SubnetIds = params.get("SubnetIds")
        if params.get("VirtualNodes") is not None:
            self._VirtualNodes = []
            for item in params.get("VirtualNodes"):
                obj = VirtualNodeSpec()
                obj._deserialize(item)
                self._VirtualNodes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterVirtualNodeResponse(AbstractModel):
    r"""CreateClusterVirtualNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodeName: 虚拟节点名称
        :type NodeName: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodeName = None
        self._RequestId = None

    @property
    def NodeName(self):
        r"""虚拟节点名称
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NodeName = params.get("NodeName")
        self._RequestId = params.get("RequestId")


class CreateECMInstancesRequest(AbstractModel):
    r"""CreateECMInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群id，边缘集群需要先开启公网访问才能添加ecm节点
        :type ClusterID: str
        :param _ModuleId: 边缘模块id
        :type ModuleId: str
        :param _ZoneInstanceCountISPSet: 需要创建实例的可用区及创建数目及运营商的列表
        :type ZoneInstanceCountISPSet: list of ECMZoneInstanceCountISP
        :param _Password: 密码
        :type Password: str
        :param _InternetMaxBandwidthOut: 公网带宽
        :type InternetMaxBandwidthOut: int
        :param _ImageId: 镜像id
        :type ImageId: str
        :param _InstanceName: 实例名称
        :type InstanceName: str
        :param _HostName: 主机名称
        :type HostName: str
        :param _EnhancedService: 增强服务，包括云镜和云监控
        :type EnhancedService: :class:`tencentcloud.tke.v20180525.models.ECMEnhancedService`
        :param _UserData: 用户自定义脚本
        :type UserData: str
        :param _External: 实例扩展信息
        :type External: str
        :param _SecurityGroupIds: 实例所属安全组
        :type SecurityGroupIds: list of str
        """
        self._ClusterID = None
        self._ModuleId = None
        self._ZoneInstanceCountISPSet = None
        self._Password = None
        self._InternetMaxBandwidthOut = None
        self._ImageId = None
        self._InstanceName = None
        self._HostName = None
        self._EnhancedService = None
        self._UserData = None
        self._External = None
        self._SecurityGroupIds = None

    @property
    def ClusterID(self):
        r"""集群id，边缘集群需要先开启公网访问才能添加ecm节点
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def ModuleId(self):
        r"""边缘模块id
        :rtype: str
        """
        return self._ModuleId

    @ModuleId.setter
    def ModuleId(self, ModuleId):
        self._ModuleId = ModuleId

    @property
    def ZoneInstanceCountISPSet(self):
        r"""需要创建实例的可用区及创建数目及运营商的列表
        :rtype: list of ECMZoneInstanceCountISP
        """
        return self._ZoneInstanceCountISPSet

    @ZoneInstanceCountISPSet.setter
    def ZoneInstanceCountISPSet(self, ZoneInstanceCountISPSet):
        self._ZoneInstanceCountISPSet = ZoneInstanceCountISPSet

    @property
    def Password(self):
        r"""密码
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def InternetMaxBandwidthOut(self):
        r"""公网带宽
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut

    @property
    def ImageId(self):
        r"""镜像id
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def InstanceName(self):
        r"""实例名称
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def HostName(self):
        r"""主机名称
        :rtype: str
        """
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def EnhancedService(self):
        r"""增强服务，包括云镜和云监控
        :rtype: :class:`tencentcloud.tke.v20180525.models.ECMEnhancedService`
        """
        return self._EnhancedService

    @EnhancedService.setter
    def EnhancedService(self, EnhancedService):
        self._EnhancedService = EnhancedService

    @property
    def UserData(self):
        r"""用户自定义脚本
        :rtype: str
        """
        return self._UserData

    @UserData.setter
    def UserData(self, UserData):
        self._UserData = UserData

    @property
    def External(self):
        r"""实例扩展信息
        :rtype: str
        """
        return self._External

    @External.setter
    def External(self, External):
        self._External = External

    @property
    def SecurityGroupIds(self):
        r"""实例所属安全组
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._ModuleId = params.get("ModuleId")
        if params.get("ZoneInstanceCountISPSet") is not None:
            self._ZoneInstanceCountISPSet = []
            for item in params.get("ZoneInstanceCountISPSet"):
                obj = ECMZoneInstanceCountISP()
                obj._deserialize(item)
                self._ZoneInstanceCountISPSet.append(obj)
        self._Password = params.get("Password")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        self._ImageId = params.get("ImageId")
        self._InstanceName = params.get("InstanceName")
        self._HostName = params.get("HostName")
        if params.get("EnhancedService") is not None:
            self._EnhancedService = ECMEnhancedService()
            self._EnhancedService._deserialize(params.get("EnhancedService"))
        self._UserData = params.get("UserData")
        self._External = params.get("External")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateECMInstancesResponse(AbstractModel):
    r"""CreateECMInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EcmIdSet: ecm id 列表
        :type EcmIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EcmIdSet = None
        self._RequestId = None

    @property
    def EcmIdSet(self):
        r"""ecm id 列表
        :rtype: list of str
        """
        return self._EcmIdSet

    @EcmIdSet.setter
    def EcmIdSet(self, EcmIdSet):
        self._EcmIdSet = EcmIdSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EcmIdSet = params.get("EcmIdSet")
        self._RequestId = params.get("RequestId")


class CreateEKSClusterRequest(AbstractModel):
    r"""CreateEKSCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _K8SVersion: k8s版本号。可为1.18.4 1.20.6。
        :type K8SVersion: str
        :param _VpcId: vpc 的Id
        :type VpcId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _SubnetIds: 子网Id 列表
        :type SubnetIds: list of str
        :param _ClusterDesc: 集群描述信息
        :type ClusterDesc: str
        :param _ServiceSubnetId: Service CIDR 或 Serivce 所在子网Id
        :type ServiceSubnetId: str
        :param _DnsServers: 集群自定义的Dns服务器信息
        :type DnsServers: list of DnsServerConf
        :param _ExtraParam: 扩展参数。须是map[string]string 的json 格式。
        :type ExtraParam: str
        :param _EnableVpcCoreDNS: 是否在用户集群内开启Dns。默认为true
        :type EnableVpcCoreDNS: bool
        :param _TagSpecification: 标签描述列表。通过指定该参数可以同时绑定标签到相应的资源实例，当前仅支持绑定标签到集群实例。
        :type TagSpecification: list of TagSpecification
        :param _SubnetInfos: 子网信息列表
        :type SubnetInfos: list of SubnetInfos
        """
        self._K8SVersion = None
        self._VpcId = None
        self._ClusterName = None
        self._SubnetIds = None
        self._ClusterDesc = None
        self._ServiceSubnetId = None
        self._DnsServers = None
        self._ExtraParam = None
        self._EnableVpcCoreDNS = None
        self._TagSpecification = None
        self._SubnetInfos = None

    @property
    def K8SVersion(self):
        r"""k8s版本号。可为1.18.4 1.20.6。
        :rtype: str
        """
        return self._K8SVersion

    @K8SVersion.setter
    def K8SVersion(self, K8SVersion):
        self._K8SVersion = K8SVersion

    @property
    def VpcId(self):
        r"""vpc 的Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def SubnetIds(self):
        r"""子网Id 列表
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def ClusterDesc(self):
        r"""集群描述信息
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def ServiceSubnetId(self):
        r"""Service CIDR 或 Serivce 所在子网Id
        :rtype: str
        """
        return self._ServiceSubnetId

    @ServiceSubnetId.setter
    def ServiceSubnetId(self, ServiceSubnetId):
        self._ServiceSubnetId = ServiceSubnetId

    @property
    def DnsServers(self):
        r"""集群自定义的Dns服务器信息
        :rtype: list of DnsServerConf
        """
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers

    @property
    def ExtraParam(self):
        r"""扩展参数。须是map[string]string 的json 格式。
        :rtype: str
        """
        return self._ExtraParam

    @ExtraParam.setter
    def ExtraParam(self, ExtraParam):
        self._ExtraParam = ExtraParam

    @property
    def EnableVpcCoreDNS(self):
        r"""是否在用户集群内开启Dns。默认为true
        :rtype: bool
        """
        return self._EnableVpcCoreDNS

    @EnableVpcCoreDNS.setter
    def EnableVpcCoreDNS(self, EnableVpcCoreDNS):
        self._EnableVpcCoreDNS = EnableVpcCoreDNS

    @property
    def TagSpecification(self):
        r"""标签描述列表。通过指定该参数可以同时绑定标签到相应的资源实例，当前仅支持绑定标签到集群实例。
        :rtype: list of TagSpecification
        """
        return self._TagSpecification

    @TagSpecification.setter
    def TagSpecification(self, TagSpecification):
        self._TagSpecification = TagSpecification

    @property
    def SubnetInfos(self):
        r"""子网信息列表
        :rtype: list of SubnetInfos
        """
        return self._SubnetInfos

    @SubnetInfos.setter
    def SubnetInfos(self, SubnetInfos):
        self._SubnetInfos = SubnetInfos


    def _deserialize(self, params):
        self._K8SVersion = params.get("K8SVersion")
        self._VpcId = params.get("VpcId")
        self._ClusterName = params.get("ClusterName")
        self._SubnetIds = params.get("SubnetIds")
        self._ClusterDesc = params.get("ClusterDesc")
        self._ServiceSubnetId = params.get("ServiceSubnetId")
        if params.get("DnsServers") is not None:
            self._DnsServers = []
            for item in params.get("DnsServers"):
                obj = DnsServerConf()
                obj._deserialize(item)
                self._DnsServers.append(obj)
        self._ExtraParam = params.get("ExtraParam")
        self._EnableVpcCoreDNS = params.get("EnableVpcCoreDNS")
        if params.get("TagSpecification") is not None:
            self._TagSpecification = []
            for item in params.get("TagSpecification"):
                obj = TagSpecification()
                obj._deserialize(item)
                self._TagSpecification.append(obj)
        if params.get("SubnetInfos") is not None:
            self._SubnetInfos = []
            for item in params.get("SubnetInfos"):
                obj = SubnetInfos()
                obj._deserialize(item)
                self._SubnetInfos.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEKSClusterResponse(AbstractModel):
    r"""CreateEKSCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 弹性集群Id
        :type ClusterId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""弹性集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class CreateEKSContainerInstancesRequest(AbstractModel):
    r"""CreateEKSContainerInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Containers: 容器组
        :type Containers: list of Container
        :param _EksCiName: EKS Container Instance容器实例名称
        :type EksCiName: str
        :param _SecurityGroupIds: 指定新创建实例所属于的安全组Id
        :type SecurityGroupIds: list of str
        :param _SubnetId: 实例所属子网Id
        :type SubnetId: str
        :param _VpcId: 实例所属VPC的Id
        :type VpcId: str
        :param _Memory: 内存，单位：GiB。可参考[资源规格](https://cloud.tencent.com/document/product/457/39808)文档
        :type Memory: float
        :param _Cpu: CPU，单位：核。可参考[资源规格](https://cloud.tencent.com/document/product/457/39808)文档
        :type Cpu: float
        :param _RestartPolicy: 实例重启策略： Always(总是重启)、Never(从不重启)、OnFailure(失败时重启)，默认：Always。
        :type RestartPolicy: str
        :param _ImageRegistryCredentials: 镜像仓库凭证数组
        :type ImageRegistryCredentials: list of ImageRegistryCredential
        :param _EksCiVolume: 数据卷，包含NfsVolume数组和CbsVolume数组
        :type EksCiVolume: :class:`tencentcloud.tke.v20180525.models.EksCiVolume`
        :param _Replicas: 实例副本数，默认为1
        :type Replicas: int
        :param _InitContainers: Init 容器
        :type InitContainers: list of Container
        :param _DnsConfig: 自定义DNS配置
        :type DnsConfig: :class:`tencentcloud.tke.v20180525.models.DNSConfig`
        :param _ExistedEipIds: 用来绑定容器实例的已有EIP的列表。如传值，需要保证数值和Replicas相等。
另外此参数和AutoCreateEipAttribute互斥。
        :type ExistedEipIds: list of str
        :param _AutoCreateEipAttribute: 自动创建EIP的可选参数。若传此参数，则会自动创建EIP。
另外此参数和ExistedEipIds互斥
        :type AutoCreateEipAttribute: :class:`tencentcloud.tke.v20180525.models.EipAttribute`
        :param _AutoCreateEip: 是否为容器实例自动创建EIP，默认为false。若传true，则此参数和ExistedEipIds互斥
        :type AutoCreateEip: bool
        :param _CpuType: Pod 所需的 CPU 资源型号，如果不填写则默认不强制指定 CPU 类型。目前支持型号如下：
intel
amd
- 支持优先级顺序写法，如 “amd,intel” 表示优先创建 amd 资源 Pod，如果所选地域可用区 amd 资源不足，则会创建 intel 资源 Pod。
        :type CpuType: str
        :param _GpuType: 容器实例所需的 GPU 资源型号，目前支持型号如下：
1/4\*V100
1/2\*V100
V100
1/4\*T4
1/2\*T4
T4
        :type GpuType: str
        :param _GpuCount: Pod 所需的 GPU 数量，如填写，请确保为支持的规格。默认单位为卡，无需再次注明。
        :type GpuCount: int
        :param _CamRoleName: 为容器实例关联 CAM 角色，value 填写 CAM 角色名称，容器实例可获取该 CAM 角色包含的权限策略，方便 容器实例 内的程序进行如购买资源、读写存储等云资源操作。
        :type CamRoleName: str
        """
        self._Containers = None
        self._EksCiName = None
        self._SecurityGroupIds = None
        self._SubnetId = None
        self._VpcId = None
        self._Memory = None
        self._Cpu = None
        self._RestartPolicy = None
        self._ImageRegistryCredentials = None
        self._EksCiVolume = None
        self._Replicas = None
        self._InitContainers = None
        self._DnsConfig = None
        self._ExistedEipIds = None
        self._AutoCreateEipAttribute = None
        self._AutoCreateEip = None
        self._CpuType = None
        self._GpuType = None
        self._GpuCount = None
        self._CamRoleName = None

    @property
    def Containers(self):
        r"""容器组
        :rtype: list of Container
        """
        return self._Containers

    @Containers.setter
    def Containers(self, Containers):
        self._Containers = Containers

    @property
    def EksCiName(self):
        r"""EKS Container Instance容器实例名称
        :rtype: str
        """
        return self._EksCiName

    @EksCiName.setter
    def EksCiName(self, EksCiName):
        self._EksCiName = EksCiName

    @property
    def SecurityGroupIds(self):
        r"""指定新创建实例所属于的安全组Id
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def SubnetId(self):
        r"""实例所属子网Id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcId(self):
        r"""实例所属VPC的Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def Memory(self):
        r"""内存，单位：GiB。可参考[资源规格](https://cloud.tencent.com/document/product/457/39808)文档
        :rtype: float
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def Cpu(self):
        r"""CPU，单位：核。可参考[资源规格](https://cloud.tencent.com/document/product/457/39808)文档
        :rtype: float
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def RestartPolicy(self):
        r"""实例重启策略： Always(总是重启)、Never(从不重启)、OnFailure(失败时重启)，默认：Always。
        :rtype: str
        """
        return self._RestartPolicy

    @RestartPolicy.setter
    def RestartPolicy(self, RestartPolicy):
        self._RestartPolicy = RestartPolicy

    @property
    def ImageRegistryCredentials(self):
        r"""镜像仓库凭证数组
        :rtype: list of ImageRegistryCredential
        """
        return self._ImageRegistryCredentials

    @ImageRegistryCredentials.setter
    def ImageRegistryCredentials(self, ImageRegistryCredentials):
        self._ImageRegistryCredentials = ImageRegistryCredentials

    @property
    def EksCiVolume(self):
        r"""数据卷，包含NfsVolume数组和CbsVolume数组
        :rtype: :class:`tencentcloud.tke.v20180525.models.EksCiVolume`
        """
        return self._EksCiVolume

    @EksCiVolume.setter
    def EksCiVolume(self, EksCiVolume):
        self._EksCiVolume = EksCiVolume

    @property
    def Replicas(self):
        r"""实例副本数，默认为1
        :rtype: int
        """
        return self._Replicas

    @Replicas.setter
    def Replicas(self, Replicas):
        self._Replicas = Replicas

    @property
    def InitContainers(self):
        r"""Init 容器
        :rtype: list of Container
        """
        return self._InitContainers

    @InitContainers.setter
    def InitContainers(self, InitContainers):
        self._InitContainers = InitContainers

    @property
    def DnsConfig(self):
        r"""自定义DNS配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.DNSConfig`
        """
        return self._DnsConfig

    @DnsConfig.setter
    def DnsConfig(self, DnsConfig):
        self._DnsConfig = DnsConfig

    @property
    def ExistedEipIds(self):
        r"""用来绑定容器实例的已有EIP的列表。如传值，需要保证数值和Replicas相等。
另外此参数和AutoCreateEipAttribute互斥。
        :rtype: list of str
        """
        return self._ExistedEipIds

    @ExistedEipIds.setter
    def ExistedEipIds(self, ExistedEipIds):
        self._ExistedEipIds = ExistedEipIds

    @property
    def AutoCreateEipAttribute(self):
        r"""自动创建EIP的可选参数。若传此参数，则会自动创建EIP。
另外此参数和ExistedEipIds互斥
        :rtype: :class:`tencentcloud.tke.v20180525.models.EipAttribute`
        """
        return self._AutoCreateEipAttribute

    @AutoCreateEipAttribute.setter
    def AutoCreateEipAttribute(self, AutoCreateEipAttribute):
        self._AutoCreateEipAttribute = AutoCreateEipAttribute

    @property
    def AutoCreateEip(self):
        r"""是否为容器实例自动创建EIP，默认为false。若传true，则此参数和ExistedEipIds互斥
        :rtype: bool
        """
        return self._AutoCreateEip

    @AutoCreateEip.setter
    def AutoCreateEip(self, AutoCreateEip):
        self._AutoCreateEip = AutoCreateEip

    @property
    def CpuType(self):
        r"""Pod 所需的 CPU 资源型号，如果不填写则默认不强制指定 CPU 类型。目前支持型号如下：
intel
amd
- 支持优先级顺序写法，如 “amd,intel” 表示优先创建 amd 资源 Pod，如果所选地域可用区 amd 资源不足，则会创建 intel 资源 Pod。
        :rtype: str
        """
        return self._CpuType

    @CpuType.setter
    def CpuType(self, CpuType):
        self._CpuType = CpuType

    @property
    def GpuType(self):
        r"""容器实例所需的 GPU 资源型号，目前支持型号如下：
1/4\*V100
1/2\*V100
V100
1/4\*T4
1/2\*T4
T4
        :rtype: str
        """
        return self._GpuType

    @GpuType.setter
    def GpuType(self, GpuType):
        self._GpuType = GpuType

    @property
    def GpuCount(self):
        r"""Pod 所需的 GPU 数量，如填写，请确保为支持的规格。默认单位为卡，无需再次注明。
        :rtype: int
        """
        return self._GpuCount

    @GpuCount.setter
    def GpuCount(self, GpuCount):
        self._GpuCount = GpuCount

    @property
    def CamRoleName(self):
        r"""为容器实例关联 CAM 角色，value 填写 CAM 角色名称，容器实例可获取该 CAM 角色包含的权限策略，方便 容器实例 内的程序进行如购买资源、读写存储等云资源操作。
        :rtype: str
        """
        return self._CamRoleName

    @CamRoleName.setter
    def CamRoleName(self, CamRoleName):
        self._CamRoleName = CamRoleName


    def _deserialize(self, params):
        if params.get("Containers") is not None:
            self._Containers = []
            for item in params.get("Containers"):
                obj = Container()
                obj._deserialize(item)
                self._Containers.append(obj)
        self._EksCiName = params.get("EksCiName")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._SubnetId = params.get("SubnetId")
        self._VpcId = params.get("VpcId")
        self._Memory = params.get("Memory")
        self._Cpu = params.get("Cpu")
        self._RestartPolicy = params.get("RestartPolicy")
        if params.get("ImageRegistryCredentials") is not None:
            self._ImageRegistryCredentials = []
            for item in params.get("ImageRegistryCredentials"):
                obj = ImageRegistryCredential()
                obj._deserialize(item)
                self._ImageRegistryCredentials.append(obj)
        if params.get("EksCiVolume") is not None:
            self._EksCiVolume = EksCiVolume()
            self._EksCiVolume._deserialize(params.get("EksCiVolume"))
        self._Replicas = params.get("Replicas")
        if params.get("InitContainers") is not None:
            self._InitContainers = []
            for item in params.get("InitContainers"):
                obj = Container()
                obj._deserialize(item)
                self._InitContainers.append(obj)
        if params.get("DnsConfig") is not None:
            self._DnsConfig = DNSConfig()
            self._DnsConfig._deserialize(params.get("DnsConfig"))
        self._ExistedEipIds = params.get("ExistedEipIds")
        if params.get("AutoCreateEipAttribute") is not None:
            self._AutoCreateEipAttribute = EipAttribute()
            self._AutoCreateEipAttribute._deserialize(params.get("AutoCreateEipAttribute"))
        self._AutoCreateEip = params.get("AutoCreateEip")
        self._CpuType = params.get("CpuType")
        self._GpuType = params.get("GpuType")
        self._GpuCount = params.get("GpuCount")
        self._CamRoleName = params.get("CamRoleName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEKSContainerInstancesResponse(AbstractModel):
    r"""CreateEKSContainerInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EksCiIds: EKS Container Instance Id集合，格式为eksci-xxx，是容器实例的唯一标识。
        :type EksCiIds: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EksCiIds = None
        self._RequestId = None

    @property
    def EksCiIds(self):
        r"""EKS Container Instance Id集合，格式为eksci-xxx，是容器实例的唯一标识。
        :rtype: list of str
        """
        return self._EksCiIds

    @EksCiIds.setter
    def EksCiIds(self, EksCiIds):
        self._EksCiIds = EksCiIds

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EksCiIds = params.get("EksCiIds")
        self._RequestId = params.get("RequestId")


class CreateEdgeCVMInstancesRequest(AbstractModel):
    r"""CreateEdgeCVMInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群id，边缘集群需要先开启公网访问才能添加cvm节点
        :type ClusterID: str
        :param _RunInstancePara: CVM创建透传参数，json化字符串格式，如需要保证扩展集群节点请求幂等性需要在此参数添加ClientToken字段，详见[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口。
        :type RunInstancePara: str
        :param _CvmRegion: CVM所属Region
        :type CvmRegion: str
        :param _CvmCount: CVM数量
        :type CvmCount: int
        :param _External: 实例扩展信息
        :type External: str
        :param _UserScript: 用户自定义脚本
        :type UserScript: str
        :param _EnableEni: 是否开启弹性网卡功能
        :type EnableEni: bool
        """
        self._ClusterID = None
        self._RunInstancePara = None
        self._CvmRegion = None
        self._CvmCount = None
        self._External = None
        self._UserScript = None
        self._EnableEni = None

    @property
    def ClusterID(self):
        r"""集群id，边缘集群需要先开启公网访问才能添加cvm节点
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def RunInstancePara(self):
        r"""CVM创建透传参数，json化字符串格式，如需要保证扩展集群节点请求幂等性需要在此参数添加ClientToken字段，详见[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口。
        :rtype: str
        """
        return self._RunInstancePara

    @RunInstancePara.setter
    def RunInstancePara(self, RunInstancePara):
        self._RunInstancePara = RunInstancePara

    @property
    def CvmRegion(self):
        r"""CVM所属Region
        :rtype: str
        """
        return self._CvmRegion

    @CvmRegion.setter
    def CvmRegion(self, CvmRegion):
        self._CvmRegion = CvmRegion

    @property
    def CvmCount(self):
        r"""CVM数量
        :rtype: int
        """
        return self._CvmCount

    @CvmCount.setter
    def CvmCount(self, CvmCount):
        self._CvmCount = CvmCount

    @property
    def External(self):
        r"""实例扩展信息
        :rtype: str
        """
        return self._External

    @External.setter
    def External(self, External):
        self._External = External

    @property
    def UserScript(self):
        r"""用户自定义脚本
        :rtype: str
        """
        return self._UserScript

    @UserScript.setter
    def UserScript(self, UserScript):
        self._UserScript = UserScript

    @property
    def EnableEni(self):
        r"""是否开启弹性网卡功能
        :rtype: bool
        """
        return self._EnableEni

    @EnableEni.setter
    def EnableEni(self, EnableEni):
        self._EnableEni = EnableEni


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._RunInstancePara = params.get("RunInstancePara")
        self._CvmRegion = params.get("CvmRegion")
        self._CvmCount = params.get("CvmCount")
        self._External = params.get("External")
        self._UserScript = params.get("UserScript")
        self._EnableEni = params.get("EnableEni")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEdgeCVMInstancesResponse(AbstractModel):
    r"""CreateEdgeCVMInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CvmIdSet: cvm id 列表
        :type CvmIdSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CvmIdSet = None
        self._RequestId = None

    @property
    def CvmIdSet(self):
        r"""cvm id 列表
        :rtype: list of str
        """
        return self._CvmIdSet

    @CvmIdSet.setter
    def CvmIdSet(self, CvmIdSet):
        self._CvmIdSet = CvmIdSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CvmIdSet = params.get("CvmIdSet")
        self._RequestId = params.get("RequestId")


class CreateEdgeLogConfigRequest(AbstractModel):
    r"""CreateEdgeLogConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _LogConfig: 日志采集配置的json表达
        :type LogConfig: str
        :param _LogsetId: CLS日志集ID
        :type LogsetId: str
        """
        self._ClusterId = None
        self._LogConfig = None
        self._LogsetId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def LogConfig(self):
        r"""日志采集配置的json表达
        :rtype: str
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def LogsetId(self):
        r"""CLS日志集ID
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._LogConfig = params.get("LogConfig")
        self._LogsetId = params.get("LogsetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEdgeLogConfigResponse(AbstractModel):
    r"""CreateEdgeLogConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateEksLogConfigRequest(AbstractModel):
    r"""CreateEksLogConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _LogConfig: 日志采集配置的json表达
        :type LogConfig: str
        :param _LogsetId: 日志集ID
        :type LogsetId: str
        """
        self._ClusterId = None
        self._LogConfig = None
        self._LogsetId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def LogConfig(self):
        r"""日志采集配置的json表达
        :rtype: str
        """
        return self._LogConfig

    @LogConfig.setter
    def LogConfig(self, LogConfig):
        self._LogConfig = LogConfig

    @property
    def LogsetId(self):
        r"""日志集ID
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._LogConfig = params.get("LogConfig")
        self._LogsetId = params.get("LogsetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEksLogConfigResponse(AbstractModel):
    r"""CreateEksLogConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TopicId: 日志采集topicid
        :type TopicId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TopicId = None
        self._RequestId = None

    @property
    def TopicId(self):
        r"""日志采集topicid
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TopicId = params.get("TopicId")
        self._RequestId = params.get("RequestId")


class CreateImageCacheRequest(AbstractModel):
    r"""CreateImageCache请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Images: 用于制作镜像缓存的容器镜像列表
        :type Images: list of str
        :param _SubnetId: 实例所属子网 ID
        :type SubnetId: str
        :param _VpcId: 实例所属 VPC ID
        :type VpcId: str
        :param _ImageCacheName: 镜像缓存名称
        :type ImageCacheName: str
        :param _SecurityGroupIds: 安全组 ID
        :type SecurityGroupIds: list of str
        :param _ImageRegistryCredentials: 镜像仓库凭证数组
        :type ImageRegistryCredentials: list of ImageRegistryCredential
        :param _ExistedEipId: 用来绑定容器实例的已有EIP
        :type ExistedEipId: str
        :param _AutoCreateEip: 是否为容器实例自动创建EIP，默认为false。若传true，则此参数和ExistedEipIds互斥
        :type AutoCreateEip: bool
        :param _AutoCreateEipAttribute: 自动创建EIP的可选参数。若传此参数，则会自动创建EIP。
另外此参数和ExistedEipIds互斥
        :type AutoCreateEipAttribute: :class:`tencentcloud.tke.v20180525.models.EipAttribute`
        :param _ImageCacheSize: 镜像缓存的大小。默认为20 GiB。取值范围参考[云硬盘类型](https://cloud.tencent.com/document/product/362/2353)中的高性能云盘类型的大小限制。
        :type ImageCacheSize: int
        :param _RetentionDays: 镜像缓存保留时间天数，过期将会自动清理，默认为0，永不过期。
        :type RetentionDays: int
        :param _RegistrySkipVerifyList: 指定拉取镜像仓库的镜像时不校验证书。如["harbor.example.com"]。
        :type RegistrySkipVerifyList: list of str
        :param _RegistryHttpEndPointList: 指定拉取镜像仓库的镜像时使用 HTTP 协议。如["harbor.example.com"]。
        :type RegistryHttpEndPointList: list of str
        :param _ResolveConfig: 自定义制作镜像缓存过程中容器实例的宿主机上的 DNS。如：
"nameserver 4.4.4.4\nnameserver 8.8.8.8"
        :type ResolveConfig: str
        :param _Tags: 腾讯云标签
        :type Tags: list of Tag
        """
        self._Images = None
        self._SubnetId = None
        self._VpcId = None
        self._ImageCacheName = None
        self._SecurityGroupIds = None
        self._ImageRegistryCredentials = None
        self._ExistedEipId = None
        self._AutoCreateEip = None
        self._AutoCreateEipAttribute = None
        self._ImageCacheSize = None
        self._RetentionDays = None
        self._RegistrySkipVerifyList = None
        self._RegistryHttpEndPointList = None
        self._ResolveConfig = None
        self._Tags = None

    @property
    def Images(self):
        r"""用于制作镜像缓存的容器镜像列表
        :rtype: list of str
        """
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def SubnetId(self):
        r"""实例所属子网 ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def VpcId(self):
        r"""实例所属 VPC ID
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ImageCacheName(self):
        r"""镜像缓存名称
        :rtype: str
        """
        return self._ImageCacheName

    @ImageCacheName.setter
    def ImageCacheName(self, ImageCacheName):
        self._ImageCacheName = ImageCacheName

    @property
    def SecurityGroupIds(self):
        r"""安全组 ID
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def ImageRegistryCredentials(self):
        r"""镜像仓库凭证数组
        :rtype: list of ImageRegistryCredential
        """
        return self._ImageRegistryCredentials

    @ImageRegistryCredentials.setter
    def ImageRegistryCredentials(self, ImageRegistryCredentials):
        self._ImageRegistryCredentials = ImageRegistryCredentials

    @property
    def ExistedEipId(self):
        r"""用来绑定容器实例的已有EIP
        :rtype: str
        """
        return self._ExistedEipId

    @ExistedEipId.setter
    def ExistedEipId(self, ExistedEipId):
        self._ExistedEipId = ExistedEipId

    @property
    def AutoCreateEip(self):
        r"""是否为容器实例自动创建EIP，默认为false。若传true，则此参数和ExistedEipIds互斥
        :rtype: bool
        """
        return self._AutoCreateEip

    @AutoCreateEip.setter
    def AutoCreateEip(self, AutoCreateEip):
        self._AutoCreateEip = AutoCreateEip

    @property
    def AutoCreateEipAttribute(self):
        r"""自动创建EIP的可选参数。若传此参数，则会自动创建EIP。
另外此参数和ExistedEipIds互斥
        :rtype: :class:`tencentcloud.tke.v20180525.models.EipAttribute`
        """
        return self._AutoCreateEipAttribute

    @AutoCreateEipAttribute.setter
    def AutoCreateEipAttribute(self, AutoCreateEipAttribute):
        self._AutoCreateEipAttribute = AutoCreateEipAttribute

    @property
    def ImageCacheSize(self):
        r"""镜像缓存的大小。默认为20 GiB。取值范围参考[云硬盘类型](https://cloud.tencent.com/document/product/362/2353)中的高性能云盘类型的大小限制。
        :rtype: int
        """
        return self._ImageCacheSize

    @ImageCacheSize.setter
    def ImageCacheSize(self, ImageCacheSize):
        self._ImageCacheSize = ImageCacheSize

    @property
    def RetentionDays(self):
        r"""镜像缓存保留时间天数，过期将会自动清理，默认为0，永不过期。
        :rtype: int
        """
        return self._RetentionDays

    @RetentionDays.setter
    def RetentionDays(self, RetentionDays):
        self._RetentionDays = RetentionDays

    @property
    def RegistrySkipVerifyList(self):
        r"""指定拉取镜像仓库的镜像时不校验证书。如["harbor.example.com"]。
        :rtype: list of str
        """
        return self._RegistrySkipVerifyList

    @RegistrySkipVerifyList.setter
    def RegistrySkipVerifyList(self, RegistrySkipVerifyList):
        self._RegistrySkipVerifyList = RegistrySkipVerifyList

    @property
    def RegistryHttpEndPointList(self):
        r"""指定拉取镜像仓库的镜像时使用 HTTP 协议。如["harbor.example.com"]。
        :rtype: list of str
        """
        return self._RegistryHttpEndPointList

    @RegistryHttpEndPointList.setter
    def RegistryHttpEndPointList(self, RegistryHttpEndPointList):
        self._RegistryHttpEndPointList = RegistryHttpEndPointList

    @property
    def ResolveConfig(self):
        r"""自定义制作镜像缓存过程中容器实例的宿主机上的 DNS。如：
"nameserver 4.4.4.4\nnameserver 8.8.8.8"
        :rtype: str
        """
        return self._ResolveConfig

    @ResolveConfig.setter
    def ResolveConfig(self, ResolveConfig):
        self._ResolveConfig = ResolveConfig

    @property
    def Tags(self):
        r"""腾讯云标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Images = params.get("Images")
        self._SubnetId = params.get("SubnetId")
        self._VpcId = params.get("VpcId")
        self._ImageCacheName = params.get("ImageCacheName")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("ImageRegistryCredentials") is not None:
            self._ImageRegistryCredentials = []
            for item in params.get("ImageRegistryCredentials"):
                obj = ImageRegistryCredential()
                obj._deserialize(item)
                self._ImageRegistryCredentials.append(obj)
        self._ExistedEipId = params.get("ExistedEipId")
        self._AutoCreateEip = params.get("AutoCreateEip")
        if params.get("AutoCreateEipAttribute") is not None:
            self._AutoCreateEipAttribute = EipAttribute()
            self._AutoCreateEipAttribute._deserialize(params.get("AutoCreateEipAttribute"))
        self._ImageCacheSize = params.get("ImageCacheSize")
        self._RetentionDays = params.get("RetentionDays")
        self._RegistrySkipVerifyList = params.get("RegistrySkipVerifyList")
        self._RegistryHttpEndPointList = params.get("RegistryHttpEndPointList")
        self._ResolveConfig = params.get("ResolveConfig")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageCacheResponse(AbstractModel):
    r"""CreateImageCache返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageCacheId: 镜像缓存Id
        :type ImageCacheId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ImageCacheId = None
        self._RequestId = None

    @property
    def ImageCacheId(self):
        r"""镜像缓存Id
        :rtype: str
        """
        return self._ImageCacheId

    @ImageCacheId.setter
    def ImageCacheId(self, ImageCacheId):
        self._ImageCacheId = ImageCacheId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageCacheId = params.get("ImageCacheId")
        self._RequestId = params.get("RequestId")


class CreatePrometheusAlertPolicyRequest(AbstractModel):
    r"""CreatePrometheusAlertPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _AlertRule: 告警配置
        :type AlertRule: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertPolicyItem`
        """
        self._InstanceId = None
        self._AlertRule = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AlertRule(self):
        r"""告警配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertPolicyItem`
        """
        return self._AlertRule

    @AlertRule.setter
    def AlertRule(self, AlertRule):
        self._AlertRule = AlertRule


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("AlertRule") is not None:
            self._AlertRule = PrometheusAlertPolicyItem()
            self._AlertRule._deserialize(params.get("AlertRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusAlertPolicyResponse(AbstractModel):
    r"""CreatePrometheusAlertPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 告警id
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        r"""告警id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreatePrometheusAlertRuleRequest(AbstractModel):
    r"""CreatePrometheusAlertRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _AlertRule: 告警配置
        :type AlertRule: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertRuleDetail`
        """
        self._InstanceId = None
        self._AlertRule = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AlertRule(self):
        r"""告警配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertRuleDetail`
        """
        return self._AlertRule

    @AlertRule.setter
    def AlertRule(self, AlertRule):
        self._AlertRule = AlertRule


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("AlertRule") is not None:
            self._AlertRule = PrometheusAlertRuleDetail()
            self._AlertRule._deserialize(params.get("AlertRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusAlertRuleResponse(AbstractModel):
    r"""CreatePrometheusAlertRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 告警id
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        r"""告警id
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreatePrometheusClusterAgentRequest(AbstractModel):
    r"""CreatePrometheusClusterAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Agents: agent列表
        :type Agents: list of PrometheusClusterAgentBasic
        """
        self._InstanceId = None
        self._Agents = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Agents(self):
        r"""agent列表
        :rtype: list of PrometheusClusterAgentBasic
        """
        return self._Agents

    @Agents.setter
    def Agents(self, Agents):
        self._Agents = Agents


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Agents") is not None:
            self._Agents = []
            for item in params.get("Agents"):
                obj = PrometheusClusterAgentBasic()
                obj._deserialize(item)
                self._Agents.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusClusterAgentResponse(AbstractModel):
    r"""CreatePrometheusClusterAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePrometheusConfigRequest(AbstractModel):
    r"""CreatePrometheusConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ServiceMonitors: ServiceMonitors配置
        :type ServiceMonitors: list of PrometheusConfigItem
        :param _PodMonitors: PodMonitors配置
        :type PodMonitors: list of PrometheusConfigItem
        :param _RawJobs: prometheus原生Job配置
        :type RawJobs: list of PrometheusConfigItem
        :param _Probes: Probe 配置
        :type Probes: list of PrometheusConfigItem
        """
        self._InstanceId = None
        self._ClusterType = None
        self._ClusterId = None
        self._ServiceMonitors = None
        self._PodMonitors = None
        self._RawJobs = None
        self._Probes = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ServiceMonitors(self):
        r"""ServiceMonitors配置
        :rtype: list of PrometheusConfigItem
        """
        return self._ServiceMonitors

    @ServiceMonitors.setter
    def ServiceMonitors(self, ServiceMonitors):
        self._ServiceMonitors = ServiceMonitors

    @property
    def PodMonitors(self):
        r"""PodMonitors配置
        :rtype: list of PrometheusConfigItem
        """
        return self._PodMonitors

    @PodMonitors.setter
    def PodMonitors(self, PodMonitors):
        self._PodMonitors = PodMonitors

    @property
    def RawJobs(self):
        r"""prometheus原生Job配置
        :rtype: list of PrometheusConfigItem
        """
        return self._RawJobs

    @RawJobs.setter
    def RawJobs(self, RawJobs):
        self._RawJobs = RawJobs

    @property
    def Probes(self):
        r"""Probe 配置
        :rtype: list of PrometheusConfigItem
        """
        return self._Probes

    @Probes.setter
    def Probes(self, Probes):
        self._Probes = Probes


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterType = params.get("ClusterType")
        self._ClusterId = params.get("ClusterId")
        if params.get("ServiceMonitors") is not None:
            self._ServiceMonitors = []
            for item in params.get("ServiceMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._ServiceMonitors.append(obj)
        if params.get("PodMonitors") is not None:
            self._PodMonitors = []
            for item in params.get("PodMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._PodMonitors.append(obj)
        if params.get("RawJobs") is not None:
            self._RawJobs = []
            for item in params.get("RawJobs"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._RawJobs.append(obj)
        if params.get("Probes") is not None:
            self._Probes = []
            for item in params.get("Probes"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._Probes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusConfigResponse(AbstractModel):
    r"""CreatePrometheusConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePrometheusDashboardRequest(AbstractModel):
    r"""CreatePrometheusDashboard请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _DashboardName: 面板组名称
        :type DashboardName: str
        :param _Contents: 面板列表
每一项是一个grafana dashboard的json定义
        :type Contents: list of str
        """
        self._InstanceId = None
        self._DashboardName = None
        self._Contents = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DashboardName(self):
        r"""面板组名称
        :rtype: str
        """
        return self._DashboardName

    @DashboardName.setter
    def DashboardName(self, DashboardName):
        self._DashboardName = DashboardName

    @property
    def Contents(self):
        r"""面板列表
每一项是一个grafana dashboard的json定义
        :rtype: list of str
        """
        return self._Contents

    @Contents.setter
    def Contents(self, Contents):
        self._Contents = Contents


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DashboardName = params.get("DashboardName")
        self._Contents = params.get("Contents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusDashboardResponse(AbstractModel):
    r"""CreatePrometheusDashboard返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePrometheusGlobalNotificationRequest(AbstractModel):
    r"""CreatePrometheusGlobalNotification请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Notification: 告警通知渠道
        :type Notification: :class:`tencentcloud.tke.v20180525.models.PrometheusNotificationItem`
        """
        self._InstanceId = None
        self._Notification = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Notification(self):
        r"""告警通知渠道
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusNotificationItem`
        """
        return self._Notification

    @Notification.setter
    def Notification(self, Notification):
        self._Notification = Notification


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Notification") is not None:
            self._Notification = PrometheusNotificationItem()
            self._Notification._deserialize(params.get("Notification"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusGlobalNotificationResponse(AbstractModel):
    r"""CreatePrometheusGlobalNotification返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Id: 全局告警通知渠道ID
注意：此字段可能返回 null，表示取不到有效值。
        :type Id: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Id = None
        self._RequestId = None

    @property
    def Id(self):
        r"""全局告警通知渠道ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._RequestId = params.get("RequestId")


class CreatePrometheusRecordRuleYamlRequest(AbstractModel):
    r"""CreatePrometheusRecordRuleYaml请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Content: yaml的内容
        :type Content: str
        """
        self._InstanceId = None
        self._Content = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Content(self):
        r"""yaml的内容
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusRecordRuleYamlResponse(AbstractModel):
    r"""CreatePrometheusRecordRuleYaml返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePrometheusTempRequest(AbstractModel):
    r"""CreatePrometheusTemp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 模板设置
        :type Template: :class:`tencentcloud.tke.v20180525.models.PrometheusTemp`
        """
        self._Template = None

    @property
    def Template(self):
        r"""模板设置
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusTemp`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = PrometheusTemp()
            self._Template._deserialize(params.get("Template"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusTempResponse(AbstractModel):
    r"""CreatePrometheusTemp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id
        :type TemplateId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        r"""模板Id
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreatePrometheusTemplateRequest(AbstractModel):
    r"""CreatePrometheusTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Template: 模板设置
        :type Template: :class:`tencentcloud.tke.v20180525.models.PrometheusTemplate`
        """
        self._Template = None

    @property
    def Template(self):
        r"""模板设置
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusTemplate`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template


    def _deserialize(self, params):
        if params.get("Template") is not None:
            self._Template = PrometheusTemplate()
            self._Template._deserialize(params.get("Template"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePrometheusTemplateResponse(AbstractModel):
    r"""CreatePrometheusTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板Id
        :type TemplateId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TemplateId = None
        self._RequestId = None

    @property
    def TemplateId(self):
        r"""模板Id
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        self._RequestId = params.get("RequestId")


class CreateReservedInstancesRequest(AbstractModel):
    r"""CreateReservedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ReservedInstanceSpec: 预留券实例规格。
        :type ReservedInstanceSpec: :class:`tencentcloud.tke.v20180525.models.ReservedInstanceSpec`
        :param _InstanceCount: 购买实例数量，一次最大购买数量为300。
        :type InstanceCount: int
        :param _InstanceChargePrepaid: 预付费模式，即包年包月相关参数设置。通过该参数可以指定包年包月实例的购买时长、是否设置自动续费等属性。
        :type InstanceChargePrepaid: :class:`tencentcloud.tke.v20180525.models.InstanceChargePrepaid`
        :param _InstanceName: 预留券名称，名称不得超过60个字符。
        :type InstanceName: str
        :param _ClientToken: 用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :type ClientToken: str
        """
        self._ReservedInstanceSpec = None
        self._InstanceCount = None
        self._InstanceChargePrepaid = None
        self._InstanceName = None
        self._ClientToken = None

    @property
    def ReservedInstanceSpec(self):
        r"""预留券实例规格。
        :rtype: :class:`tencentcloud.tke.v20180525.models.ReservedInstanceSpec`
        """
        return self._ReservedInstanceSpec

    @ReservedInstanceSpec.setter
    def ReservedInstanceSpec(self, ReservedInstanceSpec):
        self._ReservedInstanceSpec = ReservedInstanceSpec

    @property
    def InstanceCount(self):
        r"""购买实例数量，一次最大购买数量为300。
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def InstanceChargePrepaid(self):
        r"""预付费模式，即包年包月相关参数设置。通过该参数可以指定包年包月实例的购买时长、是否设置自动续费等属性。
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceChargePrepaid`
        """
        return self._InstanceChargePrepaid

    @InstanceChargePrepaid.setter
    def InstanceChargePrepaid(self, InstanceChargePrepaid):
        self._InstanceChargePrepaid = InstanceChargePrepaid

    @property
    def InstanceName(self):
        r"""预留券名称，名称不得超过60个字符。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def ClientToken(self):
        r"""用于保证请求幂等性的字符串。该字符串由客户生成，需保证不同请求之间唯一，最大值不超过64个ASCII字符。若不指定该参数，则无法保证请求的幂等性。
        :rtype: str
        """
        return self._ClientToken

    @ClientToken.setter
    def ClientToken(self, ClientToken):
        self._ClientToken = ClientToken


    def _deserialize(self, params):
        if params.get("ReservedInstanceSpec") is not None:
            self._ReservedInstanceSpec = ReservedInstanceSpec()
            self._ReservedInstanceSpec._deserialize(params.get("ReservedInstanceSpec"))
        self._InstanceCount = params.get("InstanceCount")
        if params.get("InstanceChargePrepaid") is not None:
            self._InstanceChargePrepaid = InstanceChargePrepaid()
            self._InstanceChargePrepaid._deserialize(params.get("InstanceChargePrepaid"))
        self._InstanceName = params.get("InstanceName")
        self._ClientToken = params.get("ClientToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateReservedInstancesResponse(AbstractModel):
    r"""CreateReservedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReservedInstanceIds: 预留券实例 ID。
        :type ReservedInstanceIds: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReservedInstanceIds = None
        self._RequestId = None

    @property
    def ReservedInstanceIds(self):
        r"""预留券实例 ID。
        :rtype: list of str
        """
        return self._ReservedInstanceIds

    @ReservedInstanceIds.setter
    def ReservedInstanceIds(self, ReservedInstanceIds):
        self._ReservedInstanceIds = ReservedInstanceIds

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ReservedInstanceIds = params.get("ReservedInstanceIds")
        self._RequestId = params.get("RequestId")


class CreateTKEEdgeClusterRequest(AbstractModel):
    r"""CreateTKEEdgeCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _K8SVersion: k8s版本号
        :type K8SVersion: str
        :param _VpcId: vpc 的Id
        :type VpcId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _PodCIDR: 集群pod cidr
        :type PodCIDR: str
        :param _ServiceCIDR: 集群service cidr
        :type ServiceCIDR: str
        :param _ClusterDesc: 集群描述信息
        :type ClusterDesc: str
        :param _ClusterAdvancedSettings: 集群高级设置
        :type ClusterAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.EdgeClusterAdvancedSettings`
        :param _MaxNodePodNum: 节点上最大Pod数量
        :type MaxNodePodNum: int
        :param _PublicLB: 边缘计算集群公网访问LB信息
        :type PublicLB: :class:`tencentcloud.tke.v20180525.models.EdgeClusterPublicLB`
        :param _ClusterLevel: 集群的级别
        :type ClusterLevel: str
        :param _AutoUpgradeClusterLevel: 集群是否支持自动升配
        :type AutoUpgradeClusterLevel: bool
        :param _ChargeType: 集群计费方式
        :type ChargeType: str
        :param _EdgeVersion: 边缘集群版本，此版本区别于k8s版本，是整个集群各组件版本集合
        :type EdgeVersion: str
        :param _RegistryPrefix: 边缘组件镜像仓库前缀
        :type RegistryPrefix: str
        :param _TagSpecification: 集群绑定的云标签
        :type TagSpecification: :class:`tencentcloud.tke.v20180525.models.TagSpecification`
        """
        self._K8SVersion = None
        self._VpcId = None
        self._ClusterName = None
        self._PodCIDR = None
        self._ServiceCIDR = None
        self._ClusterDesc = None
        self._ClusterAdvancedSettings = None
        self._MaxNodePodNum = None
        self._PublicLB = None
        self._ClusterLevel = None
        self._AutoUpgradeClusterLevel = None
        self._ChargeType = None
        self._EdgeVersion = None
        self._RegistryPrefix = None
        self._TagSpecification = None

    @property
    def K8SVersion(self):
        r"""k8s版本号
        :rtype: str
        """
        return self._K8SVersion

    @K8SVersion.setter
    def K8SVersion(self, K8SVersion):
        self._K8SVersion = K8SVersion

    @property
    def VpcId(self):
        r"""vpc 的Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def PodCIDR(self):
        r"""集群pod cidr
        :rtype: str
        """
        return self._PodCIDR

    @PodCIDR.setter
    def PodCIDR(self, PodCIDR):
        self._PodCIDR = PodCIDR

    @property
    def ServiceCIDR(self):
        r"""集群service cidr
        :rtype: str
        """
        return self._ServiceCIDR

    @ServiceCIDR.setter
    def ServiceCIDR(self, ServiceCIDR):
        self._ServiceCIDR = ServiceCIDR

    @property
    def ClusterDesc(self):
        r"""集群描述信息
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def ClusterAdvancedSettings(self):
        r"""集群高级设置
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterAdvancedSettings`
        """
        return self._ClusterAdvancedSettings

    @ClusterAdvancedSettings.setter
    def ClusterAdvancedSettings(self, ClusterAdvancedSettings):
        self._ClusterAdvancedSettings = ClusterAdvancedSettings

    @property
    def MaxNodePodNum(self):
        r"""节点上最大Pod数量
        :rtype: int
        """
        return self._MaxNodePodNum

    @MaxNodePodNum.setter
    def MaxNodePodNum(self, MaxNodePodNum):
        self._MaxNodePodNum = MaxNodePodNum

    @property
    def PublicLB(self):
        r"""边缘计算集群公网访问LB信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterPublicLB`
        """
        return self._PublicLB

    @PublicLB.setter
    def PublicLB(self, PublicLB):
        self._PublicLB = PublicLB

    @property
    def ClusterLevel(self):
        r"""集群的级别
        :rtype: str
        """
        return self._ClusterLevel

    @ClusterLevel.setter
    def ClusterLevel(self, ClusterLevel):
        self._ClusterLevel = ClusterLevel

    @property
    def AutoUpgradeClusterLevel(self):
        r"""集群是否支持自动升配
        :rtype: bool
        """
        return self._AutoUpgradeClusterLevel

    @AutoUpgradeClusterLevel.setter
    def AutoUpgradeClusterLevel(self, AutoUpgradeClusterLevel):
        self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel

    @property
    def ChargeType(self):
        r"""集群计费方式
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def EdgeVersion(self):
        r"""边缘集群版本，此版本区别于k8s版本，是整个集群各组件版本集合
        :rtype: str
        """
        return self._EdgeVersion

    @EdgeVersion.setter
    def EdgeVersion(self, EdgeVersion):
        self._EdgeVersion = EdgeVersion

    @property
    def RegistryPrefix(self):
        r"""边缘组件镜像仓库前缀
        :rtype: str
        """
        return self._RegistryPrefix

    @RegistryPrefix.setter
    def RegistryPrefix(self, RegistryPrefix):
        self._RegistryPrefix = RegistryPrefix

    @property
    def TagSpecification(self):
        r"""集群绑定的云标签
        :rtype: :class:`tencentcloud.tke.v20180525.models.TagSpecification`
        """
        return self._TagSpecification

    @TagSpecification.setter
    def TagSpecification(self, TagSpecification):
        self._TagSpecification = TagSpecification


    def _deserialize(self, params):
        self._K8SVersion = params.get("K8SVersion")
        self._VpcId = params.get("VpcId")
        self._ClusterName = params.get("ClusterName")
        self._PodCIDR = params.get("PodCIDR")
        self._ServiceCIDR = params.get("ServiceCIDR")
        self._ClusterDesc = params.get("ClusterDesc")
        if params.get("ClusterAdvancedSettings") is not None:
            self._ClusterAdvancedSettings = EdgeClusterAdvancedSettings()
            self._ClusterAdvancedSettings._deserialize(params.get("ClusterAdvancedSettings"))
        self._MaxNodePodNum = params.get("MaxNodePodNum")
        if params.get("PublicLB") is not None:
            self._PublicLB = EdgeClusterPublicLB()
            self._PublicLB._deserialize(params.get("PublicLB"))
        self._ClusterLevel = params.get("ClusterLevel")
        self._AutoUpgradeClusterLevel = params.get("AutoUpgradeClusterLevel")
        self._ChargeType = params.get("ChargeType")
        self._EdgeVersion = params.get("EdgeVersion")
        self._RegistryPrefix = params.get("RegistryPrefix")
        if params.get("TagSpecification") is not None:
            self._TagSpecification = TagSpecification()
            self._TagSpecification._deserialize(params.get("TagSpecification"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTKEEdgeClusterResponse(AbstractModel):
    r"""CreateTKEEdgeCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 边缘计算集群Id
        :type ClusterId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterId = None
        self._RequestId = None

    @property
    def ClusterId(self):
        r"""边缘计算集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._RequestId = params.get("RequestId")


class CustomDriver(AbstractModel):
    r"""自定义驱动信息

    """

    def __init__(self):
        r"""
        :param _Address: 自定义GPU驱动地址链接
        :type Address: str
        """
        self._Address = None

    @property
    def Address(self):
        r"""自定义GPU驱动地址链接
        :rtype: str
        """
        return self._Address

    @Address.setter
    def Address(self, Address):
        self._Address = Address


    def _deserialize(self, params):
        self._Address = params.get("Address")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DNSConfig(AbstractModel):
    r"""自定义DNS配置

    """

    def __init__(self):
        r"""
        :param _Nameservers: DNS 服务器IP地址列表
        :type Nameservers: list of str
        :param _Options: 对象选项列表，每个对象由name和value（可选）构成
        :type Options: list of DNSConfigOption
        :param _Searches: DNS搜索域列表
        :type Searches: list of str
        """
        self._Nameservers = None
        self._Options = None
        self._Searches = None

    @property
    def Nameservers(self):
        r"""DNS 服务器IP地址列表
        :rtype: list of str
        """
        return self._Nameservers

    @Nameservers.setter
    def Nameservers(self, Nameservers):
        self._Nameservers = Nameservers

    @property
    def Options(self):
        r"""对象选项列表，每个对象由name和value（可选）构成
        :rtype: list of DNSConfigOption
        """
        return self._Options

    @Options.setter
    def Options(self, Options):
        self._Options = Options

    @property
    def Searches(self):
        r"""DNS搜索域列表
        :rtype: list of str
        """
        return self._Searches

    @Searches.setter
    def Searches(self, Searches):
        self._Searches = Searches


    def _deserialize(self, params):
        self._Nameservers = params.get("Nameservers")
        if params.get("Options") is not None:
            self._Options = []
            for item in params.get("Options"):
                obj = DNSConfigOption()
                obj._deserialize(item)
                self._Options.append(obj)
        self._Searches = params.get("Searches")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DNSConfigOption(AbstractModel):
    r"""DNS配置选项

    """

    def __init__(self):
        r"""
        :param _Name: 配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :type Name: str
        :param _Value: 项值
注意：此字段可能返回 null，表示取不到有效值。
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        r"""配置项名称
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""项值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DataDisk(AbstractModel):
    r"""描述了k8s节点数据盘相关配置与信息。

    """

    def __init__(self):
        r"""
        :param _DiskType: 云盘类型
        :type DiskType: str
        :param _FileSystem: 文件系统(ext3/ext4/xfs)
        :type FileSystem: str
        :param _DiskSize: 云盘大小(G）
        :type DiskSize: int
        :param _AutoFormatAndMount: 是否自动化格式盘并挂载
        :type AutoFormatAndMount: bool
        :param _MountTarget: 挂载目录
        :type MountTarget: str
        :param _DiskPartition: 挂载设备名或分区名，当且仅当添加已有节点时需要
        :type DiskPartition: str
        """
        self._DiskType = None
        self._FileSystem = None
        self._DiskSize = None
        self._AutoFormatAndMount = None
        self._MountTarget = None
        self._DiskPartition = None

    @property
    def DiskType(self):
        r"""云盘类型
        :rtype: str
        """
        return self._DiskType

    @DiskType.setter
    def DiskType(self, DiskType):
        self._DiskType = DiskType

    @property
    def FileSystem(self):
        r"""文件系统(ext3/ext4/xfs)
        :rtype: str
        """
        return self._FileSystem

    @FileSystem.setter
    def FileSystem(self, FileSystem):
        self._FileSystem = FileSystem

    @property
    def DiskSize(self):
        r"""云盘大小(G）
        :rtype: int
        """
        return self._DiskSize

    @DiskSize.setter
    def DiskSize(self, DiskSize):
        self._DiskSize = DiskSize

    @property
    def AutoFormatAndMount(self):
        r"""是否自动化格式盘并挂载
        :rtype: bool
        """
        return self._AutoFormatAndMount

    @AutoFormatAndMount.setter
    def AutoFormatAndMount(self, AutoFormatAndMount):
        self._AutoFormatAndMount = AutoFormatAndMount

    @property
    def MountTarget(self):
        r"""挂载目录
        :rtype: str
        """
        return self._MountTarget

    @MountTarget.setter
    def MountTarget(self, MountTarget):
        self._MountTarget = MountTarget

    @property
    def DiskPartition(self):
        r"""挂载设备名或分区名，当且仅当添加已有节点时需要
        :rtype: str
        """
        return self._DiskPartition

    @DiskPartition.setter
    def DiskPartition(self, DiskPartition):
        self._DiskPartition = DiskPartition


    def _deserialize(self, params):
        self._DiskType = params.get("DiskType")
        self._FileSystem = params.get("FileSystem")
        self._DiskSize = params.get("DiskSize")
        self._AutoFormatAndMount = params.get("AutoFormatAndMount")
        self._MountTarget = params.get("MountTarget")
        self._DiskPartition = params.get("DiskPartition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddonRequest(AbstractModel):
    r"""DeleteAddon请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _AddonName: addon名称
        :type AddonName: str
        """
        self._ClusterId = None
        self._AddonName = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AddonName(self):
        r"""addon名称
        :rtype: str
        """
        return self._AddonName

    @AddonName.setter
    def AddonName(self, AddonName):
        self._AddonName = AddonName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AddonName = params.get("AddonName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAddonResponse(AbstractModel):
    r"""DeleteAddon返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteBackupStorageLocationRequest(AbstractModel):
    r"""DeleteBackupStorageLocation请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Name: 备份仓库名称
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        r"""备份仓库名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteBackupStorageLocationResponse(AbstractModel):
    r"""DeleteBackupStorageLocation返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterAsGroupsRequest(AbstractModel):
    r"""DeleteClusterAsGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过[DescribeClusters](https://cloud.tencent.com/document/api/457/31862)接口获取。
        :type ClusterId: str
        :param _AutoScalingGroupIds: 集群伸缩组ID的列表
        :type AutoScalingGroupIds: list of str
        :param _KeepInstance: 是否保留伸缩组中的节点(默认值： false(不保留))
        :type KeepInstance: bool
        """
        self._ClusterId = None
        self._AutoScalingGroupIds = None
        self._KeepInstance = None

    @property
    def ClusterId(self):
        r"""集群ID，通过[DescribeClusters](https://cloud.tencent.com/document/api/457/31862)接口获取。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AutoScalingGroupIds(self):
        r"""集群伸缩组ID的列表
        :rtype: list of str
        """
        return self._AutoScalingGroupIds

    @AutoScalingGroupIds.setter
    def AutoScalingGroupIds(self, AutoScalingGroupIds):
        self._AutoScalingGroupIds = AutoScalingGroupIds

    @property
    def KeepInstance(self):
        r"""是否保留伸缩组中的节点(默认值： false(不保留))
        :rtype: bool
        """
        return self._KeepInstance

    @KeepInstance.setter
    def KeepInstance(self, KeepInstance):
        self._KeepInstance = KeepInstance


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AutoScalingGroupIds = params.get("AutoScalingGroupIds")
        self._KeepInstance = params.get("KeepInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterAsGroupsResponse(AbstractModel):
    r"""DeleteClusterAsGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterEndpointRequest(AbstractModel):
    r"""DeleteClusterEndpoint请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _IsExtranet: 是否为外网访问（TRUE 外网访问 FALSE 内网访问，默认值： FALSE）
        :type IsExtranet: bool
        """
        self._ClusterId = None
        self._IsExtranet = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def IsExtranet(self):
        r"""是否为外网访问（TRUE 外网访问 FALSE 内网访问，默认值： FALSE）
        :rtype: bool
        """
        return self._IsExtranet

    @IsExtranet.setter
    def IsExtranet(self, IsExtranet):
        self._IsExtranet = IsExtranet


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._IsExtranet = params.get("IsExtranet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterEndpointResponse(AbstractModel):
    r"""DeleteClusterEndpoint返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterEndpointVipRequest(AbstractModel):
    r"""DeleteClusterEndpointVip请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterEndpointVipResponse(AbstractModel):
    r"""DeleteClusterEndpointVip返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterInstancesRequest(AbstractModel):
    r"""DeleteClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceIds: 主机InstanceId列表
        :type InstanceIds: list of str
        :param _InstanceDeleteMode: 集群实例删除时的策略：terminate（销毁实例，仅支持按量计费云主机实例） retain （仅移除，保留实例）
        :type InstanceDeleteMode: str
        :param _ForceDelete: 是否强制删除(当节点在初始化时，可以指定参数为TRUE)
        :type ForceDelete: bool
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._InstanceDeleteMode = None
        self._ForceDelete = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""主机InstanceId列表
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def InstanceDeleteMode(self):
        r"""集群实例删除时的策略：terminate（销毁实例，仅支持按量计费云主机实例） retain （仅移除，保留实例）
        :rtype: str
        """
        return self._InstanceDeleteMode

    @InstanceDeleteMode.setter
    def InstanceDeleteMode(self, InstanceDeleteMode):
        self._InstanceDeleteMode = InstanceDeleteMode

    @property
    def ForceDelete(self):
        r"""是否强制删除(当节点在初始化时，可以指定参数为TRUE)
        :rtype: bool
        """
        return self._ForceDelete

    @ForceDelete.setter
    def ForceDelete(self, ForceDelete):
        self._ForceDelete = ForceDelete


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        self._InstanceDeleteMode = params.get("InstanceDeleteMode")
        self._ForceDelete = params.get("ForceDelete")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterInstancesResponse(AbstractModel):
    r"""DeleteClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SuccInstanceIds: 删除成功的实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :type SuccInstanceIds: list of str
        :param _FailedInstanceIds: 删除失败的实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :type FailedInstanceIds: list of str
        :param _NotFoundInstanceIds: 未匹配到的实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :type NotFoundInstanceIds: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SuccInstanceIds = None
        self._FailedInstanceIds = None
        self._NotFoundInstanceIds = None
        self._RequestId = None

    @property
    def SuccInstanceIds(self):
        r"""删除成功的实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SuccInstanceIds

    @SuccInstanceIds.setter
    def SuccInstanceIds(self, SuccInstanceIds):
        self._SuccInstanceIds = SuccInstanceIds

    @property
    def FailedInstanceIds(self):
        r"""删除失败的实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._FailedInstanceIds

    @FailedInstanceIds.setter
    def FailedInstanceIds(self, FailedInstanceIds):
        self._FailedInstanceIds = FailedInstanceIds

    @property
    def NotFoundInstanceIds(self):
        r"""未匹配到的实例ID列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._NotFoundInstanceIds

    @NotFoundInstanceIds.setter
    def NotFoundInstanceIds(self, NotFoundInstanceIds):
        self._NotFoundInstanceIds = NotFoundInstanceIds

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SuccInstanceIds = params.get("SuccInstanceIds")
        self._FailedInstanceIds = params.get("FailedInstanceIds")
        self._NotFoundInstanceIds = params.get("NotFoundInstanceIds")
        self._RequestId = params.get("RequestId")


class DeleteClusterNodePoolRequest(AbstractModel):
    r"""DeleteClusterNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 节点池对应的 ClusterId
        :type ClusterId: str
        :param _NodePoolIds: 需要删除的节点池 Id 列表
        :type NodePoolIds: list of str
        :param _KeepInstance: 删除节点池时是否保留节点池内节点(节点仍然会被移出集群，但对应的实例不会被销毁)
        :type KeepInstance: bool
        """
        self._ClusterId = None
        self._NodePoolIds = None
        self._KeepInstance = None

    @property
    def ClusterId(self):
        r"""节点池对应的 ClusterId
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolIds(self):
        r"""需要删除的节点池 Id 列表
        :rtype: list of str
        """
        return self._NodePoolIds

    @NodePoolIds.setter
    def NodePoolIds(self, NodePoolIds):
        self._NodePoolIds = NodePoolIds

    @property
    def KeepInstance(self):
        r"""删除节点池时是否保留节点池内节点(节点仍然会被移出集群，但对应的实例不会被销毁)
        :rtype: bool
        """
        return self._KeepInstance

    @KeepInstance.setter
    def KeepInstance(self, KeepInstance):
        self._KeepInstance = KeepInstance


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolIds = params.get("NodePoolIds")
        self._KeepInstance = params.get("KeepInstance")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterNodePoolResponse(AbstractModel):
    r"""DeleteClusterNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterRequest(AbstractModel):
    r"""DeleteCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceDeleteMode: 集群实例删除时的策略：terminate（销毁实例，仅支持按量计费云主机实例） retain （仅移除，保留实例）
        :type InstanceDeleteMode: str
        :param _ResourceDeleteOptions: 集群删除时资源的删除策略，目前支持CBS（默认保留CBS）
        :type ResourceDeleteOptions: list of ResourceDeleteOption
        """
        self._ClusterId = None
        self._InstanceDeleteMode = None
        self._ResourceDeleteOptions = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceDeleteMode(self):
        r"""集群实例删除时的策略：terminate（销毁实例，仅支持按量计费云主机实例） retain （仅移除，保留实例）
        :rtype: str
        """
        return self._InstanceDeleteMode

    @InstanceDeleteMode.setter
    def InstanceDeleteMode(self, InstanceDeleteMode):
        self._InstanceDeleteMode = InstanceDeleteMode

    @property
    def ResourceDeleteOptions(self):
        r"""集群删除时资源的删除策略，目前支持CBS（默认保留CBS）
        :rtype: list of ResourceDeleteOption
        """
        return self._ResourceDeleteOptions

    @ResourceDeleteOptions.setter
    def ResourceDeleteOptions(self, ResourceDeleteOptions):
        self._ResourceDeleteOptions = ResourceDeleteOptions


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceDeleteMode = params.get("InstanceDeleteMode")
        if params.get("ResourceDeleteOptions") is not None:
            self._ResourceDeleteOptions = []
            for item in params.get("ResourceDeleteOptions"):
                obj = ResourceDeleteOption()
                obj._deserialize(item)
                self._ResourceDeleteOptions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterResponse(AbstractModel):
    r"""DeleteCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterRouteRequest(AbstractModel):
    r"""DeleteClusterRoute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableName: 路由表名称。
        :type RouteTableName: str
        :param _GatewayIp: 下一跳地址。
        :type GatewayIp: str
        :param _DestinationCidrBlock: 目的端CIDR。
        :type DestinationCidrBlock: str
        """
        self._RouteTableName = None
        self._GatewayIp = None
        self._DestinationCidrBlock = None

    @property
    def RouteTableName(self):
        r"""路由表名称。
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def GatewayIp(self):
        r"""下一跳地址。
        :rtype: str
        """
        return self._GatewayIp

    @GatewayIp.setter
    def GatewayIp(self, GatewayIp):
        self._GatewayIp = GatewayIp

    @property
    def DestinationCidrBlock(self):
        r"""目的端CIDR。
        :rtype: str
        """
        return self._DestinationCidrBlock

    @DestinationCidrBlock.setter
    def DestinationCidrBlock(self, DestinationCidrBlock):
        self._DestinationCidrBlock = DestinationCidrBlock


    def _deserialize(self, params):
        self._RouteTableName = params.get("RouteTableName")
        self._GatewayIp = params.get("GatewayIp")
        self._DestinationCidrBlock = params.get("DestinationCidrBlock")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterRouteResponse(AbstractModel):
    r"""DeleteClusterRoute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterRouteTableRequest(AbstractModel):
    r"""DeleteClusterRouteTable请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableName: 路由表名称
        :type RouteTableName: str
        """
        self._RouteTableName = None

    @property
    def RouteTableName(self):
        r"""路由表名称
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName


    def _deserialize(self, params):
        self._RouteTableName = params.get("RouteTableName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterRouteTableResponse(AbstractModel):
    r"""DeleteClusterRouteTable返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterVirtualNodePoolRequest(AbstractModel):
    r"""DeleteClusterVirtualNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _NodePoolIds: 节点池ID，通过DescribeNodePools接口获取
        :type NodePoolIds: list of str
        :param _Force: 是否强制删除，在超级节点上有pod的情况下，如果选择非强制删除，则删除会失败
        :type Force: bool
        """
        self._ClusterId = None
        self._NodePoolIds = None
        self._Force = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolIds(self):
        r"""节点池ID，通过DescribeNodePools接口获取
        :rtype: list of str
        """
        return self._NodePoolIds

    @NodePoolIds.setter
    def NodePoolIds(self, NodePoolIds):
        self._NodePoolIds = NodePoolIds

    @property
    def Force(self):
        r"""是否强制删除，在超级节点上有pod的情况下，如果选择非强制删除，则删除会失败
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolIds = params.get("NodePoolIds")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterVirtualNodePoolResponse(AbstractModel):
    r"""DeleteClusterVirtualNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClusterVirtualNodeRequest(AbstractModel):
    r"""DeleteClusterVirtualNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _NodeNames: 虚拟节点ID列表
        :type NodeNames: list of str
        :param _Force: 是否强制删除：如果虚拟节点上有运行中Pod，则非强制删除状态下不会进行删除
        :type Force: bool
        """
        self._ClusterId = None
        self._NodeNames = None
        self._Force = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodeNames(self):
        r"""虚拟节点ID列表
        :rtype: list of str
        """
        return self._NodeNames

    @NodeNames.setter
    def NodeNames(self, NodeNames):
        self._NodeNames = NodeNames

    @property
    def Force(self):
        r"""是否强制删除：如果虚拟节点上有运行中Pod，则非强制删除状态下不会进行删除
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodeNames = params.get("NodeNames")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClusterVirtualNodeResponse(AbstractModel):
    r"""DeleteClusterVirtualNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteECMInstancesRequest(AbstractModel):
    r"""DeleteECMInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _EcmIdSet: ecm id集合
        :type EcmIdSet: list of str
        """
        self._ClusterID = None
        self._EcmIdSet = None

    @property
    def ClusterID(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def EcmIdSet(self):
        r"""ecm id集合
        :rtype: list of str
        """
        return self._EcmIdSet

    @EcmIdSet.setter
    def EcmIdSet(self, EcmIdSet):
        self._EcmIdSet = EcmIdSet


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._EcmIdSet = params.get("EcmIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteECMInstancesResponse(AbstractModel):
    r"""DeleteECMInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEKSClusterRequest(AbstractModel):
    r"""DeleteEKSCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 弹性集群Id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""弹性集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEKSClusterResponse(AbstractModel):
    r"""DeleteEKSCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEKSContainerInstancesRequest(AbstractModel):
    r"""DeleteEKSContainerInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EksCiIds: 需要删除的EksCi的Id。 最大数量不超过20
        :type EksCiIds: list of str
        :param _ReleaseAutoCreatedEip: 是否释放为EksCi自动创建的Eip
        :type ReleaseAutoCreatedEip: bool
        """
        self._EksCiIds = None
        self._ReleaseAutoCreatedEip = None

    @property
    def EksCiIds(self):
        r"""需要删除的EksCi的Id。 最大数量不超过20
        :rtype: list of str
        """
        return self._EksCiIds

    @EksCiIds.setter
    def EksCiIds(self, EksCiIds):
        self._EksCiIds = EksCiIds

    @property
    def ReleaseAutoCreatedEip(self):
        r"""是否释放为EksCi自动创建的Eip
        :rtype: bool
        """
        return self._ReleaseAutoCreatedEip

    @ReleaseAutoCreatedEip.setter
    def ReleaseAutoCreatedEip(self, ReleaseAutoCreatedEip):
        self._ReleaseAutoCreatedEip = ReleaseAutoCreatedEip


    def _deserialize(self, params):
        self._EksCiIds = params.get("EksCiIds")
        self._ReleaseAutoCreatedEip = params.get("ReleaseAutoCreatedEip")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEKSContainerInstancesResponse(AbstractModel):
    r"""DeleteEKSContainerInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEdgeCVMInstancesRequest(AbstractModel):
    r"""DeleteEdgeCVMInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _CvmIdSet: cvm id集合
        :type CvmIdSet: list of str
        """
        self._ClusterID = None
        self._CvmIdSet = None

    @property
    def ClusterID(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def CvmIdSet(self):
        r"""cvm id集合
        :rtype: list of str
        """
        return self._CvmIdSet

    @CvmIdSet.setter
    def CvmIdSet(self, CvmIdSet):
        self._CvmIdSet = CvmIdSet


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._CvmIdSet = params.get("CvmIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEdgeCVMInstancesResponse(AbstractModel):
    r"""DeleteEdgeCVMInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEdgeClusterInstancesRequest(AbstractModel):
    r"""DeleteEdgeClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _InstanceIds: 待删除实例ID数组
        :type InstanceIds: list of str
        """
        self._ClusterId = None
        self._InstanceIds = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""待删除实例ID数组
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEdgeClusterInstancesResponse(AbstractModel):
    r"""DeleteEdgeClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageCachesRequest(AbstractModel):
    r"""DeleteImageCaches请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageCacheIds: 镜像缓存ID数组
        :type ImageCacheIds: list of str
        """
        self._ImageCacheIds = None

    @property
    def ImageCacheIds(self):
        r"""镜像缓存ID数组
        :rtype: list of str
        """
        return self._ImageCacheIds

    @ImageCacheIds.setter
    def ImageCacheIds(self, ImageCacheIds):
        self._ImageCacheIds = ImageCacheIds


    def _deserialize(self, params):
        self._ImageCacheIds = params.get("ImageCacheIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageCachesResponse(AbstractModel):
    r"""DeleteImageCaches返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteLogConfigsRequest(AbstractModel):
    r"""DeleteLogConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _LogConfigNames: 待删除采集规则名称，多个采集规则使用","分隔
        :type LogConfigNames: str
        :param _ClusterType: 集群集群类型, tke/eks 默认为 tke 集群
        :type ClusterType: str
        """
        self._ClusterId = None
        self._LogConfigNames = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def LogConfigNames(self):
        r"""待删除采集规则名称，多个采集规则使用","分隔
        :rtype: str
        """
        return self._LogConfigNames

    @LogConfigNames.setter
    def LogConfigNames(self, LogConfigNames):
        self._LogConfigNames = LogConfigNames

    @property
    def ClusterType(self):
        r"""集群集群类型, tke/eks 默认为 tke 集群
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._LogConfigNames = params.get("LogConfigNames")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteLogConfigsResponse(AbstractModel):
    r"""DeleteLogConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Message: 删除采集规则遇到错误时返回错误原因
        :type Message: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Message = None
        self._RequestId = None

    @property
    def Message(self):
        r"""删除采集规则遇到错误时返回错误原因
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Message = params.get("Message")
        self._RequestId = params.get("RequestId")


class DeletePrometheusAlertPolicyRequest(AbstractModel):
    r"""DeletePrometheusAlertPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _AlertIds: 告警策略id列表
        :type AlertIds: list of str
        :param _Names: 告警策略名称
        :type Names: list of str
        """
        self._InstanceId = None
        self._AlertIds = None
        self._Names = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AlertIds(self):
        r"""告警策略id列表
        :rtype: list of str
        """
        return self._AlertIds

    @AlertIds.setter
    def AlertIds(self, AlertIds):
        self._AlertIds = AlertIds

    @property
    def Names(self):
        r"""告警策略名称
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AlertIds = params.get("AlertIds")
        self._Names = params.get("Names")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusAlertPolicyResponse(AbstractModel):
    r"""DeletePrometheusAlertPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusAlertRuleRequest(AbstractModel):
    r"""DeletePrometheusAlertRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _AlertIds: 告警规则id列表
        :type AlertIds: list of str
        """
        self._InstanceId = None
        self._AlertIds = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AlertIds(self):
        r"""告警规则id列表
        :rtype: list of str
        """
        return self._AlertIds

    @AlertIds.setter
    def AlertIds(self, AlertIds):
        self._AlertIds = AlertIds


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._AlertIds = params.get("AlertIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusAlertRuleResponse(AbstractModel):
    r"""DeletePrometheusAlertRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusClusterAgentRequest(AbstractModel):
    r"""DeletePrometheusClusterAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Agents: agent列表
        :type Agents: list of PrometheusAgentInfo
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Force: 在7天可回收期间，强制解除绑定
        :type Force: bool
        """
        self._Agents = None
        self._InstanceId = None
        self._Force = None

    @property
    def Agents(self):
        r"""agent列表
        :rtype: list of PrometheusAgentInfo
        """
        return self._Agents

    @Agents.setter
    def Agents(self, Agents):
        self._Agents = Agents

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Force(self):
        r"""在7天可回收期间，强制解除绑定
        :rtype: bool
        """
        return self._Force

    @Force.setter
    def Force(self, Force):
        self._Force = Force


    def _deserialize(self, params):
        if params.get("Agents") is not None:
            self._Agents = []
            for item in params.get("Agents"):
                obj = PrometheusAgentInfo()
                obj._deserialize(item)
                self._Agents.append(obj)
        self._InstanceId = params.get("InstanceId")
        self._Force = params.get("Force")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusClusterAgentResponse(AbstractModel):
    r"""DeletePrometheusClusterAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusConfigRequest(AbstractModel):
    r"""DeletePrometheusConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ServiceMonitors: 要删除的ServiceMonitor名字列表
        :type ServiceMonitors: list of str
        :param _PodMonitors: 要删除的PodMonitor名字列表
        :type PodMonitors: list of str
        :param _RawJobs: 要删除的RawJobs名字列表
        :type RawJobs: list of str
        :param _Probes: 要删除的Probe名字列表
        :type Probes: list of str
        """
        self._InstanceId = None
        self._ClusterType = None
        self._ClusterId = None
        self._ServiceMonitors = None
        self._PodMonitors = None
        self._RawJobs = None
        self._Probes = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ServiceMonitors(self):
        r"""要删除的ServiceMonitor名字列表
        :rtype: list of str
        """
        return self._ServiceMonitors

    @ServiceMonitors.setter
    def ServiceMonitors(self, ServiceMonitors):
        self._ServiceMonitors = ServiceMonitors

    @property
    def PodMonitors(self):
        r"""要删除的PodMonitor名字列表
        :rtype: list of str
        """
        return self._PodMonitors

    @PodMonitors.setter
    def PodMonitors(self, PodMonitors):
        self._PodMonitors = PodMonitors

    @property
    def RawJobs(self):
        r"""要删除的RawJobs名字列表
        :rtype: list of str
        """
        return self._RawJobs

    @RawJobs.setter
    def RawJobs(self, RawJobs):
        self._RawJobs = RawJobs

    @property
    def Probes(self):
        r"""要删除的Probe名字列表
        :rtype: list of str
        """
        return self._Probes

    @Probes.setter
    def Probes(self, Probes):
        self._Probes = Probes


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterType = params.get("ClusterType")
        self._ClusterId = params.get("ClusterId")
        self._ServiceMonitors = params.get("ServiceMonitors")
        self._PodMonitors = params.get("PodMonitors")
        self._RawJobs = params.get("RawJobs")
        self._Probes = params.get("Probes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusConfigResponse(AbstractModel):
    r"""DeletePrometheusConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusRecordRuleYamlRequest(AbstractModel):
    r"""DeletePrometheusRecordRuleYaml请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Names: 聚合规则列表
        :type Names: list of str
        """
        self._InstanceId = None
        self._Names = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Names(self):
        r"""聚合规则列表
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Names = params.get("Names")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusRecordRuleYamlResponse(AbstractModel):
    r"""DeletePrometheusRecordRuleYaml返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusTempRequest(AbstractModel):
    r"""DeletePrometheusTemp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id
        :type TemplateId: str
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        r"""模板id
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusTempResponse(AbstractModel):
    r"""DeletePrometheusTemp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusTempSyncRequest(AbstractModel):
    r"""DeletePrometheusTempSync请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id
        :type TemplateId: str
        :param _Targets: 取消同步的对象列表
        :type Targets: list of PrometheusTemplateSyncTarget
        """
        self._TemplateId = None
        self._Targets = None

    @property
    def TemplateId(self):
        r"""模板id
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Targets(self):
        r"""取消同步的对象列表
        :rtype: list of PrometheusTemplateSyncTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = PrometheusTemplateSyncTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusTempSyncResponse(AbstractModel):
    r"""DeletePrometheusTempSync返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusTemplateRequest(AbstractModel):
    r"""DeletePrometheusTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id
        :type TemplateId: str
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        r"""模板id
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusTemplateResponse(AbstractModel):
    r"""DeletePrometheusTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePrometheusTemplateSyncRequest(AbstractModel):
    r"""DeletePrometheusTemplateSync请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板id
        :type TemplateId: str
        :param _Targets: 取消同步的对象列表
        :type Targets: list of PrometheusTemplateSyncTarget
        """
        self._TemplateId = None
        self._Targets = None

    @property
    def TemplateId(self):
        r"""模板id
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Targets(self):
        r"""取消同步的对象列表
        :rtype: list of PrometheusTemplateSyncTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = PrometheusTemplateSyncTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePrometheusTemplateSyncResponse(AbstractModel):
    r"""DeletePrometheusTemplateSync返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReservedInstancesRequest(AbstractModel):
    r"""DeleteReservedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ReservedInstanceIds: 预留券实例ID。可通过 [DescribeReservedInstances](https://cloud.tencent.com/document/product/457/99162) 接口返回值中的ReservedInstanceId获取。
        :type ReservedInstanceIds: list of str
        """
        self._ReservedInstanceIds = None

    @property
    def ReservedInstanceIds(self):
        r"""预留券实例ID。可通过 [DescribeReservedInstances](https://cloud.tencent.com/document/product/457/99162) 接口返回值中的ReservedInstanceId获取。
        :rtype: list of str
        """
        return self._ReservedInstanceIds

    @ReservedInstanceIds.setter
    def ReservedInstanceIds(self, ReservedInstanceIds):
        self._ReservedInstanceIds = ReservedInstanceIds


    def _deserialize(self, params):
        self._ReservedInstanceIds = params.get("ReservedInstanceIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReservedInstancesResponse(AbstractModel):
    r"""DeleteReservedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTKEEdgeClusterRequest(AbstractModel):
    r"""DeleteTKEEdgeCluster请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTKEEdgeClusterResponse(AbstractModel):
    r"""DeleteTKEEdgeCluster返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAddonRequest(AbstractModel):
    r"""DescribeAddon请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _AddonName: addon名称（不传时会返回集群下全部的addon）
        :type AddonName: str
        """
        self._ClusterId = None
        self._AddonName = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AddonName(self):
        r"""addon名称（不传时会返回集群下全部的addon）
        :rtype: str
        """
        return self._AddonName

    @AddonName.setter
    def AddonName(self, AddonName):
        self._AddonName = AddonName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AddonName = params.get("AddonName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddonResponse(AbstractModel):
    r"""DescribeAddon返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Addons: addon列表
        :type Addons: list of Addon
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Addons = None
        self._RequestId = None

    @property
    def Addons(self):
        r"""addon列表
        :rtype: list of Addon
        """
        return self._Addons

    @Addons.setter
    def Addons(self, Addons):
        self._Addons = Addons

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Addons") is not None:
            self._Addons = []
            for item in params.get("Addons"):
                obj = Addon()
                obj._deserialize(item)
                self._Addons.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAddonValuesRequest(AbstractModel):
    r"""DescribeAddonValues请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _AddonName: addon名称
        :type AddonName: str
        """
        self._ClusterId = None
        self._AddonName = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AddonName(self):
        r"""addon名称
        :rtype: str
        """
        return self._AddonName

    @AddonName.setter
    def AddonName(self, AddonName):
        self._AddonName = AddonName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AddonName = params.get("AddonName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAddonValuesResponse(AbstractModel):
    r"""DescribeAddonValues返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Values: 参数列表，如果addon已安装，会使用已设置的参数和chart里的默认参数做渲染，是一个json格式的字符串，未安装addon时返回为空值。
        :type Values: str
        :param _DefaultValues: addon支持的参数列表，值为chart的默认值，是一个json格式的字符串。
        :type DefaultValues: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Values = None
        self._DefaultValues = None
        self._RequestId = None

    @property
    def Values(self):
        r"""参数列表，如果addon已安装，会使用已设置的参数和chart里的默认参数做渲染，是一个json格式的字符串，未安装addon时返回为空值。
        :rtype: str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def DefaultValues(self):
        r"""addon支持的参数列表，值为chart的默认值，是一个json格式的字符串。
        :rtype: str
        """
        return self._DefaultValues

    @DefaultValues.setter
    def DefaultValues(self, DefaultValues):
        self._DefaultValues = DefaultValues

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Values = params.get("Values")
        self._DefaultValues = params.get("DefaultValues")
        self._RequestId = params.get("RequestId")


class DescribeAvailableClusterVersionRequest(AbstractModel):
    r"""DescribeAvailableClusterVersion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群 Id。若只查询某个集群可升级的版本，需填写此项。
        :type ClusterId: str
        :param _ClusterIds: 集群 Id 列表。若查询多个集群可升级的版本，需填写此项。
        :type ClusterIds: list of str
        """
        self._ClusterId = None
        self._ClusterIds = None

    @property
    def ClusterId(self):
        r"""集群 Id。若只查询某个集群可升级的版本，需填写此项。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterIds(self):
        r"""集群 Id 列表。若查询多个集群可升级的版本，需填写此项。
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterIds = params.get("ClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAvailableClusterVersionResponse(AbstractModel):
    r"""DescribeAvailableClusterVersion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Versions: 可升级的集群版本号
注意：此字段可能返回 null，表示取不到有效值。
        :type Versions: list of str
        :param _Clusters: 集群信息
        :type Clusters: list of ClusterVersion
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Versions = None
        self._Clusters = None
        self._RequestId = None

    @property
    def Versions(self):
        r"""可升级的集群版本号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Versions

    @Versions.setter
    def Versions(self, Versions):
        self._Versions = Versions

    @property
    def Clusters(self):
        r"""集群信息
        :rtype: list of ClusterVersion
        """
        return self._Clusters

    @Clusters.setter
    def Clusters(self, Clusters):
        self._Clusters = Clusters

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Versions = params.get("Versions")
        if params.get("Clusters") is not None:
            self._Clusters = []
            for item in params.get("Clusters"):
                obj = ClusterVersion()
                obj._deserialize(item)
                self._Clusters.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAvailableTKEEdgeVersionRequest(AbstractModel):
    r"""DescribeAvailableTKEEdgeVersion请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 填写ClusterId获取当前集群各个组件版本和最新版本
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""填写ClusterId获取当前集群各个组件版本和最新版本
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAvailableTKEEdgeVersionResponse(AbstractModel):
    r"""DescribeAvailableTKEEdgeVersion返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Versions: 版本列表
        :type Versions: list of str
        :param _EdgeVersionLatest: 边缘集群最新版本
        :type EdgeVersionLatest: str
        :param _EdgeVersionCurrent: 边缘集群当前版本
        :type EdgeVersionCurrent: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Versions = None
        self._EdgeVersionLatest = None
        self._EdgeVersionCurrent = None
        self._RequestId = None

    @property
    def Versions(self):
        r"""版本列表
        :rtype: list of str
        """
        return self._Versions

    @Versions.setter
    def Versions(self, Versions):
        self._Versions = Versions

    @property
    def EdgeVersionLatest(self):
        r"""边缘集群最新版本
        :rtype: str
        """
        return self._EdgeVersionLatest

    @EdgeVersionLatest.setter
    def EdgeVersionLatest(self, EdgeVersionLatest):
        self._EdgeVersionLatest = EdgeVersionLatest

    @property
    def EdgeVersionCurrent(self):
        r"""边缘集群当前版本
        :rtype: str
        """
        return self._EdgeVersionCurrent

    @EdgeVersionCurrent.setter
    def EdgeVersionCurrent(self, EdgeVersionCurrent):
        self._EdgeVersionCurrent = EdgeVersionCurrent

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Versions = params.get("Versions")
        self._EdgeVersionLatest = params.get("EdgeVersionLatest")
        self._EdgeVersionCurrent = params.get("EdgeVersionCurrent")
        self._RequestId = params.get("RequestId")


class DescribeBackupStorageLocationsRequest(AbstractModel):
    r"""DescribeBackupStorageLocations请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Names: 多个备份仓库名称，如果不填写，默认返回当前地域所有存储仓库名称
        :type Names: list of str
        """
        self._Names = None

    @property
    def Names(self):
        r"""多个备份仓库名称，如果不填写，默认返回当前地域所有存储仓库名称
        :rtype: list of str
        """
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names


    def _deserialize(self, params):
        self._Names = params.get("Names")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBackupStorageLocationsResponse(AbstractModel):
    r"""DescribeBackupStorageLocations返回参数结构体

    """

    def __init__(self):
        r"""
        :param _BackupStorageLocationSet: 详细备份仓库信息
注意：此字段可能返回 null，表示取不到有效值。
        :type BackupStorageLocationSet: list of BackupStorageLocation
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._BackupStorageLocationSet = None
        self._RequestId = None

    @property
    def BackupStorageLocationSet(self):
        r"""详细备份仓库信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of BackupStorageLocation
        """
        return self._BackupStorageLocationSet

    @BackupStorageLocationSet.setter
    def BackupStorageLocationSet(self, BackupStorageLocationSet):
        self._BackupStorageLocationSet = BackupStorageLocationSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("BackupStorageLocationSet") is not None:
            self._BackupStorageLocationSet = []
            for item in params.get("BackupStorageLocationSet"):
                obj = BackupStorageLocation()
                obj._deserialize(item)
                self._BackupStorageLocationSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeBatchModifyTagsStatusRequest(AbstractModel):
    r"""DescribeBatchModifyTagsStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeBatchModifyTagsStatusResponse(AbstractModel):
    r"""DescribeBatchModifyTagsStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _FailedResources: 失败资源列表
        :type FailedResources: list of FailedResource
        :param _Status: 任务状态：
- running 运行中
- failed 失败
- done 成功
        :type Status: str
        :param _SyncSubresource: 是否同步集群内子资源标签
        :type SyncSubresource: bool
        :param _Tags: 集群标签
        :type Tags: list of Tag
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._FailedResources = None
        self._Status = None
        self._SyncSubresource = None
        self._Tags = None
        self._RequestId = None

    @property
    def FailedResources(self):
        r"""失败资源列表
        :rtype: list of FailedResource
        """
        return self._FailedResources

    @FailedResources.setter
    def FailedResources(self, FailedResources):
        self._FailedResources = FailedResources

    @property
    def Status(self):
        r"""任务状态：
- running 运行中
- failed 失败
- done 成功
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SyncSubresource(self):
        r"""是否同步集群内子资源标签
        :rtype: bool
        """
        return self._SyncSubresource

    @SyncSubresource.setter
    def SyncSubresource(self, SyncSubresource):
        self._SyncSubresource = SyncSubresource

    @property
    def Tags(self):
        r"""集群标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("FailedResources") is not None:
            self._FailedResources = []
            for item in params.get("FailedResources"):
                obj = FailedResource()
                obj._deserialize(item)
                self._FailedResources.append(obj)
        self._Status = params.get("Status")
        self._SyncSubresource = params.get("SyncSubresource")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterAsGroupOptionRequest(AbstractModel):
    r"""DescribeClusterAsGroupOption请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterAsGroupOptionResponse(AbstractModel):
    r"""DescribeClusterAsGroupOption返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterAsGroupOption: 集群弹性伸缩属性
        :type ClusterAsGroupOption: :class:`tencentcloud.tke.v20180525.models.ClusterAsGroupOption`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterAsGroupOption = None
        self._RequestId = None

    @property
    def ClusterAsGroupOption(self):
        r"""集群弹性伸缩属性
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterAsGroupOption`
        """
        return self._ClusterAsGroupOption

    @ClusterAsGroupOption.setter
    def ClusterAsGroupOption(self, ClusterAsGroupOption):
        self._ClusterAsGroupOption = ClusterAsGroupOption

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterAsGroupOption") is not None:
            self._ClusterAsGroupOption = ClusterAsGroupOption()
            self._ClusterAsGroupOption._deserialize(params.get("ClusterAsGroupOption"))
        self._RequestId = params.get("RequestId")


class DescribeClusterAsGroupsRequest(AbstractModel):
    r"""DescribeClusterAsGroups请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _AutoScalingGroupIds: 伸缩组ID列表，如果为空，表示拉取集群关联的所有伸缩组。
        :type AutoScalingGroupIds: list of str
        :param _Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :type Limit: int
        """
        self._ClusterId = None
        self._AutoScalingGroupIds = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AutoScalingGroupIds(self):
        r"""伸缩组ID列表，如果为空，表示拉取集群关联的所有伸缩组。
        :rtype: list of str
        """
        return self._AutoScalingGroupIds

    @AutoScalingGroupIds.setter
    def AutoScalingGroupIds(self, AutoScalingGroupIds):
        self._AutoScalingGroupIds = AutoScalingGroupIds

    @property
    def Offset(self):
        r"""偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AutoScalingGroupIds = params.get("AutoScalingGroupIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterAsGroupsResponse(AbstractModel):
    r"""DescribeClusterAsGroups返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群关联的伸缩组总数
        :type TotalCount: int
        :param _ClusterAsGroupSet: 集群关联的伸缩组列表
        :type ClusterAsGroupSet: list of ClusterAsGroup
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterAsGroupSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""集群关联的伸缩组总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterAsGroupSet(self):
        r"""集群关联的伸缩组列表
        :rtype: list of ClusterAsGroup
        """
        return self._ClusterAsGroupSet

    @ClusterAsGroupSet.setter
    def ClusterAsGroupSet(self, ClusterAsGroupSet):
        self._ClusterAsGroupSet = ClusterAsGroupSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterAsGroupSet") is not None:
            self._ClusterAsGroupSet = []
            for item in params.get("ClusterAsGroupSet"):
                obj = ClusterAsGroup()
                obj._deserialize(item)
                self._ClusterAsGroupSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterAuthenticationOptionsRequest(AbstractModel):
    r"""DescribeClusterAuthenticationOptions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterAuthenticationOptionsResponse(AbstractModel):
    r"""DescribeClusterAuthenticationOptions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ServiceAccounts: ServiceAccount认证配置
        :type ServiceAccounts: :class:`tencentcloud.tke.v20180525.models.ServiceAccountAuthenticationOptions`
        :param _LatestOperationState: 最近一次修改操作结果，返回值可能为：Updating，Success，Failed，TimeOut
        :type LatestOperationState: str
        :param _OIDCConfig: OIDC认证配置
        :type OIDCConfig: :class:`tencentcloud.tke.v20180525.models.OIDCConfigAuthenticationOptions`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ServiceAccounts = None
        self._LatestOperationState = None
        self._OIDCConfig = None
        self._RequestId = None

    @property
    def ServiceAccounts(self):
        r"""ServiceAccount认证配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.ServiceAccountAuthenticationOptions`
        """
        return self._ServiceAccounts

    @ServiceAccounts.setter
    def ServiceAccounts(self, ServiceAccounts):
        self._ServiceAccounts = ServiceAccounts

    @property
    def LatestOperationState(self):
        r"""最近一次修改操作结果，返回值可能为：Updating，Success，Failed，TimeOut
        :rtype: str
        """
        return self._LatestOperationState

    @LatestOperationState.setter
    def LatestOperationState(self, LatestOperationState):
        self._LatestOperationState = LatestOperationState

    @property
    def OIDCConfig(self):
        r"""OIDC认证配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.OIDCConfigAuthenticationOptions`
        """
        return self._OIDCConfig

    @OIDCConfig.setter
    def OIDCConfig(self, OIDCConfig):
        self._OIDCConfig = OIDCConfig

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ServiceAccounts") is not None:
            self._ServiceAccounts = ServiceAccountAuthenticationOptions()
            self._ServiceAccounts._deserialize(params.get("ServiceAccounts"))
        self._LatestOperationState = params.get("LatestOperationState")
        if params.get("OIDCConfig") is not None:
            self._OIDCConfig = OIDCConfigAuthenticationOptions()
            self._OIDCConfig._deserialize(params.get("OIDCConfig"))
        self._RequestId = params.get("RequestId")


class DescribeClusterCommonNamesRequest(AbstractModel):
    r"""DescribeClusterCommonNames请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _SubaccountUins: 子账户列表，不可超出最大值50
        :type SubaccountUins: list of str
        :param _RoleIds: 角色ID列表，不可超出最大值50
        :type RoleIds: list of str
        """
        self._ClusterId = None
        self._SubaccountUins = None
        self._RoleIds = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SubaccountUins(self):
        r"""子账户列表，不可超出最大值50
        :rtype: list of str
        """
        return self._SubaccountUins

    @SubaccountUins.setter
    def SubaccountUins(self, SubaccountUins):
        self._SubaccountUins = SubaccountUins

    @property
    def RoleIds(self):
        r"""角色ID列表，不可超出最大值50
        :rtype: list of str
        """
        return self._RoleIds

    @RoleIds.setter
    def RoleIds(self, RoleIds):
        self._RoleIds = RoleIds


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SubaccountUins = params.get("SubaccountUins")
        self._RoleIds = params.get("RoleIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterCommonNamesResponse(AbstractModel):
    r"""DescribeClusterCommonNames返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CommonNames: 子账户Uin与其客户端证书的CN字段映射
        :type CommonNames: list of CommonName
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CommonNames = None
        self._RequestId = None

    @property
    def CommonNames(self):
        r"""子账户Uin与其客户端证书的CN字段映射
        :rtype: list of CommonName
        """
        return self._CommonNames

    @CommonNames.setter
    def CommonNames(self, CommonNames):
        self._CommonNames = CommonNames

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CommonNames") is not None:
            self._CommonNames = []
            for item in params.get("CommonNames"):
                obj = CommonName()
                obj._deserialize(item)
                self._CommonNames.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterControllersRequest(AbstractModel):
    r"""DescribeClusterControllers请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterControllersResponse(AbstractModel):
    r"""DescribeClusterControllers返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ControllerStatusSet: 描述集群中各个控制器的状态
        :type ControllerStatusSet: list of ControllerStatus
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ControllerStatusSet = None
        self._RequestId = None

    @property
    def ControllerStatusSet(self):
        r"""描述集群中各个控制器的状态
        :rtype: list of ControllerStatus
        """
        return self._ControllerStatusSet

    @ControllerStatusSet.setter
    def ControllerStatusSet(self, ControllerStatusSet):
        self._ControllerStatusSet = ControllerStatusSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ControllerStatusSet") is not None:
            self._ControllerStatusSet = []
            for item in params.get("ControllerStatusSet"):
                obj = ControllerStatus()
                obj._deserialize(item)
                self._ControllerStatusSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterEndpointStatusRequest(AbstractModel):
    r"""DescribeClusterEndpointStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _IsExtranet: 是否为外网访问（TRUE 外网访问 FALSE 内网访问，默认值： FALSE）
        :type IsExtranet: bool
        """
        self._ClusterId = None
        self._IsExtranet = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def IsExtranet(self):
        r"""是否为外网访问（TRUE 外网访问 FALSE 内网访问，默认值： FALSE）
        :rtype: bool
        """
        return self._IsExtranet

    @IsExtranet.setter
    def IsExtranet(self, IsExtranet):
        self._IsExtranet = IsExtranet


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._IsExtranet = params.get("IsExtranet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterEndpointStatusResponse(AbstractModel):
    r"""DescribeClusterEndpointStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 查询集群访问端口状态（Created 开启成功，Creating 开启中，NotFound 未开启）
        :type Status: str
        :param _ErrorMsg: 开启访问入口失败信息
        :type ErrorMsg: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._ErrorMsg = None
        self._RequestId = None

    @property
    def Status(self):
        r"""查询集群访问端口状态（Created 开启成功，Creating 开启中，NotFound 未开启）
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrorMsg(self):
        r"""开启访问入口失败信息
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrorMsg = params.get("ErrorMsg")
        self._RequestId = params.get("RequestId")


class DescribeClusterEndpointVipStatusRequest(AbstractModel):
    r"""DescribeClusterEndpointVipStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterEndpointVipStatusResponse(AbstractModel):
    r"""DescribeClusterEndpointVipStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 端口操作状态 (Creating 创建中  CreateFailed 创建失败 Created 创建完成 Deleting 删除中 DeletedFailed 删除失败 Deleted 已删除 NotFound 未发现操作 )
        :type Status: str
        :param _ErrorMsg: 操作失败的原因
        :type ErrorMsg: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._ErrorMsg = None
        self._RequestId = None

    @property
    def Status(self):
        r"""端口操作状态 (Creating 创建中  CreateFailed 创建失败 Created 创建完成 Deleting 删除中 DeletedFailed 删除失败 Deleted 已删除 NotFound 未发现操作 )
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrorMsg(self):
        r"""操作失败的原因
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrorMsg = params.get("ErrorMsg")
        self._RequestId = params.get("RequestId")


class DescribeClusterEndpointsRequest(AbstractModel):
    r"""DescribeClusterEndpoints请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterEndpointsResponse(AbstractModel):
    r"""DescribeClusterEndpoints返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CertificationAuthority: 集群APIServer的CA证书
        :type CertificationAuthority: str
        :param _ClusterExternalEndpoint: 集群APIServer的外网访问地址
        :type ClusterExternalEndpoint: str
        :param _ClusterIntranetEndpoint: 集群APIServer的内网访问地址
        :type ClusterIntranetEndpoint: str
        :param _ClusterDomain: 集群APIServer的域名
        :type ClusterDomain: str
        :param _ClusterExternalACL: 集群APIServer的外网访问ACL列表
注意：此字段可能返回 null，表示取不到有效值。
        :type ClusterExternalACL: list of str
        :param _ClusterExternalDomain: 外网域名
        :type ClusterExternalDomain: str
        :param _ClusterIntranetDomain: 内网域名
        :type ClusterIntranetDomain: str
        :param _SecurityGroup: 外网安全组
        :type SecurityGroup: str
        :param _ClusterIntranetSubnetId: 内网访问所属子网
        :type ClusterIntranetSubnetId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CertificationAuthority = None
        self._ClusterExternalEndpoint = None
        self._ClusterIntranetEndpoint = None
        self._ClusterDomain = None
        self._ClusterExternalACL = None
        self._ClusterExternalDomain = None
        self._ClusterIntranetDomain = None
        self._SecurityGroup = None
        self._ClusterIntranetSubnetId = None
        self._RequestId = None

    @property
    def CertificationAuthority(self):
        r"""集群APIServer的CA证书
        :rtype: str
        """
        return self._CertificationAuthority

    @CertificationAuthority.setter
    def CertificationAuthority(self, CertificationAuthority):
        self._CertificationAuthority = CertificationAuthority

    @property
    def ClusterExternalEndpoint(self):
        r"""集群APIServer的外网访问地址
        :rtype: str
        """
        return self._ClusterExternalEndpoint

    @ClusterExternalEndpoint.setter
    def ClusterExternalEndpoint(self, ClusterExternalEndpoint):
        self._ClusterExternalEndpoint = ClusterExternalEndpoint

    @property
    def ClusterIntranetEndpoint(self):
        r"""集群APIServer的内网访问地址
        :rtype: str
        """
        return self._ClusterIntranetEndpoint

    @ClusterIntranetEndpoint.setter
    def ClusterIntranetEndpoint(self, ClusterIntranetEndpoint):
        self._ClusterIntranetEndpoint = ClusterIntranetEndpoint

    @property
    def ClusterDomain(self):
        r"""集群APIServer的域名
        :rtype: str
        """
        return self._ClusterDomain

    @ClusterDomain.setter
    def ClusterDomain(self, ClusterDomain):
        self._ClusterDomain = ClusterDomain

    @property
    def ClusterExternalACL(self):
        r"""集群APIServer的外网访问ACL列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._ClusterExternalACL

    @ClusterExternalACL.setter
    def ClusterExternalACL(self, ClusterExternalACL):
        self._ClusterExternalACL = ClusterExternalACL

    @property
    def ClusterExternalDomain(self):
        r"""外网域名
        :rtype: str
        """
        return self._ClusterExternalDomain

    @ClusterExternalDomain.setter
    def ClusterExternalDomain(self, ClusterExternalDomain):
        self._ClusterExternalDomain = ClusterExternalDomain

    @property
    def ClusterIntranetDomain(self):
        r"""内网域名
        :rtype: str
        """
        return self._ClusterIntranetDomain

    @ClusterIntranetDomain.setter
    def ClusterIntranetDomain(self, ClusterIntranetDomain):
        self._ClusterIntranetDomain = ClusterIntranetDomain

    @property
    def SecurityGroup(self):
        r"""外网安全组
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup

    @property
    def ClusterIntranetSubnetId(self):
        r"""内网访问所属子网
        :rtype: str
        """
        return self._ClusterIntranetSubnetId

    @ClusterIntranetSubnetId.setter
    def ClusterIntranetSubnetId(self, ClusterIntranetSubnetId):
        self._ClusterIntranetSubnetId = ClusterIntranetSubnetId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._CertificationAuthority = params.get("CertificationAuthority")
        self._ClusterExternalEndpoint = params.get("ClusterExternalEndpoint")
        self._ClusterIntranetEndpoint = params.get("ClusterIntranetEndpoint")
        self._ClusterDomain = params.get("ClusterDomain")
        self._ClusterExternalACL = params.get("ClusterExternalACL")
        self._ClusterExternalDomain = params.get("ClusterExternalDomain")
        self._ClusterIntranetDomain = params.get("ClusterIntranetDomain")
        self._SecurityGroup = params.get("SecurityGroup")
        self._ClusterIntranetSubnetId = params.get("ClusterIntranetSubnetId")
        self._RequestId = params.get("RequestId")


class DescribeClusterExtraArgsRequest(AbstractModel):
    r"""DescribeClusterExtraArgs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterExtraArgsResponse(AbstractModel):
    r"""DescribeClusterExtraArgs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterExtraArgs: 集群自定义参数
        :type ClusterExtraArgs: :class:`tencentcloud.tke.v20180525.models.ClusterExtraArgs`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterExtraArgs = None
        self._RequestId = None

    @property
    def ClusterExtraArgs(self):
        r"""集群自定义参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterExtraArgs`
        """
        return self._ClusterExtraArgs

    @ClusterExtraArgs.setter
    def ClusterExtraArgs(self, ClusterExtraArgs):
        self._ClusterExtraArgs = ClusterExtraArgs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterExtraArgs") is not None:
            self._ClusterExtraArgs = ClusterExtraArgs()
            self._ClusterExtraArgs._deserialize(params.get("ClusterExtraArgs"))
        self._RequestId = params.get("RequestId")


class DescribeClusterInspectionResultsOverviewRequest(AbstractModel):
    r"""DescribeClusterInspectionResultsOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: Array of String	目标集群列表，为空查询用户所有集群

        :type ClusterIds: list of str
        :param _GroupBy: 聚合字段信息，概览结果按照 GroupBy 信息聚合后返回，可选参数：
catalogue.first：按一级分类聚合
catalogue.second：按二级分类聚合
        :type GroupBy: list of str
        """
        self._ClusterIds = None
        self._GroupBy = None

    @property
    def ClusterIds(self):
        r"""Array of String	目标集群列表，为空查询用户所有集群

        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def GroupBy(self):
        r"""聚合字段信息，概览结果按照 GroupBy 信息聚合后返回，可选参数：
catalogue.first：按一级分类聚合
catalogue.second：按二级分类聚合
        :rtype: list of str
        """
        return self._GroupBy

    @GroupBy.setter
    def GroupBy(self, GroupBy):
        self._GroupBy = GroupBy


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._GroupBy = params.get("GroupBy")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterInspectionResultsOverviewResponse(AbstractModel):
    r"""DescribeClusterInspectionResultsOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Statistics: 诊断结果统计
注意：此字段可能返回 null，表示取不到有效值。
        :type Statistics: list of KubeJarvisStateStatistic
        :param _Diagnostics: 诊断结果概览
注意：此字段可能返回 null，表示取不到有效值。
        :type Diagnostics: list of KubeJarvisStateDiagnosticOverview
        :param _InspectionOverview: 集群诊断结果概览
注意：此字段可能返回 null，表示取不到有效值。
        :type InspectionOverview: list of KubeJarvisStateInspectionOverview
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Statistics = None
        self._Diagnostics = None
        self._InspectionOverview = None
        self._RequestId = None

    @property
    def Statistics(self):
        r"""诊断结果统计
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KubeJarvisStateStatistic
        """
        return self._Statistics

    @Statistics.setter
    def Statistics(self, Statistics):
        self._Statistics = Statistics

    @property
    def Diagnostics(self):
        r"""诊断结果概览
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KubeJarvisStateDiagnosticOverview
        """
        return self._Diagnostics

    @Diagnostics.setter
    def Diagnostics(self, Diagnostics):
        self._Diagnostics = Diagnostics

    @property
    def InspectionOverview(self):
        r"""集群诊断结果概览
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KubeJarvisStateInspectionOverview
        """
        return self._InspectionOverview

    @InspectionOverview.setter
    def InspectionOverview(self, InspectionOverview):
        self._InspectionOverview = InspectionOverview

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Statistics") is not None:
            self._Statistics = []
            for item in params.get("Statistics"):
                obj = KubeJarvisStateStatistic()
                obj._deserialize(item)
                self._Statistics.append(obj)
        if params.get("Diagnostics") is not None:
            self._Diagnostics = []
            for item in params.get("Diagnostics"):
                obj = KubeJarvisStateDiagnosticOverview()
                obj._deserialize(item)
                self._Diagnostics.append(obj)
        if params.get("InspectionOverview") is not None:
            self._InspectionOverview = []
            for item in params.get("InspectionOverview"):
                obj = KubeJarvisStateInspectionOverview()
                obj._deserialize(item)
                self._InspectionOverview.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterInstancesRequest(AbstractModel):
    r"""DescribeClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :type Limit: int
        :param _InstanceIds: 需要获取的节点实例Id列表。如果为空，表示拉取集群下所有节点实例。
        :type InstanceIds: list of str
        :param _InstanceRole: 节点角色, MASTER, WORKER, ETCD, MASTER_ETCD,ALL, 默认为WORKER。默认为WORKER类型。
        :type InstanceRole: str
        :param _Filters: 过滤条件列表；Name的可选值为nodepool-id、nodepool-instance-type；Name为nodepool-id表示根据节点池id过滤机器，Value的值为具体的节点池id，Name为nodepool-instance-type表示节点加入节点池的方式，Value的值为MANUALLY_ADDED（手动加入节点池）、AUTOSCALING_ADDED（伸缩组扩容方式加入节点池）、ALL（手动加入节点池 和 伸缩组扩容方式加入节点池）
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._InstanceIds = None
        self._InstanceRole = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        r"""偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def InstanceIds(self):
        r"""需要获取的节点实例Id列表。如果为空，表示拉取集群下所有节点实例。
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def InstanceRole(self):
        r"""节点角色, MASTER, WORKER, ETCD, MASTER_ETCD,ALL, 默认为WORKER。默认为WORKER类型。
        :rtype: str
        """
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def Filters(self):
        r"""过滤条件列表；Name的可选值为nodepool-id、nodepool-instance-type；Name为nodepool-id表示根据节点池id过滤机器，Value的值为具体的节点池id，Name为nodepool-instance-type表示节点加入节点池的方式，Value的值为MANUALLY_ADDED（手动加入节点池）、AUTOSCALING_ADDED（伸缩组扩容方式加入节点池）、ALL（手动加入节点池 和 伸缩组扩容方式加入节点池）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._InstanceIds = params.get("InstanceIds")
        self._InstanceRole = params.get("InstanceRole")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterInstancesResponse(AbstractModel):
    r"""DescribeClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群中实例总数
        :type TotalCount: int
        :param _InstanceSet: 集群中实例列表
        :type InstanceSet: list of Instance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""集群中实例总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceSet(self):
        r"""集群中实例列表
        :rtype: list of Instance
        """
        return self._InstanceSet

    @InstanceSet.setter
    def InstanceSet(self, InstanceSet):
        self._InstanceSet = InstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("InstanceSet") is not None:
            self._InstanceSet = []
            for item in params.get("InstanceSet"):
                obj = Instance()
                obj._deserialize(item)
                self._InstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterKubeconfigRequest(AbstractModel):
    r"""DescribeClusterKubeconfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _IsExtranet: 默认false 获取内网，是否获取外网访问的kubeconfig
        :type IsExtranet: bool
        """
        self._ClusterId = None
        self._IsExtranet = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def IsExtranet(self):
        r"""默认false 获取内网，是否获取外网访问的kubeconfig
        :rtype: bool
        """
        return self._IsExtranet

    @IsExtranet.setter
    def IsExtranet(self, IsExtranet):
        self._IsExtranet = IsExtranet


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._IsExtranet = params.get("IsExtranet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterKubeconfigResponse(AbstractModel):
    r"""DescribeClusterKubeconfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Kubeconfig: 子账户kubeconfig文件，可用于直接访问集群kube-apiserver（入参IsExtranet为false，返回内网访问的kubeconfig，没开内网的情况下server会是一个默认域名；入参IsExtranet为true，返回外网的kubeconfig，没开外网的情况下server会是一个默认域名。默认域名默认不可达，需要自行处理）
        :type Kubeconfig: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Kubeconfig = None
        self._RequestId = None

    @property
    def Kubeconfig(self):
        r"""子账户kubeconfig文件，可用于直接访问集群kube-apiserver（入参IsExtranet为false，返回内网访问的kubeconfig，没开内网的情况下server会是一个默认域名；入参IsExtranet为true，返回外网的kubeconfig，没开外网的情况下server会是一个默认域名。默认域名默认不可达，需要自行处理）
        :rtype: str
        """
        return self._Kubeconfig

    @Kubeconfig.setter
    def Kubeconfig(self, Kubeconfig):
        self._Kubeconfig = Kubeconfig

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Kubeconfig = params.get("Kubeconfig")
        self._RequestId = params.get("RequestId")


class DescribeClusterLevelAttributeRequest(AbstractModel):
    r"""DescribeClusterLevelAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群ID，变配时使用
        :type ClusterID: str
        """
        self._ClusterID = None

    @property
    def ClusterID(self):
        r"""集群ID，变配时使用
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterLevelAttributeResponse(AbstractModel):
    r"""DescribeClusterLevelAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _Items: 集群规模
        :type Items: list of ClusterLevelAttribute
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""集群规模
        :rtype: list of ClusterLevelAttribute
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ClusterLevelAttribute()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterLevelChangeRecordsRequest(AbstractModel):
    r"""DescribeClusterLevelChangeRecords请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群ID
        :type ClusterID: str
        :param _StartAt: 开始时间
        :type StartAt: str
        :param _EndAt: 结束时间
        :type EndAt: str
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Limit: 最大输出条数，默认20
        :type Limit: int
        """
        self._ClusterID = None
        self._StartAt = None
        self._EndAt = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterID(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def StartAt(self):
        r"""开始时间
        :rtype: str
        """
        return self._StartAt

    @StartAt.setter
    def StartAt(self, StartAt):
        self._StartAt = StartAt

    @property
    def EndAt(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndAt

    @EndAt.setter
    def EndAt(self, EndAt):
        self._EndAt = EndAt

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""最大输出条数，默认20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._StartAt = params.get("StartAt")
        self._EndAt = params.get("EndAt")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterLevelChangeRecordsResponse(AbstractModel):
    r"""DescribeClusterLevelChangeRecords返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _Items: 集群规模
        :type Items: list of ClusterLevelChangeRecord
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Items = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Items(self):
        r"""集群规模
        :rtype: list of ClusterLevelChangeRecord
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ClusterLevelChangeRecord()
                obj._deserialize(item)
                self._Items.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterNodePoolDetailRequest(AbstractModel):
    r"""DescribeClusterNodePoolDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _NodePoolId: 节点池id
        :type NodePoolId: str
        """
        self._ClusterId = None
        self._NodePoolId = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池id
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterNodePoolDetailResponse(AbstractModel):
    r"""DescribeClusterNodePoolDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodePool: 节点池详情
        :type NodePool: :class:`tencentcloud.tke.v20180525.models.NodePool`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodePool = None
        self._RequestId = None

    @property
    def NodePool(self):
        r"""节点池详情
        :rtype: :class:`tencentcloud.tke.v20180525.models.NodePool`
        """
        return self._NodePool

    @NodePool.setter
    def NodePool(self, NodePool):
        self._NodePool = NodePool

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodePool") is not None:
            self._NodePool = NodePool()
            self._NodePool._deserialize(params.get("NodePool"))
        self._RequestId = params.get("RequestId")


class DescribeClusterNodePoolsRequest(AbstractModel):
    r"""DescribeClusterNodePools请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: ClusterId（集群id）
        :type ClusterId: str
        :param _Filters: · "Name":"NodePoolsName","Values": ["test"]
    按照【节点池名】进行过滤。
    类型：String
    必选：否

·  "Name":"NodePoolsId","Values": ["np-d2mb2zb"]
    按照【节点池id】进行过滤。
    类型：String
    必选：否

·  "Name":"Tags","Values": ["product:tke"]
    按照【标签键值对】进行过滤。
    类型：String
    必选：否
        :type Filters: list of Filter
        """
        self._ClusterId = None
        self._Filters = None

    @property
    def ClusterId(self):
        r"""ClusterId（集群id）
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Filters(self):
        r"""· "Name":"NodePoolsName","Values": ["test"]
    按照【节点池名】进行过滤。
    类型：String
    必选：否

·  "Name":"NodePoolsId","Values": ["np-d2mb2zb"]
    按照【节点池id】进行过滤。
    类型：String
    必选：否

·  "Name":"Tags","Values": ["product:tke"]
    按照【标签键值对】进行过滤。
    类型：String
    必选：否
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterNodePoolsResponse(AbstractModel):
    r"""DescribeClusterNodePools返回参数结构体

    """

    def __init__(self):
        r"""
        :param _NodePoolSet: NodePools（节点池列表）
        :type NodePoolSet: list of NodePool
        :param _TotalCount: 资源总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._NodePoolSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def NodePoolSet(self):
        r"""NodePools（节点池列表）
        :rtype: list of NodePool
        """
        return self._NodePoolSet

    @NodePoolSet.setter
    def NodePoolSet(self, NodePoolSet):
        self._NodePoolSet = NodePoolSet

    @property
    def TotalCount(self):
        r"""资源总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("NodePoolSet") is not None:
            self._NodePoolSet = []
            for item in params.get("NodePoolSet"):
                obj = NodePool()
                obj._deserialize(item)
                self._NodePoolSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeClusterPendingReleasesRequest(AbstractModel):
    r"""DescribeClusterPendingReleases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Limit: 返回数量限制，默认20，最大100
        :type Limit: int
        :param _Offset: 偏移量，默认0
        :type Offset: int
        :param _ClusterType: 集群类型
        :type ClusterType: str
        """
        self._ClusterId = None
        self._Limit = None
        self._Offset = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        r"""返回数量限制，默认20，最大100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量，默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterPendingReleasesResponse(AbstractModel):
    r"""DescribeClusterPendingReleases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReleaseSet: 正在安装中应用列表
        :type ReleaseSet: list of PendingRelease
        :param _Limit: 每页返回数量限制
        :type Limit: int
        :param _Offset: 页偏移量
        :type Offset: int
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReleaseSet = None
        self._Limit = None
        self._Offset = None
        self._Total = None
        self._RequestId = None

    @property
    def ReleaseSet(self):
        r"""正在安装中应用列表
        :rtype: list of PendingRelease
        """
        return self._ReleaseSet

    @ReleaseSet.setter
    def ReleaseSet(self, ReleaseSet):
        self._ReleaseSet = ReleaseSet

    @property
    def Limit(self):
        r"""每页返回数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Total(self):
        r"""总数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReleaseSet") is not None:
            self._ReleaseSet = []
            for item in params.get("ReleaseSet"):
                obj = PendingRelease()
                obj._deserialize(item)
                self._ReleaseSet.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeClusterReleaseDetailsRequest(AbstractModel):
    r"""DescribeClusterReleaseDetails请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Name: 应用名称
        :type Name: str
        :param _Namespace: 应用所在命名空间
        :type Namespace: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        """
        self._ClusterId = None
        self._Name = None
        self._Namespace = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Name(self):
        r"""应用名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Namespace(self):
        r"""应用所在命名空间
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Name = params.get("Name")
        self._Namespace = params.get("Namespace")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterReleaseDetailsResponse(AbstractModel):
    r"""DescribeClusterReleaseDetails返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Release: 应用详情
        :type Release: :class:`tencentcloud.tke.v20180525.models.ReleaseDetails`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Release = None
        self._RequestId = None

    @property
    def Release(self):
        r"""应用详情
        :rtype: :class:`tencentcloud.tke.v20180525.models.ReleaseDetails`
        """
        return self._Release

    @Release.setter
    def Release(self, Release):
        self._Release = Release

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Release") is not None:
            self._Release = ReleaseDetails()
            self._Release._deserialize(params.get("Release"))
        self._RequestId = params.get("RequestId")


class DescribeClusterReleaseHistoryRequest(AbstractModel):
    r"""DescribeClusterReleaseHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Name: 应用名称
        :type Name: str
        :param _Namespace: 应用所在命名空间
        :type Namespace: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        """
        self._ClusterId = None
        self._Name = None
        self._Namespace = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Name(self):
        r"""应用名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Namespace(self):
        r"""应用所在命名空间
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Name = params.get("Name")
        self._Namespace = params.get("Namespace")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterReleaseHistoryResponse(AbstractModel):
    r"""DescribeClusterReleaseHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ReleaseHistorySet: 已安装应用版本历史
        :type ReleaseHistorySet: list of ReleaseHistory
        :param _Total: 总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ReleaseHistorySet = None
        self._Total = None
        self._RequestId = None

    @property
    def ReleaseHistorySet(self):
        r"""已安装应用版本历史
        :rtype: list of ReleaseHistory
        """
        return self._ReleaseHistorySet

    @ReleaseHistorySet.setter
    def ReleaseHistorySet(self, ReleaseHistorySet):
        self._ReleaseHistorySet = ReleaseHistorySet

    @property
    def Total(self):
        r"""总数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ReleaseHistorySet") is not None:
            self._ReleaseHistorySet = []
            for item in params.get("ReleaseHistorySet"):
                obj = ReleaseHistory()
                obj._deserialize(item)
                self._ReleaseHistorySet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeClusterReleasesRequest(AbstractModel):
    r"""DescribeClusterReleases请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Limit: 每页数量限制
        :type Limit: int
        :param _Offset: 页偏移量
        :type Offset: int
        :param _ClusterType: 集群类型, 目前支持传入 tke, eks, tkeedge, external 
        :type ClusterType: str
        :param _Namespace: helm Release 安装的namespace
        :type Namespace: str
        :param _ReleaseName: helm Release 的名字
        :type ReleaseName: str
        :param _ChartName: helm Chart 的名字
        :type ChartName: str
        """
        self._ClusterId = None
        self._Limit = None
        self._Offset = None
        self._ClusterType = None
        self._Namespace = None
        self._ReleaseName = None
        self._ChartName = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        r"""每页数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""页偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def ClusterType(self):
        r"""集群类型, 目前支持传入 tke, eks, tkeedge, external 
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def Namespace(self):
        r"""helm Release 安装的namespace
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ReleaseName(self):
        r"""helm Release 的名字
        :rtype: str
        """
        return self._ReleaseName

    @ReleaseName.setter
    def ReleaseName(self, ReleaseName):
        self._ReleaseName = ReleaseName

    @property
    def ChartName(self):
        r"""helm Chart 的名字
        :rtype: str
        """
        return self._ChartName

    @ChartName.setter
    def ChartName(self, ChartName):
        self._ChartName = ChartName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._ClusterType = params.get("ClusterType")
        self._Namespace = params.get("Namespace")
        self._ReleaseName = params.get("ReleaseName")
        self._ChartName = params.get("ChartName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterReleasesResponse(AbstractModel):
    r"""DescribeClusterReleases返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 数量限制
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _ReleaseSet: 已安装应用列表
        :type ReleaseSet: list of Release
        :param _Total: 已安装应用总数量
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Limit = None
        self._Offset = None
        self._ReleaseSet = None
        self._Total = None
        self._RequestId = None

    @property
    def Limit(self):
        r"""数量限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def ReleaseSet(self):
        r"""已安装应用列表
        :rtype: list of Release
        """
        return self._ReleaseSet

    @ReleaseSet.setter
    def ReleaseSet(self, ReleaseSet):
        self._ReleaseSet = ReleaseSet

    @property
    def Total(self):
        r"""已安装应用总数量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("ReleaseSet") is not None:
            self._ReleaseSet = []
            for item in params.get("ReleaseSet"):
                obj = Release()
                obj._deserialize(item)
                self._ReleaseSet.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeClusterRouteTablesRequest(AbstractModel):
    r"""DescribeClusterRouteTables请求参数结构体

    """


class DescribeClusterRouteTablesResponse(AbstractModel):
    r"""DescribeClusterRouteTables返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RouteTableSet: 集群路由表对象。
        :type RouteTableSet: list of RouteTableInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteTableSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteTableSet(self):
        r"""集群路由表对象。
        :rtype: list of RouteTableInfo
        """
        return self._RouteTableSet

    @RouteTableSet.setter
    def RouteTableSet(self, RouteTableSet):
        self._RouteTableSet = RouteTableSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteTableSet") is not None:
            self._RouteTableSet = []
            for item in params.get("RouteTableSet"):
                obj = RouteTableInfo()
                obj._deserialize(item)
                self._RouteTableSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterRoutesRequest(AbstractModel):
    r"""DescribeClusterRoutes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableName: 路由表名称。
        :type RouteTableName: str
        :param _Filters: 过滤条件,当前只支持按照单个条件GatewayIP进行过滤（可选）
        :type Filters: list of Filter
        """
        self._RouteTableName = None
        self._Filters = None

    @property
    def RouteTableName(self):
        r"""路由表名称。
        :rtype: str
        """
        return self._RouteTableName

    @RouteTableName.setter
    def RouteTableName(self, RouteTableName):
        self._RouteTableName = RouteTableName

    @property
    def Filters(self):
        r"""过滤条件,当前只支持按照单个条件GatewayIP进行过滤（可选）
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._RouteTableName = params.get("RouteTableName")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterRoutesResponse(AbstractModel):
    r"""DescribeClusterRoutes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RouteSet: 集群路由对象。
        :type RouteSet: list of RouteInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RouteSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RouteSet(self):
        r"""集群路由对象。
        :rtype: list of RouteInfo
        """
        return self._RouteSet

    @RouteSet.setter
    def RouteSet(self, RouteSet):
        self._RouteSet = RouteSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RouteSet") is not None:
            self._RouteSet = []
            for item in params.get("RouteSet"):
                obj = RouteInfo()
                obj._deserialize(item)
                self._RouteSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterSecurityRequest(AbstractModel):
    r"""DescribeClusterSecurity请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群 ID，请填写 查询集群列表 接口中返回的 clusterId 字段
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterSecurityResponse(AbstractModel):
    r"""DescribeClusterSecurity返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UserName: 集群的账号名称
        :type UserName: str
        :param _Password: 集群的访问密码
        :type Password: str
        :param _CertificationAuthority: 集群访问CA证书
        :type CertificationAuthority: str
        :param _ClusterExternalEndpoint: 集群访问的地址
        :type ClusterExternalEndpoint: str
        :param _Domain: 集群访问的域名
        :type Domain: str
        :param _PgwEndpoint: 集群Endpoint地址
        :type PgwEndpoint: str
        :param _SecurityPolicy: 集群访问策略组
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityPolicy: list of str
        :param _Kubeconfig: 集群Kubeconfig文件
        :type Kubeconfig: str
        :param _JnsGwEndpoint: 集群JnsGw的访问地址
注意：此字段可能返回 null，表示取不到有效值。
        :type JnsGwEndpoint: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UserName = None
        self._Password = None
        self._CertificationAuthority = None
        self._ClusterExternalEndpoint = None
        self._Domain = None
        self._PgwEndpoint = None
        self._SecurityPolicy = None
        self._Kubeconfig = None
        self._JnsGwEndpoint = None
        self._RequestId = None

    @property
    def UserName(self):
        r"""集群的账号名称
        :rtype: str
        """
        return self._UserName

    @UserName.setter
    def UserName(self, UserName):
        self._UserName = UserName

    @property
    def Password(self):
        r"""集群的访问密码
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def CertificationAuthority(self):
        r"""集群访问CA证书
        :rtype: str
        """
        return self._CertificationAuthority

    @CertificationAuthority.setter
    def CertificationAuthority(self, CertificationAuthority):
        self._CertificationAuthority = CertificationAuthority

    @property
    def ClusterExternalEndpoint(self):
        r"""集群访问的地址
        :rtype: str
        """
        return self._ClusterExternalEndpoint

    @ClusterExternalEndpoint.setter
    def ClusterExternalEndpoint(self, ClusterExternalEndpoint):
        self._ClusterExternalEndpoint = ClusterExternalEndpoint

    @property
    def Domain(self):
        r"""集群访问的域名
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def PgwEndpoint(self):
        r"""集群Endpoint地址
        :rtype: str
        """
        return self._PgwEndpoint

    @PgwEndpoint.setter
    def PgwEndpoint(self, PgwEndpoint):
        self._PgwEndpoint = PgwEndpoint

    @property
    def SecurityPolicy(self):
        r"""集群访问策略组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SecurityPolicy

    @SecurityPolicy.setter
    def SecurityPolicy(self, SecurityPolicy):
        self._SecurityPolicy = SecurityPolicy

    @property
    def Kubeconfig(self):
        r"""集群Kubeconfig文件
        :rtype: str
        """
        return self._Kubeconfig

    @Kubeconfig.setter
    def Kubeconfig(self, Kubeconfig):
        self._Kubeconfig = Kubeconfig

    @property
    def JnsGwEndpoint(self):
        r"""集群JnsGw的访问地址
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._JnsGwEndpoint

    @JnsGwEndpoint.setter
    def JnsGwEndpoint(self, JnsGwEndpoint):
        self._JnsGwEndpoint = JnsGwEndpoint

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UserName = params.get("UserName")
        self._Password = params.get("Password")
        self._CertificationAuthority = params.get("CertificationAuthority")
        self._ClusterExternalEndpoint = params.get("ClusterExternalEndpoint")
        self._Domain = params.get("Domain")
        self._PgwEndpoint = params.get("PgwEndpoint")
        self._SecurityPolicy = params.get("SecurityPolicy")
        self._Kubeconfig = params.get("Kubeconfig")
        self._JnsGwEndpoint = params.get("JnsGwEndpoint")
        self._RequestId = params.get("RequestId")


class DescribeClusterStatusRequest(AbstractModel):
    r"""DescribeClusterStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 集群ID列表，不传默认拉取所有集群
        :type ClusterIds: list of str
        """
        self._ClusterIds = None

    @property
    def ClusterIds(self):
        r"""集群ID列表，不传默认拉取所有集群
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterStatusResponse(AbstractModel):
    r"""DescribeClusterStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterStatusSet: 集群状态列表
        :type ClusterStatusSet: list of ClusterStatus
        :param _TotalCount: 集群个数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterStatusSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ClusterStatusSet(self):
        r"""集群状态列表
        :rtype: list of ClusterStatus
        """
        return self._ClusterStatusSet

    @ClusterStatusSet.setter
    def ClusterStatusSet(self, ClusterStatusSet):
        self._ClusterStatusSet = ClusterStatusSet

    @property
    def TotalCount(self):
        r"""集群个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterStatusSet") is not None:
            self._ClusterStatusSet = []
            for item in params.get("ClusterStatusSet"):
                obj = ClusterStatus()
                obj._deserialize(item)
                self._ClusterStatusSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeClusterVirtualNodePoolsRequest(AbstractModel):
    r"""DescribeClusterVirtualNodePools请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterVirtualNodePoolsResponse(AbstractModel):
    r"""DescribeClusterVirtualNodePools返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 节点池总数
        :type TotalCount: int
        :param _NodePoolSet: 虚拟节点池列表
        :type NodePoolSet: list of VirtualNodePool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._NodePoolSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""节点池总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NodePoolSet(self):
        r"""虚拟节点池列表
        :rtype: list of VirtualNodePool
        """
        return self._NodePoolSet

    @NodePoolSet.setter
    def NodePoolSet(self, NodePoolSet):
        self._NodePoolSet = NodePoolSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("NodePoolSet") is not None:
            self._NodePoolSet = []
            for item in params.get("NodePoolSet"):
                obj = VirtualNodePool()
                obj._deserialize(item)
                self._NodePoolSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClusterVirtualNodeRequest(AbstractModel):
    r"""DescribeClusterVirtualNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _NodePoolId: 节点池ID，通过DescribeNodePools接口获取
        :type NodePoolId: str
        :param _NodeNames: 节点名称，可搜索DescribeClusterVirtualNode接口节点
        :type NodeNames: list of str
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._NodeNames = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池ID，通过DescribeNodePools接口获取
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def NodeNames(self):
        r"""节点名称，可搜索DescribeClusterVirtualNode接口节点
        :rtype: list of str
        """
        return self._NodeNames

    @NodeNames.setter
    def NodeNames(self, NodeNames):
        self._NodeNames = NodeNames


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._NodeNames = params.get("NodeNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterVirtualNodeResponse(AbstractModel):
    r"""DescribeClusterVirtualNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Nodes: 节点列表
        :type Nodes: list of VirtualNode
        :param _TotalCount: 节点总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Nodes = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Nodes(self):
        r"""节点列表
        :rtype: list of VirtualNode
        """
        return self._Nodes

    @Nodes.setter
    def Nodes(self, Nodes):
        self._Nodes = Nodes

    @property
    def TotalCount(self):
        r"""节点总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Nodes") is not None:
            self._Nodes = []
            for item in params.get("Nodes"):
                obj = VirtualNode()
                obj._deserialize(item)
                self._Nodes.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeClustersRequest(AbstractModel):
    r"""DescribeClusters请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 集群ID列表(为空时，
表示获取账号下所有集群)
        :type ClusterIds: list of str
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Limit: 最大输出条数，默认20，最大为100
        :type Limit: int
        :param _Filters: · "Name":"ClusterName","Values": ["test"] 按照【集群名】进行过滤。 类型：String 必选：否 · "Name":"ClusterType","Values": ["MANAGED_CLUSTER"] 按照【集群类型】进行过滤。 类型：String 必选：否 · "Name":"ClusterStatus","Values": ["Running"] 按照【集群状态】进行过滤。 类型：String 必选：否 · "Name":"vpc-id","Values": ["vpc-2wds9k9p"] 按照【VPC】进行过滤。 类型：String 必选：否 · "Name":"tag-key","Values": ["testKey"] 按照【标签键】进行过滤。 类型：String 必选：否 · "Name":"tag-value","Values": ["testValue"] 按照【标签值】进行过滤。 类型：String 必选：否 · "Name":"Tags","Values": ["product:tke"] 按照【标签键值对】进行过滤。 类型：String 必选：否
        :type Filters: list of Filter
        :param _ClusterType: 集群类型，例如：MANAGED_CLUSTER
        :type ClusterType: str
        """
        self._ClusterIds = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._ClusterType = None

    @property
    def ClusterIds(self):
        r"""集群ID列表(为空时，
表示获取账号下所有集群)
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""最大输出条数，默认20，最大为100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""· "Name":"ClusterName","Values": ["test"] 按照【集群名】进行过滤。 类型：String 必选：否 · "Name":"ClusterType","Values": ["MANAGED_CLUSTER"] 按照【集群类型】进行过滤。 类型：String 必选：否 · "Name":"ClusterStatus","Values": ["Running"] 按照【集群状态】进行过滤。 类型：String 必选：否 · "Name":"vpc-id","Values": ["vpc-2wds9k9p"] 按照【VPC】进行过滤。 类型：String 必选：否 · "Name":"tag-key","Values": ["testKey"] 按照【标签键】进行过滤。 类型：String 必选：否 · "Name":"tag-value","Values": ["testValue"] 按照【标签值】进行过滤。 类型：String 必选：否 · "Name":"Tags","Values": ["product:tke"] 按照【标签键值对】进行过滤。 类型：String 必选：否
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ClusterType(self):
        r"""集群类型，例如：MANAGED_CLUSTER
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClustersResponse(AbstractModel):
    r"""DescribeClusters返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总个数
        :type TotalCount: int
        :param _Clusters: 集群信息列表
        :type Clusters: list of Cluster
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Clusters = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""集群总个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Clusters(self):
        r"""集群信息列表
        :rtype: list of Cluster
        """
        return self._Clusters

    @Clusters.setter
    def Clusters(self, Clusters):
        self._Clusters = Clusters

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Clusters") is not None:
            self._Clusters = []
            for item in params.get("Clusters"):
                obj = Cluster()
                obj._deserialize(item)
                self._Clusters.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeECMInstancesRequest(AbstractModel):
    r"""DescribeECMInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群id
        :type ClusterID: str
        :param _Filters: 过滤条件
仅支持ecm-id过滤
        :type Filters: list of Filter
        """
        self._ClusterID = None
        self._Filters = None

    @property
    def ClusterID(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def Filters(self):
        r"""过滤条件
仅支持ecm-id过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeECMInstancesResponse(AbstractModel):
    r"""DescribeECMInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 返回的实例相关信息列表的长度
        :type TotalCount: int
        :param _InstanceInfoSet: 返回的实例相关信息列表
        :type InstanceInfoSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""返回的实例相关信息列表的长度
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceInfoSet(self):
        r"""返回的实例相关信息列表
        :rtype: list of str
        """
        return self._InstanceInfoSet

    @InstanceInfoSet.setter
    def InstanceInfoSet(self, InstanceInfoSet):
        self._InstanceInfoSet = InstanceInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._InstanceInfoSet = params.get("InstanceInfoSet")
        self._RequestId = params.get("RequestId")


class DescribeEKSClusterCredentialRequest(AbstractModel):
    r"""DescribeEKSClusterCredential请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEKSClusterCredentialResponse(AbstractModel):
    r"""DescribeEKSClusterCredential返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Addresses: 集群的接入地址信息
        :type Addresses: list of IPAddress
        :param _Credential: 集群的认证信息（token只有请求是主账号才返回，子账户请使用返回的kubeconfig）
        :type Credential: :class:`tencentcloud.tke.v20180525.models.ClusterCredential`
        :param _PublicLB: 集群的公网访问信息
        :type PublicLB: :class:`tencentcloud.tke.v20180525.models.ClusterPublicLB`
        :param _InternalLB: 集群的内网访问信息
        :type InternalLB: :class:`tencentcloud.tke.v20180525.models.ClusterInternalLB`
        :param _ProxyLB: 标记是否新的内外网功能
        :type ProxyLB: bool
        :param _Kubeconfig: 连接用户集群k8s 的Config
        :type Kubeconfig: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Addresses = None
        self._Credential = None
        self._PublicLB = None
        self._InternalLB = None
        self._ProxyLB = None
        self._Kubeconfig = None
        self._RequestId = None

    @property
    def Addresses(self):
        r"""集群的接入地址信息
        :rtype: list of IPAddress
        """
        return self._Addresses

    @Addresses.setter
    def Addresses(self, Addresses):
        self._Addresses = Addresses

    @property
    def Credential(self):
        r"""集群的认证信息（token只有请求是主账号才返回，子账户请使用返回的kubeconfig）
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterCredential`
        """
        return self._Credential

    @Credential.setter
    def Credential(self, Credential):
        self._Credential = Credential

    @property
    def PublicLB(self):
        r"""集群的公网访问信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterPublicLB`
        """
        return self._PublicLB

    @PublicLB.setter
    def PublicLB(self, PublicLB):
        self._PublicLB = PublicLB

    @property
    def InternalLB(self):
        r"""集群的内网访问信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterInternalLB`
        """
        return self._InternalLB

    @InternalLB.setter
    def InternalLB(self, InternalLB):
        self._InternalLB = InternalLB

    @property
    def ProxyLB(self):
        r"""标记是否新的内外网功能
        :rtype: bool
        """
        return self._ProxyLB

    @ProxyLB.setter
    def ProxyLB(self, ProxyLB):
        self._ProxyLB = ProxyLB

    @property
    def Kubeconfig(self):
        r"""连接用户集群k8s 的Config
        :rtype: str
        """
        return self._Kubeconfig

    @Kubeconfig.setter
    def Kubeconfig(self, Kubeconfig):
        self._Kubeconfig = Kubeconfig

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Addresses") is not None:
            self._Addresses = []
            for item in params.get("Addresses"):
                obj = IPAddress()
                obj._deserialize(item)
                self._Addresses.append(obj)
        if params.get("Credential") is not None:
            self._Credential = ClusterCredential()
            self._Credential._deserialize(params.get("Credential"))
        if params.get("PublicLB") is not None:
            self._PublicLB = ClusterPublicLB()
            self._PublicLB._deserialize(params.get("PublicLB"))
        if params.get("InternalLB") is not None:
            self._InternalLB = ClusterInternalLB()
            self._InternalLB._deserialize(params.get("InternalLB"))
        self._ProxyLB = params.get("ProxyLB")
        self._Kubeconfig = params.get("Kubeconfig")
        self._RequestId = params.get("RequestId")


class DescribeEKSClustersRequest(AbstractModel):
    r"""DescribeEKSClusters请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 集群ID列表(为空时，
表示获取账号下所有集群)
        :type ClusterIds: list of str
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Limit: 最大输出条数，默认20
        :type Limit: int
        :param _Filters: 过滤条件,当前只支持按照单个条件ClusterName进行过滤
        :type Filters: list of Filter
        """
        self._ClusterIds = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ClusterIds(self):
        r"""集群ID列表(为空时，
表示获取账号下所有集群)
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""最大输出条数，默认20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤条件,当前只支持按照单个条件ClusterName进行过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEKSClustersResponse(AbstractModel):
    r"""DescribeEKSClusters返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总个数
        :type TotalCount: int
        :param _Clusters: 集群信息列表
        :type Clusters: list of EksCluster
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Clusters = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""集群总个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Clusters(self):
        r"""集群信息列表
        :rtype: list of EksCluster
        """
        return self._Clusters

    @Clusters.setter
    def Clusters(self, Clusters):
        self._Clusters = Clusters

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Clusters") is not None:
            self._Clusters = []
            for item in params.get("Clusters"):
                obj = EksCluster()
                obj._deserialize(item)
                self._Clusters.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEKSContainerInstanceEventRequest(AbstractModel):
    r"""DescribeEKSContainerInstanceEvent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EksCiId: 容器实例id
        :type EksCiId: str
        :param _Limit: 最大事件数量。默认为50，最大取值100。
        :type Limit: int
        """
        self._EksCiId = None
        self._Limit = None

    @property
    def EksCiId(self):
        r"""容器实例id
        :rtype: str
        """
        return self._EksCiId

    @EksCiId.setter
    def EksCiId(self, EksCiId):
        self._EksCiId = EksCiId

    @property
    def Limit(self):
        r"""最大事件数量。默认为50，最大取值100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._EksCiId = params.get("EksCiId")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEKSContainerInstanceEventResponse(AbstractModel):
    r"""DescribeEKSContainerInstanceEvent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Events: 事件集合
        :type Events: list of Event
        :param _EksCiId: 容器实例id
        :type EksCiId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Events = None
        self._EksCiId = None
        self._RequestId = None

    @property
    def Events(self):
        r"""事件集合
        :rtype: list of Event
        """
        return self._Events

    @Events.setter
    def Events(self, Events):
        self._Events = Events

    @property
    def EksCiId(self):
        r"""容器实例id
        :rtype: str
        """
        return self._EksCiId

    @EksCiId.setter
    def EksCiId(self, EksCiId):
        self._EksCiId = EksCiId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Events") is not None:
            self._Events = []
            for item in params.get("Events"):
                obj = Event()
                obj._deserialize(item)
                self._Events.append(obj)
        self._EksCiId = params.get("EksCiId")
        self._RequestId = params.get("RequestId")


class DescribeEKSContainerInstanceRegionsRequest(AbstractModel):
    r"""DescribeEKSContainerInstanceRegions请求参数结构体

    """


class DescribeEKSContainerInstanceRegionsResponse(AbstractModel):
    r"""DescribeEKSContainerInstanceRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Regions: EKS Container Instance支持的地域信息
        :type Regions: list of EksCiRegionInfo
        :param _TotalCount: 总数
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Regions = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def Regions(self):
        r"""EKS Container Instance支持的地域信息
        :rtype: list of EksCiRegionInfo
        """
        return self._Regions

    @Regions.setter
    def Regions(self, Regions):
        self._Regions = Regions

    @property
    def TotalCount(self):
        r"""总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Regions") is not None:
            self._Regions = []
            for item in params.get("Regions"):
                obj = EksCiRegionInfo()
                obj._deserialize(item)
                self._Regions.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeEKSContainerInstancesRequest(AbstractModel):
    r"""DescribeEKSContainerInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Limit: 限定此次返回资源的数量。如果不设定，默认返回20，最大不能超过100
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Filters: 过滤条件，可条件：
(1)实例名称
KeyName: eks-ci-name
类型：String

(2)实例状态
KeyName: status
类型：String
可选值："Pending", "Running", "Succeeded", "Failed"

(3)内网ip
KeyName: private-ip
类型：String

(4)EIP地址
KeyName: eip-address
类型：String

(5)VpcId
KeyName: vpc-id
类型：String
        :type Filters: list of Filter
        :param _EksCiIds: 容器实例 ID 数组
        :type EksCiIds: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._EksCiIds = None

    @property
    def Limit(self):
        r"""限定此次返回资源的数量。如果不设定，默认返回20，最大不能超过100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，可条件：
(1)实例名称
KeyName: eks-ci-name
类型：String

(2)实例状态
KeyName: status
类型：String
可选值："Pending", "Running", "Succeeded", "Failed"

(3)内网ip
KeyName: private-ip
类型：String

(4)EIP地址
KeyName: eip-address
类型：String

(5)VpcId
KeyName: vpc-id
类型：String
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def EksCiIds(self):
        r"""容器实例 ID 数组
        :rtype: list of str
        """
        return self._EksCiIds

    @EksCiIds.setter
    def EksCiIds(self, EksCiIds):
        self._EksCiIds = EksCiIds


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._EksCiIds = params.get("EksCiIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEKSContainerInstancesResponse(AbstractModel):
    r"""DescribeEKSContainerInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 容器组总数
        :type TotalCount: int
        :param _EksCis: 容器组列表
        :type EksCis: list of EksCi
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._EksCis = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""容器组总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EksCis(self):
        r"""容器组列表
        :rtype: list of EksCi
        """
        return self._EksCis

    @EksCis.setter
    def EksCis(self, EksCis):
        self._EksCis = EksCis

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EksCis") is not None:
            self._EksCis = []
            for item in params.get("EksCis"):
                obj = EksCi()
                obj._deserialize(item)
                self._EksCis.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEdgeAvailableExtraArgsRequest(AbstractModel):
    r"""DescribeEdgeAvailableExtraArgs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        """
        self._ClusterVersion = None

    @property
    def ClusterVersion(self):
        r"""集群版本
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion


    def _deserialize(self, params):
        self._ClusterVersion = params.get("ClusterVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEdgeAvailableExtraArgsResponse(AbstractModel):
    r"""DescribeEdgeAvailableExtraArgs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterVersion: 集群版本
        :type ClusterVersion: str
        :param _AvailableExtraArgs: 可用的自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :type AvailableExtraArgs: :class:`tencentcloud.tke.v20180525.models.EdgeAvailableExtraArgs`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterVersion = None
        self._AvailableExtraArgs = None
        self._RequestId = None

    @property
    def ClusterVersion(self):
        r"""集群版本
        :rtype: str
        """
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def AvailableExtraArgs(self):
        r"""可用的自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeAvailableExtraArgs`
        """
        return self._AvailableExtraArgs

    @AvailableExtraArgs.setter
    def AvailableExtraArgs(self, AvailableExtraArgs):
        self._AvailableExtraArgs = AvailableExtraArgs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterVersion = params.get("ClusterVersion")
        if params.get("AvailableExtraArgs") is not None:
            self._AvailableExtraArgs = EdgeAvailableExtraArgs()
            self._AvailableExtraArgs._deserialize(params.get("AvailableExtraArgs"))
        self._RequestId = params.get("RequestId")


class DescribeEdgeCVMInstancesRequest(AbstractModel):
    r"""DescribeEdgeCVMInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群id
        :type ClusterID: str
        :param _Filters: 过滤条件
仅支持cvm-id过滤
        :type Filters: list of Filter
        """
        self._ClusterID = None
        self._Filters = None

    @property
    def ClusterID(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def Filters(self):
        r"""过滤条件
仅支持cvm-id过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEdgeCVMInstancesResponse(AbstractModel):
    r"""DescribeEdgeCVMInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 返回的实例相关信息列表的长度
        :type TotalCount: int
        :param _InstanceInfoSet: 返回的实例相关信息列表
        :type InstanceInfoSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""返回的实例相关信息列表的长度
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceInfoSet(self):
        r"""返回的实例相关信息列表
        :rtype: list of str
        """
        return self._InstanceInfoSet

    @InstanceInfoSet.setter
    def InstanceInfoSet(self, InstanceInfoSet):
        self._InstanceInfoSet = InstanceInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._InstanceInfoSet = params.get("InstanceInfoSet")
        self._RequestId = params.get("RequestId")


class DescribeEdgeClusterExtraArgsRequest(AbstractModel):
    r"""DescribeEdgeClusterExtraArgs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEdgeClusterExtraArgsResponse(AbstractModel):
    r"""DescribeEdgeClusterExtraArgs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterExtraArgs: 集群自定义参数
        :type ClusterExtraArgs: :class:`tencentcloud.tke.v20180525.models.EdgeClusterExtraArgs`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterExtraArgs = None
        self._RequestId = None

    @property
    def ClusterExtraArgs(self):
        r"""集群自定义参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterExtraArgs`
        """
        return self._ClusterExtraArgs

    @ClusterExtraArgs.setter
    def ClusterExtraArgs(self, ClusterExtraArgs):
        self._ClusterExtraArgs = ClusterExtraArgs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterExtraArgs") is not None:
            self._ClusterExtraArgs = EdgeClusterExtraArgs()
            self._ClusterExtraArgs._deserialize(params.get("ClusterExtraArgs"))
        self._RequestId = params.get("RequestId")


class DescribeEdgeClusterInstancesRequest(AbstractModel):
    r"""DescribeEdgeClusterInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterID: 集群id
        :type ClusterID: str
        :param _Limit: 查询总数
        :type Limit: int
        :param _Offset: 偏移量
        :type Offset: int
        :param _Filters: 过滤条件，仅支持NodeName过滤
        :type Filters: list of Filter
        """
        self._ClusterID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def ClusterID(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def Limit(self):
        r"""查询总数
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，仅支持NodeName过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEdgeClusterInstancesResponse(AbstractModel):
    r"""DescribeEdgeClusterInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 该集群总数
        :type TotalCount: int
        :param _InstanceInfoSet: 节点信息集合
        :type InstanceInfoSet: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._InstanceInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""该集群总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def InstanceInfoSet(self):
        r"""节点信息集合
        :rtype: str
        """
        return self._InstanceInfoSet

    @InstanceInfoSet.setter
    def InstanceInfoSet(self, InstanceInfoSet):
        self._InstanceInfoSet = InstanceInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._InstanceInfoSet = params.get("InstanceInfoSet")
        self._RequestId = params.get("RequestId")


class DescribeEdgeClusterUpgradeInfoRequest(AbstractModel):
    r"""DescribeEdgeClusterUpgradeInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _EdgeVersion: 要升级到的TKEEdge版本
        :type EdgeVersion: str
        """
        self._ClusterId = None
        self._EdgeVersion = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def EdgeVersion(self):
        r"""要升级到的TKEEdge版本
        :rtype: str
        """
        return self._EdgeVersion

    @EdgeVersion.setter
    def EdgeVersion(self, EdgeVersion):
        self._EdgeVersion = EdgeVersion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._EdgeVersion = params.get("EdgeVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEdgeClusterUpgradeInfoResponse(AbstractModel):
    r"""DescribeEdgeClusterUpgradeInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ComponentVersion: 可升级的集群组件及其版本
        :type ComponentVersion: str
        :param _EdgeVersionCurrent: 边缘集群当前版本
        :type EdgeVersionCurrent: str
        :param _RegistryPrefix: 边缘组件镜像仓库地址前缀，包含域名和命名空间
        :type RegistryPrefix: str
        :param _ClusterUpgradeStatus: 集群升级状态，可能值：running、updating、failed
        :type ClusterUpgradeStatus: str
        :param _ClusterUpgradeStatusReason: 集群升级中状态或者失败原因
        :type ClusterUpgradeStatusReason: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ComponentVersion = None
        self._EdgeVersionCurrent = None
        self._RegistryPrefix = None
        self._ClusterUpgradeStatus = None
        self._ClusterUpgradeStatusReason = None
        self._RequestId = None

    @property
    def ComponentVersion(self):
        r"""可升级的集群组件及其版本
        :rtype: str
        """
        return self._ComponentVersion

    @ComponentVersion.setter
    def ComponentVersion(self, ComponentVersion):
        self._ComponentVersion = ComponentVersion

    @property
    def EdgeVersionCurrent(self):
        r"""边缘集群当前版本
        :rtype: str
        """
        return self._EdgeVersionCurrent

    @EdgeVersionCurrent.setter
    def EdgeVersionCurrent(self, EdgeVersionCurrent):
        self._EdgeVersionCurrent = EdgeVersionCurrent

    @property
    def RegistryPrefix(self):
        r"""边缘组件镜像仓库地址前缀，包含域名和命名空间
        :rtype: str
        """
        return self._RegistryPrefix

    @RegistryPrefix.setter
    def RegistryPrefix(self, RegistryPrefix):
        self._RegistryPrefix = RegistryPrefix

    @property
    def ClusterUpgradeStatus(self):
        r"""集群升级状态，可能值：running、updating、failed
        :rtype: str
        """
        return self._ClusterUpgradeStatus

    @ClusterUpgradeStatus.setter
    def ClusterUpgradeStatus(self, ClusterUpgradeStatus):
        self._ClusterUpgradeStatus = ClusterUpgradeStatus

    @property
    def ClusterUpgradeStatusReason(self):
        r"""集群升级中状态或者失败原因
        :rtype: str
        """
        return self._ClusterUpgradeStatusReason

    @ClusterUpgradeStatusReason.setter
    def ClusterUpgradeStatusReason(self, ClusterUpgradeStatusReason):
        self._ClusterUpgradeStatusReason = ClusterUpgradeStatusReason

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ComponentVersion = params.get("ComponentVersion")
        self._EdgeVersionCurrent = params.get("EdgeVersionCurrent")
        self._RegistryPrefix = params.get("RegistryPrefix")
        self._ClusterUpgradeStatus = params.get("ClusterUpgradeStatus")
        self._ClusterUpgradeStatusReason = params.get("ClusterUpgradeStatusReason")
        self._RequestId = params.get("RequestId")


class DescribeEdgeLogSwitchesRequest(AbstractModel):
    r"""DescribeEdgeLogSwitches请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 集群ID列表
        :type ClusterIds: list of str
        """
        self._ClusterIds = None

    @property
    def ClusterIds(self):
        r"""集群ID列表
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEdgeLogSwitchesResponse(AbstractModel):
    r"""DescribeEdgeLogSwitches返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SwitchSet: 集群日志开关集合
        :type SwitchSet: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SwitchSet = None
        self._RequestId = None

    @property
    def SwitchSet(self):
        r"""集群日志开关集合
        :rtype: list of str
        """
        return self._SwitchSet

    @SwitchSet.setter
    def SwitchSet(self, SwitchSet):
        self._SwitchSet = SwitchSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SwitchSet = params.get("SwitchSet")
        self._RequestId = params.get("RequestId")


class DescribeEksContainerInstanceLogRequest(AbstractModel):
    r"""DescribeEksContainerInstanceLog请求参数结构体

    """

    def __init__(self):
        r"""
        :param _EksCiId: Eks Container Instance Id，即容器实例Id
        :type EksCiId: str
        :param _ContainerName: 容器名称，单容器的实例可选填。如果为多容器实例，请指定容器名称。
        :type ContainerName: str
        :param _Tail: 返回最新日志行数，默认500，最大2000。日志内容最大返回 1M 数据。
        :type Tail: int
        :param _StartTime: UTC时间，RFC3339标准
        :type StartTime: str
        :param _Previous: 是否是查上一个容器（如果容器退出重启了）
        :type Previous: bool
        :param _SinceSeconds: 查询最近多少秒内的日志
        :type SinceSeconds: int
        :param _LimitBytes: 日志总大小限制
        :type LimitBytes: int
        """
        self._EksCiId = None
        self._ContainerName = None
        self._Tail = None
        self._StartTime = None
        self._Previous = None
        self._SinceSeconds = None
        self._LimitBytes = None

    @property
    def EksCiId(self):
        r"""Eks Container Instance Id，即容器实例Id
        :rtype: str
        """
        return self._EksCiId

    @EksCiId.setter
    def EksCiId(self, EksCiId):
        self._EksCiId = EksCiId

    @property
    def ContainerName(self):
        r"""容器名称，单容器的实例可选填。如果为多容器实例，请指定容器名称。
        :rtype: str
        """
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def Tail(self):
        r"""返回最新日志行数，默认500，最大2000。日志内容最大返回 1M 数据。
        :rtype: int
        """
        return self._Tail

    @Tail.setter
    def Tail(self, Tail):
        self._Tail = Tail

    @property
    def StartTime(self):
        r"""UTC时间，RFC3339标准
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def Previous(self):
        r"""是否是查上一个容器（如果容器退出重启了）
        :rtype: bool
        """
        return self._Previous

    @Previous.setter
    def Previous(self, Previous):
        self._Previous = Previous

    @property
    def SinceSeconds(self):
        r"""查询最近多少秒内的日志
        :rtype: int
        """
        return self._SinceSeconds

    @SinceSeconds.setter
    def SinceSeconds(self, SinceSeconds):
        self._SinceSeconds = SinceSeconds

    @property
    def LimitBytes(self):
        r"""日志总大小限制
        :rtype: int
        """
        return self._LimitBytes

    @LimitBytes.setter
    def LimitBytes(self, LimitBytes):
        self._LimitBytes = LimitBytes


    def _deserialize(self, params):
        self._EksCiId = params.get("EksCiId")
        self._ContainerName = params.get("ContainerName")
        self._Tail = params.get("Tail")
        self._StartTime = params.get("StartTime")
        self._Previous = params.get("Previous")
        self._SinceSeconds = params.get("SinceSeconds")
        self._LimitBytes = params.get("LimitBytes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEksContainerInstanceLogResponse(AbstractModel):
    r"""DescribeEksContainerInstanceLog返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ContainerName: 容器名称
        :type ContainerName: str
        :param _LogContent: 日志内容
        :type LogContent: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ContainerName = None
        self._LogContent = None
        self._RequestId = None

    @property
    def ContainerName(self):
        r"""容器名称
        :rtype: str
        """
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def LogContent(self):
        r"""日志内容
        :rtype: str
        """
        return self._LogContent

    @LogContent.setter
    def LogContent(self, LogContent):
        self._LogContent = LogContent

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ContainerName = params.get("ContainerName")
        self._LogContent = params.get("LogContent")
        self._RequestId = params.get("RequestId")


class DescribeEnableVpcCniProgressRequest(AbstractModel):
    r"""DescribeEnableVpcCniProgress请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 开启vpc-cni的集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""开启vpc-cni的集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnableVpcCniProgressResponse(AbstractModel):
    r"""DescribeEnableVpcCniProgress返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 任务进度的描述：Running/Succeed/Failed
        :type Status: str
        :param _ErrorMessage: 当任务进度为Failed时，对任务状态的进一步描述，例如IPAMD组件安装失败
        :type ErrorMessage: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._ErrorMessage = None
        self._RequestId = None

    @property
    def Status(self):
        r"""任务进度的描述：Running/Succeed/Failed
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrorMessage(self):
        r"""当任务进度为Failed时，对任务状态的进一步描述，例如IPAMD组件安装失败
        :rtype: str
        """
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrorMessage = params.get("ErrorMessage")
        self._RequestId = params.get("RequestId")


class DescribeEncryptionStatusRequest(AbstractModel):
    r"""DescribeEncryptionStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEncryptionStatusResponse(AbstractModel):
    r"""DescribeEncryptionStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 加密状态
- Opening: 开启中
- Opened: 已开启
- Closing: 关闭中
- Closed: 已关闭
        :type Status: str
        :param _ErrorMsg: 加密错误信息
        :type ErrorMsg: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._ErrorMsg = None
        self._RequestId = None

    @property
    def Status(self):
        r"""加密状态
- Opening: 开启中
- Opened: 已开启
- Closing: 关闭中
- Closed: 已关闭
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrorMsg(self):
        r"""加密错误信息
        :rtype: str
        """
        return self._ErrorMsg

    @ErrorMsg.setter
    def ErrorMsg(self, ErrorMsg):
        self._ErrorMsg = ErrorMsg

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrorMsg = params.get("ErrorMsg")
        self._RequestId = params.get("RequestId")


class DescribeExistedInstancesRequest(AbstractModel):
    r"""DescribeExistedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群 ID，请填写查询集群列表 接口中返回的 ClusterId 字段（仅通过ClusterId获取需要过滤条件中的VPCID。节点状态比较时会使用该地域下所有集群中的节点进行比较。参数不支持同时指定InstanceIds和ClusterId。
        :type ClusterId: str
        :param _InstanceIds: 按照一个或者多个实例ID查询。实例ID形如：ins-xxxxxxxx。（此参数的具体格式可参考API简介的id.N一节）。每次请求的实例的上限为100。参数不支持同时指定InstanceIds和Filters。
        :type InstanceIds: list of str
        :param _Filters: 过滤条件,字段和详见[CVM查询实例](https://cloud.tencent.com/document/api/213/15728)如果设置了ClusterId，会附加集群的VPCID作为查询字段，在此情况下如果在Filter中指定了"vpc-id"作为过滤字段，指定的VPCID必须与集群的VPCID相同。
        :type Filters: list of Filter
        :param _VagueIpAddress: 实例IP进行过滤(同时支持内网IP和外网IP)
        :type VagueIpAddress: str
        :param _VagueInstanceName: 实例名称进行过滤
        :type VagueInstanceName: str
        :param _Offset: 偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :type Limit: int
        :param _IpAddresses: 根据多个实例IP进行过滤
        :type IpAddresses: list of str
        """
        self._ClusterId = None
        self._InstanceIds = None
        self._Filters = None
        self._VagueIpAddress = None
        self._VagueInstanceName = None
        self._Offset = None
        self._Limit = None
        self._IpAddresses = None

    @property
    def ClusterId(self):
        r"""集群 ID，请填写查询集群列表 接口中返回的 ClusterId 字段（仅通过ClusterId获取需要过滤条件中的VPCID。节点状态比较时会使用该地域下所有集群中的节点进行比较。参数不支持同时指定InstanceIds和ClusterId。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def InstanceIds(self):
        r"""按照一个或者多个实例ID查询。实例ID形如：ins-xxxxxxxx。（此参数的具体格式可参考API简介的id.N一节）。每次请求的实例的上限为100。参数不支持同时指定InstanceIds和Filters。
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def Filters(self):
        r"""过滤条件,字段和详见[CVM查询实例](https://cloud.tencent.com/document/api/213/15728)如果设置了ClusterId，会附加集群的VPCID作为查询字段，在此情况下如果在Filter中指定了"vpc-id"作为过滤字段，指定的VPCID必须与集群的VPCID相同。
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def VagueIpAddress(self):
        r"""实例IP进行过滤(同时支持内网IP和外网IP)
        :rtype: str
        """
        return self._VagueIpAddress

    @VagueIpAddress.setter
    def VagueIpAddress(self, VagueIpAddress):
        self._VagueIpAddress = VagueIpAddress

    @property
    def VagueInstanceName(self):
        r"""实例名称进行过滤
        :rtype: str
        """
        return self._VagueInstanceName

    @VagueInstanceName.setter
    def VagueInstanceName(self, VagueInstanceName):
        self._VagueInstanceName = VagueInstanceName

    @property
    def Offset(self):
        r"""偏移量，默认为0。关于Offset的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认为20，最大值为100。关于Limit的更进一步介绍请参考 API [简介](https://cloud.tencent.com/document/api/213/15688)中的相关小节。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def IpAddresses(self):
        r"""根据多个实例IP进行过滤
        :rtype: list of str
        """
        return self._IpAddresses

    @IpAddresses.setter
    def IpAddresses(self, IpAddresses):
        self._IpAddresses = IpAddresses


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._InstanceIds = params.get("InstanceIds")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._VagueIpAddress = params.get("VagueIpAddress")
        self._VagueInstanceName = params.get("VagueInstanceName")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._IpAddresses = params.get("IpAddresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExistedInstancesResponse(AbstractModel):
    r"""DescribeExistedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ExistedInstanceSet: 已经存在的实例信息数组。
        :type ExistedInstanceSet: list of ExistedInstance
        :param _TotalCount: 符合条件的实例数量。
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ExistedInstanceSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ExistedInstanceSet(self):
        r"""已经存在的实例信息数组。
        :rtype: list of ExistedInstance
        """
        return self._ExistedInstanceSet

    @ExistedInstanceSet.setter
    def ExistedInstanceSet(self, ExistedInstanceSet):
        self._ExistedInstanceSet = ExistedInstanceSet

    @property
    def TotalCount(self):
        r"""符合条件的实例数量。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ExistedInstanceSet") is not None:
            self._ExistedInstanceSet = []
            for item in params.get("ExistedInstanceSet"):
                obj = ExistedInstance()
                obj._deserialize(item)
                self._ExistedInstanceSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeExternalNodeSupportConfigRequest(AbstractModel):
    r"""DescribeExternalNodeSupportConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExternalNodeSupportConfigResponse(AbstractModel):
    r"""DescribeExternalNodeSupportConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterCIDR: 用于分配集群容器和服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突。且网段范围必须在内网网段内，例如:10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16。
        :type ClusterCIDR: str
        :param _NetworkType: 集群网络插件类型，支持：CiliumBGP、CiliumVXLan
        :type NetworkType: str
        :param _SubnetId: 子网ID
        :type SubnetId: str
        :param _Enabled: 是否开启第三方节点专线连接支持
        :type Enabled: bool
        :param _AS: 节点所属交换机的BGP AS 号
        :type AS: str
        :param _SwitchIP: 节点所属交换机的交换机 IP
        :type SwitchIP: str
        :param _Status: 开启第三方节点池状态
        :type Status: str
        :param _FailedReason: 如果开启失败原因
        :type FailedReason: str
        :param _Master: 内网访问地址
        :type Master: str
        :param _Proxy: 镜像仓库代理地址
        :type Proxy: str
        :param _Progress: 用于记录开启第三方节点的过程进行到哪一步了
注意：此字段可能返回 null，表示取不到有效值。
        :type Progress: list of Step
        :param _EnabledPublicConnect: 是否开启第三方节点公网连接支持
        :type EnabledPublicConnect: bool
        :param _PublicConnectUrl: 注册节点公网版公网连接地址
        :type PublicConnectUrl: str
        :param _PublicCustomDomain: 注册节点公网版自定义域名
        :type PublicCustomDomain: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ClusterCIDR = None
        self._NetworkType = None
        self._SubnetId = None
        self._Enabled = None
        self._AS = None
        self._SwitchIP = None
        self._Status = None
        self._FailedReason = None
        self._Master = None
        self._Proxy = None
        self._Progress = None
        self._EnabledPublicConnect = None
        self._PublicConnectUrl = None
        self._PublicCustomDomain = None
        self._RequestId = None

    @property
    def ClusterCIDR(self):
        r"""用于分配集群容器和服务 IP 的 CIDR，不得与 VPC CIDR 冲突，也不得与同 VPC 内其他集群 CIDR 冲突。且网段范围必须在内网网段内，例如:10.1.0.0/14, 192.168.0.1/18,172.16.0.0/16。
        :rtype: str
        """
        return self._ClusterCIDR

    @ClusterCIDR.setter
    def ClusterCIDR(self, ClusterCIDR):
        self._ClusterCIDR = ClusterCIDR

    @property
    def NetworkType(self):
        r"""集群网络插件类型，支持：CiliumBGP、CiliumVXLan
        :rtype: str
        """
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def SubnetId(self):
        r"""子网ID
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def Enabled(self):
        r"""是否开启第三方节点专线连接支持
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def AS(self):
        r"""节点所属交换机的BGP AS 号
        :rtype: str
        """
        return self._AS

    @AS.setter
    def AS(self, AS):
        self._AS = AS

    @property
    def SwitchIP(self):
        r"""节点所属交换机的交换机 IP
        :rtype: str
        """
        return self._SwitchIP

    @SwitchIP.setter
    def SwitchIP(self, SwitchIP):
        self._SwitchIP = SwitchIP

    @property
    def Status(self):
        r"""开启第三方节点池状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FailedReason(self):
        r"""如果开启失败原因
        :rtype: str
        """
        return self._FailedReason

    @FailedReason.setter
    def FailedReason(self, FailedReason):
        self._FailedReason = FailedReason

    @property
    def Master(self):
        r"""内网访问地址
        :rtype: str
        """
        return self._Master

    @Master.setter
    def Master(self, Master):
        self._Master = Master

    @property
    def Proxy(self):
        r"""镜像仓库代理地址
        :rtype: str
        """
        return self._Proxy

    @Proxy.setter
    def Proxy(self, Proxy):
        self._Proxy = Proxy

    @property
    def Progress(self):
        r"""用于记录开启第三方节点的过程进行到哪一步了
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Step
        """
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def EnabledPublicConnect(self):
        r"""是否开启第三方节点公网连接支持
        :rtype: bool
        """
        return self._EnabledPublicConnect

    @EnabledPublicConnect.setter
    def EnabledPublicConnect(self, EnabledPublicConnect):
        self._EnabledPublicConnect = EnabledPublicConnect

    @property
    def PublicConnectUrl(self):
        r"""注册节点公网版公网连接地址
        :rtype: str
        """
        return self._PublicConnectUrl

    @PublicConnectUrl.setter
    def PublicConnectUrl(self, PublicConnectUrl):
        self._PublicConnectUrl = PublicConnectUrl

    @property
    def PublicCustomDomain(self):
        r"""注册节点公网版自定义域名
        :rtype: str
        """
        return self._PublicCustomDomain

    @PublicCustomDomain.setter
    def PublicCustomDomain(self, PublicCustomDomain):
        self._PublicCustomDomain = PublicCustomDomain

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterCIDR = params.get("ClusterCIDR")
        self._NetworkType = params.get("NetworkType")
        self._SubnetId = params.get("SubnetId")
        self._Enabled = params.get("Enabled")
        self._AS = params.get("AS")
        self._SwitchIP = params.get("SwitchIP")
        self._Status = params.get("Status")
        self._FailedReason = params.get("FailedReason")
        self._Master = params.get("Master")
        self._Proxy = params.get("Proxy")
        if params.get("Progress") is not None:
            self._Progress = []
            for item in params.get("Progress"):
                obj = Step()
                obj._deserialize(item)
                self._Progress.append(obj)
        self._EnabledPublicConnect = params.get("EnabledPublicConnect")
        self._PublicConnectUrl = params.get("PublicConnectUrl")
        self._PublicCustomDomain = params.get("PublicCustomDomain")
        self._RequestId = params.get("RequestId")


class DescribeIPAMDRequest(AbstractModel):
    r"""DescribeIPAMD请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeIPAMDResponse(AbstractModel):
    r"""DescribeIPAMD返回参数结构体

    """

    def __init__(self):
        r"""
        :param _EnableIPAMD: 是否安装了eniipamd组件
        :type EnableIPAMD: bool
        :param _EnableCustomizedPodCidr: 是否开启自定义podcidr，默认为false，已安装eniipamd组件才意义
        :type EnableCustomizedPodCidr: bool
        :param _DisableVpcCniMode: 是否不开启vpccni模式，默认为false，已安装eniipamd组件才意义
        :type DisableVpcCniMode: bool
        :param _Phase: 组件状态，已安装eniipamd组件才会有值
        :type Phase: str
        :param _Reason: 错误信息，已安装eniipamd组件且状态为非running才会有错误信息
        :type Reason: str
        :param _SubnetIds: 子网信息，已安装eniipamd组件才会有值
注意：此字段可能返回 null，表示取不到有效值。
        :type SubnetIds: list of str
        :param _ClaimExpiredDuration: 固定ip回收时间，已安装eniipamd组件才会有值
        :type ClaimExpiredDuration: str
        :param _EnableTrunkingENI: 是否开启了中继网卡模式
        :type EnableTrunkingENI: bool
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._EnableIPAMD = None
        self._EnableCustomizedPodCidr = None
        self._DisableVpcCniMode = None
        self._Phase = None
        self._Reason = None
        self._SubnetIds = None
        self._ClaimExpiredDuration = None
        self._EnableTrunkingENI = None
        self._RequestId = None

    @property
    def EnableIPAMD(self):
        r"""是否安装了eniipamd组件
        :rtype: bool
        """
        return self._EnableIPAMD

    @EnableIPAMD.setter
    def EnableIPAMD(self, EnableIPAMD):
        self._EnableIPAMD = EnableIPAMD

    @property
    def EnableCustomizedPodCidr(self):
        r"""是否开启自定义podcidr，默认为false，已安装eniipamd组件才意义
        :rtype: bool
        """
        return self._EnableCustomizedPodCidr

    @EnableCustomizedPodCidr.setter
    def EnableCustomizedPodCidr(self, EnableCustomizedPodCidr):
        self._EnableCustomizedPodCidr = EnableCustomizedPodCidr

    @property
    def DisableVpcCniMode(self):
        r"""是否不开启vpccni模式，默认为false，已安装eniipamd组件才意义
        :rtype: bool
        """
        return self._DisableVpcCniMode

    @DisableVpcCniMode.setter
    def DisableVpcCniMode(self, DisableVpcCniMode):
        self._DisableVpcCniMode = DisableVpcCniMode

    @property
    def Phase(self):
        r"""组件状态，已安装eniipamd组件才会有值
        :rtype: str
        """
        return self._Phase

    @Phase.setter
    def Phase(self, Phase):
        self._Phase = Phase

    @property
    def Reason(self):
        r"""错误信息，已安装eniipamd组件且状态为非running才会有错误信息
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def SubnetIds(self):
        r"""子网信息，已安装eniipamd组件才会有值
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def ClaimExpiredDuration(self):
        r"""固定ip回收时间，已安装eniipamd组件才会有值
        :rtype: str
        """
        return self._ClaimExpiredDuration

    @ClaimExpiredDuration.setter
    def ClaimExpiredDuration(self, ClaimExpiredDuration):
        self._ClaimExpiredDuration = ClaimExpiredDuration

    @property
    def EnableTrunkingENI(self):
        r"""是否开启了中继网卡模式
        :rtype: bool
        """
        return self._EnableTrunkingENI

    @EnableTrunkingENI.setter
    def EnableTrunkingENI(self, EnableTrunkingENI):
        self._EnableTrunkingENI = EnableTrunkingENI

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EnableIPAMD = params.get("EnableIPAMD")
        self._EnableCustomizedPodCidr = params.get("EnableCustomizedPodCidr")
        self._DisableVpcCniMode = params.get("DisableVpcCniMode")
        self._Phase = params.get("Phase")
        self._Reason = params.get("Reason")
        self._SubnetIds = params.get("SubnetIds")
        self._ClaimExpiredDuration = params.get("ClaimExpiredDuration")
        self._EnableTrunkingENI = params.get("EnableTrunkingENI")
        self._RequestId = params.get("RequestId")


class DescribeImageCachesRequest(AbstractModel):
    r"""DescribeImageCaches请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ImageCacheIds: 镜像缓存Id数组
        :type ImageCacheIds: list of str
        :param _ImageCacheNames: 镜像缓存名称数组
        :type ImageCacheNames: list of str
        :param _Limit: 限定此次返回资源的数量。如果不设定，默认返回20，最大不能超过50
        :type Limit: int
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Filters: 过滤条件，可选条件：
(1)实例名称
KeyName: image-cache-name
类型：String
        :type Filters: list of Filter
        """
        self._ImageCacheIds = None
        self._ImageCacheNames = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def ImageCacheIds(self):
        r"""镜像缓存Id数组
        :rtype: list of str
        """
        return self._ImageCacheIds

    @ImageCacheIds.setter
    def ImageCacheIds(self, ImageCacheIds):
        self._ImageCacheIds = ImageCacheIds

    @property
    def ImageCacheNames(self):
        r"""镜像缓存名称数组
        :rtype: list of str
        """
        return self._ImageCacheNames

    @ImageCacheNames.setter
    def ImageCacheNames(self, ImageCacheNames):
        self._ImageCacheNames = ImageCacheNames

    @property
    def Limit(self):
        r"""限定此次返回资源的数量。如果不设定，默认返回20，最大不能超过50
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        r"""过滤条件，可选条件：
(1)实例名称
KeyName: image-cache-name
类型：String
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ImageCacheIds = params.get("ImageCacheIds")
        self._ImageCacheNames = params.get("ImageCacheNames")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageCachesResponse(AbstractModel):
    r"""DescribeImageCaches返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 镜像缓存总数
        :type TotalCount: int
        :param _ImageCaches: 镜像缓存信息列表
        :type ImageCaches: list of ImageCache
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageCaches = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""镜像缓存总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageCaches(self):
        r"""镜像缓存信息列表
        :rtype: list of ImageCache
        """
        return self._ImageCaches

    @ImageCaches.setter
    def ImageCaches(self, ImageCaches):
        self._ImageCaches = ImageCaches

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageCaches") is not None:
            self._ImageCaches = []
            for item in params.get("ImageCaches"):
                obj = ImageCache()
                obj._deserialize(item)
                self._ImageCaches.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImagesRequest(AbstractModel):
    r"""DescribeImages请求参数结构体

    """


class DescribeImagesResponse(AbstractModel):
    r"""DescribeImages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 镜像数量
        :type TotalCount: int
        :param _ImageInstanceSet: 镜像信息列表
        :type ImageInstanceSet: list of ImageInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""镜像数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageInstanceSet(self):
        r"""镜像信息列表
        :rtype: list of ImageInstance
        """
        return self._ImageInstanceSet

    @ImageInstanceSet.setter
    def ImageInstanceSet(self, ImageInstanceSet):
        self._ImageInstanceSet = ImageInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageInstanceSet") is not None:
            self._ImageInstanceSet = []
            for item in params.get("ImageInstanceSet"):
                obj = ImageInstance()
                obj._deserialize(item)
                self._ImageInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogConfigsRequest(AbstractModel):
    r"""DescribeLogConfigs请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterType: 当前集群类型支持tke、eks。默认为tke
        :type ClusterType: str
        :param _LogConfigNames: 按照采集规则名称查找，多个采集规则使用 "," 分隔。
        :type LogConfigNames: str
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Limit: 最大输出条数，默认20，最大为100
        :type Limit: int
        """
        self._ClusterId = None
        self._ClusterType = None
        self._LogConfigNames = None
        self._Offset = None
        self._Limit = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterType(self):
        r"""当前集群类型支持tke、eks。默认为tke
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def LogConfigNames(self):
        r"""按照采集规则名称查找，多个采集规则使用 "," 分隔。
        :rtype: str
        """
        return self._LogConfigNames

    @LogConfigNames.setter
    def LogConfigNames(self, LogConfigNames):
        self._LogConfigNames = LogConfigNames

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""最大输出条数，默认20，最大为100
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterType = params.get("ClusterType")
        self._LogConfigNames = params.get("LogConfigNames")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogConfigsResponse(AbstractModel):
    r"""DescribeLogConfigs返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 分页查找时返回采集规则总数
        :type Total: int
        :param _Message: 指定采集规则名称查找，部分失败时返回失败采集规则名称及最后一个失败原因
        :type Message: str
        :param _LogConfigs: 采集规则查询结果
        :type LogConfigs: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Message = None
        self._LogConfigs = None
        self._RequestId = None

    @property
    def Total(self):
        r"""分页查找时返回采集规则总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Message(self):
        r"""指定采集规则名称查找，部分失败时返回失败采集规则名称及最后一个失败原因
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def LogConfigs(self):
        r"""采集规则查询结果
        :rtype: str
        """
        return self._LogConfigs

    @LogConfigs.setter
    def LogConfigs(self, LogConfigs):
        self._LogConfigs = LogConfigs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        self._Message = params.get("Message")
        self._LogConfigs = params.get("LogConfigs")
        self._RequestId = params.get("RequestId")


class DescribeLogSwitchesRequest(AbstractModel):
    r"""DescribeLogSwitches请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 集群ID列表
        :type ClusterIds: list of str
        :param _ClusterType: 集群类型，tke 或eks
        :type ClusterType: str
        """
        self._ClusterIds = None
        self._ClusterType = None

    @property
    def ClusterIds(self):
        r"""集群ID列表
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def ClusterType(self):
        r"""集群类型，tke 或eks
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLogSwitchesResponse(AbstractModel):
    r"""DescribeLogSwitches返回参数结构体

    """

    def __init__(self):
        r"""
        :param _SwitchSet: 集群日志开关集合
注意：此字段可能返回 null，表示取不到有效值。
        :type SwitchSet: list of Switch
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._SwitchSet = None
        self._RequestId = None

    @property
    def SwitchSet(self):
        r"""集群日志开关集合
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Switch
        """
        return self._SwitchSet

    @SwitchSet.setter
    def SwitchSet(self, SwitchSet):
        self._SwitchSet = SwitchSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SwitchSet") is not None:
            self._SwitchSet = []
            for item in params.get("SwitchSet"):
                obj = Switch()
                obj._deserialize(item)
                self._SwitchSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMasterComponentRequest(AbstractModel):
    r"""DescribeMasterComponent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Component: master组件名称，支持kube-apiserver、kube-scheduler、kube-controller-manager
        :type Component: str
        """
        self._ClusterId = None
        self._Component = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Component(self):
        r"""master组件名称，支持kube-apiserver、kube-scheduler、kube-controller-manager
        :rtype: str
        """
        return self._Component

    @Component.setter
    def Component(self, Component):
        self._Component = Component


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Component = params.get("Component")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMasterComponentResponse(AbstractModel):
    r"""DescribeMasterComponent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Component: master组件名称
        :type Component: str
        :param _Status: master组件状态，三种状态：running、updating、shutdown
        :type Status: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Component = None
        self._Status = None
        self._RequestId = None

    @property
    def Component(self):
        r"""master组件名称
        :rtype: str
        """
        return self._Component

    @Component.setter
    def Component(self, Component):
        self._Component = Component

    @property
    def Status(self):
        r"""master组件状态，三种状态：running、updating、shutdown
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Component = params.get("Component")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeOSImagesRequest(AbstractModel):
    r"""DescribeOSImages请求参数结构体

    """


class DescribeOSImagesResponse(AbstractModel):
    r"""DescribeOSImages返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OSImageSeriesSet: 镜像信息列表
        :type OSImageSeriesSet: list of OSImage
        :param _TotalCount: 镜像数量
        :type TotalCount: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OSImageSeriesSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def OSImageSeriesSet(self):
        r"""镜像信息列表
        :rtype: list of OSImage
        """
        return self._OSImageSeriesSet

    @OSImageSeriesSet.setter
    def OSImageSeriesSet(self, OSImageSeriesSet):
        self._OSImageSeriesSet = OSImageSeriesSet

    @property
    def TotalCount(self):
        r"""镜像数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OSImageSeriesSet") is not None:
            self._OSImageSeriesSet = []
            for item in params.get("OSImageSeriesSet"):
                obj = OSImage()
                obj._deserialize(item)
                self._OSImageSeriesSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeOpenPolicyListRequest(AbstractModel):
    r"""DescribeOpenPolicyList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Category: 策略分类 基线：baseline 优选：priority 可选：optional
        :type Category: str
        """
        self._ClusterId = None
        self._Category = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Category(self):
        r"""策略分类 基线：baseline 优选：priority 可选：optional
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Category = params.get("Category")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeOpenPolicyListResponse(AbstractModel):
    r"""DescribeOpenPolicyList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OpenPolicyInfoList: 策略信息列表
        :type OpenPolicyInfoList: list of OpenPolicyInfo
        :param _GatekeeperStatus: 集群内是否安装了gatekeeper addon
        :type GatekeeperStatus: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OpenPolicyInfoList = None
        self._GatekeeperStatus = None
        self._RequestId = None

    @property
    def OpenPolicyInfoList(self):
        r"""策略信息列表
        :rtype: list of OpenPolicyInfo
        """
        return self._OpenPolicyInfoList

    @OpenPolicyInfoList.setter
    def OpenPolicyInfoList(self, OpenPolicyInfoList):
        self._OpenPolicyInfoList = OpenPolicyInfoList

    @property
    def GatekeeperStatus(self):
        r"""集群内是否安装了gatekeeper addon
        :rtype: int
        """
        return self._GatekeeperStatus

    @GatekeeperStatus.setter
    def GatekeeperStatus(self, GatekeeperStatus):
        self._GatekeeperStatus = GatekeeperStatus

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OpenPolicyInfoList") is not None:
            self._OpenPolicyInfoList = []
            for item in params.get("OpenPolicyInfoList"):
                obj = OpenPolicyInfo()
                obj._deserialize(item)
                self._OpenPolicyInfoList.append(obj)
        self._GatekeeperStatus = params.get("GatekeeperStatus")
        self._RequestId = params.get("RequestId")


class DescribePodChargeInfoRequest(AbstractModel):
    r"""DescribePodChargeInfo请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群 ID。TKE 集群可通过 [DescribeClusters](https://cloud.tencent.com/document/api/457/31862) 接口返回值中的ClusterId获取。
        :type ClusterId: str
        :param _Namespace: 命名空间
        :type Namespace: str
        :param _Name: Pod名称
        :type Name: str
        :param _Uids: Pod的Uid，可以通过Uids 来批量查询，也可以通过 Namespace 和 Name 来查询某个 Pod 的计费信息。Uids 不传时，Namespace 和 Name 必须同时传。
        :type Uids: list of str
        """
        self._ClusterId = None
        self._Namespace = None
        self._Name = None
        self._Uids = None

    @property
    def ClusterId(self):
        r"""集群 ID。TKE 集群可通过 [DescribeClusters](https://cloud.tencent.com/document/api/457/31862) 接口返回值中的ClusterId获取。
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Namespace(self):
        r"""命名空间
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Name(self):
        r"""Pod名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Uids(self):
        r"""Pod的Uid，可以通过Uids 来批量查询，也可以通过 Namespace 和 Name 来查询某个 Pod 的计费信息。Uids 不传时，Namespace 和 Name 必须同时传。
        :rtype: list of str
        """
        return self._Uids

    @Uids.setter
    def Uids(self, Uids):
        self._Uids = Uids


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Namespace = params.get("Namespace")
        self._Name = params.get("Name")
        self._Uids = params.get("Uids")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePodChargeInfoResponse(AbstractModel):
    r"""DescribePodChargeInfo返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ChargeInfoSet: Pod计费信息
        :type ChargeInfoSet: list of PodChargeInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ChargeInfoSet = None
        self._RequestId = None

    @property
    def ChargeInfoSet(self):
        r"""Pod计费信息
        :rtype: list of PodChargeInfo
        """
        return self._ChargeInfoSet

    @ChargeInfoSet.setter
    def ChargeInfoSet(self, ChargeInfoSet):
        self._ChargeInfoSet = ChargeInfoSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ChargeInfoSet") is not None:
            self._ChargeInfoSet = []
            for item in params.get("ChargeInfoSet"):
                obj = PodChargeInfo()
                obj._deserialize(item)
                self._ChargeInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePodDeductionRateRequest(AbstractModel):
    r"""DescribePodDeductionRate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Zone: 可用区
        :type Zone: str
        :param _ClusterId: 集群 ID
        :type ClusterId: str
        :param _NodeName: 节点 ID
        :type NodeName: str
        """
        self._Zone = None
        self._ClusterId = None
        self._NodeName = None

    @property
    def Zone(self):
        r"""可用区
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ClusterId(self):
        r"""集群 ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodeName(self):
        r"""节点 ID
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._ClusterId = params.get("ClusterId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePodDeductionRateResponse(AbstractModel):
    r"""DescribePodDeductionRate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PodDeductionRateSet: 各个规格的 可被预留券抵扣的Pod 抵扣率
        :type PodDeductionRateSet: list of PodDeductionRate
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PodDeductionRateSet = None
        self._RequestId = None

    @property
    def PodDeductionRateSet(self):
        r"""各个规格的 可被预留券抵扣的Pod 抵扣率
        :rtype: list of PodDeductionRate
        """
        return self._PodDeductionRateSet

    @PodDeductionRateSet.setter
    def PodDeductionRateSet(self, PodDeductionRateSet):
        self._PodDeductionRateSet = PodDeductionRateSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PodDeductionRateSet") is not None:
            self._PodDeductionRateSet = []
            for item in params.get("PodDeductionRateSet"):
                obj = PodDeductionRate()
                obj._deserialize(item)
                self._PodDeductionRateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePodsBySpecRequest(AbstractModel):
    r"""DescribePodsBySpec请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Cpu: 核数
        :type Cpu: float
        :param _Memory: 内存，单位：GiB
        :type Memory: float
        :param _GpuNum: 卡数，有0.25、0.5、1、2、4和8
        :type GpuNum: str
        :param _Zone: 可用区
        :type Zone: str
        :param _ClusterId: 集群 ID
        :type ClusterId: str
        :param _NodeName: 节点 ID
        :type NodeName: str
        :param _Offset: 偏移量，默认0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _Filters: pod-type
按照**【Pod 类型**】进行过滤。资源类型：intel、amd、v100、t4、a10\*gnv4、a10\*gnv4v等。
类型：String
必选：否

pod-deduct
按照**【上个周期抵扣的Pod**】进行过滤。Values可不设置。
必选：否

pod-not-deduct
按照**【上个周期未抵扣的Pod**】进行过滤。Values可不设置。
必选：否
        :type Filters: list of Filter
        """
        self._Cpu = None
        self._Memory = None
        self._GpuNum = None
        self._Zone = None
        self._ClusterId = None
        self._NodeName = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Cpu(self):
        r"""核数
        :rtype: float
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def Memory(self):
        r"""内存，单位：GiB
        :rtype: float
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def GpuNum(self):
        r"""卡数，有0.25、0.5、1、2、4和8
        :rtype: str
        """
        return self._GpuNum

    @GpuNum.setter
    def GpuNum(self, GpuNum):
        self._GpuNum = GpuNum

    @property
    def Zone(self):
        r"""可用区
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ClusterId(self):
        r"""集群 ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodeName(self):
        r"""节点 ID
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Offset(self):
        r"""偏移量，默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""pod-type
按照**【Pod 类型**】进行过滤。资源类型：intel、amd、v100、t4、a10\*gnv4、a10\*gnv4v等。
类型：String
必选：否

pod-deduct
按照**【上个周期抵扣的Pod**】进行过滤。Values可不设置。
必选：否

pod-not-deduct
按照**【上个周期未抵扣的Pod**】进行过滤。Values可不设置。
必选：否
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Cpu = params.get("Cpu")
        self._Memory = params.get("Memory")
        self._GpuNum = params.get("GpuNum")
        self._Zone = params.get("Zone")
        self._ClusterId = params.get("ClusterId")
        self._NodeName = params.get("NodeName")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePodsBySpecResponse(AbstractModel):
    r"""DescribePodsBySpec返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: Pod 总数
        :type TotalCount: int
        :param _PodSet: Pod 节点信息
        :type PodSet: list of PodNodeInfo
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PodSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""Pod 总数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PodSet(self):
        r"""Pod 节点信息
        :rtype: list of PodNodeInfo
        """
        return self._PodSet

    @PodSet.setter
    def PodSet(self, PodSet):
        self._PodSet = PodSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PodSet") is not None:
            self._PodSet = []
            for item in params.get("PodSet"):
                obj = PodNodeInfo()
                obj._deserialize(item)
                self._PodSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePostNodeResourcesRequest(AbstractModel):
    r"""DescribePostNodeResources请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群 ID
        :type ClusterId: str
        :param _NodeName:  节点名称
        :type NodeName: str
        """
        self._ClusterId = None
        self._NodeName = None

    @property
    def ClusterId(self):
        r"""集群 ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodeName(self):
        r""" 节点名称
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePostNodeResourcesResponse(AbstractModel):
    r"""DescribePostNodeResources返回参数结构体

    """

    def __init__(self):
        r"""
        :param _PodSet: Pod详情
        :type PodSet: list of SuperNodeResource
        :param _ReservedInstanceSet: 预留券详情
        :type ReservedInstanceSet: list of SuperNodeResource
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._PodSet = None
        self._ReservedInstanceSet = None
        self._RequestId = None

    @property
    def PodSet(self):
        r"""Pod详情
        :rtype: list of SuperNodeResource
        """
        return self._PodSet

    @PodSet.setter
    def PodSet(self, PodSet):
        self._PodSet = PodSet

    @property
    def ReservedInstanceSet(self):
        r"""预留券详情
        :rtype: list of SuperNodeResource
        """
        return self._ReservedInstanceSet

    @ReservedInstanceSet.setter
    def ReservedInstanceSet(self, ReservedInstanceSet):
        self._ReservedInstanceSet = ReservedInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PodSet") is not None:
            self._PodSet = []
            for item in params.get("PodSet"):
                obj = SuperNodeResource()
                obj._deserialize(item)
                self._PodSet.append(obj)
        if params.get("ReservedInstanceSet") is not None:
            self._ReservedInstanceSet = []
            for item in params.get("ReservedInstanceSet"):
                obj = SuperNodeResource()
                obj._deserialize(item)
                self._ReservedInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrometheusAgentInstancesRequest(AbstractModel):
    r"""DescribePrometheusAgentInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
可以是tke, eks, edge的集群id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群id
可以是tke, eks, edge的集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusAgentInstancesResponse(AbstractModel):
    r"""DescribePrometheusAgentInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 关联该集群的实例列表
注意：此字段可能返回 null，表示取不到有效值。
        :type Instances: list of str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Instances = None
        self._RequestId = None

    @property
    def Instances(self):
        r"""关联该集群的实例列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Instances = params.get("Instances")
        self._RequestId = params.get("RequestId")


class DescribePrometheusAgentsRequest(AbstractModel):
    r"""DescribePrometheusAgents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Offset: 用于分页
        :type Offset: int
        :param _Limit: 用于分页
        :type Limit: int
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""用于分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""用于分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusAgentsResponse(AbstractModel):
    r"""DescribePrometheusAgents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Agents: 被关联集群信息
        :type Agents: list of PrometheusAgentOverview
        :param _Total: 被关联集群总量
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Agents = None
        self._Total = None
        self._RequestId = None

    @property
    def Agents(self):
        r"""被关联集群信息
        :rtype: list of PrometheusAgentOverview
        """
        return self._Agents

    @Agents.setter
    def Agents(self, Agents):
        self._Agents = Agents

    @property
    def Total(self):
        r"""被关联集群总量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Agents") is not None:
            self._Agents = []
            for item in params.get("Agents"):
                obj = PrometheusAgentOverview()
                obj._deserialize(item)
                self._Agents.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusAlertHistoryRequest(AbstractModel):
    r"""DescribePrometheusAlertHistory请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _RuleName: 告警名称
        :type RuleName: str
        :param _StartTime: 开始时间
        :type StartTime: str
        :param _EndTime: 结束时间
        :type EndTime: str
        :param _Labels: label集合
        :type Labels: str
        :param _Offset: 分片
        :type Offset: int
        :param _Limit: 分片
        :type Limit: int
        """
        self._InstanceId = None
        self._RuleName = None
        self._StartTime = None
        self._EndTime = None
        self._Labels = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def RuleName(self):
        r"""告警名称
        :rtype: str
        """
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def StartTime(self):
        r"""开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Labels(self):
        r"""label集合
        :rtype: str
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Offset(self):
        r"""分片
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分片
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._RuleName = params.get("RuleName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._Labels = params.get("Labels")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusAlertHistoryResponse(AbstractModel):
    r"""DescribePrometheusAlertHistory返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Items: 告警历史
        :type Items: list of PrometheusAlertHistoryItem
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Items = None
        self._Total = None
        self._RequestId = None

    @property
    def Items(self):
        r"""告警历史
        :rtype: list of PrometheusAlertHistoryItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = PrometheusAlertHistoryItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusAlertPolicyRequest(AbstractModel):
    r"""DescribePrometheusAlertPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 分页
        :type Limit: int
        :param _Filters: 过滤
支持ID，Name
        :type Filters: list of Filter
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤
支持ID，Name
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusAlertPolicyResponse(AbstractModel):
    r"""DescribePrometheusAlertPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlertRules: 告警详情
注意：此字段可能返回 null，表示取不到有效值。
        :type AlertRules: list of PrometheusAlertPolicyItem
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlertRules = None
        self._Total = None
        self._RequestId = None

    @property
    def AlertRules(self):
        r"""告警详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PrometheusAlertPolicyItem
        """
        return self._AlertRules

    @AlertRules.setter
    def AlertRules(self, AlertRules):
        self._AlertRules = AlertRules

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlertRules") is not None:
            self._AlertRules = []
            for item in params.get("AlertRules"):
                obj = PrometheusAlertPolicyItem()
                obj._deserialize(item)
                self._AlertRules.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusAlertRuleRequest(AbstractModel):
    r"""DescribePrometheusAlertRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 分页
        :type Limit: int
        :param _Filters: 过滤
支持ID，Name
        :type Filters: list of Filter
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤
支持ID，Name
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusAlertRuleResponse(AbstractModel):
    r"""DescribePrometheusAlertRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AlertRules: 告警详情
        :type AlertRules: list of PrometheusAlertRuleDetail
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AlertRules = None
        self._Total = None
        self._RequestId = None

    @property
    def AlertRules(self):
        r"""告警详情
        :rtype: list of PrometheusAlertRuleDetail
        """
        return self._AlertRules

    @AlertRules.setter
    def AlertRules(self, AlertRules):
        self._AlertRules = AlertRules

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AlertRules") is not None:
            self._AlertRules = []
            for item in params.get("AlertRules"):
                obj = PrometheusAlertRuleDetail()
                obj._deserialize(item)
                self._AlertRules.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusClusterAgentsRequest(AbstractModel):
    r"""DescribePrometheusClusterAgents请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Offset: 用于分页
        :type Offset: int
        :param _Limit: 用于分页
        :type Limit: int
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""用于分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""用于分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusClusterAgentsResponse(AbstractModel):
    r"""DescribePrometheusClusterAgents返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Agents: 被关联集群信息
        :type Agents: list of PrometheusAgentOverview
        :param _Total: 被关联集群总量
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Agents = None
        self._Total = None
        self._RequestId = None

    @property
    def Agents(self):
        r"""被关联集群信息
        :rtype: list of PrometheusAgentOverview
        """
        return self._Agents

    @Agents.setter
    def Agents(self, Agents):
        self._Agents = Agents

    @property
    def Total(self):
        r"""被关联集群总量
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Agents") is not None:
            self._Agents = []
            for item in params.get("Agents"):
                obj = PrometheusAgentOverview()
                obj._deserialize(item)
                self._Agents.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusConfigRequest(AbstractModel):
    r"""DescribePrometheusConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        """
        self._InstanceId = None
        self._ClusterId = None
        self._ClusterType = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterId = params.get("ClusterId")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusConfigResponse(AbstractModel):
    r"""DescribePrometheusConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Config: 全局配置
        :type Config: str
        :param _ServiceMonitors: ServiceMonitor配置
        :type ServiceMonitors: list of PrometheusConfigItem
        :param _PodMonitors: PodMonitor配置
        :type PodMonitors: list of PrometheusConfigItem
        :param _RawJobs: 原生Job
        :type RawJobs: list of PrometheusConfigItem
        :param _Probes: Probe配置
        :type Probes: list of PrometheusConfigItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Config = None
        self._ServiceMonitors = None
        self._PodMonitors = None
        self._RawJobs = None
        self._Probes = None
        self._RequestId = None

    @property
    def Config(self):
        r"""全局配置
        :rtype: str
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ServiceMonitors(self):
        r"""ServiceMonitor配置
        :rtype: list of PrometheusConfigItem
        """
        return self._ServiceMonitors

    @ServiceMonitors.setter
    def ServiceMonitors(self, ServiceMonitors):
        self._ServiceMonitors = ServiceMonitors

    @property
    def PodMonitors(self):
        r"""PodMonitor配置
        :rtype: list of PrometheusConfigItem
        """
        return self._PodMonitors

    @PodMonitors.setter
    def PodMonitors(self, PodMonitors):
        self._PodMonitors = PodMonitors

    @property
    def RawJobs(self):
        r"""原生Job
        :rtype: list of PrometheusConfigItem
        """
        return self._RawJobs

    @RawJobs.setter
    def RawJobs(self, RawJobs):
        self._RawJobs = RawJobs

    @property
    def Probes(self):
        r"""Probe配置
        :rtype: list of PrometheusConfigItem
        """
        return self._Probes

    @Probes.setter
    def Probes(self, Probes):
        self._Probes = Probes

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Config = params.get("Config")
        if params.get("ServiceMonitors") is not None:
            self._ServiceMonitors = []
            for item in params.get("ServiceMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._ServiceMonitors.append(obj)
        if params.get("PodMonitors") is not None:
            self._PodMonitors = []
            for item in params.get("PodMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._PodMonitors.append(obj)
        if params.get("RawJobs") is not None:
            self._RawJobs = []
            for item in params.get("RawJobs"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._RawJobs.append(obj)
        if params.get("Probes") is not None:
            self._Probes = []
            for item in params.get("Probes"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._Probes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrometheusGlobalConfigRequest(AbstractModel):
    r"""DescribePrometheusGlobalConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例级别抓取配置
        :type InstanceId: str
        :param _DisableStatistics: 是否禁用统计
        :type DisableStatistics: bool
        """
        self._InstanceId = None
        self._DisableStatistics = None

    @property
    def InstanceId(self):
        r"""实例级别抓取配置
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def DisableStatistics(self):
        r"""是否禁用统计
        :rtype: bool
        """
        return self._DisableStatistics

    @DisableStatistics.setter
    def DisableStatistics(self, DisableStatistics):
        self._DisableStatistics = DisableStatistics


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._DisableStatistics = params.get("DisableStatistics")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusGlobalConfigResponse(AbstractModel):
    r"""DescribePrometheusGlobalConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Config: 配置内容
        :type Config: str
        :param _ServiceMonitors: ServiceMonitors列表以及对应targets信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ServiceMonitors: list of PrometheusConfigItem
        :param _PodMonitors: PodMonitors列表以及对应targets信息
注意：此字段可能返回 null，表示取不到有效值。
        :type PodMonitors: list of PrometheusConfigItem
        :param _RawJobs: RawJobs列表以及对应targets信息
注意：此字段可能返回 null，表示取不到有效值。
        :type RawJobs: list of PrometheusConfigItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Config = None
        self._ServiceMonitors = None
        self._PodMonitors = None
        self._RawJobs = None
        self._RequestId = None

    @property
    def Config(self):
        r"""配置内容
        :rtype: str
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ServiceMonitors(self):
        r"""ServiceMonitors列表以及对应targets信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PrometheusConfigItem
        """
        return self._ServiceMonitors

    @ServiceMonitors.setter
    def ServiceMonitors(self, ServiceMonitors):
        self._ServiceMonitors = ServiceMonitors

    @property
    def PodMonitors(self):
        r"""PodMonitors列表以及对应targets信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PrometheusConfigItem
        """
        return self._PodMonitors

    @PodMonitors.setter
    def PodMonitors(self, PodMonitors):
        self._PodMonitors = PodMonitors

    @property
    def RawJobs(self):
        r"""RawJobs列表以及对应targets信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PrometheusConfigItem
        """
        return self._RawJobs

    @RawJobs.setter
    def RawJobs(self, RawJobs):
        self._RawJobs = RawJobs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Config = params.get("Config")
        if params.get("ServiceMonitors") is not None:
            self._ServiceMonitors = []
            for item in params.get("ServiceMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._ServiceMonitors.append(obj)
        if params.get("PodMonitors") is not None:
            self._PodMonitors = []
            for item in params.get("PodMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._PodMonitors.append(obj)
        if params.get("RawJobs") is not None:
            self._RawJobs = []
            for item in params.get("RawJobs"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._RawJobs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrometheusGlobalNotificationRequest(AbstractModel):
    r"""DescribePrometheusGlobalNotification请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusGlobalNotificationResponse(AbstractModel):
    r"""DescribePrometheusGlobalNotification返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Notification: 全局告警通知渠道
注意：此字段可能返回 null，表示取不到有效值。
        :type Notification: :class:`tencentcloud.tke.v20180525.models.PrometheusNotificationItem`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Notification = None
        self._RequestId = None

    @property
    def Notification(self):
        r"""全局告警通知渠道
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusNotificationItem`
        """
        return self._Notification

    @Notification.setter
    def Notification(self, Notification):
        self._Notification = Notification

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Notification") is not None:
            self._Notification = PrometheusNotificationItem()
            self._Notification._deserialize(params.get("Notification"))
        self._RequestId = params.get("RequestId")


class DescribePrometheusInstanceInitStatusRequest(AbstractModel):
    r"""DescribePrometheusInstanceInitStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusInstanceInitStatusResponse(AbstractModel):
    r"""DescribePrometheusInstanceInitStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Status: 实例初始化状态，取值：
uninitialized 未初始化 
initializing 初始化中
running 初始化完成，运行中
注意：此字段可能返回 null，表示取不到有效值。
        :type Status: str
        :param _Steps: 初始化任务步骤
注意：此字段可能返回 null，表示取不到有效值。
        :type Steps: list of TaskStepInfo
        :param _EksClusterId: 实例eks集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :type EksClusterId: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Status = None
        self._Steps = None
        self._EksClusterId = None
        self._RequestId = None

    @property
    def Status(self):
        r"""实例初始化状态，取值：
uninitialized 未初始化 
initializing 初始化中
running 初始化完成，运行中
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Steps(self):
        r"""初始化任务步骤
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TaskStepInfo
        """
        return self._Steps

    @Steps.setter
    def Steps(self, Steps):
        self._Steps = Steps

    @property
    def EksClusterId(self):
        r"""实例eks集群ID
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EksClusterId

    @EksClusterId.setter
    def EksClusterId(self, EksClusterId):
        self._EksClusterId = EksClusterId

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        if params.get("Steps") is not None:
            self._Steps = []
            for item in params.get("Steps"):
                obj = TaskStepInfo()
                obj._deserialize(item)
                self._Steps.append(obj)
        self._EksClusterId = params.get("EksClusterId")
        self._RequestId = params.get("RequestId")


class DescribePrometheusInstanceRequest(AbstractModel):
    r"""DescribePrometheusInstance请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        """
        self._InstanceId = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusInstanceResponse(AbstractModel):
    r"""DescribePrometheusInstance返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Name: 实例名称
        :type Name: str
        :param _VpcId: 私有网络id
        :type VpcId: str
        :param _SubnetId: 子网id
        :type SubnetId: str
        :param _COSBucket: cos桶名称
        :type COSBucket: str
        :param _QueryAddress: 数据查询地址
        :type QueryAddress: str
        :param _Grafana: 实例中grafana相关的信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Grafana: :class:`tencentcloud.tke.v20180525.models.PrometheusGrafanaInfo`
        :param _AlertManagerUrl: 用户自定义alertmanager
注意：此字段可能返回 null，表示取不到有效值。
        :type AlertManagerUrl: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InstanceId = None
        self._Name = None
        self._VpcId = None
        self._SubnetId = None
        self._COSBucket = None
        self._QueryAddress = None
        self._Grafana = None
        self._AlertManagerUrl = None
        self._RequestId = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Name(self):
        r"""实例名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VpcId(self):
        r"""私有网络id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetId(self):
        r"""子网id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def COSBucket(self):
        r"""cos桶名称
        :rtype: str
        """
        return self._COSBucket

    @COSBucket.setter
    def COSBucket(self, COSBucket):
        self._COSBucket = COSBucket

    @property
    def QueryAddress(self):
        r"""数据查询地址
        :rtype: str
        """
        return self._QueryAddress

    @QueryAddress.setter
    def QueryAddress(self, QueryAddress):
        self._QueryAddress = QueryAddress

    @property
    def Grafana(self):
        r"""实例中grafana相关的信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusGrafanaInfo`
        """
        return self._Grafana

    @Grafana.setter
    def Grafana(self, Grafana):
        self._Grafana = Grafana

    @property
    def AlertManagerUrl(self):
        r"""用户自定义alertmanager
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._AlertManagerUrl

    @AlertManagerUrl.setter
    def AlertManagerUrl(self, AlertManagerUrl):
        self._AlertManagerUrl = AlertManagerUrl

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Name = params.get("Name")
        self._VpcId = params.get("VpcId")
        self._SubnetId = params.get("SubnetId")
        self._COSBucket = params.get("COSBucket")
        self._QueryAddress = params.get("QueryAddress")
        if params.get("Grafana") is not None:
            self._Grafana = PrometheusGrafanaInfo()
            self._Grafana._deserialize(params.get("Grafana"))
        self._AlertManagerUrl = params.get("AlertManagerUrl")
        self._RequestId = params.get("RequestId")


class DescribePrometheusInstancesOverviewRequest(AbstractModel):
    r"""DescribePrometheusInstancesOverview请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 用于分页
        :type Offset: int
        :param _Limit: 用于分页
        :type Limit: int
        :param _Filters: 过滤实例，目前支持：
ID: 通过实例ID来过滤 
Name: 通过实例名称来过滤
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        r"""用于分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""用于分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤实例，目前支持：
ID: 通过实例ID来过滤 
Name: 通过实例名称来过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusInstancesOverviewResponse(AbstractModel):
    r"""DescribePrometheusInstancesOverview返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of PrometheusInstancesOverview
        :param _Total: 实例总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Instances = None
        self._Total = None
        self._RequestId = None

    @property
    def Instances(self):
        r"""实例列表
        :rtype: list of PrometheusInstancesOverview
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def Total(self):
        r"""实例总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = PrometheusInstancesOverview()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusOverviewsRequest(AbstractModel):
    r"""DescribePrometheusOverviews请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 用于分页
        :type Offset: int
        :param _Limit: 用于分页
        :type Limit: int
        :param _Filters: 过滤实例，目前支持：
ID: 通过实例ID来过滤 
Name: 通过实例名称来过滤
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        r"""用于分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""用于分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤实例，目前支持：
ID: 通过实例ID来过滤 
Name: 通过实例名称来过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusOverviewsResponse(AbstractModel):
    r"""DescribePrometheusOverviews返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Instances: 实例列表
        :type Instances: list of PrometheusInstanceOverview
        :param _Total: 实例总数
注意：此字段可能返回 null，表示取不到有效值。
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Instances = None
        self._Total = None
        self._RequestId = None

    @property
    def Instances(self):
        r"""实例列表
        :rtype: list of PrometheusInstanceOverview
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def Total(self):
        r"""实例总数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = PrometheusInstanceOverview()
                obj._deserialize(item)
                self._Instances.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusRecordRulesRequest(AbstractModel):
    r"""DescribePrometheusRecordRules请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Offset: 分页
        :type Offset: int
        :param _Limit: 分页
        :type Limit: int
        :param _Filters: 过滤
        :type Filters: list of Filter
        """
        self._InstanceId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Offset(self):
        r"""分页
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""分页
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusRecordRulesResponse(AbstractModel):
    r"""DescribePrometheusRecordRules返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Records: 聚合规则
        :type Records: list of PrometheusRecordRuleYamlItem
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Records = None
        self._Total = None
        self._RequestId = None

    @property
    def Records(self):
        r"""聚合规则
        :rtype: list of PrometheusRecordRuleYamlItem
        """
        return self._Records

    @Records.setter
    def Records(self, Records):
        self._Records = Records

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Records") is not None:
            self._Records = []
            for item in params.get("Records"):
                obj = PrometheusRecordRuleYamlItem()
                obj._deserialize(item)
                self._Records.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusTargetsRequest(AbstractModel):
    r"""DescribePrometheusTargets请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Filters: 过滤条件，当前支持
Name=state
Value=up, down, unknown
        :type Filters: list of Filter
        """
        self._InstanceId = None
        self._ClusterType = None
        self._ClusterId = None
        self._Filters = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Filters(self):
        r"""过滤条件，当前支持
Name=state
Value=up, down, unknown
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterType = params.get("ClusterType")
        self._ClusterId = params.get("ClusterId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusTargetsResponse(AbstractModel):
    r"""DescribePrometheusTargets返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Jobs: 所有Job的targets信息
        :type Jobs: list of PrometheusJobTargets
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Jobs = None
        self._RequestId = None

    @property
    def Jobs(self):
        r"""所有Job的targets信息
        :rtype: list of PrometheusJobTargets
        """
        return self._Jobs

    @Jobs.setter
    def Jobs(self, Jobs):
        self._Jobs = Jobs

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Jobs") is not None:
            self._Jobs = []
            for item in params.get("Jobs"):
                obj = PrometheusJobTargets()
                obj._deserialize(item)
                self._Jobs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrometheusTempRequest(AbstractModel):
    r"""DescribePrometheusTemp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 模糊过滤条件，支持
Level 按模板级别过滤
Name 按名称过滤
Describe 按描述过滤
ID 按templateId过滤
        :type Filters: list of Filter
        :param _Offset: 分页偏移
        :type Offset: int
        :param _Limit: 总数限制
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""模糊过滤条件，支持
Level 按模板级别过滤
Name 按名称过滤
Describe 按描述过滤
ID 按templateId过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""分页偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""总数限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusTempResponse(AbstractModel):
    r"""DescribePrometheusTemp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 模板列表
        :type Templates: list of PrometheusTemp
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._Total = None
        self._RequestId = None

    @property
    def Templates(self):
        r"""模板列表
        :rtype: list of PrometheusTemp
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = PrometheusTemp()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribePrometheusTempSyncRequest(AbstractModel):
    r"""DescribePrometheusTempSync请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板ID
        :type TemplateId: str
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        r"""模板ID
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusTempSyncResponse(AbstractModel):
    r"""DescribePrometheusTempSync返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Targets: 同步目标详情
注意：此字段可能返回 null，表示取不到有效值。
        :type Targets: list of PrometheusTemplateSyncTarget
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Targets = None
        self._RequestId = None

    @property
    def Targets(self):
        r"""同步目标详情
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of PrometheusTemplateSyncTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = PrometheusTemplateSyncTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrometheusTemplateSyncRequest(AbstractModel):
    r"""DescribePrometheusTemplateSync请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板ID
        :type TemplateId: str
        """
        self._TemplateId = None

    @property
    def TemplateId(self):
        r"""模板ID
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusTemplateSyncResponse(AbstractModel):
    r"""DescribePrometheusTemplateSync返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Targets: 同步目标详情
        :type Targets: list of PrometheusTemplateSyncTarget
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Targets = None
        self._RequestId = None

    @property
    def Targets(self):
        r"""同步目标详情
        :rtype: list of PrometheusTemplateSyncTarget
        """
        return self._Targets

    @Targets.setter
    def Targets(self, Targets):
        self._Targets = Targets

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Targets") is not None:
            self._Targets = []
            for item in params.get("Targets"):
                obj = PrometheusTemplateSyncTarget()
                obj._deserialize(item)
                self._Targets.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePrometheusTemplatesRequest(AbstractModel):
    r"""DescribePrometheusTemplates请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Filters: 模糊过滤条件，支持
Level 按模板级别过滤
Name 按名称过滤
Describe 按描述过滤
ID 按templateId过滤
        :type Filters: list of Filter
        :param _Offset: 分页偏移
        :type Offset: int
        :param _Limit: 总数限制
        :type Limit: int
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None

    @property
    def Filters(self):
        r"""模糊过滤条件，支持
Level 按模板级别过滤
Name 按名称过滤
Describe 按描述过滤
ID 按templateId过滤
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        r"""分页偏移
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""总数限制
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePrometheusTemplatesResponse(AbstractModel):
    r"""DescribePrometheusTemplates返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Templates: 模板列表
        :type Templates: list of PrometheusTemplate
        :param _Total: 总数
        :type Total: int
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Templates = None
        self._Total = None
        self._RequestId = None

    @property
    def Templates(self):
        r"""模板列表
        :rtype: list of PrometheusTemplate
        """
        return self._Templates

    @Templates.setter
    def Templates(self, Templates):
        self._Templates = Templates

    @property
    def Total(self):
        r"""总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Templates") is not None:
            self._Templates = []
            for item in params.get("Templates"):
                obj = PrometheusTemplate()
                obj._deserialize(item)
                self._Templates.append(obj)
        self._Total = params.get("Total")
        self._RequestId = params.get("RequestId")


class DescribeRIUtilizationDetailRequest(AbstractModel):
    r"""DescribeRIUtilizationDetail请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _Filters: reserved-instance-id
按照**【预留实例ID**】进行过滤。预留实例ID形如：eksri-xxxxxxxx。
类型：String
必选：否

begin-time
按照**【抵扣开始时间**】进行过滤。形如：2023-06-28 15:27:40。
类型：String
必选：否

end-time
按照**【抵扣结束时间**】进行过滤。形如：2023-06-28 15:27:40。
类型：String
必选：否
        :type Filters: list of Filter
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        r"""偏移量，默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""reserved-instance-id
按照**【预留实例ID**】进行过滤。预留实例ID形如：eksri-xxxxxxxx。
类型：String
必选：否

begin-time
按照**【抵扣开始时间**】进行过滤。形如：2023-06-28 15:27:40。
类型：String
必选：否

end-time
按照**【抵扣结束时间**】进行过滤。形如：2023-06-28 15:27:40。
类型：String
必选：否
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRIUtilizationDetailResponse(AbstractModel):
    r"""DescribeRIUtilizationDetail返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数。
        :type TotalCount: int
        :param _RIUtilizationDetailSet: 详情。
        :type RIUtilizationDetailSet: list of RIUtilizationDetail
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RIUtilizationDetailSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RIUtilizationDetailSet(self):
        r"""详情。
        :rtype: list of RIUtilizationDetail
        """
        return self._RIUtilizationDetailSet

    @RIUtilizationDetailSet.setter
    def RIUtilizationDetailSet(self, RIUtilizationDetailSet):
        self._RIUtilizationDetailSet = RIUtilizationDetailSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RIUtilizationDetailSet") is not None:
            self._RIUtilizationDetailSet = []
            for item in params.get("RIUtilizationDetailSet"):
                obj = RIUtilizationDetail()
                obj._deserialize(item)
                self._RIUtilizationDetailSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRegionsRequest(AbstractModel):
    r"""DescribeRegions请求参数结构体

    """


class DescribeRegionsResponse(AbstractModel):
    r"""DescribeRegions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 地域的数量
        :type TotalCount: int
        :param _RegionInstanceSet: 地域列表
        :type RegionInstanceSet: list of RegionInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._RegionInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""地域的数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RegionInstanceSet(self):
        r"""地域列表
        :rtype: list of RegionInstance
        """
        return self._RegionInstanceSet

    @RegionInstanceSet.setter
    def RegionInstanceSet(self, RegionInstanceSet):
        self._RegionInstanceSet = RegionInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RegionInstanceSet") is not None:
            self._RegionInstanceSet = []
            for item in params.get("RegionInstanceSet"):
                obj = RegionInstance()
                obj._deserialize(item)
                self._RegionInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReservedInstanceUtilizationRateRequest(AbstractModel):
    r"""DescribeReservedInstanceUtilizationRate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Zone: 可用区
        :type Zone: str
        :param _ClusterId: 集群 ID
        :type ClusterId: str
        :param _NodeName: 节点 ID
        :type NodeName: str
        """
        self._Zone = None
        self._ClusterId = None
        self._NodeName = None

    @property
    def Zone(self):
        r"""可用区
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def ClusterId(self):
        r"""集群 ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodeName(self):
        r"""节点 ID
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._ClusterId = params.get("ClusterId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReservedInstanceUtilizationRateResponse(AbstractModel):
    r"""DescribeReservedInstanceUtilizationRate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _UtilizationRateSet: 预留券使用率
        :type UtilizationRateSet: list of ReservedInstanceUtilizationRate
        :param _PodNum: 按量计费的 Pod 总数
        :type PodNum: int
        :param _PodRate:  Pod 被预留券抵扣的抵扣率
        :type PodRate: float
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._UtilizationRateSet = None
        self._PodNum = None
        self._PodRate = None
        self._RequestId = None

    @property
    def UtilizationRateSet(self):
        r"""预留券使用率
        :rtype: list of ReservedInstanceUtilizationRate
        """
        return self._UtilizationRateSet

    @UtilizationRateSet.setter
    def UtilizationRateSet(self, UtilizationRateSet):
        self._UtilizationRateSet = UtilizationRateSet

    @property
    def PodNum(self):
        r"""按量计费的 Pod 总数
        :rtype: int
        """
        return self._PodNum

    @PodNum.setter
    def PodNum(self, PodNum):
        self._PodNum = PodNum

    @property
    def PodRate(self):
        r""" Pod 被预留券抵扣的抵扣率
        :rtype: float
        """
        return self._PodRate

    @PodRate.setter
    def PodRate(self, PodRate):
        self._PodRate = PodRate

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("UtilizationRateSet") is not None:
            self._UtilizationRateSet = []
            for item in params.get("UtilizationRateSet"):
                obj = ReservedInstanceUtilizationRate()
                obj._deserialize(item)
                self._UtilizationRateSet.append(obj)
        self._PodNum = params.get("PodNum")
        self._PodRate = params.get("PodRate")
        self._RequestId = params.get("RequestId")


class DescribeReservedInstancesRequest(AbstractModel):
    r"""DescribeReservedInstances请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Offset: 偏移量，默认0。
        :type Offset: int
        :param _Limit: 返回数量，默认为20，最大值为100。
        :type Limit: int
        :param _Filters: status
按照**【状态**】进行过滤。状态：Creating：创建中、Active：生效中、Expired：已过期、Refunded：已退还。
类型：String
必选：否

resource-type
按照**【资源类型**】进行过滤。资源类型：common、amd、v100、t4、a10\*gnv4、a10\*gnv4v等，common表示通用类型。
类型：String
必选：否

cpu
按照**【核数**】进行过滤。
类型：String
必选：否

memory
按照**【内存**】进行过滤。
类型：String
必选：否

gpu
按照**【GPU卡数**】进行过滤，取值有0.25、0.5、1、2、4等。
类型：String
必选：否

cluster-id
按照**【集群ID**】进行过滤。
类型：String
必选：否

node-name
按照**【节点名称**】进行过滤。
类型：String
必选：否

scope
按照**【可用区**】进行过滤。比如：ap-guangzhou-2，为空字符串表示地域抵扣范围。如果只过滤可用区抵扣范围，需要同时将cluster-id、node-name设置为空字符串。
类型：String
必选：否

reserved-instance-id
按照**【预留实例ID**】进行过滤。预留实例ID形如：eksri-xxxxxxxx。
类型：String
必选：否

reserved-instance-name
按照**【预留实例名称**】进行过滤。
类型：String
必选：否

reserved-instance-deduct
按照**【上个周期抵扣的预留券**】进行过滤。Values可不设置。
必选：否

reserved-instance-not-deduct
按照**【上个周期未抵扣的预留券**】进行过滤。Values可不设置。
必选：否
        :type Filters: list of Filter
        :param _OrderField: 排序字段。支持CreatedAt、ActiveAt、ExpireAt。默认值CreatedAt。
        :type OrderField: str
        :param _OrderDirection: 排序方法。顺序：ASC，倒序：DESC。默认值DESC。
        :type OrderDirection: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._OrderField = None
        self._OrderDirection = None

    @property
    def Offset(self):
        r"""偏移量，默认0。
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""返回数量，默认为20，最大值为100。
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""status
按照**【状态**】进行过滤。状态：Creating：创建中、Active：生效中、Expired：已过期、Refunded：已退还。
类型：String
必选：否

resource-type
按照**【资源类型**】进行过滤。资源类型：common、amd、v100、t4、a10\*gnv4、a10\*gnv4v等，common表示通用类型。
类型：String
必选：否

cpu
按照**【核数**】进行过滤。
类型：String
必选：否

memory
按照**【内存**】进行过滤。
类型：String
必选：否

gpu
按照**【GPU卡数**】进行过滤，取值有0.25、0.5、1、2、4等。
类型：String
必选：否

cluster-id
按照**【集群ID**】进行过滤。
类型：String
必选：否

node-name
按照**【节点名称**】进行过滤。
类型：String
必选：否

scope
按照**【可用区**】进行过滤。比如：ap-guangzhou-2，为空字符串表示地域抵扣范围。如果只过滤可用区抵扣范围，需要同时将cluster-id、node-name设置为空字符串。
类型：String
必选：否

reserved-instance-id
按照**【预留实例ID**】进行过滤。预留实例ID形如：eksri-xxxxxxxx。
类型：String
必选：否

reserved-instance-name
按照**【预留实例名称**】进行过滤。
类型：String
必选：否

reserved-instance-deduct
按照**【上个周期抵扣的预留券**】进行过滤。Values可不设置。
必选：否

reserved-instance-not-deduct
按照**【上个周期未抵扣的预留券**】进行过滤。Values可不设置。
必选：否
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def OrderField(self):
        r"""排序字段。支持CreatedAt、ActiveAt、ExpireAt。默认值CreatedAt。
        :rtype: str
        """
        return self._OrderField

    @OrderField.setter
    def OrderField(self, OrderField):
        self._OrderField = OrderField

    @property
    def OrderDirection(self):
        r"""排序方法。顺序：ASC，倒序：DESC。默认值DESC。
        :rtype: str
        """
        return self._OrderDirection

    @OrderDirection.setter
    def OrderDirection(self, OrderDirection):
        self._OrderDirection = OrderDirection


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._OrderField = params.get("OrderField")
        self._OrderDirection = params.get("OrderDirection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReservedInstancesResponse(AbstractModel):
    r"""DescribeReservedInstances返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 总数。
        :type TotalCount: int
        :param _ReservedInstanceSet: 预留实例列表。
        :type ReservedInstanceSet: list of ReservedInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._ReservedInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""总数。
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ReservedInstanceSet(self):
        r"""预留实例列表。
        :rtype: list of ReservedInstance
        """
        return self._ReservedInstanceSet

    @ReservedInstanceSet.setter
    def ReservedInstanceSet(self, ReservedInstanceSet):
        self._ReservedInstanceSet = ReservedInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ReservedInstanceSet") is not None:
            self._ReservedInstanceSet = []
            for item in params.get("ReservedInstanceSet"):
                obj = ReservedInstance()
                obj._deserialize(item)
                self._ReservedInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeResourceUsageRequest(AbstractModel):
    r"""DescribeResourceUsage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeResourceUsageResponse(AbstractModel):
    r"""DescribeResourceUsage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _CRDUsage: CRD使用量
        :type CRDUsage: :class:`tencentcloud.tke.v20180525.models.ResourceUsage`
        :param _PodUsage: Pod使用量
        :type PodUsage: int
        :param _RSUsage: ReplicaSet使用量
        :type RSUsage: int
        :param _ConfigMapUsage: ConfigMap使用量
        :type ConfigMapUsage: int
        :param _OtherUsage: 其他资源使用量
        :type OtherUsage: :class:`tencentcloud.tke.v20180525.models.ResourceUsage`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._CRDUsage = None
        self._PodUsage = None
        self._RSUsage = None
        self._ConfigMapUsage = None
        self._OtherUsage = None
        self._RequestId = None

    @property
    def CRDUsage(self):
        r"""CRD使用量
        :rtype: :class:`tencentcloud.tke.v20180525.models.ResourceUsage`
        """
        return self._CRDUsage

    @CRDUsage.setter
    def CRDUsage(self, CRDUsage):
        self._CRDUsage = CRDUsage

    @property
    def PodUsage(self):
        r"""Pod使用量
        :rtype: int
        """
        return self._PodUsage

    @PodUsage.setter
    def PodUsage(self, PodUsage):
        self._PodUsage = PodUsage

    @property
    def RSUsage(self):
        r"""ReplicaSet使用量
        :rtype: int
        """
        return self._RSUsage

    @RSUsage.setter
    def RSUsage(self, RSUsage):
        self._RSUsage = RSUsage

    @property
    def ConfigMapUsage(self):
        r"""ConfigMap使用量
        :rtype: int
        """
        return self._ConfigMapUsage

    @ConfigMapUsage.setter
    def ConfigMapUsage(self, ConfigMapUsage):
        self._ConfigMapUsage = ConfigMapUsage

    @property
    def OtherUsage(self):
        r"""其他资源使用量
        :rtype: :class:`tencentcloud.tke.v20180525.models.ResourceUsage`
        """
        return self._OtherUsage

    @OtherUsage.setter
    def OtherUsage(self, OtherUsage):
        self._OtherUsage = OtherUsage

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("CRDUsage") is not None:
            self._CRDUsage = ResourceUsage()
            self._CRDUsage._deserialize(params.get("CRDUsage"))
        self._PodUsage = params.get("PodUsage")
        self._RSUsage = params.get("RSUsage")
        self._ConfigMapUsage = params.get("ConfigMapUsage")
        if params.get("OtherUsage") is not None:
            self._OtherUsage = ResourceUsage()
            self._OtherUsage._deserialize(params.get("OtherUsage"))
        self._RequestId = params.get("RequestId")


class DescribeRouteTableConflictsRequest(AbstractModel):
    r"""DescribeRouteTableConflicts请求参数结构体

    """

    def __init__(self):
        r"""
        :param _RouteTableCidrBlock: 路由表CIDR
        :type RouteTableCidrBlock: str
        :param _VpcId: 路由表绑定的VPC
        :type VpcId: str
        """
        self._RouteTableCidrBlock = None
        self._VpcId = None

    @property
    def RouteTableCidrBlock(self):
        r"""路由表CIDR
        :rtype: str
        """
        return self._RouteTableCidrBlock

    @RouteTableCidrBlock.setter
    def RouteTableCidrBlock(self, RouteTableCidrBlock):
        self._RouteTableCidrBlock = RouteTableCidrBlock

    @property
    def VpcId(self):
        r"""路由表绑定的VPC
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._RouteTableCidrBlock = params.get("RouteTableCidrBlock")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRouteTableConflictsResponse(AbstractModel):
    r"""DescribeRouteTableConflicts返回参数结构体

    """

    def __init__(self):
        r"""
        :param _HasConflict: 路由表是否冲突。
        :type HasConflict: bool
        :param _RouteTableConflictSet: 路由表冲突列表。
        :type RouteTableConflictSet: list of RouteTableConflict
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._HasConflict = None
        self._RouteTableConflictSet = None
        self._RequestId = None

    @property
    def HasConflict(self):
        r"""路由表是否冲突。
        :rtype: bool
        """
        return self._HasConflict

    @HasConflict.setter
    def HasConflict(self, HasConflict):
        self._HasConflict = HasConflict

    @property
    def RouteTableConflictSet(self):
        r"""路由表冲突列表。
        :rtype: list of RouteTableConflict
        """
        return self._RouteTableConflictSet

    @RouteTableConflictSet.setter
    def RouteTableConflictSet(self, RouteTableConflictSet):
        self._RouteTableConflictSet = RouteTableConflictSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HasConflict = params.get("HasConflict")
        if params.get("RouteTableConflictSet") is not None:
            self._RouteTableConflictSet = []
            for item in params.get("RouteTableConflictSet"):
                obj = RouteTableConflict()
                obj._deserialize(item)
                self._RouteTableConflictSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSupportedRuntimeRequest(AbstractModel):
    r"""DescribeSupportedRuntime请求参数结构体

    """

    def __init__(self):
        r"""
        :param _K8sVersion: K8S版本
        :type K8sVersion: str
        """
        self._K8sVersion = None

    @property
    def K8sVersion(self):
        r"""K8S版本
        :rtype: str
        """
        return self._K8sVersion

    @K8sVersion.setter
    def K8sVersion(self, K8sVersion):
        self._K8sVersion = K8sVersion


    def _deserialize(self, params):
        self._K8sVersion = params.get("K8sVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSupportedRuntimeResponse(AbstractModel):
    r"""DescribeSupportedRuntime返回参数结构体

    """

    def __init__(self):
        r"""
        :param _OptionalRuntimes: 可选运行时列表
        :type OptionalRuntimes: list of OptionalRuntimes
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._OptionalRuntimes = None
        self._RequestId = None

    @property
    def OptionalRuntimes(self):
        r"""可选运行时列表
        :rtype: list of OptionalRuntimes
        """
        return self._OptionalRuntimes

    @OptionalRuntimes.setter
    def OptionalRuntimes(self, OptionalRuntimes):
        self._OptionalRuntimes = OptionalRuntimes

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("OptionalRuntimes") is not None:
            self._OptionalRuntimes = []
            for item in params.get("OptionalRuntimes"):
                obj = OptionalRuntimes()
                obj._deserialize(item)
                self._OptionalRuntimes.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTKEEdgeClusterCredentialRequest(AbstractModel):
    r"""DescribeTKEEdgeClusterCredential请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTKEEdgeClusterCredentialResponse(AbstractModel):
    r"""DescribeTKEEdgeClusterCredential返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Addresses: 集群的接入地址信息
注意：此字段可能返回 null，表示取不到有效值。
        :type Addresses: list of IPAddress
        :param _Credential: 集群的认证信息
        :type Credential: :class:`tencentcloud.tke.v20180525.models.ClusterCredential`
        :param _PublicLB: 集群的公网访问信息
        :type PublicLB: :class:`tencentcloud.tke.v20180525.models.EdgeClusterPublicLB`
        :param _InternalLB: 集群的内网访问信息
        :type InternalLB: :class:`tencentcloud.tke.v20180525.models.EdgeClusterInternalLB`
        :param _CoreDns: 集群的CoreDns部署信息
        :type CoreDns: str
        :param _HealthRegion: 集群的健康检查多地域部署信息
        :type HealthRegion: str
        :param _Health: 集群的健康检查部署信息
        :type Health: str
        :param _GridDaemon: 是否部署GridDaemon以支持headless service
        :type GridDaemon: str
        :param _UnitCluster: 公网访问kins集群
        :type UnitCluster: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Addresses = None
        self._Credential = None
        self._PublicLB = None
        self._InternalLB = None
        self._CoreDns = None
        self._HealthRegion = None
        self._Health = None
        self._GridDaemon = None
        self._UnitCluster = None
        self._RequestId = None

    @property
    def Addresses(self):
        r"""集群的接入地址信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of IPAddress
        """
        return self._Addresses

    @Addresses.setter
    def Addresses(self, Addresses):
        self._Addresses = Addresses

    @property
    def Credential(self):
        r"""集群的认证信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterCredential`
        """
        return self._Credential

    @Credential.setter
    def Credential(self, Credential):
        self._Credential = Credential

    @property
    def PublicLB(self):
        r"""集群的公网访问信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterPublicLB`
        """
        return self._PublicLB

    @PublicLB.setter
    def PublicLB(self, PublicLB):
        self._PublicLB = PublicLB

    @property
    def InternalLB(self):
        r"""集群的内网访问信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterInternalLB`
        """
        return self._InternalLB

    @InternalLB.setter
    def InternalLB(self, InternalLB):
        self._InternalLB = InternalLB

    @property
    def CoreDns(self):
        r"""集群的CoreDns部署信息
        :rtype: str
        """
        return self._CoreDns

    @CoreDns.setter
    def CoreDns(self, CoreDns):
        self._CoreDns = CoreDns

    @property
    def HealthRegion(self):
        r"""集群的健康检查多地域部署信息
        :rtype: str
        """
        return self._HealthRegion

    @HealthRegion.setter
    def HealthRegion(self, HealthRegion):
        self._HealthRegion = HealthRegion

    @property
    def Health(self):
        r"""集群的健康检查部署信息
        :rtype: str
        """
        return self._Health

    @Health.setter
    def Health(self, Health):
        self._Health = Health

    @property
    def GridDaemon(self):
        r"""是否部署GridDaemon以支持headless service
        :rtype: str
        """
        return self._GridDaemon

    @GridDaemon.setter
    def GridDaemon(self, GridDaemon):
        self._GridDaemon = GridDaemon

    @property
    def UnitCluster(self):
        r"""公网访问kins集群
        :rtype: str
        """
        return self._UnitCluster

    @UnitCluster.setter
    def UnitCluster(self, UnitCluster):
        self._UnitCluster = UnitCluster

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Addresses") is not None:
            self._Addresses = []
            for item in params.get("Addresses"):
                obj = IPAddress()
                obj._deserialize(item)
                self._Addresses.append(obj)
        if params.get("Credential") is not None:
            self._Credential = ClusterCredential()
            self._Credential._deserialize(params.get("Credential"))
        if params.get("PublicLB") is not None:
            self._PublicLB = EdgeClusterPublicLB()
            self._PublicLB._deserialize(params.get("PublicLB"))
        if params.get("InternalLB") is not None:
            self._InternalLB = EdgeClusterInternalLB()
            self._InternalLB._deserialize(params.get("InternalLB"))
        self._CoreDns = params.get("CoreDns")
        self._HealthRegion = params.get("HealthRegion")
        self._Health = params.get("Health")
        self._GridDaemon = params.get("GridDaemon")
        self._UnitCluster = params.get("UnitCluster")
        self._RequestId = params.get("RequestId")


class DescribeTKEEdgeClusterStatusRequest(AbstractModel):
    r"""DescribeTKEEdgeClusterStatus请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 边缘计算容器集群Id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""边缘计算容器集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTKEEdgeClusterStatusResponse(AbstractModel):
    r"""DescribeTKEEdgeClusterStatus返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Phase: 集群当前状态
        :type Phase: str
        :param _Conditions: 集群过程数组
        :type Conditions: list of ClusterCondition
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Phase = None
        self._Conditions = None
        self._RequestId = None

    @property
    def Phase(self):
        r"""集群当前状态
        :rtype: str
        """
        return self._Phase

    @Phase.setter
    def Phase(self, Phase):
        self._Phase = Phase

    @property
    def Conditions(self):
        r"""集群过程数组
        :rtype: list of ClusterCondition
        """
        return self._Conditions

    @Conditions.setter
    def Conditions(self, Conditions):
        self._Conditions = Conditions

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Phase = params.get("Phase")
        if params.get("Conditions") is not None:
            self._Conditions = []
            for item in params.get("Conditions"):
                obj = ClusterCondition()
                obj._deserialize(item)
                self._Conditions.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTKEEdgeClustersRequest(AbstractModel):
    r"""DescribeTKEEdgeClusters请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 集群ID列表(为空时，
表示获取账号下所有集群)
        :type ClusterIds: list of str
        :param _Offset: 偏移量,默认0
        :type Offset: int
        :param _Limit: 最大输出条数，默认20
        :type Limit: int
        :param _Filters: 过滤条件,当前只支持按照ClusterName和云标签进行过滤,云标签过滤格式Tags:["key1:value1","key2:value2"]
        :type Filters: list of Filter
        """
        self._ClusterIds = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def ClusterIds(self):
        r"""集群ID列表(为空时，
表示获取账号下所有集群)
        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def Offset(self):
        r"""偏移量,默认0
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        r"""最大输出条数，默认20
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        r"""过滤条件,当前只支持按照ClusterName和云标签进行过滤,云标签过滤格式Tags:["key1:value1","key2:value2"]
        :rtype: list of Filter
        """
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = Filter()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTKEEdgeClustersResponse(AbstractModel):
    r"""DescribeTKEEdgeClusters返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 集群总个数
        :type TotalCount: int
        :param _Clusters: 集群信息列表
        :type Clusters: list of EdgeCluster
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._Clusters = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""集群总个数
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def Clusters(self):
        r"""集群信息列表
        :rtype: list of EdgeCluster
        """
        return self._Clusters

    @Clusters.setter
    def Clusters(self, Clusters):
        self._Clusters = Clusters

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("Clusters") is not None:
            self._Clusters = []
            for item in params.get("Clusters"):
                obj = EdgeCluster()
                obj._deserialize(item)
                self._Clusters.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTKEEdgeExternalKubeconfigRequest(AbstractModel):
    r"""DescribeTKEEdgeExternalKubeconfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTKEEdgeExternalKubeconfigResponse(AbstractModel):
    r"""DescribeTKEEdgeExternalKubeconfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Kubeconfig: kubeconfig文件内容
        :type Kubeconfig: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Kubeconfig = None
        self._RequestId = None

    @property
    def Kubeconfig(self):
        r"""kubeconfig文件内容
        :rtype: str
        """
        return self._Kubeconfig

    @Kubeconfig.setter
    def Kubeconfig(self, Kubeconfig):
        self._Kubeconfig = Kubeconfig

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Kubeconfig = params.get("Kubeconfig")
        self._RequestId = params.get("RequestId")


class DescribeTKEEdgeScriptRequest(AbstractModel):
    r"""DescribeTKEEdgeScript请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _Interface: 网卡名,指定边缘节点上kubelet向apiserver注册使用的网卡
        :type Interface: str
        :param _NodeName: 节点名字
        :type NodeName: str
        :param _Config: json格式的节点配置
        :type Config: str
        :param _ScriptVersion: 可以下载某个历史版本的edgectl脚本，默认下载最新版本，edgectl版本信息可以在脚本里查看
        :type ScriptVersion: str
        """
        self._ClusterId = None
        self._Interface = None
        self._NodeName = None
        self._Config = None
        self._ScriptVersion = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Interface(self):
        r"""网卡名,指定边缘节点上kubelet向apiserver注册使用的网卡
        :rtype: str
        """
        return self._Interface

    @Interface.setter
    def Interface(self, Interface):
        self._Interface = Interface

    @property
    def NodeName(self):
        r"""节点名字
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def Config(self):
        r"""json格式的节点配置
        :rtype: str
        """
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def ScriptVersion(self):
        r"""可以下载某个历史版本的edgectl脚本，默认下载最新版本，edgectl版本信息可以在脚本里查看
        :rtype: str
        """
        return self._ScriptVersion

    @ScriptVersion.setter
    def ScriptVersion(self, ScriptVersion):
        self._ScriptVersion = ScriptVersion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Interface = params.get("Interface")
        self._NodeName = params.get("NodeName")
        self._Config = params.get("Config")
        self._ScriptVersion = params.get("ScriptVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTKEEdgeScriptResponse(AbstractModel):
    r"""DescribeTKEEdgeScript返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Link: 下载链接
        :type Link: str
        :param _Token: 下载需要的token
        :type Token: str
        :param _Command: 下载命令
        :type Command: str
        :param _ScriptVersion: edgectl脚本版本，默认拉取最新版本
注意：此字段可能返回 null，表示取不到有效值。
        :type ScriptVersion: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Link = None
        self._Token = None
        self._Command = None
        self._ScriptVersion = None
        self._RequestId = None

    @property
    def Link(self):
        r"""下载链接
        :rtype: str
        """
        return self._Link

    @Link.setter
    def Link(self, Link):
        self._Link = Link

    @property
    def Token(self):
        r"""下载需要的token
        :rtype: str
        """
        return self._Token

    @Token.setter
    def Token(self, Token):
        self._Token = Token

    @property
    def Command(self):
        r"""下载命令
        :rtype: str
        """
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def ScriptVersion(self):
        r"""edgectl脚本版本，默认拉取最新版本
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._ScriptVersion

    @ScriptVersion.setter
    def ScriptVersion(self, ScriptVersion):
        self._ScriptVersion = ScriptVersion

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Link = params.get("Link")
        self._Token = params.get("Token")
        self._Command = params.get("Command")
        self._ScriptVersion = params.get("ScriptVersion")
        self._RequestId = params.get("RequestId")


class DescribeVersionsRequest(AbstractModel):
    r"""DescribeVersions请求参数结构体

    """


class DescribeVersionsResponse(AbstractModel):
    r"""DescribeVersions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 版本数量
        :type TotalCount: int
        :param _VersionInstanceSet: 版本列表
        :type VersionInstanceSet: list of VersionInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._VersionInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""版本数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VersionInstanceSet(self):
        r"""版本列表
        :rtype: list of VersionInstance
        """
        return self._VersionInstanceSet

    @VersionInstanceSet.setter
    def VersionInstanceSet(self, VersionInstanceSet):
        self._VersionInstanceSet = VersionInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("VersionInstanceSet") is not None:
            self._VersionInstanceSet = []
            for item in params.get("VersionInstanceSet"):
                obj = VersionInstance()
                obj._deserialize(item)
                self._VersionInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVpcCniPodLimitsRequest(AbstractModel):
    r"""DescribeVpcCniPodLimits请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Zone: 查询的机型所在可用区，如：ap-guangzhou-3，默认为空，即不按可用区过滤信息
        :type Zone: str
        :param _InstanceFamily: 查询的实例机型系列信息，如：S5，默认为空，即不按机型系列过滤信息
        :type InstanceFamily: str
        :param _InstanceType: 查询的实例机型信息，如：S5.LARGE8，默认为空，即不按机型过滤信息
        :type InstanceType: str
        """
        self._Zone = None
        self._InstanceFamily = None
        self._InstanceType = None

    @property
    def Zone(self):
        r"""查询的机型所在可用区，如：ap-guangzhou-3，默认为空，即不按可用区过滤信息
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def InstanceFamily(self):
        r"""查询的实例机型系列信息，如：S5，默认为空，即不按机型系列过滤信息
        :rtype: str
        """
        return self._InstanceFamily

    @InstanceFamily.setter
    def InstanceFamily(self, InstanceFamily):
        self._InstanceFamily = InstanceFamily

    @property
    def InstanceType(self):
        r"""查询的实例机型信息，如：S5.LARGE8，默认为空，即不按机型过滤信息
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._InstanceFamily = params.get("InstanceFamily")
        self._InstanceType = params.get("InstanceType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVpcCniPodLimitsResponse(AbstractModel):
    r"""DescribeVpcCniPodLimits返回参数结构体

    """

    def __init__(self):
        r"""
        :param _TotalCount: 机型数据数量
        :type TotalCount: int
        :param _PodLimitsInstanceSet: 机型信息及其可支持的最大VPC-CNI模式Pod数量信息
        :type PodLimitsInstanceSet: list of PodLimitsInstance
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._TotalCount = None
        self._PodLimitsInstanceSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        r"""机型数据数量
        :rtype: int
        """
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PodLimitsInstanceSet(self):
        r"""机型信息及其可支持的最大VPC-CNI模式Pod数量信息
        :rtype: list of PodLimitsInstance
        """
        return self._PodLimitsInstanceSet

    @PodLimitsInstanceSet.setter
    def PodLimitsInstanceSet(self, PodLimitsInstanceSet):
        self._PodLimitsInstanceSet = PodLimitsInstanceSet

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PodLimitsInstanceSet") is not None:
            self._PodLimitsInstanceSet = []
            for item in params.get("PodLimitsInstanceSet"):
                obj = PodLimitsInstance()
                obj._deserialize(item)
                self._PodLimitsInstanceSet.append(obj)
        self._RequestId = params.get("RequestId")


class DisableClusterAuditRequest(AbstractModel):
    r"""DisableClusterAudit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _DeleteLogSetAndTopic: 取值为true代表关闭集群审计时删除默认创建的日志集和主题，false代表不删除
        :type DeleteLogSetAndTopic: bool
        """
        self._ClusterId = None
        self._DeleteLogSetAndTopic = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DeleteLogSetAndTopic(self):
        r"""取值为true代表关闭集群审计时删除默认创建的日志集和主题，false代表不删除
        :rtype: bool
        """
        return self._DeleteLogSetAndTopic

    @DeleteLogSetAndTopic.setter
    def DeleteLogSetAndTopic(self, DeleteLogSetAndTopic):
        self._DeleteLogSetAndTopic = DeleteLogSetAndTopic


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DeleteLogSetAndTopic = params.get("DeleteLogSetAndTopic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableClusterAuditResponse(AbstractModel):
    r"""DisableClusterAudit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableClusterDeletionProtectionRequest(AbstractModel):
    r"""DisableClusterDeletionProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableClusterDeletionProtectionResponse(AbstractModel):
    r"""DisableClusterDeletionProtection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableEncryptionProtectionRequest(AbstractModel):
    r"""DisableEncryptionProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableEncryptionProtectionResponse(AbstractModel):
    r"""DisableEncryptionProtection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableEventPersistenceRequest(AbstractModel):
    r"""DisableEventPersistence请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _DeleteLogSetAndTopic: 取值为true代表关闭集群审计时删除默认创建的日志集和主题，false代表不删除
        :type DeleteLogSetAndTopic: bool
        """
        self._ClusterId = None
        self._DeleteLogSetAndTopic = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DeleteLogSetAndTopic(self):
        r"""取值为true代表关闭集群审计时删除默认创建的日志集和主题，false代表不删除
        :rtype: bool
        """
        return self._DeleteLogSetAndTopic

    @DeleteLogSetAndTopic.setter
    def DeleteLogSetAndTopic(self, DeleteLogSetAndTopic):
        self._DeleteLogSetAndTopic = DeleteLogSetAndTopic


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DeleteLogSetAndTopic = params.get("DeleteLogSetAndTopic")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableEventPersistenceResponse(AbstractModel):
    r"""DisableEventPersistence返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableVpcCniNetworkTypeRequest(AbstractModel):
    r"""DisableVpcCniNetworkType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableVpcCniNetworkTypeResponse(AbstractModel):
    r"""DisableVpcCniNetworkType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DnsServerConf(AbstractModel):
    r"""Eks 自定义域名服务器 配置

    """

    def __init__(self):
        r"""
        :param _Domain: 域名。空字符串表示所有域名。
        :type Domain: str
        :param _DnsServers: dns 服务器地址列表。地址格式 ip:port
        :type DnsServers: list of str
        """
        self._Domain = None
        self._DnsServers = None

    @property
    def Domain(self):
        r"""域名。空字符串表示所有域名。
        :rtype: str
        """
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DnsServers(self):
        r"""dns 服务器地址列表。地址格式 ip:port
        :rtype: list of str
        """
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DnsServers = params.get("DnsServers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrainClusterVirtualNodeRequest(AbstractModel):
    r"""DrainClusterVirtualNode请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _NodeName: 节点ID
        :type NodeName: str
        """
        self._ClusterId = None
        self._NodeName = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodeName(self):
        r"""节点ID
        :rtype: str
        """
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrainClusterVirtualNodeResponse(AbstractModel):
    r"""DrainClusterVirtualNode返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DriverVersion(AbstractModel):
    r"""GPU驱动和CUDA的版本信息

    """

    def __init__(self):
        r"""
        :param _Name: GPU驱动或者CUDA的名字
        :type Name: str
        :param _Version: GPU驱动或者CUDA的版本
        :type Version: str
        """
        self._Name = None
        self._Version = None

    @property
    def Name(self):
        r"""GPU驱动或者CUDA的名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        r"""GPU驱动或者CUDA的版本
        :rtype: str
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ECMEnhancedService(AbstractModel):
    r"""ECM增强服务

    """

    def __init__(self):
        r"""
        :param _SecurityService: 是否开启云监控服务
        :type SecurityService: :class:`tencentcloud.tke.v20180525.models.ECMRunMonitorServiceEnabled`
        :param _MonitorService: 是否开启云镜服务
        :type MonitorService: :class:`tencentcloud.tke.v20180525.models.ECMRunSecurityServiceEnabled`
        """
        self._SecurityService = None
        self._MonitorService = None

    @property
    def SecurityService(self):
        r"""是否开启云监控服务
        :rtype: :class:`tencentcloud.tke.v20180525.models.ECMRunMonitorServiceEnabled`
        """
        return self._SecurityService

    @SecurityService.setter
    def SecurityService(self, SecurityService):
        self._SecurityService = SecurityService

    @property
    def MonitorService(self):
        r"""是否开启云镜服务
        :rtype: :class:`tencentcloud.tke.v20180525.models.ECMRunSecurityServiceEnabled`
        """
        return self._MonitorService

    @MonitorService.setter
    def MonitorService(self, MonitorService):
        self._MonitorService = MonitorService


    def _deserialize(self, params):
        if params.get("SecurityService") is not None:
            self._SecurityService = ECMRunMonitorServiceEnabled()
            self._SecurityService._deserialize(params.get("SecurityService"))
        if params.get("MonitorService") is not None:
            self._MonitorService = ECMRunSecurityServiceEnabled()
            self._MonitorService._deserialize(params.get("MonitorService"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ECMRunMonitorServiceEnabled(AbstractModel):
    r"""ECM云监控服务

    """

    def __init__(self):
        r"""
        :param _Enabled: 是否开启
        :type Enabled: bool
        """
        self._Enabled = None

    @property
    def Enabled(self):
        r"""是否开启
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ECMRunSecurityServiceEnabled(AbstractModel):
    r"""ECM云镜服务

    """

    def __init__(self):
        r"""
        :param _Enabled: 是否开启
        :type Enabled: bool
        :param _Version: 云镜版本：0 基础版，1 专业版
        :type Version: int
        """
        self._Enabled = None
        self._Version = None

    @property
    def Enabled(self):
        r"""是否开启
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Version(self):
        r"""云镜版本：0 基础版，1 专业版
        :rtype: int
        """
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ECMZoneInstanceCountISP(AbstractModel):
    r"""ECM实例可用区及对应的实例创建数目及运营商的组合

    """

    def __init__(self):
        r"""
        :param _Zone: 创建实例的可用区
        :type Zone: str
        :param _InstanceCount: 在当前可用区欲创建的实例数目
        :type InstanceCount: int
        :param _ISP: 运营商
        :type ISP: str
        """
        self._Zone = None
        self._InstanceCount = None
        self._ISP = None

    @property
    def Zone(self):
        r"""创建实例的可用区
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone

    @property
    def InstanceCount(self):
        r"""在当前可用区欲创建的实例数目
        :rtype: int
        """
        return self._InstanceCount

    @InstanceCount.setter
    def InstanceCount(self, InstanceCount):
        self._InstanceCount = InstanceCount

    @property
    def ISP(self):
        r"""运营商
        :rtype: str
        """
        return self._ISP

    @ISP.setter
    def ISP(self, ISP):
        self._ISP = ISP


    def _deserialize(self, params):
        self._Zone = params.get("Zone")
        self._InstanceCount = params.get("InstanceCount")
        self._ISP = params.get("ISP")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeArgsFlag(AbstractModel):
    r"""边缘容器参数描述

    """

    def __init__(self):
        r"""
        :param _Name: 参数名
        :type Name: str
        :param _Type: 参数类型
        :type Type: str
        :param _Usage: 参数描述
        :type Usage: str
        :param _Default: 参数默认值
        :type Default: str
        :param _Constraint: 参数可选范围（目前包含range和in两种，"[]"代表range，如"[1, 5]"表示参数必须>=1且 <=5, "()"代表in， 如"('aa', 'bb')"表示参数只能为字符串'aa'或者'bb'，该参数为空表示不校验）
        :type Constraint: str
        """
        self._Name = None
        self._Type = None
        self._Usage = None
        self._Default = None
        self._Constraint = None

    @property
    def Name(self):
        r"""参数名
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        r"""参数类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Usage(self):
        r"""参数描述
        :rtype: str
        """
        return self._Usage

    @Usage.setter
    def Usage(self, Usage):
        self._Usage = Usage

    @property
    def Default(self):
        r"""参数默认值
        :rtype: str
        """
        return self._Default

    @Default.setter
    def Default(self, Default):
        self._Default = Default

    @property
    def Constraint(self):
        r"""参数可选范围（目前包含range和in两种，"[]"代表range，如"[1, 5]"表示参数必须>=1且 <=5, "()"代表in， 如"('aa', 'bb')"表示参数只能为字符串'aa'或者'bb'，该参数为空表示不校验）
        :rtype: str
        """
        return self._Constraint

    @Constraint.setter
    def Constraint(self, Constraint):
        self._Constraint = Constraint


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._Usage = params.get("Usage")
        self._Default = params.get("Default")
        self._Constraint = params.get("Constraint")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeAvailableExtraArgs(AbstractModel):
    r"""边缘容器集群可用的自定义参数

    """

    def __init__(self):
        r"""
        :param _KubeAPIServer: kube-apiserver可用的自定义参数
        :type KubeAPIServer: list of EdgeArgsFlag
        :param _KubeControllerManager: kube-controller-manager可用的自定义参数
        :type KubeControllerManager: list of EdgeArgsFlag
        :param _KubeScheduler: kube-scheduler可用的自定义参数
        :type KubeScheduler: list of EdgeArgsFlag
        :param _Kubelet: kubelet可用的自定义参数
        :type Kubelet: list of EdgeArgsFlag
        """
        self._KubeAPIServer = None
        self._KubeControllerManager = None
        self._KubeScheduler = None
        self._Kubelet = None

    @property
    def KubeAPIServer(self):
        r"""kube-apiserver可用的自定义参数
        :rtype: list of EdgeArgsFlag
        """
        return self._KubeAPIServer

    @KubeAPIServer.setter
    def KubeAPIServer(self, KubeAPIServer):
        self._KubeAPIServer = KubeAPIServer

    @property
    def KubeControllerManager(self):
        r"""kube-controller-manager可用的自定义参数
        :rtype: list of EdgeArgsFlag
        """
        return self._KubeControllerManager

    @KubeControllerManager.setter
    def KubeControllerManager(self, KubeControllerManager):
        self._KubeControllerManager = KubeControllerManager

    @property
    def KubeScheduler(self):
        r"""kube-scheduler可用的自定义参数
        :rtype: list of EdgeArgsFlag
        """
        return self._KubeScheduler

    @KubeScheduler.setter
    def KubeScheduler(self, KubeScheduler):
        self._KubeScheduler = KubeScheduler

    @property
    def Kubelet(self):
        r"""kubelet可用的自定义参数
        :rtype: list of EdgeArgsFlag
        """
        return self._Kubelet

    @Kubelet.setter
    def Kubelet(self, Kubelet):
        self._Kubelet = Kubelet


    def _deserialize(self, params):
        if params.get("KubeAPIServer") is not None:
            self._KubeAPIServer = []
            for item in params.get("KubeAPIServer"):
                obj = EdgeArgsFlag()
                obj._deserialize(item)
                self._KubeAPIServer.append(obj)
        if params.get("KubeControllerManager") is not None:
            self._KubeControllerManager = []
            for item in params.get("KubeControllerManager"):
                obj = EdgeArgsFlag()
                obj._deserialize(item)
                self._KubeControllerManager.append(obj)
        if params.get("KubeScheduler") is not None:
            self._KubeScheduler = []
            for item in params.get("KubeScheduler"):
                obj = EdgeArgsFlag()
                obj._deserialize(item)
                self._KubeScheduler.append(obj)
        if params.get("Kubelet") is not None:
            self._Kubelet = []
            for item in params.get("Kubelet"):
                obj = EdgeArgsFlag()
                obj._deserialize(item)
                self._Kubelet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeCluster(AbstractModel):
    r"""边缘计算集群信息

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _VpcId: Vpc Id
        :type VpcId: str
        :param _PodCIDR: 集群pod cidr
        :type PodCIDR: str
        :param _ServiceCIDR: 集群 service cidr
        :type ServiceCIDR: str
        :param _K8SVersion: k8s 版本号
        :type K8SVersion: str
        :param _Status: 集群状态
        :type Status: str
        :param _ClusterDesc: 集群描述信息
        :type ClusterDesc: str
        :param _CreatedTime: 集群创建时间
        :type CreatedTime: str
        :param _EdgeClusterVersion: 边缘集群版本
        :type EdgeClusterVersion: str
        :param _MaxNodePodNum: 节点最大Pod数
        :type MaxNodePodNum: int
        :param _ClusterAdvancedSettings: 集群高级设置
        :type ClusterAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.EdgeClusterAdvancedSettings`
        :param _Level: 边缘容器集群级别
        :type Level: str
        :param _AutoUpgradeClusterLevel: 是否支持自动提升集群配置
        :type AutoUpgradeClusterLevel: bool
        :param _ChargeType: 集群付费模式，支持POSTPAID_BY_HOUR或者PREPAID
        :type ChargeType: str
        :param _EdgeVersion: 边缘集群组件的版本
        :type EdgeVersion: str
        :param _TagSpecification: 集群绑定的云标签
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSpecification: :class:`tencentcloud.tke.v20180525.models.TagSpecification`
        """
        self._ClusterId = None
        self._ClusterName = None
        self._VpcId = None
        self._PodCIDR = None
        self._ServiceCIDR = None
        self._K8SVersion = None
        self._Status = None
        self._ClusterDesc = None
        self._CreatedTime = None
        self._EdgeClusterVersion = None
        self._MaxNodePodNum = None
        self._ClusterAdvancedSettings = None
        self._Level = None
        self._AutoUpgradeClusterLevel = None
        self._ChargeType = None
        self._EdgeVersion = None
        self._TagSpecification = None

    @property
    def ClusterId(self):
        r"""集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def VpcId(self):
        r"""Vpc Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def PodCIDR(self):
        r"""集群pod cidr
        :rtype: str
        """
        return self._PodCIDR

    @PodCIDR.setter
    def PodCIDR(self, PodCIDR):
        self._PodCIDR = PodCIDR

    @property
    def ServiceCIDR(self):
        r"""集群 service cidr
        :rtype: str
        """
        return self._ServiceCIDR

    @ServiceCIDR.setter
    def ServiceCIDR(self, ServiceCIDR):
        self._ServiceCIDR = ServiceCIDR

    @property
    def K8SVersion(self):
        r"""k8s 版本号
        :rtype: str
        """
        return self._K8SVersion

    @K8SVersion.setter
    def K8SVersion(self, K8SVersion):
        self._K8SVersion = K8SVersion

    @property
    def Status(self):
        r"""集群状态
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterDesc(self):
        r"""集群描述信息
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def CreatedTime(self):
        r"""集群创建时间
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def EdgeClusterVersion(self):
        r"""边缘集群版本
        :rtype: str
        """
        return self._EdgeClusterVersion

    @EdgeClusterVersion.setter
    def EdgeClusterVersion(self, EdgeClusterVersion):
        self._EdgeClusterVersion = EdgeClusterVersion

    @property
    def MaxNodePodNum(self):
        r"""节点最大Pod数
        :rtype: int
        """
        return self._MaxNodePodNum

    @MaxNodePodNum.setter
    def MaxNodePodNum(self, MaxNodePodNum):
        self._MaxNodePodNum = MaxNodePodNum

    @property
    def ClusterAdvancedSettings(self):
        r"""集群高级设置
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterAdvancedSettings`
        """
        return self._ClusterAdvancedSettings

    @ClusterAdvancedSettings.setter
    def ClusterAdvancedSettings(self, ClusterAdvancedSettings):
        self._ClusterAdvancedSettings = ClusterAdvancedSettings

    @property
    def Level(self):
        r"""边缘容器集群级别
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def AutoUpgradeClusterLevel(self):
        r"""是否支持自动提升集群配置
        :rtype: bool
        """
        return self._AutoUpgradeClusterLevel

    @AutoUpgradeClusterLevel.setter
    def AutoUpgradeClusterLevel(self, AutoUpgradeClusterLevel):
        self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel

    @property
    def ChargeType(self):
        r"""集群付费模式，支持POSTPAID_BY_HOUR或者PREPAID
        :rtype: str
        """
        return self._ChargeType

    @ChargeType.setter
    def ChargeType(self, ChargeType):
        self._ChargeType = ChargeType

    @property
    def EdgeVersion(self):
        r"""边缘集群组件的版本
        :rtype: str
        """
        return self._EdgeVersion

    @EdgeVersion.setter
    def EdgeVersion(self, EdgeVersion):
        self._EdgeVersion = EdgeVersion

    @property
    def TagSpecification(self):
        r"""集群绑定的云标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.TagSpecification`
        """
        return self._TagSpecification

    @TagSpecification.setter
    def TagSpecification(self, TagSpecification):
        self._TagSpecification = TagSpecification


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._VpcId = params.get("VpcId")
        self._PodCIDR = params.get("PodCIDR")
        self._ServiceCIDR = params.get("ServiceCIDR")
        self._K8SVersion = params.get("K8SVersion")
        self._Status = params.get("Status")
        self._ClusterDesc = params.get("ClusterDesc")
        self._CreatedTime = params.get("CreatedTime")
        self._EdgeClusterVersion = params.get("EdgeClusterVersion")
        self._MaxNodePodNum = params.get("MaxNodePodNum")
        if params.get("ClusterAdvancedSettings") is not None:
            self._ClusterAdvancedSettings = EdgeClusterAdvancedSettings()
            self._ClusterAdvancedSettings._deserialize(params.get("ClusterAdvancedSettings"))
        self._Level = params.get("Level")
        self._AutoUpgradeClusterLevel = params.get("AutoUpgradeClusterLevel")
        self._ChargeType = params.get("ChargeType")
        self._EdgeVersion = params.get("EdgeVersion")
        if params.get("TagSpecification") is not None:
            self._TagSpecification = TagSpecification()
            self._TagSpecification._deserialize(params.get("TagSpecification"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeClusterAdvancedSettings(AbstractModel):
    r"""边缘容器集群高级配置

    """

    def __init__(self):
        r"""
        :param _ExtraArgs: 集群自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtraArgs: :class:`tencentcloud.tke.v20180525.models.EdgeClusterExtraArgs`
        :param _Runtime: 运行时类型，支持"docker"和"containerd"，默认为docker
        :type Runtime: str
        :param _ProxyMode: 集群kube-proxy转发模式，支持"iptables"和"ipvs"，默认为iptables
        :type ProxyMode: str
        """
        self._ExtraArgs = None
        self._Runtime = None
        self._ProxyMode = None

    @property
    def ExtraArgs(self):
        r"""集群自定义参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.EdgeClusterExtraArgs`
        """
        return self._ExtraArgs

    @ExtraArgs.setter
    def ExtraArgs(self, ExtraArgs):
        self._ExtraArgs = ExtraArgs

    @property
    def Runtime(self):
        r"""运行时类型，支持"docker"和"containerd"，默认为docker
        :rtype: str
        """
        return self._Runtime

    @Runtime.setter
    def Runtime(self, Runtime):
        self._Runtime = Runtime

    @property
    def ProxyMode(self):
        r"""集群kube-proxy转发模式，支持"iptables"和"ipvs"，默认为iptables
        :rtype: str
        """
        return self._ProxyMode

    @ProxyMode.setter
    def ProxyMode(self, ProxyMode):
        self._ProxyMode = ProxyMode


    def _deserialize(self, params):
        if params.get("ExtraArgs") is not None:
            self._ExtraArgs = EdgeClusterExtraArgs()
            self._ExtraArgs._deserialize(params.get("ExtraArgs"))
        self._Runtime = params.get("Runtime")
        self._ProxyMode = params.get("ProxyMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeClusterExtraArgs(AbstractModel):
    r"""边缘容器集群master自定义参数

    """

    def __init__(self):
        r"""
        :param _KubeAPIServer: kube-apiserver自定义参数，参数格式为["k1=v1", "k1=v2"]， 例如["max-requests-inflight=500","feature-gates=PodShareProcessNamespace=true,DynamicKubeletConfig=true"]
        :type KubeAPIServer: list of str
        :param _KubeControllerManager: kube-controller-manager自定义参数
        :type KubeControllerManager: list of str
        :param _KubeScheduler: kube-scheduler自定义参数
        :type KubeScheduler: list of str
        """
        self._KubeAPIServer = None
        self._KubeControllerManager = None
        self._KubeScheduler = None

    @property
    def KubeAPIServer(self):
        r"""kube-apiserver自定义参数，参数格式为["k1=v1", "k1=v2"]， 例如["max-requests-inflight=500","feature-gates=PodShareProcessNamespace=true,DynamicKubeletConfig=true"]
        :rtype: list of str
        """
        return self._KubeAPIServer

    @KubeAPIServer.setter
    def KubeAPIServer(self, KubeAPIServer):
        self._KubeAPIServer = KubeAPIServer

    @property
    def KubeControllerManager(self):
        r"""kube-controller-manager自定义参数
        :rtype: list of str
        """
        return self._KubeControllerManager

    @KubeControllerManager.setter
    def KubeControllerManager(self, KubeControllerManager):
        self._KubeControllerManager = KubeControllerManager

    @property
    def KubeScheduler(self):
        r"""kube-scheduler自定义参数
        :rtype: list of str
        """
        return self._KubeScheduler

    @KubeScheduler.setter
    def KubeScheduler(self, KubeScheduler):
        self._KubeScheduler = KubeScheduler


    def _deserialize(self, params):
        self._KubeAPIServer = params.get("KubeAPIServer")
        self._KubeControllerManager = params.get("KubeControllerManager")
        self._KubeScheduler = params.get("KubeScheduler")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeClusterInternalLB(AbstractModel):
    r"""边缘计算集群内网访问LB信息

    """

    def __init__(self):
        r"""
        :param _Enabled: 是否开启内网访问LB
        :type Enabled: bool
        :param _SubnetId: 内网访问LB关联的子网Id
        :type SubnetId: list of str
        """
        self._Enabled = None
        self._SubnetId = None

    @property
    def Enabled(self):
        r"""是否开启内网访问LB
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def SubnetId(self):
        r"""内网访问LB关联的子网Id
        :rtype: list of str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        self._SubnetId = params.get("SubnetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EdgeClusterPublicLB(AbstractModel):
    r"""边缘计算集群公网访问负载均衡信息

    """

    def __init__(self):
        r"""
        :param _Enabled: 是否开启公网访问LB
        :type Enabled: bool
        :param _AllowFromCidrs: 允许访问的公网cidr
        :type AllowFromCidrs: list of str
        """
        self._Enabled = None
        self._AllowFromCidrs = None

    @property
    def Enabled(self):
        r"""是否开启公网访问LB
        :rtype: bool
        """
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def AllowFromCidrs(self):
        r"""允许访问的公网cidr
        :rtype: list of str
        """
        return self._AllowFromCidrs

    @AllowFromCidrs.setter
    def AllowFromCidrs(self, AllowFromCidrs):
        self._AllowFromCidrs = AllowFromCidrs


    def _deserialize(self, params):
        self._Enabled = params.get("Enabled")
        self._AllowFromCidrs = params.get("AllowFromCidrs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EipAttribute(AbstractModel):
    r"""用以帮助用户自动创建EIP的配置

    """

    def __init__(self):
        r"""
        :param _DeletePolicy: 容器实例删除后，EIP是否释放。
Never表示不释放，其他任意值（包括空字符串）表示释放。
        :type DeletePolicy: str
        :param _InternetServiceProvider: EIP线路类型。默认值：BGP。
已开通静态单线IP白名单的用户，可选值：
CMCC：中国移动
CTCC：中国电信
CUCC：中国联通
注意：仅部分地域支持静态单线IP。
注意：此字段可能返回 null，表示取不到有效值。
        :type InternetServiceProvider: str
        :param _InternetMaxBandwidthOut: EIP出带宽上限，单位：Mbps。
注意：此字段可能返回 null，表示取不到有效值。
        :type InternetMaxBandwidthOut: int
        """
        self._DeletePolicy = None
        self._InternetServiceProvider = None
        self._InternetMaxBandwidthOut = None

    @property
    def DeletePolicy(self):
        r"""容器实例删除后，EIP是否释放。
Never表示不释放，其他任意值（包括空字符串）表示释放。
        :rtype: str
        """
        return self._DeletePolicy

    @DeletePolicy.setter
    def DeletePolicy(self, DeletePolicy):
        self._DeletePolicy = DeletePolicy

    @property
    def InternetServiceProvider(self):
        r"""EIP线路类型。默认值：BGP。
已开通静态单线IP白名单的用户，可选值：
CMCC：中国移动
CTCC：中国电信
CUCC：中国联通
注意：仅部分地域支持静态单线IP。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._InternetServiceProvider

    @InternetServiceProvider.setter
    def InternetServiceProvider(self, InternetServiceProvider):
        self._InternetServiceProvider = InternetServiceProvider

    @property
    def InternetMaxBandwidthOut(self):
        r"""EIP出带宽上限，单位：Mbps。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._InternetMaxBandwidthOut

    @InternetMaxBandwidthOut.setter
    def InternetMaxBandwidthOut(self, InternetMaxBandwidthOut):
        self._InternetMaxBandwidthOut = InternetMaxBandwidthOut


    def _deserialize(self, params):
        self._DeletePolicy = params.get("DeletePolicy")
        self._InternetServiceProvider = params.get("InternetServiceProvider")
        self._InternetMaxBandwidthOut = params.get("InternetMaxBandwidthOut")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EksCi(AbstractModel):
    r"""EksContainerInstance实例类型

    """

    def __init__(self):
        r"""
        :param _AutoCreatedEipId: 自动为用户创建的EipId
        :type AutoCreatedEipId: str
        :param _CamRoleName: 为容器实例关联 CAM 角色，value 填写 CAM 角色名称，容器实例可获取该 CAM 角色包含的权限策略，方便 容器实例 内的程序进行如购买资源、读写存储等云资源操作。
        :type CamRoleName: str
        :param _Containers: 容器列表
        :type Containers: list of Container
        :param _Cpu: CPU大小
        :type Cpu: float
        :param _CpuType: CPU类型
        :type CpuType: str
        :param _CreationTime: 接到请求后的系统创建时间。
        :type CreationTime: str
        :param _EipAddress: 容器实例绑定的Eip地址，注意可能为空
注意：此字段可能返回 null，表示取不到有效值。
        :type EipAddress: str
        :param _EksCiId: EKS Container Instance Id
        :type EksCiId: str
        :param _EksCiName: EKS Container Instance Name
        :type EksCiName: str
        :param _EksCiVolume: 数据卷信息
        :type EksCiVolume: :class:`tencentcloud.tke.v20180525.models.EksCiVolume`
        :param _GpuCount: GPU卡数量
        :type GpuCount: int
        :param _GpuType: GPU类型。如无使用GPU则不返回
        :type GpuType: str
        :param _InitContainers: 初始化容器列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InitContainers: list of Container
        :param _Memory: 内存大小
        :type Memory: float
        :param _PersistStatus: 容器状态是否持久化
注意：此字段可能返回 null，表示取不到有效值。
        :type PersistStatus: bool
        :param _PrivateIp: 内网ip地址
        :type PrivateIp: str
        :param _RestartPolicy: 容器组的重启策略
        :type RestartPolicy: str
        :param _SecurityContext: 容器组运行的安全上下文
注意：此字段可能返回 null，表示取不到有效值。
        :type SecurityContext: :class:`tencentcloud.tke.v20180525.models.SecurityContext`
        :param _SecurityGroupIds: 安全组ID
        :type SecurityGroupIds: list of str
        :param _Status: 返回容器组创建状态：Pending，Running，Succeeded，Failed。其中：
Failed （运行失败）指的容器组退出，RestartPolilcy为Never， 有容器exitCode非0；
Succeeded（运行成功）指的是容器组退出了，RestartPolicy为Never或onFailure，所有容器exitCode都为0；
Failed和Succeeded这两种状态都会停止运行，停止计费。
Pending是创建中，Running是 运行中。
        :type Status: str
        :param _SubnetId: 实例所属子网Id
        :type SubnetId: str
        :param _SucceededTime: 容器全部成功退出后的时间
        :type SucceededTime: str
        :param _VpcId: 实例所属VPC的Id
        :type VpcId: str
        """
        self._AutoCreatedEipId = None
        self._CamRoleName = None
        self._Containers = None
        self._Cpu = None
        self._CpuType = None
        self._CreationTime = None
        self._EipAddress = None
        self._EksCiId = None
        self._EksCiName = None
        self._EksCiVolume = None
        self._GpuCount = None
        self._GpuType = None
        self._InitContainers = None
        self._Memory = None
        self._PersistStatus = None
        self._PrivateIp = None
        self._RestartPolicy = None
        self._SecurityContext = None
        self._SecurityGroupIds = None
        self._Status = None
        self._SubnetId = None
        self._SucceededTime = None
        self._VpcId = None

    @property
    def AutoCreatedEipId(self):
        r"""自动为用户创建的EipId
        :rtype: str
        """
        return self._AutoCreatedEipId

    @AutoCreatedEipId.setter
    def AutoCreatedEipId(self, AutoCreatedEipId):
        self._AutoCreatedEipId = AutoCreatedEipId

    @property
    def CamRoleName(self):
        r"""为容器实例关联 CAM 角色，value 填写 CAM 角色名称，容器实例可获取该 CAM 角色包含的权限策略，方便 容器实例 内的程序进行如购买资源、读写存储等云资源操作。
        :rtype: str
        """
        return self._CamRoleName

    @CamRoleName.setter
    def CamRoleName(self, CamRoleName):
        self._CamRoleName = CamRoleName

    @property
    def Containers(self):
        r"""容器列表
        :rtype: list of Container
        """
        return self._Containers

    @Containers.setter
    def Containers(self, Containers):
        self._Containers = Containers

    @property
    def Cpu(self):
        r"""CPU大小
        :rtype: float
        """
        return self._Cpu

    @Cpu.setter
    def Cpu(self, Cpu):
        self._Cpu = Cpu

    @property
    def CpuType(self):
        r"""CPU类型
        :rtype: str
        """
        return self._CpuType

    @CpuType.setter
    def CpuType(self, CpuType):
        self._CpuType = CpuType

    @property
    def CreationTime(self):
        r"""接到请求后的系统创建时间。
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def EipAddress(self):
        r"""容器实例绑定的Eip地址，注意可能为空
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._EipAddress

    @EipAddress.setter
    def EipAddress(self, EipAddress):
        self._EipAddress = EipAddress

    @property
    def EksCiId(self):
        r"""EKS Container Instance Id
        :rtype: str
        """
        return self._EksCiId

    @EksCiId.setter
    def EksCiId(self, EksCiId):
        self._EksCiId = EksCiId

    @property
    def EksCiName(self):
        r"""EKS Container Instance Name
        :rtype: str
        """
        return self._EksCiName

    @EksCiName.setter
    def EksCiName(self, EksCiName):
        self._EksCiName = EksCiName

    @property
    def EksCiVolume(self):
        r"""数据卷信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.EksCiVolume`
        """
        return self._EksCiVolume

    @EksCiVolume.setter
    def EksCiVolume(self, EksCiVolume):
        self._EksCiVolume = EksCiVolume

    @property
    def GpuCount(self):
        r"""GPU卡数量
        :rtype: int
        """
        return self._GpuCount

    @GpuCount.setter
    def GpuCount(self, GpuCount):
        self._GpuCount = GpuCount

    @property
    def GpuType(self):
        r"""GPU类型。如无使用GPU则不返回
        :rtype: str
        """
        return self._GpuType

    @GpuType.setter
    def GpuType(self, GpuType):
        self._GpuType = GpuType

    @property
    def InitContainers(self):
        r"""初始化容器列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Container
        """
        return self._InitContainers

    @InitContainers.setter
    def InitContainers(self, InitContainers):
        self._InitContainers = InitContainers

    @property
    def Memory(self):
        r"""内存大小
        :rtype: float
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def PersistStatus(self):
        r"""容器状态是否持久化
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: bool
        """
        return self._PersistStatus

    @PersistStatus.setter
    def PersistStatus(self, PersistStatus):
        self._PersistStatus = PersistStatus

    @property
    def PrivateIp(self):
        r"""内网ip地址
        :rtype: str
        """
        return self._PrivateIp

    @PrivateIp.setter
    def PrivateIp(self, PrivateIp):
        self._PrivateIp = PrivateIp

    @property
    def RestartPolicy(self):
        r"""容器组的重启策略
        :rtype: str
        """
        return self._RestartPolicy

    @RestartPolicy.setter
    def RestartPolicy(self, RestartPolicy):
        self._RestartPolicy = RestartPolicy

    @property
    def SecurityContext(self):
        r"""容器组运行的安全上下文
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.SecurityContext`
        """
        return self._SecurityContext

    @SecurityContext.setter
    def SecurityContext(self, SecurityContext):
        self._SecurityContext = SecurityContext

    @property
    def SecurityGroupIds(self):
        r"""安全组ID
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Status(self):
        r"""返回容器组创建状态：Pending，Running，Succeeded，Failed。其中：
Failed （运行失败）指的容器组退出，RestartPolilcy为Never， 有容器exitCode非0；
Succeeded（运行成功）指的是容器组退出了，RestartPolicy为Never或onFailure，所有容器exitCode都为0；
Failed和Succeeded这两种状态都会停止运行，停止计费。
Pending是创建中，Running是 运行中。
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def SubnetId(self):
        r"""实例所属子网Id
        :rtype: str
        """
        return self._SubnetId

    @SubnetId.setter
    def SubnetId(self, SubnetId):
        self._SubnetId = SubnetId

    @property
    def SucceededTime(self):
        r"""容器全部成功退出后的时间
        :rtype: str
        """
        return self._SucceededTime

    @SucceededTime.setter
    def SucceededTime(self, SucceededTime):
        self._SucceededTime = SucceededTime

    @property
    def VpcId(self):
        r"""实例所属VPC的Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId


    def _deserialize(self, params):
        self._AutoCreatedEipId = params.get("AutoCreatedEipId")
        self._CamRoleName = params.get("CamRoleName")
        if params.get("Containers") is not None:
            self._Containers = []
            for item in params.get("Containers"):
                obj = Container()
                obj._deserialize(item)
                self._Containers.append(obj)
        self._Cpu = params.get("Cpu")
        self._CpuType = params.get("CpuType")
        self._CreationTime = params.get("CreationTime")
        self._EipAddress = params.get("EipAddress")
        self._EksCiId = params.get("EksCiId")
        self._EksCiName = params.get("EksCiName")
        if params.get("EksCiVolume") is not None:
            self._EksCiVolume = EksCiVolume()
            self._EksCiVolume._deserialize(params.get("EksCiVolume"))
        self._GpuCount = params.get("GpuCount")
        self._GpuType = params.get("GpuType")
        if params.get("InitContainers") is not None:
            self._InitContainers = []
            for item in params.get("InitContainers"):
                obj = Container()
                obj._deserialize(item)
                self._InitContainers.append(obj)
        self._Memory = params.get("Memory")
        self._PersistStatus = params.get("PersistStatus")
        self._PrivateIp = params.get("PrivateIp")
        self._RestartPolicy = params.get("RestartPolicy")
        if params.get("SecurityContext") is not None:
            self._SecurityContext = SecurityContext()
            self._SecurityContext._deserialize(params.get("SecurityContext"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._Status = params.get("Status")
        self._SubnetId = params.get("SubnetId")
        self._SucceededTime = params.get("SucceededTime")
        self._VpcId = params.get("VpcId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EksCiRegionInfo(AbstractModel):
    r"""EksCi地域信息

    """

    def __init__(self):
        r"""
        :param _Alias: 地域别名，形如gz
        :type Alias: str
        :param _RegionName: 地域名，形如ap-guangzhou
        :type RegionName: str
        :param _RegionId: 地域ID
        :type RegionId: int
        """
        self._Alias = None
        self._RegionName = None
        self._RegionId = None

    @property
    def Alias(self):
        r"""地域别名，形如gz
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def RegionName(self):
        r"""地域名，形如ap-guangzhou
        :rtype: str
        """
        return self._RegionName

    @RegionName.setter
    def RegionName(self, RegionName):
        self._RegionName = RegionName

    @property
    def RegionId(self):
        r"""地域ID
        :rtype: int
        """
        return self._RegionId

    @RegionId.setter
    def RegionId(self, RegionId):
        self._RegionId = RegionId


    def _deserialize(self, params):
        self._Alias = params.get("Alias")
        self._RegionName = params.get("RegionName")
        self._RegionId = params.get("RegionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EksCiVolume(AbstractModel):
    r"""EKS Instance Volume,  可选包括CbsVolume和NfsVolume

    """

    def __init__(self):
        r"""
        :param _CbsVolumes: Cbs Volume
注意：此字段可能返回 null，表示取不到有效值。
        :type CbsVolumes: list of CbsVolume
        :param _NfsVolumes: Nfs Volume
注意：此字段可能返回 null，表示取不到有效值。
        :type NfsVolumes: list of NfsVolume
        """
        self._CbsVolumes = None
        self._NfsVolumes = None

    @property
    def CbsVolumes(self):
        r"""Cbs Volume
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of CbsVolume
        """
        return self._CbsVolumes

    @CbsVolumes.setter
    def CbsVolumes(self, CbsVolumes):
        self._CbsVolumes = CbsVolumes

    @property
    def NfsVolumes(self):
        r"""Nfs Volume
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of NfsVolume
        """
        return self._NfsVolumes

    @NfsVolumes.setter
    def NfsVolumes(self, NfsVolumes):
        self._NfsVolumes = NfsVolumes


    def _deserialize(self, params):
        if params.get("CbsVolumes") is not None:
            self._CbsVolumes = []
            for item in params.get("CbsVolumes"):
                obj = CbsVolume()
                obj._deserialize(item)
                self._CbsVolumes.append(obj)
        if params.get("NfsVolumes") is not None:
            self._NfsVolumes = []
            for item in params.get("NfsVolumes"):
                obj = NfsVolume()
                obj._deserialize(item)
                self._NfsVolumes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EksCluster(AbstractModel):
    r"""弹性集群信息

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群Id
        :type ClusterId: str
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _VpcId: Vpc Id
        :type VpcId: str
        :param _SubnetIds: 子网列表
        :type SubnetIds: list of str
        :param _K8SVersion: k8s 版本号
        :type K8SVersion: str
        :param _Status: 集群状态(running 运行中，initializing 初始化中，Failed 异常，Idling 空闲中，Activating 激活中，Terminating 删除中)
        :type Status: str
        :param _ClusterDesc: 集群描述信息
        :type ClusterDesc: str
        :param _CreatedTime: 集群创建时间
        :type CreatedTime: str
        :param _ServiceSubnetId: Service 子网Id
        :type ServiceSubnetId: str
        :param _DnsServers: 集群的自定义dns 服务器信息
        :type DnsServers: list of DnsServerConf
        :param _NeedDeleteCbs: 将来删除集群时是否要删除cbs。默认为 FALSE
        :type NeedDeleteCbs: bool
        :param _EnableVpcCoreDNS: 是否在用户集群内开启Dns。默认为TRUE
        :type EnableVpcCoreDNS: bool
        :param _TagSpecification: 标签描述列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type TagSpecification: list of TagSpecification
        """
        self._ClusterId = None
        self._ClusterName = None
        self._VpcId = None
        self._SubnetIds = None
        self._K8SVersion = None
        self._Status = None
        self._ClusterDesc = None
        self._CreatedTime = None
        self._ServiceSubnetId = None
        self._DnsServers = None
        self._NeedDeleteCbs = None
        self._EnableVpcCoreDNS = None
        self._TagSpecification = None

    @property
    def ClusterId(self):
        r"""集群Id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def VpcId(self):
        r"""Vpc Id
        :rtype: str
        """
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def SubnetIds(self):
        r"""子网列表
        :rtype: list of str
        """
        return self._SubnetIds

    @SubnetIds.setter
    def SubnetIds(self, SubnetIds):
        self._SubnetIds = SubnetIds

    @property
    def K8SVersion(self):
        r"""k8s 版本号
        :rtype: str
        """
        return self._K8SVersion

    @K8SVersion.setter
    def K8SVersion(self, K8SVersion):
        self._K8SVersion = K8SVersion

    @property
    def Status(self):
        r"""集群状态(running 运行中，initializing 初始化中，Failed 异常，Idling 空闲中，Activating 激活中，Terminating 删除中)
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ClusterDesc(self):
        r"""集群描述信息
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def CreatedTime(self):
        r"""集群创建时间
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def ServiceSubnetId(self):
        r"""Service 子网Id
        :rtype: str
        """
        return self._ServiceSubnetId

    @ServiceSubnetId.setter
    def ServiceSubnetId(self, ServiceSubnetId):
        self._ServiceSubnetId = ServiceSubnetId

    @property
    def DnsServers(self):
        r"""集群的自定义dns 服务器信息
        :rtype: list of DnsServerConf
        """
        return self._DnsServers

    @DnsServers.setter
    def DnsServers(self, DnsServers):
        self._DnsServers = DnsServers

    @property
    def NeedDeleteCbs(self):
        r"""将来删除集群时是否要删除cbs。默认为 FALSE
        :rtype: bool
        """
        return self._NeedDeleteCbs

    @NeedDeleteCbs.setter
    def NeedDeleteCbs(self, NeedDeleteCbs):
        self._NeedDeleteCbs = NeedDeleteCbs

    @property
    def EnableVpcCoreDNS(self):
        r"""是否在用户集群内开启Dns。默认为TRUE
        :rtype: bool
        """
        return self._EnableVpcCoreDNS

    @EnableVpcCoreDNS.setter
    def EnableVpcCoreDNS(self, EnableVpcCoreDNS):
        self._EnableVpcCoreDNS = EnableVpcCoreDNS

    @property
    def TagSpecification(self):
        r"""标签描述列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of TagSpecification
        """
        return self._TagSpecification

    @TagSpecification.setter
    def TagSpecification(self, TagSpecification):
        self._TagSpecification = TagSpecification


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._VpcId = params.get("VpcId")
        self._SubnetIds = params.get("SubnetIds")
        self._K8SVersion = params.get("K8SVersion")
        self._Status = params.get("Status")
        self._ClusterDesc = params.get("ClusterDesc")
        self._CreatedTime = params.get("CreatedTime")
        self._ServiceSubnetId = params.get("ServiceSubnetId")
        if params.get("DnsServers") is not None:
            self._DnsServers = []
            for item in params.get("DnsServers"):
                obj = DnsServerConf()
                obj._deserialize(item)
                self._DnsServers.append(obj)
        self._NeedDeleteCbs = params.get("NeedDeleteCbs")
        self._EnableVpcCoreDNS = params.get("EnableVpcCoreDNS")
        if params.get("TagSpecification") is not None:
            self._TagSpecification = []
            for item in params.get("TagSpecification"):
                obj = TagSpecification()
                obj._deserialize(item)
                self._TagSpecification.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableClusterAuditRequest(AbstractModel):
    r"""EnableClusterAudit请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _LogsetId: CLS日志集ID
        :type LogsetId: str
        :param _TopicId: CLS日志主题ID
        :type TopicId: str
        :param _TopicRegion: topic所在region，默认为集群当前region
        :type TopicRegion: str
        """
        self._ClusterId = None
        self._LogsetId = None
        self._TopicId = None
        self._TopicRegion = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def LogsetId(self):
        r"""CLS日志集ID
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def TopicId(self):
        r"""CLS日志主题ID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicRegion(self):
        r"""topic所在region，默认为集群当前region
        :rtype: str
        """
        return self._TopicRegion

    @TopicRegion.setter
    def TopicRegion(self, TopicRegion):
        self._TopicRegion = TopicRegion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._LogsetId = params.get("LogsetId")
        self._TopicId = params.get("TopicId")
        self._TopicRegion = params.get("TopicRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableClusterAuditResponse(AbstractModel):
    r"""EnableClusterAudit返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableClusterDeletionProtectionRequest(AbstractModel):
    r"""EnableClusterDeletionProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableClusterDeletionProtectionResponse(AbstractModel):
    r"""EnableClusterDeletionProtection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableEncryptionProtectionRequest(AbstractModel):
    r"""EnableEncryptionProtection请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _KMSConfiguration: kms加密配置
        :type KMSConfiguration: :class:`tencentcloud.tke.v20180525.models.KMSConfiguration`
        """
        self._ClusterId = None
        self._KMSConfiguration = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def KMSConfiguration(self):
        r"""kms加密配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.KMSConfiguration`
        """
        return self._KMSConfiguration

    @KMSConfiguration.setter
    def KMSConfiguration(self, KMSConfiguration):
        self._KMSConfiguration = KMSConfiguration


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("KMSConfiguration") is not None:
            self._KMSConfiguration = KMSConfiguration()
            self._KMSConfiguration._deserialize(params.get("KMSConfiguration"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableEncryptionProtectionResponse(AbstractModel):
    r"""EnableEncryptionProtection返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableEventPersistenceRequest(AbstractModel):
    r"""EnableEventPersistence请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _LogsetId: cls服务的logsetID
        :type LogsetId: str
        :param _TopicId: cls服务的topicID
        :type TopicId: str
        :param _TopicRegion: topic所在地域，默认为集群所在地域
        :type TopicRegion: str
        """
        self._ClusterId = None
        self._LogsetId = None
        self._TopicId = None
        self._TopicRegion = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def LogsetId(self):
        r"""cls服务的logsetID
        :rtype: str
        """
        return self._LogsetId

    @LogsetId.setter
    def LogsetId(self, LogsetId):
        self._LogsetId = LogsetId

    @property
    def TopicId(self):
        r"""cls服务的topicID
        :rtype: str
        """
        return self._TopicId

    @TopicId.setter
    def TopicId(self, TopicId):
        self._TopicId = TopicId

    @property
    def TopicRegion(self):
        r"""topic所在地域，默认为集群所在地域
        :rtype: str
        """
        return self._TopicRegion

    @TopicRegion.setter
    def TopicRegion(self, TopicRegion):
        self._TopicRegion = TopicRegion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._LogsetId = params.get("LogsetId")
        self._TopicId = params.get("TopicId")
        self._TopicRegion = params.get("TopicRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableEventPersistenceResponse(AbstractModel):
    r"""EnableEventPersistence返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableVpcCniNetworkTypeRequest(AbstractModel):
    r"""EnableVpcCniNetworkType请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _VpcCniType: 开启vpc-cni的模式，tke-route-eni开启的是策略路由模式，tke-direct-eni开启的是独立网卡模式
        :type VpcCniType: str
        :param _EnableStaticIp: 是否开启固定IP模式
        :type EnableStaticIp: bool
        :param _Subnets: 使用的容器子网
        :type Subnets: list of str
        :param _ExpiredSeconds: 在固定IP模式下，Pod销毁后退还IP的时间，传参必须大于300；不传默认IP永不销毁。
        :type ExpiredSeconds: int
        :param _SkipAddingNonMasqueradeCIDRs: 是否同步添加 vpc 网段到 ip-masq-agent-config 的 NonMasqueradeCIDRs 字段，默认 false 会同步添加
        :type SkipAddingNonMasqueradeCIDRs: bool
        """
        self._ClusterId = None
        self._VpcCniType = None
        self._EnableStaticIp = None
        self._Subnets = None
        self._ExpiredSeconds = None
        self._SkipAddingNonMasqueradeCIDRs = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def VpcCniType(self):
        r"""开启vpc-cni的模式，tke-route-eni开启的是策略路由模式，tke-direct-eni开启的是独立网卡模式
        :rtype: str
        """
        return self._VpcCniType

    @VpcCniType.setter
    def VpcCniType(self, VpcCniType):
        self._VpcCniType = VpcCniType

    @property
    def EnableStaticIp(self):
        r"""是否开启固定IP模式
        :rtype: bool
        """
        return self._EnableStaticIp

    @EnableStaticIp.setter
    def EnableStaticIp(self, EnableStaticIp):
        self._EnableStaticIp = EnableStaticIp

    @property
    def Subnets(self):
        r"""使用的容器子网
        :rtype: list of str
        """
        return self._Subnets

    @Subnets.setter
    def Subnets(self, Subnets):
        self._Subnets = Subnets

    @property
    def ExpiredSeconds(self):
        r"""在固定IP模式下，Pod销毁后退还IP的时间，传参必须大于300；不传默认IP永不销毁。
        :rtype: int
        """
        return self._ExpiredSeconds

    @ExpiredSeconds.setter
    def ExpiredSeconds(self, ExpiredSeconds):
        self._ExpiredSeconds = ExpiredSeconds

    @property
    def SkipAddingNonMasqueradeCIDRs(self):
        r"""是否同步添加 vpc 网段到 ip-masq-agent-config 的 NonMasqueradeCIDRs 字段，默认 false 会同步添加
        :rtype: bool
        """
        return self._SkipAddingNonMasqueradeCIDRs

    @SkipAddingNonMasqueradeCIDRs.setter
    def SkipAddingNonMasqueradeCIDRs(self, SkipAddingNonMasqueradeCIDRs):
        self._SkipAddingNonMasqueradeCIDRs = SkipAddingNonMasqueradeCIDRs


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._VpcCniType = params.get("VpcCniType")
        self._EnableStaticIp = params.get("EnableStaticIp")
        self._Subnets = params.get("Subnets")
        self._ExpiredSeconds = params.get("ExpiredSeconds")
        self._SkipAddingNonMasqueradeCIDRs = params.get("SkipAddingNonMasqueradeCIDRs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableVpcCniNetworkTypeResponse(AbstractModel):
    r"""EnableVpcCniNetworkType返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnhancedService(AbstractModel):
    r"""描述了实例的增强服务启用情况与其设置，如云安全，云监控等实例 Agent

    """

    def __init__(self):
        r"""
        :param _SecurityService: 开启云安全服务。若不指定该参数，则默认开启云安全服务。
        :type SecurityService: :class:`tencentcloud.tke.v20180525.models.RunSecurityServiceEnabled`
        :param _MonitorService: 开启云监控服务。若不指定该参数，则默认开启云监控服务。
        :type MonitorService: :class:`tencentcloud.tke.v20180525.models.RunMonitorServiceEnabled`
        :param _AutomationService: 开启云自动化助手服务（TencentCloud Automation Tools，TAT）。若不指定该参数，则公共镜像默认开启云自动化助手服务，其他镜像默认不开启云自动化助手服务。
        :type AutomationService: :class:`tencentcloud.tke.v20180525.models.RunAutomationServiceEnabled`
        """
        self._SecurityService = None
        self._MonitorService = None
        self._AutomationService = None

    @property
    def SecurityService(self):
        r"""开启云安全服务。若不指定该参数，则默认开启云安全服务。
        :rtype: :class:`tencentcloud.tke.v20180525.models.RunSecurityServiceEnabled`
        """
        return self._SecurityService

    @SecurityService.setter
    def SecurityService(self, SecurityService):
        self._SecurityService = SecurityService

    @property
    def MonitorService(self):
        r"""开启云监控服务。若不指定该参数，则默认开启云监控服务。
        :rtype: :class:`tencentcloud.tke.v20180525.models.RunMonitorServiceEnabled`
        """
        return self._MonitorService

    @MonitorService.setter
    def MonitorService(self, MonitorService):
        self._MonitorService = MonitorService

    @property
    def AutomationService(self):
        r"""开启云自动化助手服务（TencentCloud Automation Tools，TAT）。若不指定该参数，则公共镜像默认开启云自动化助手服务，其他镜像默认不开启云自动化助手服务。
        :rtype: :class:`tencentcloud.tke.v20180525.models.RunAutomationServiceEnabled`
        """
        return self._AutomationService

    @AutomationService.setter
    def AutomationService(self, AutomationService):
        self._AutomationService = AutomationService


    def _deserialize(self, params):
        if params.get("SecurityService") is not None:
            self._SecurityService = RunSecurityServiceEnabled()
            self._SecurityService._deserialize(params.get("SecurityService"))
        if params.get("MonitorService") is not None:
            self._MonitorService = RunMonitorServiceEnabled()
            self._MonitorService._deserialize(params.get("MonitorService"))
        if params.get("AutomationService") is not None:
            self._AutomationService = RunAutomationServiceEnabled()
            self._AutomationService._deserialize(params.get("AutomationService"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnvironmentVariable(AbstractModel):
    r"""EnvironmentVariable

    """

    def __init__(self):
        r"""
        :param _Name: key
        :type Name: str
        :param _Value: val
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        r"""key
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""val
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EtcdOverrideConfig(AbstractModel):
    r"""元数据拆分存储Etcd配置

    """

    def __init__(self):
        r"""
        :param _Resources: k8s资源，支持核心资源，控制类资源，配置及敏感资源
        :type Resources: list of str
        """
        self._Resources = None

    @property
    def Resources(self):
        r"""k8s资源，支持核心资源，控制类资源，配置及敏感资源
        :rtype: list of str
        """
        return self._Resources

    @Resources.setter
    def Resources(self, Resources):
        self._Resources = Resources


    def _deserialize(self, params):
        self._Resources = params.get("Resources")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Event(AbstractModel):
    r"""服务事件

    """

    def __init__(self):
        r"""
        :param _PodName: pod名称
        :type PodName: str
        :param _Reason: 事件原因内容
        :type Reason: str
        :param _Type: 事件类型
        :type Type: str
        :param _Count: 事件出现次数
        :type Count: int
        :param _FirstTimestamp: 事件第一次出现时间
        :type FirstTimestamp: str
        :param _LastTimestamp: 事件最后一次出现时间
        :type LastTimestamp: str
        :param _Message: 事件内容
        :type Message: str
        """
        self._PodName = None
        self._Reason = None
        self._Type = None
        self._Count = None
        self._FirstTimestamp = None
        self._LastTimestamp = None
        self._Message = None

    @property
    def PodName(self):
        r"""pod名称
        :rtype: str
        """
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def Reason(self):
        r"""事件原因内容
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Type(self):
        r"""事件类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Count(self):
        r"""事件出现次数
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count

    @property
    def FirstTimestamp(self):
        r"""事件第一次出现时间
        :rtype: str
        """
        return self._FirstTimestamp

    @FirstTimestamp.setter
    def FirstTimestamp(self, FirstTimestamp):
        self._FirstTimestamp = FirstTimestamp

    @property
    def LastTimestamp(self):
        r"""事件最后一次出现时间
        :rtype: str
        """
        return self._LastTimestamp

    @LastTimestamp.setter
    def LastTimestamp(self, LastTimestamp):
        self._LastTimestamp = LastTimestamp

    @property
    def Message(self):
        r"""事件内容
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._PodName = params.get("PodName")
        self._Reason = params.get("Reason")
        self._Type = params.get("Type")
        self._Count = params.get("Count")
        self._FirstTimestamp = params.get("FirstTimestamp")
        self._LastTimestamp = params.get("LastTimestamp")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Exec(AbstractModel):
    r"""探针在容器内执行检测命令参数类型

    """

    def __init__(self):
        r"""
        :param _Commands: 容器内检测的命令
注意：此字段可能返回 null，表示取不到有效值。
        :type Commands: list of str
        """
        self._Commands = None

    @property
    def Commands(self):
        r"""容器内检测的命令
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Commands

    @Commands.setter
    def Commands(self, Commands):
        self._Commands = Commands


    def _deserialize(self, params):
        self._Commands = params.get("Commands")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExistedInstance(AbstractModel):
    r"""已经存在的实例信息

    """

    def __init__(self):
        r"""
        :param _Usable: 实例是否支持加入集群(TRUE 可以加入 FALSE 不能加入)。
        :type Usable: bool
        :param _UnusableReason: 实例不支持加入的原因。
        :type UnusableReason: str
        :param _AlreadyInCluster: 实例已经所在的集群ID。
        :type AlreadyInCluster: str
        :param _InstanceId: 实例ID形如：ins-e55paxnt。
        :type InstanceId: str
        :param _InstanceName: 实例名称。
        :type InstanceName: str
        :param _PrivateIpAddresses: 实例主网卡的内网IP列表。
注意：此字段可能返回 null，表示取不到有效值。
        :type PrivateIpAddresses: list of str
        :param _PublicIpAddresses: 实例主网卡的公网IP列表。
注意：此字段可能返回 null，表示取不到有效值。
注意：此字段可能返回 null，表示取不到有效值。
        :type PublicIpAddresses: list of str
        :param _CreatedTime: 创建时间。按照ISO8601标准表示，并且使用UTC时间。格式为：YYYY-MM-DDThh:mm:ssZ。
        :type CreatedTime: str
        :param _CPU: 实例的CPU核数，单位：核。
        :type CPU: int
        :param _Memory: 实例内存容量，单位：GB。
        :type Memory: int
        :param _OsName: 操作系统名称。
        :type OsName: str
        :param _InstanceType: 实例机型。
        :type InstanceType: str
        :param _AutoscalingGroupId: 伸缩组ID
        :type AutoscalingGroupId: str
        :param _InstanceChargeType: 实例计费模式。取值范围： PREPAID：表示预付费，即包年包月 POSTPAID_BY_HOUR：表示后付费，即按量计费 CDHPAID：CDH付费，即只对CDH计费，不对CDH上的实例计费。
        :type InstanceChargeType: str
        :param _IPv6Addresses: 实例的IPv6地址。
注意：此字段可能返回 null，表示取不到有效值。
注意：此字段可能返回 null，表示取不到有效值。
        :type IPv6Addresses: list of str
        """
        self._Usable = None
        self._UnusableReason = None
        self._AlreadyInCluster = None
        self._InstanceId = None
        self._InstanceName = None
        self._PrivateIpAddresses = None
        self._PublicIpAddresses = None
        self._CreatedTime = None
        self._CPU = None
        self._Memory = None
        self._OsName = None
        self._InstanceType = None
        self._AutoscalingGroupId = None
        self._InstanceChargeType = None
        self._IPv6Addresses = None

    @property
    def Usable(self):
        r"""实例是否支持加入集群(TRUE 可以加入 FALSE 不能加入)。
        :rtype: bool
        """
        return self._Usable

    @Usable.setter
    def Usable(self, Usable):
        self._Usable = Usable

    @property
    def UnusableReason(self):
        r"""实例不支持加入的原因。
        :rtype: str
        """
        return self._UnusableReason

    @UnusableReason.setter
    def UnusableReason(self, UnusableReason):
        self._UnusableReason = UnusableReason

    @property
    def AlreadyInCluster(self):
        r"""实例已经所在的集群ID。
        :rtype: str
        """
        return self._AlreadyInCluster

    @AlreadyInCluster.setter
    def AlreadyInCluster(self, AlreadyInCluster):
        self._AlreadyInCluster = AlreadyInCluster

    @property
    def InstanceId(self):
        r"""实例ID形如：ins-e55paxnt。
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        r"""实例名称。
        :rtype: str
        """
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def PrivateIpAddresses(self):
        r"""实例主网卡的内网IP列表。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def PublicIpAddresses(self):
        r"""实例主网卡的公网IP列表。
注意：此字段可能返回 null，表示取不到有效值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._PublicIpAddresses

    @PublicIpAddresses.setter
    def PublicIpAddresses(self, PublicIpAddresses):
        self._PublicIpAddresses = PublicIpAddresses

    @property
    def CreatedTime(self):
        r"""创建时间。按照ISO8601标准表示，并且使用UTC时间。格式为：YYYY-MM-DDThh:mm:ssZ。
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def CPU(self):
        r"""实例的CPU核数，单位：核。
        :rtype: int
        """
        return self._CPU

    @CPU.setter
    def CPU(self, CPU):
        self._CPU = CPU

    @property
    def Memory(self):
        r"""实例内存容量，单位：GB。
        :rtype: int
        """
        return self._Memory

    @Memory.setter
    def Memory(self, Memory):
        self._Memory = Memory

    @property
    def OsName(self):
        r"""操作系统名称。
        :rtype: str
        """
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def InstanceType(self):
        r"""实例机型。
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def AutoscalingGroupId(self):
        r"""伸缩组ID
        :rtype: str
        """
        return self._AutoscalingGroupId

    @AutoscalingGroupId.setter
    def AutoscalingGroupId(self, AutoscalingGroupId):
        self._AutoscalingGroupId = AutoscalingGroupId

    @property
    def InstanceChargeType(self):
        r"""实例计费模式。取值范围： PREPAID：表示预付费，即包年包月 POSTPAID_BY_HOUR：表示后付费，即按量计费 CDHPAID：CDH付费，即只对CDH计费，不对CDH上的实例计费。
        :rtype: str
        """
        return self._InstanceChargeType

    @InstanceChargeType.setter
    def InstanceChargeType(self, InstanceChargeType):
        self._InstanceChargeType = InstanceChargeType

    @property
    def IPv6Addresses(self):
        r"""实例的IPv6地址。
注意：此字段可能返回 null，表示取不到有效值。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._IPv6Addresses

    @IPv6Addresses.setter
    def IPv6Addresses(self, IPv6Addresses):
        self._IPv6Addresses = IPv6Addresses


    def _deserialize(self, params):
        self._Usable = params.get("Usable")
        self._UnusableReason = params.get("UnusableReason")
        self._AlreadyInCluster = params.get("AlreadyInCluster")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._PublicIpAddresses = params.get("PublicIpAddresses")
        self._CreatedTime = params.get("CreatedTime")
        self._CPU = params.get("CPU")
        self._Memory = params.get("Memory")
        self._OsName = params.get("OsName")
        self._InstanceType = params.get("InstanceType")
        self._AutoscalingGroupId = params.get("AutoscalingGroupId")
        self._InstanceChargeType = params.get("InstanceChargeType")
        self._IPv6Addresses = params.get("IPv6Addresses")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExistedInstancesForNode(AbstractModel):
    r"""不同角色的已存在节点配置参数

    """

    def __init__(self):
        r"""
        :param _NodeRole: 节点角色，取值:MASTER_ETCD, WORKER。MASTER_ETCD只有在创建 INDEPENDENT_CLUSTER 独立集群时需要指定。MASTER_ETCD节点数量为3～7，建议为奇数。MASTER_ETCD最小配置为4C8G。
        :type NodeRole: str
        :param _ExistedInstancesPara: 已存在实例的重装参数
        :type ExistedInstancesPara: :class:`tencentcloud.tke.v20180525.models.ExistedInstancesPara`
        :param _InstanceAdvancedSettingsOverride: 节点高级设置，会覆盖集群级别设置的InstanceAdvancedSettings（当前只对节点自定义参数ExtraArgs生效）
        :type InstanceAdvancedSettingsOverride: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _DesiredPodNumbers: 自定义模式集群，可指定每个节点的pod数量
        :type DesiredPodNumbers: list of int
        """
        self._NodeRole = None
        self._ExistedInstancesPara = None
        self._InstanceAdvancedSettingsOverride = None
        self._DesiredPodNumbers = None

    @property
    def NodeRole(self):
        r"""节点角色，取值:MASTER_ETCD, WORKER。MASTER_ETCD只有在创建 INDEPENDENT_CLUSTER 独立集群时需要指定。MASTER_ETCD节点数量为3～7，建议为奇数。MASTER_ETCD最小配置为4C8G。
        :rtype: str
        """
        return self._NodeRole

    @NodeRole.setter
    def NodeRole(self, NodeRole):
        self._NodeRole = NodeRole

    @property
    def ExistedInstancesPara(self):
        r"""已存在实例的重装参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.ExistedInstancesPara`
        """
        return self._ExistedInstancesPara

    @ExistedInstancesPara.setter
    def ExistedInstancesPara(self, ExistedInstancesPara):
        self._ExistedInstancesPara = ExistedInstancesPara

    @property
    def InstanceAdvancedSettingsOverride(self):
        r"""节点高级设置，会覆盖集群级别设置的InstanceAdvancedSettings（当前只对节点自定义参数ExtraArgs生效）
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettingsOverride

    @InstanceAdvancedSettingsOverride.setter
    def InstanceAdvancedSettingsOverride(self, InstanceAdvancedSettingsOverride):
        self._InstanceAdvancedSettingsOverride = InstanceAdvancedSettingsOverride

    @property
    def DesiredPodNumbers(self):
        r"""自定义模式集群，可指定每个节点的pod数量
        :rtype: list of int
        """
        return self._DesiredPodNumbers

    @DesiredPodNumbers.setter
    def DesiredPodNumbers(self, DesiredPodNumbers):
        self._DesiredPodNumbers = DesiredPodNumbers


    def _deserialize(self, params):
        self._NodeRole = params.get("NodeRole")
        if params.get("ExistedInstancesPara") is not None:
            self._ExistedInstancesPara = ExistedInstancesPara()
            self._ExistedInstancesPara._deserialize(params.get("ExistedInstancesPara"))
        if params.get("InstanceAdvancedSettingsOverride") is not None:
            self._InstanceAdvancedSettingsOverride = InstanceAdvancedSettings()
            self._InstanceAdvancedSettingsOverride._deserialize(params.get("InstanceAdvancedSettingsOverride"))
        self._DesiredPodNumbers = params.get("DesiredPodNumbers")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExistedInstancesPara(AbstractModel):
    r"""已存在实例的重装参数

    """

    def __init__(self):
        r"""
        :param _InstanceIds: 集群ID
        :type InstanceIds: list of str
        :param _InstanceAdvancedSettings: 实例额外需要设置参数信息（目前后端暂不支持此字段，我们将在未来的版本中实现）
        :type InstanceAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _EnhancedService: 增强服务。通过该参数可以指定是否开启云安全、云监控等服务。若不指定该参数，则默认开启云监控、云安全服务。
        :type EnhancedService: :class:`tencentcloud.tke.v20180525.models.EnhancedService`
        :param _LoginSettings: 节点登录信息（目前仅支持使用Password或者单个KeyIds）
        :type LoginSettings: :class:`tencentcloud.tke.v20180525.models.LoginSettings`
        :param _SecurityGroupIds: 实例所属安全组。该参数可以通过调用 DescribeSecurityGroups 的返回值中的sgId字段来获取。若不指定该参数，则绑定默认安全组。
        :type SecurityGroupIds: list of str
        :param _HostName: 重装系统时，可以指定修改实例的HostName(集群为HostName模式时，此参数必传，规则名称除不支持大写字符外与[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口HostName一致)
        :type HostName: str
        """
        self._InstanceIds = None
        self._InstanceAdvancedSettings = None
        self._EnhancedService = None
        self._LoginSettings = None
        self._SecurityGroupIds = None
        self._HostName = None

    @property
    def InstanceIds(self):
        r"""集群ID
        :rtype: list of str
        """
        return self._InstanceIds

    @InstanceIds.setter
    def InstanceIds(self, InstanceIds):
        self._InstanceIds = InstanceIds

    @property
    def InstanceAdvancedSettings(self):
        r"""实例额外需要设置参数信息（目前后端暂不支持此字段，我们将在未来的版本中实现）
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def EnhancedService(self):
        r"""增强服务。通过该参数可以指定是否开启云安全、云监控等服务。若不指定该参数，则默认开启云监控、云安全服务。
        :rtype: :class:`tencentcloud.tke.v20180525.models.EnhancedService`
        """
        return self._EnhancedService

    @EnhancedService.setter
    def EnhancedService(self, EnhancedService):
        self._EnhancedService = EnhancedService

    @property
    def LoginSettings(self):
        r"""节点登录信息（目前仅支持使用Password或者单个KeyIds）
        :rtype: :class:`tencentcloud.tke.v20180525.models.LoginSettings`
        """
        return self._LoginSettings

    @LoginSettings.setter
    def LoginSettings(self, LoginSettings):
        self._LoginSettings = LoginSettings

    @property
    def SecurityGroupIds(self):
        r"""实例所属安全组。该参数可以通过调用 DescribeSecurityGroups 的返回值中的sgId字段来获取。若不指定该参数，则绑定默认安全组。
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def HostName(self):
        r"""重装系统时，可以指定修改实例的HostName(集群为HostName模式时，此参数必传，规则名称除不支持大写字符外与[CVM创建实例](https://cloud.tencent.com/document/product/213/15730)接口HostName一致)
        :rtype: str
        """
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName


    def _deserialize(self, params):
        self._InstanceIds = params.get("InstanceIds")
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        if params.get("EnhancedService") is not None:
            self._EnhancedService = EnhancedService()
            self._EnhancedService._deserialize(params.get("EnhancedService"))
        if params.get("LoginSettings") is not None:
            self._LoginSettings = LoginSettings()
            self._LoginSettings._deserialize(params.get("LoginSettings"))
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        self._HostName = params.get("HostName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtensionAddon(AbstractModel):
    r"""创建集群时，选择安装的扩展组件的信息

    """

    def __init__(self):
        r"""
        :param _AddonName: 扩展组件名称
        :type AddonName: str
        :param _AddonParam: 扩展组件信息(扩展组件资源对象的json字符串描述)
        :type AddonParam: str
        """
        self._AddonName = None
        self._AddonParam = None

    @property
    def AddonName(self):
        r"""扩展组件名称
        :rtype: str
        """
        return self._AddonName

    @AddonName.setter
    def AddonName(self, AddonName):
        self._AddonName = AddonName

    @property
    def AddonParam(self):
        r"""扩展组件信息(扩展组件资源对象的json字符串描述)
        :rtype: str
        """
        return self._AddonParam

    @AddonParam.setter
    def AddonParam(self, AddonParam):
        self._AddonParam = AddonParam


    def _deserialize(self, params):
        self._AddonName = params.get("AddonName")
        self._AddonParam = params.get("AddonParam")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FailedResource(AbstractModel):
    r"""修改标签失败的资源

    """

    def __init__(self):
        r"""
        :param _Resource: 资源六段式
        :type Resource: str
        :param _Error: 执行失败的原因
        :type Error: str
        """
        self._Resource = None
        self._Error = None

    @property
    def Resource(self):
        r"""资源六段式
        :rtype: str
        """
        return self._Resource

    @Resource.setter
    def Resource(self, Resource):
        self._Resource = Resource

    @property
    def Error(self):
        r"""执行失败的原因
        :rtype: str
        """
        return self._Error

    @Error.setter
    def Error(self, Error):
        self._Error = Error


    def _deserialize(self, params):
        self._Resource = params.get("Resource")
        self._Error = params.get("Error")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Filter(AbstractModel):
    r"""过滤器

    """

    def __init__(self):
        r"""
        :param _Name: 属性名称, 若存在多个Filter时，Filter间的关系为逻辑与（AND）关系。
        :type Name: str
        :param _Values: 属性值, 若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        r"""属性名称, 若存在多个Filter时，Filter间的关系为逻辑与（AND）关系。
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        r"""属性值, 若同一个Filter存在多个Values，同一Filter下Values间的关系为逻辑或（OR）关系。
        :rtype: list of str
        """
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForwardTKEEdgeApplicationRequestV3Request(AbstractModel):
    r"""ForwardTKEEdgeApplicationRequestV3请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Method: 请求集群addon的访问
        :type Method: str
        :param _Path: 请求集群addon的路径
        :type Path: str
        :param _Accept: 请求集群addon后允许接收的数据格式
        :type Accept: str
        :param _ContentType: 请求集群addon的数据格式
        :type ContentType: str
        :param _RequestBody: 请求集群addon的数据
        :type RequestBody: str
        :param _ClusterName: 集群名称，例如cls-1234abcd
        :type ClusterName: str
        :param _EncodedBody: 是否编码请求内容
        :type EncodedBody: str
        """
        self._Method = None
        self._Path = None
        self._Accept = None
        self._ContentType = None
        self._RequestBody = None
        self._ClusterName = None
        self._EncodedBody = None

    @property
    def Method(self):
        r"""请求集群addon的访问
        :rtype: str
        """
        return self._Method

    @Method.setter
    def Method(self, Method):
        self._Method = Method

    @property
    def Path(self):
        r"""请求集群addon的路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Accept(self):
        r"""请求集群addon后允许接收的数据格式
        :rtype: str
        """
        return self._Accept

    @Accept.setter
    def Accept(self, Accept):
        self._Accept = Accept

    @property
    def ContentType(self):
        r"""请求集群addon的数据格式
        :rtype: str
        """
        return self._ContentType

    @ContentType.setter
    def ContentType(self, ContentType):
        self._ContentType = ContentType

    @property
    def RequestBody(self):
        r"""请求集群addon的数据
        :rtype: str
        """
        return self._RequestBody

    @RequestBody.setter
    def RequestBody(self, RequestBody):
        self._RequestBody = RequestBody

    @property
    def ClusterName(self):
        r"""集群名称，例如cls-1234abcd
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def EncodedBody(self):
        r"""是否编码请求内容
        :rtype: str
        """
        return self._EncodedBody

    @EncodedBody.setter
    def EncodedBody(self, EncodedBody):
        self._EncodedBody = EncodedBody


    def _deserialize(self, params):
        self._Method = params.get("Method")
        self._Path = params.get("Path")
        self._Accept = params.get("Accept")
        self._ContentType = params.get("ContentType")
        self._RequestBody = params.get("RequestBody")
        self._ClusterName = params.get("ClusterName")
        self._EncodedBody = params.get("EncodedBody")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ForwardTKEEdgeApplicationRequestV3Response(AbstractModel):
    r"""ForwardTKEEdgeApplicationRequestV3返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ResponseBody: 请求集群addon后返回的数据
        :type ResponseBody: str
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ResponseBody = None
        self._RequestId = None

    @property
    def ResponseBody(self):
        r"""请求集群addon后返回的数据
        :rtype: str
        """
        return self._ResponseBody

    @ResponseBody.setter
    def ResponseBody(self, ResponseBody):
        self._ResponseBody = ResponseBody

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ResponseBody = params.get("ResponseBody")
        self._RequestId = params.get("RequestId")


class GPUArgs(AbstractModel):
    r"""GPU相关的参数，包括驱动版本，CUDA版本，cuDNN版本以及是否开启MIG

    """

    def __init__(self):
        r"""
        :param _CUDA: CUDA版本信息
        :type CUDA: :class:`tencentcloud.tke.v20180525.models.DriverVersion`
        :param _CUDNN: cuDNN版本信息
        :type CUDNN: :class:`tencentcloud.tke.v20180525.models.CUDNN`
        :param _CustomDriver: 自定义GPU驱动信息
        :type CustomDriver: :class:`tencentcloud.tke.v20180525.models.CustomDriver`
        :param _Driver: GPU驱动版本信息
        :type Driver: :class:`tencentcloud.tke.v20180525.models.DriverVersion`
        :param _MIGEnable: 是否启用MIG特性
        :type MIGEnable: bool
        """
        self._CUDA = None
        self._CUDNN = None
        self._CustomDriver = None
        self._Driver = None
        self._MIGEnable = None

    @property
    def CUDA(self):
        r"""CUDA版本信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.DriverVersion`
        """
        return self._CUDA

    @CUDA.setter
    def CUDA(self, CUDA):
        self._CUDA = CUDA

    @property
    def CUDNN(self):
        r"""cuDNN版本信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.CUDNN`
        """
        return self._CUDNN

    @CUDNN.setter
    def CUDNN(self, CUDNN):
        self._CUDNN = CUDNN

    @property
    def CustomDriver(self):
        r"""自定义GPU驱动信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.CustomDriver`
        """
        return self._CustomDriver

    @CustomDriver.setter
    def CustomDriver(self, CustomDriver):
        self._CustomDriver = CustomDriver

    @property
    def Driver(self):
        r"""GPU驱动版本信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.DriverVersion`
        """
        return self._Driver

    @Driver.setter
    def Driver(self, Driver):
        self._Driver = Driver

    @property
    def MIGEnable(self):
        r"""是否启用MIG特性
        :rtype: bool
        """
        return self._MIGEnable

    @MIGEnable.setter
    def MIGEnable(self, MIGEnable):
        self._MIGEnable = MIGEnable


    def _deserialize(self, params):
        if params.get("CUDA") is not None:
            self._CUDA = DriverVersion()
            self._CUDA._deserialize(params.get("CUDA"))
        if params.get("CUDNN") is not None:
            self._CUDNN = CUDNN()
            self._CUDNN._deserialize(params.get("CUDNN"))
        if params.get("CustomDriver") is not None:
            self._CustomDriver = CustomDriver()
            self._CustomDriver._deserialize(params.get("CustomDriver"))
        if params.get("Driver") is not None:
            self._Driver = DriverVersion()
            self._Driver._deserialize(params.get("Driver"))
        self._MIGEnable = params.get("MIGEnable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetClusterLevelPriceRequest(AbstractModel):
    r"""GetClusterLevelPrice请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterLevel: 集群规格，托管集群询价
        :type ClusterLevel: str
        """
        self._ClusterLevel = None

    @property
    def ClusterLevel(self):
        r"""集群规格，托管集群询价
        :rtype: str
        """
        return self._ClusterLevel

    @ClusterLevel.setter
    def ClusterLevel(self, ClusterLevel):
        self._ClusterLevel = ClusterLevel


    def _deserialize(self, params):
        self._ClusterLevel = params.get("ClusterLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetClusterLevelPriceResponse(AbstractModel):
    r"""GetClusterLevelPrice返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Cost: 询价结果，单位：分，打折后
        :type Cost: int
        :param _TotalCost: 询价结果，单位：分，折扣前
        :type TotalCost: int
        :param _Policy: 总的折扣，100表示100%不打折
        :type Policy: float
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Cost = None
        self._TotalCost = None
        self._Policy = None
        self._RequestId = None

    @property
    def Cost(self):
        r"""询价结果，单位：分，打折后
        :rtype: int
        """
        return self._Cost

    @Cost.setter
    def Cost(self, Cost):
        self._Cost = Cost

    @property
    def TotalCost(self):
        r"""询价结果，单位：分，折扣前
        :rtype: int
        """
        return self._TotalCost

    @TotalCost.setter
    def TotalCost(self, TotalCost):
        self._TotalCost = TotalCost

    @property
    def Policy(self):
        r"""总的折扣，100表示100%不打折
        :rtype: float
        """
        return self._Policy

    @Policy.setter
    def Policy(self, Policy):
        self._Policy = Policy

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Cost = params.get("Cost")
        self._TotalCost = params.get("TotalCost")
        self._Policy = params.get("Policy")
        self._RequestId = params.get("RequestId")


class GetMostSuitableImageCacheRequest(AbstractModel):
    r"""GetMostSuitableImageCache请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Images: 容器镜像列表
        :type Images: list of str
        """
        self._Images = None

    @property
    def Images(self):
        r"""容器镜像列表
        :rtype: list of str
        """
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images


    def _deserialize(self, params):
        self._Images = params.get("Images")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetMostSuitableImageCacheResponse(AbstractModel):
    r"""GetMostSuitableImageCache返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Found: 是否有匹配的镜像缓存
        :type Found: bool
        :param _ImageCache: 匹配的镜像缓存
注意：此字段可能返回 null，表示取不到有效值。
        :type ImageCache: :class:`tencentcloud.tke.v20180525.models.ImageCache`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Found = None
        self._ImageCache = None
        self._RequestId = None

    @property
    def Found(self):
        r"""是否有匹配的镜像缓存
        :rtype: bool
        """
        return self._Found

    @Found.setter
    def Found(self, Found):
        self._Found = Found

    @property
    def ImageCache(self):
        r"""匹配的镜像缓存
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.ImageCache`
        """
        return self._ImageCache

    @ImageCache.setter
    def ImageCache(self, ImageCache):
        self._ImageCache = ImageCache

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Found = params.get("Found")
        if params.get("ImageCache") is not None:
            self._ImageCache = ImageCache()
            self._ImageCache._deserialize(params.get("ImageCache"))
        self._RequestId = params.get("RequestId")


class GetTkeAppChartListRequest(AbstractModel):
    r"""GetTkeAppChartList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _Kind: app类型，取值log,scheduler,network,storage,monitor,dns,image,other,invisible
        :type Kind: str
        :param _Arch: app支持的操作系统，取值arm32、arm64、amd64
        :type Arch: str
        :param _ClusterType: 集群类型，取值tke、eks
        :type ClusterType: str
        """
        self._Kind = None
        self._Arch = None
        self._ClusterType = None

    @property
    def Kind(self):
        r"""app类型，取值log,scheduler,network,storage,monitor,dns,image,other,invisible
        :rtype: str
        """
        return self._Kind

    @Kind.setter
    def Kind(self, Kind):
        self._Kind = Kind

    @property
    def Arch(self):
        r"""app支持的操作系统，取值arm32、arm64、amd64
        :rtype: str
        """
        return self._Arch

    @Arch.setter
    def Arch(self, Arch):
        self._Arch = Arch

    @property
    def ClusterType(self):
        r"""集群类型，取值tke、eks
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._Kind = params.get("Kind")
        self._Arch = params.get("Arch")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetTkeAppChartListResponse(AbstractModel):
    r"""GetTkeAppChartList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _AppCharts: 所支持的chart列表
        :type AppCharts: list of AppChart
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._AppCharts = None
        self._RequestId = None

    @property
    def AppCharts(self):
        r"""所支持的chart列表
        :rtype: list of AppChart
        """
        return self._AppCharts

    @AppCharts.setter
    def AppCharts(self, AppCharts):
        self._AppCharts = AppCharts

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AppCharts") is not None:
            self._AppCharts = []
            for item in params.get("AppCharts"):
                obj = AppChart()
                obj._deserialize(item)
                self._AppCharts.append(obj)
        self._RequestId = params.get("RequestId")


class GetUpgradeInstanceProgressRequest(AbstractModel):
    r"""GetUpgradeInstanceProgress请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Limit: 最多获取多少个节点的进度
        :type Limit: int
        :param _Offset: 从第几个节点开始获取进度
        :type Offset: int
        """
        self._ClusterId = None
        self._Limit = None
        self._Offset = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Limit(self):
        r"""最多获取多少个节点的进度
        :rtype: int
        """
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        r"""从第几个节点开始获取进度
        :rtype: int
        """
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class GetUpgradeInstanceProgressResponse(AbstractModel):
    r"""GetUpgradeInstanceProgress返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Total: 升级节点总数
        :type Total: int
        :param _Done: 已升级节点总数
        :type Done: int
        :param _LifeState: 升级任务生命周期
process 运行中
paused 已停止
pauing 正在停止
done  已完成
timeout 已超时
aborted 已取消
        :type LifeState: str
        :param _Instances: 各节点升级进度详情
        :type Instances: list of InstanceUpgradeProgressItem
        :param _ClusterStatus: 集群当前状态
        :type ClusterStatus: :class:`tencentcloud.tke.v20180525.models.InstanceUpgradeClusterStatus`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Total = None
        self._Done = None
        self._LifeState = None
        self._Instances = None
        self._ClusterStatus = None
        self._RequestId = None

    @property
    def Total(self):
        r"""升级节点总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total

    @property
    def Done(self):
        r"""已升级节点总数
        :rtype: int
        """
        return self._Done

    @Done.setter
    def Done(self, Done):
        self._Done = Done

    @property
    def LifeState(self):
        r"""升级任务生命周期
process 运行中
paused 已停止
pauing 正在停止
done  已完成
timeout 已超时
aborted 已取消
        :rtype: str
        """
        return self._LifeState

    @LifeState.setter
    def LifeState(self, LifeState):
        self._LifeState = LifeState

    @property
    def Instances(self):
        r"""各节点升级进度详情
        :rtype: list of InstanceUpgradeProgressItem
        """
        return self._Instances

    @Instances.setter
    def Instances(self, Instances):
        self._Instances = Instances

    @property
    def ClusterStatus(self):
        r"""集群当前状态
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceUpgradeClusterStatus`
        """
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Total = params.get("Total")
        self._Done = params.get("Done")
        self._LifeState = params.get("LifeState")
        if params.get("Instances") is not None:
            self._Instances = []
            for item in params.get("Instances"):
                obj = InstanceUpgradeProgressItem()
                obj._deserialize(item)
                self._Instances.append(obj)
        if params.get("ClusterStatus") is not None:
            self._ClusterStatus = InstanceUpgradeClusterStatus()
            self._ClusterStatus._deserialize(params.get("ClusterStatus"))
        self._RequestId = params.get("RequestId")


class HttpGet(AbstractModel):
    r"""Probe中的HttpGet

    """

    def __init__(self):
        r"""
        :param _Path: HttpGet检测的路径
注意：此字段可能返回 null，表示取不到有效值。
        :type Path: str
        :param _Port: HttpGet检测的端口号
注意：此字段可能返回 null，表示取不到有效值。
        :type Port: int
        :param _Scheme: HTTP or HTTPS
注意：此字段可能返回 null，表示取不到有效值。
        :type Scheme: str
        """
        self._Path = None
        self._Port = None
        self._Scheme = None

    @property
    def Path(self):
        r"""HttpGet检测的路径
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Port(self):
        r"""HttpGet检测的端口号
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port

    @property
    def Scheme(self):
        r"""HTTP or HTTPS
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._Port = params.get("Port")
        self._Scheme = params.get("Scheme")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class IPAddress(AbstractModel):
    r"""IP 地址

    """

    def __init__(self):
        r"""
        :param _Type: Ip 地址的类型。可为 advertise, public 等
        :type Type: str
        :param _Ip: Ip 地址
        :type Ip: str
        :param _Port: 网络端口
        :type Port: int
        """
        self._Type = None
        self._Ip = None
        self._Port = None

    @property
    def Type(self):
        r"""Ip 地址的类型。可为 advertise, public 等
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Ip(self):
        r"""Ip 地址
        :rtype: str
        """
        return self._Ip

    @Ip.setter
    def Ip(self, Ip):
        self._Ip = Ip

    @property
    def Port(self):
        r"""网络端口
        :rtype: int
        """
        return self._Port

    @Port.setter
    def Port(self, Port):
        self._Port = Port


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Ip = params.get("Ip")
        self._Port = params.get("Port")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageCache(AbstractModel):
    r"""镜像缓存的信息

    """

    def __init__(self):
        r"""
        :param _ImageCacheId: 镜像缓存Id
        :type ImageCacheId: str
        :param _ImageCacheName: 镜像缓存名称
        :type ImageCacheName: str
        :param _ImageCacheSize: 镜像缓存大小。单位：GiB
        :type ImageCacheSize: int
        :param _Images: 镜像缓存包含的镜像列表
        :type Images: list of str
        :param _CreationTime: 创建时间
        :type CreationTime: str
        :param _ExpireDateTime: 到期时间
        :type ExpireDateTime: str
        :param _Events: 镜像缓存事件信息
        :type Events: list of ImageCacheEvent
        :param _LastMatchedTime: 最新一次匹配到镜像缓存的时间
        :type LastMatchedTime: str
        :param _SnapshotId: 镜像缓存对应的快照Id
        :type SnapshotId: str
        :param _Status: 镜像缓存状态，可能取值：
Pending：创建中
Ready：创建完成
Failed：创建失败
Updating：更新中
UpdateFailed：更新失败
只有状态为Ready时，才能正常使用镜像缓存
        :type Status: str
        :param _RetentionDays: 镜像缓存保留时间天数，过期将会自动清理，默认为0，永不过期。
        :type RetentionDays: int
        :param _ImageRegistryCredentials: 镜像拉取凭证
        :type ImageRegistryCredentials: list of ImageRegistryCredential
        :param _Tags: 腾讯云标签
        :type Tags: list of Tag
        """
        self._ImageCacheId = None
        self._ImageCacheName = None
        self._ImageCacheSize = None
        self._Images = None
        self._CreationTime = None
        self._ExpireDateTime = None
        self._Events = None
        self._LastMatchedTime = None
        self._SnapshotId = None
        self._Status = None
        self._RetentionDays = None
        self._ImageRegistryCredentials = None
        self._Tags = None

    @property
    def ImageCacheId(self):
        r"""镜像缓存Id
        :rtype: str
        """
        return self._ImageCacheId

    @ImageCacheId.setter
    def ImageCacheId(self, ImageCacheId):
        self._ImageCacheId = ImageCacheId

    @property
    def ImageCacheName(self):
        r"""镜像缓存名称
        :rtype: str
        """
        return self._ImageCacheName

    @ImageCacheName.setter
    def ImageCacheName(self, ImageCacheName):
        self._ImageCacheName = ImageCacheName

    @property
    def ImageCacheSize(self):
        r"""镜像缓存大小。单位：GiB
        :rtype: int
        """
        return self._ImageCacheSize

    @ImageCacheSize.setter
    def ImageCacheSize(self, ImageCacheSize):
        self._ImageCacheSize = ImageCacheSize

    @property
    def Images(self):
        r"""镜像缓存包含的镜像列表
        :rtype: list of str
        """
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def CreationTime(self):
        r"""创建时间
        :rtype: str
        """
        return self._CreationTime

    @CreationTime.setter
    def CreationTime(self, CreationTime):
        self._CreationTime = CreationTime

    @property
    def ExpireDateTime(self):
        r"""到期时间
        :rtype: str
        """
        return self._ExpireDateTime

    @ExpireDateTime.setter
    def ExpireDateTime(self, ExpireDateTime):
        self._ExpireDateTime = ExpireDateTime

    @property
    def Events(self):
        r"""镜像缓存事件信息
        :rtype: list of ImageCacheEvent
        """
        return self._Events

    @Events.setter
    def Events(self, Events):
        self._Events = Events

    @property
    def LastMatchedTime(self):
        r"""最新一次匹配到镜像缓存的时间
        :rtype: str
        """
        return self._LastMatchedTime

    @LastMatchedTime.setter
    def LastMatchedTime(self, LastMatchedTime):
        self._LastMatchedTime = LastMatchedTime

    @property
    def SnapshotId(self):
        r"""镜像缓存对应的快照Id
        :rtype: str
        """
        return self._SnapshotId

    @SnapshotId.setter
    def SnapshotId(self, SnapshotId):
        self._SnapshotId = SnapshotId

    @property
    def Status(self):
        r"""镜像缓存状态，可能取值：
Pending：创建中
Ready：创建完成
Failed：创建失败
Updating：更新中
UpdateFailed：更新失败
只有状态为Ready时，才能正常使用镜像缓存
        :rtype: str
        """
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RetentionDays(self):
        r"""镜像缓存保留时间天数，过期将会自动清理，默认为0，永不过期。
        :rtype: int
        """
        return self._RetentionDays

    @RetentionDays.setter
    def RetentionDays(self, RetentionDays):
        self._RetentionDays = RetentionDays

    @property
    def ImageRegistryCredentials(self):
        r"""镜像拉取凭证
        :rtype: list of ImageRegistryCredential
        """
        return self._ImageRegistryCredentials

    @ImageRegistryCredentials.setter
    def ImageRegistryCredentials(self, ImageRegistryCredentials):
        self._ImageRegistryCredentials = ImageRegistryCredentials

    @property
    def Tags(self):
        r"""腾讯云标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._ImageCacheId = params.get("ImageCacheId")
        self._ImageCacheName = params.get("ImageCacheName")
        self._ImageCacheSize = params.get("ImageCacheSize")
        self._Images = params.get("Images")
        self._CreationTime = params.get("CreationTime")
        self._ExpireDateTime = params.get("ExpireDateTime")
        if params.get("Events") is not None:
            self._Events = []
            for item in params.get("Events"):
                obj = ImageCacheEvent()
                obj._deserialize(item)
                self._Events.append(obj)
        self._LastMatchedTime = params.get("LastMatchedTime")
        self._SnapshotId = params.get("SnapshotId")
        self._Status = params.get("Status")
        self._RetentionDays = params.get("RetentionDays")
        if params.get("ImageRegistryCredentials") is not None:
            self._ImageRegistryCredentials = []
            for item in params.get("ImageRegistryCredentials"):
                obj = ImageRegistryCredential()
                obj._deserialize(item)
                self._ImageRegistryCredentials.append(obj)
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageCacheEvent(AbstractModel):
    r"""镜像缓存的事件

    """

    def __init__(self):
        r"""
        :param _ImageCacheId: 镜像缓存Id
        :type ImageCacheId: str
        :param _Type: 事件类型, Normal或者Warning
        :type Type: str
        :param _Reason: 事件原因简述
        :type Reason: str
        :param _Message: 事件原因详述
        :type Message: str
        :param _FirstTimestamp: 事件第一次出现时间
        :type FirstTimestamp: str
        :param _LastTimestamp: 事件最后一次出现时间
        :type LastTimestamp: str
        """
        self._ImageCacheId = None
        self._Type = None
        self._Reason = None
        self._Message = None
        self._FirstTimestamp = None
        self._LastTimestamp = None

    @property
    def ImageCacheId(self):
        r"""镜像缓存Id
        :rtype: str
        """
        return self._ImageCacheId

    @ImageCacheId.setter
    def ImageCacheId(self, ImageCacheId):
        self._ImageCacheId = ImageCacheId

    @property
    def Type(self):
        r"""事件类型, Normal或者Warning
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Reason(self):
        r"""事件原因简述
        :rtype: str
        """
        return self._Reason

    @Reason.setter
    def Reason(self, Reason):
        self._Reason = Reason

    @property
    def Message(self):
        r"""事件原因详述
        :rtype: str
        """
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FirstTimestamp(self):
        r"""事件第一次出现时间
        :rtype: str
        """
        return self._FirstTimestamp

    @FirstTimestamp.setter
    def FirstTimestamp(self, FirstTimestamp):
        self._FirstTimestamp = FirstTimestamp

    @property
    def LastTimestamp(self):
        r"""事件最后一次出现时间
        :rtype: str
        """
        return self._LastTimestamp

    @LastTimestamp.setter
    def LastTimestamp(self, LastTimestamp):
        self._LastTimestamp = LastTimestamp


    def _deserialize(self, params):
        self._ImageCacheId = params.get("ImageCacheId")
        self._Type = params.get("Type")
        self._Reason = params.get("Reason")
        self._Message = params.get("Message")
        self._FirstTimestamp = params.get("FirstTimestamp")
        self._LastTimestamp = params.get("LastTimestamp")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageInstance(AbstractModel):
    r"""镜像信息

    """

    def __init__(self):
        r"""
        :param _Alias: 镜像别名
        :type Alias: str
        :param _OsName: 操作系统名称
        :type OsName: str
        :param _ImageId: 镜像ID
        :type ImageId: str
        :param _OsCustomizeType: 容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :type OsCustomizeType: str
        """
        self._Alias = None
        self._OsName = None
        self._ImageId = None
        self._OsCustomizeType = None

    @property
    def Alias(self):
        r"""镜像别名
        :rtype: str
        """
        return self._Alias

    @Alias.setter
    def Alias(self, Alias):
        self._Alias = Alias

    @property
    def OsName(self):
        r"""操作系统名称
        :rtype: str
        """
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def ImageId(self):
        r"""镜像ID
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def OsCustomizeType(self):
        r"""容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType


    def _deserialize(self, params):
        self._Alias = params.get("Alias")
        self._OsName = params.get("OsName")
        self._ImageId = params.get("ImageId")
        self._OsCustomizeType = params.get("OsCustomizeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageRegistryCredential(AbstractModel):
    r"""从镜像仓库拉取镜像的凭据

    """

    def __init__(self):
        r"""
        :param _Server: 镜像仓库地址
        :type Server: str
        :param _Username: 用户名
        :type Username: str
        :param _Password: 密码
        :type Password: str
        :param _Name: ImageRegistryCredential的名字
        :type Name: str
        """
        self._Server = None
        self._Username = None
        self._Password = None
        self._Name = None

    @property
    def Server(self):
        r"""镜像仓库地址
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def Username(self):
        r"""用户名
        :rtype: str
        """
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        r"""密码
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Name(self):
        r"""ImageRegistryCredential的名字
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Server = params.get("Server")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstallAddonRequest(AbstractModel):
    r"""InstallAddon请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID（仅支持标准tke集群）
        :type ClusterId: str
        :param _AddonName: addon名称
        :type AddonName: str
        :param _AddonVersion: addon版本（不传默认安装最新版本）
        :type AddonVersion: str
        :param _RawValues: addon的参数，是一个json格式的base64转码后的字符串（addon参数由DescribeAddonValues获取）
        :type RawValues: str
        :param _DryRun: 是否仅做安装检查，设置为true时仅做检查，不会安装组件
        :type DryRun: bool
        """
        self._ClusterId = None
        self._AddonName = None
        self._AddonVersion = None
        self._RawValues = None
        self._DryRun = None

    @property
    def ClusterId(self):
        r"""集群ID（仅支持标准tke集群）
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def AddonName(self):
        r"""addon名称
        :rtype: str
        """
        return self._AddonName

    @AddonName.setter
    def AddonName(self, AddonName):
        self._AddonName = AddonName

    @property
    def AddonVersion(self):
        r"""addon版本（不传默认安装最新版本）
        :rtype: str
        """
        return self._AddonVersion

    @AddonVersion.setter
    def AddonVersion(self, AddonVersion):
        self._AddonVersion = AddonVersion

    @property
    def RawValues(self):
        r"""addon的参数，是一个json格式的base64转码后的字符串（addon参数由DescribeAddonValues获取）
        :rtype: str
        """
        return self._RawValues

    @RawValues.setter
    def RawValues(self, RawValues):
        self._RawValues = RawValues

    @property
    def DryRun(self):
        r"""是否仅做安装检查，设置为true时仅做检查，不会安装组件
        :rtype: bool
        """
        return self._DryRun

    @DryRun.setter
    def DryRun(self, DryRun):
        self._DryRun = DryRun


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._AddonName = params.get("AddonName")
        self._AddonVersion = params.get("AddonVersion")
        self._RawValues = params.get("RawValues")
        self._DryRun = params.get("DryRun")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstallAddonResponse(AbstractModel):
    r"""InstallAddon返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class InstallEdgeLogAgentRequest(AbstractModel):
    r"""InstallEdgeLogAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstallEdgeLogAgentResponse(AbstractModel):
    r"""InstallEdgeLogAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class InstallLogAgentRequest(AbstractModel):
    r"""InstallLogAgent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: TKE集群ID
        :type ClusterId: str
        :param _KubeletRootDir: kubelet根目录
        :type KubeletRootDir: str
        :param _ClusterType: 集群类型 tke/eks，默认tke
        :type ClusterType: str
        """
        self._ClusterId = None
        self._KubeletRootDir = None
        self._ClusterType = None

    @property
    def ClusterId(self):
        r"""TKE集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def KubeletRootDir(self):
        r"""kubelet根目录
        :rtype: str
        """
        return self._KubeletRootDir

    @KubeletRootDir.setter
    def KubeletRootDir(self, KubeletRootDir):
        self._KubeletRootDir = KubeletRootDir

    @property
    def ClusterType(self):
        r"""集群类型 tke/eks，默认tke
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._KubeletRootDir = params.get("KubeletRootDir")
        self._ClusterType = params.get("ClusterType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstallLogAgentResponse(AbstractModel):
    r"""InstallLogAgent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class Instance(AbstractModel):
    r"""集群的实例信息

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _InstanceRole: 节点角色, MASTER, WORKER, ETCD, MASTER_ETCD,ALL, 默认为WORKER
        :type InstanceRole: str
        :param _FailedReason: 实例异常(或者处于初始化中)的原因
        :type FailedReason: str
        :param _InstanceState: 实例的状态（running 运行中，initializing 初始化中，failed 异常）
        :type InstanceState: str
        :param _DrainStatus: 实例是否封锁状态
        :type DrainStatus: str
        :param _InstanceAdvancedSettings: 节点配置
        :type InstanceAdvancedSettings: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        :param _CreatedTime: 添加时间
        :type CreatedTime: str
        :param _LanIP: 节点内网IP
注意：此字段可能返回 null，表示取不到有效值。
        :type LanIP: str
        :param _NodePoolId: 资源池ID
        :type NodePoolId: str
        :param _AutoscalingGroupId: 自动伸缩组ID
        :type AutoscalingGroupId: str
        """
        self._InstanceId = None
        self._InstanceRole = None
        self._FailedReason = None
        self._InstanceState = None
        self._DrainStatus = None
        self._InstanceAdvancedSettings = None
        self._CreatedTime = None
        self._LanIP = None
        self._NodePoolId = None
        self._AutoscalingGroupId = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceRole(self):
        r"""节点角色, MASTER, WORKER, ETCD, MASTER_ETCD,ALL, 默认为WORKER
        :rtype: str
        """
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def FailedReason(self):
        r"""实例异常(或者处于初始化中)的原因
        :rtype: str
        """
        return self._FailedReason

    @FailedReason.setter
    def FailedReason(self, FailedReason):
        self._FailedReason = FailedReason

    @property
    def InstanceState(self):
        r"""实例的状态（running 运行中，initializing 初始化中，failed 异常）
        :rtype: str
        """
        return self._InstanceState

    @InstanceState.setter
    def InstanceState(self, InstanceState):
        self._InstanceState = InstanceState

    @property
    def DrainStatus(self):
        r"""实例是否封锁状态
        :rtype: str
        """
        return self._DrainStatus

    @DrainStatus.setter
    def DrainStatus(self, DrainStatus):
        self._DrainStatus = DrainStatus

    @property
    def InstanceAdvancedSettings(self):
        r"""节点配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceAdvancedSettings`
        """
        return self._InstanceAdvancedSettings

    @InstanceAdvancedSettings.setter
    def InstanceAdvancedSettings(self, InstanceAdvancedSettings):
        self._InstanceAdvancedSettings = InstanceAdvancedSettings

    @property
    def CreatedTime(self):
        r"""添加时间
        :rtype: str
        """
        return self._CreatedTime

    @CreatedTime.setter
    def CreatedTime(self, CreatedTime):
        self._CreatedTime = CreatedTime

    @property
    def LanIP(self):
        r"""节点内网IP
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._LanIP

    @LanIP.setter
    def LanIP(self, LanIP):
        self._LanIP = LanIP

    @property
    def NodePoolId(self):
        r"""资源池ID
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def AutoscalingGroupId(self):
        r"""自动伸缩组ID
        :rtype: str
        """
        return self._AutoscalingGroupId

    @AutoscalingGroupId.setter
    def AutoscalingGroupId(self, AutoscalingGroupId):
        self._AutoscalingGroupId = AutoscalingGroupId


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._InstanceRole = params.get("InstanceRole")
        self._FailedReason = params.get("FailedReason")
        self._InstanceState = params.get("InstanceState")
        self._DrainStatus = params.get("DrainStatus")
        if params.get("InstanceAdvancedSettings") is not None:
            self._InstanceAdvancedSettings = InstanceAdvancedSettings()
            self._InstanceAdvancedSettings._deserialize(params.get("InstanceAdvancedSettings"))
        self._CreatedTime = params.get("CreatedTime")
        self._LanIP = params.get("LanIP")
        self._NodePoolId = params.get("NodePoolId")
        self._AutoscalingGroupId = params.get("AutoscalingGroupId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceAdvancedSettings(AbstractModel):
    r"""描述了k8s集群相关配置与信息。

    """

    def __init__(self):
        r"""
        :param _DesiredPodNumber: 该节点属于podCIDR大小自定义模式时，可指定节点上运行的pod数量上限
注意：此字段可能返回 null，表示取不到有效值。
        :type DesiredPodNumber: int
        :param _GPUArgs: GPU驱动相关参数,相关的GPU参数获取:https://cloud.tencent.com/document/api/213/15715
注意：此字段可能返回 null，表示取不到有效值。
        :type GPUArgs: :class:`tencentcloud.tke.v20180525.models.GPUArgs`
        :param _PreStartUserScript: base64 编码的用户脚本，在初始化节点之前执行，目前只对添加已有节点生效
注意：此字段可能返回 null，表示取不到有效值。
        :type PreStartUserScript: str
        :param _Taints: 节点污点
注意：此字段可能返回 null，表示取不到有效值。
        :type Taints: list of Taint
        :param _MountTarget: 数据盘挂载点, 默认不挂载数据盘. 已格式化的 ext3，ext4，xfs 文件系统的数据盘将直接挂载，其他文件系统或未格式化的数据盘将自动格式化为ext4 (tlinux系统格式化成xfs)并挂载，请注意备份数据! 无数据盘或有多块数据盘的云主机此设置不生效。
注意：多盘场景请使用下方的DataDisks数据结构，设置对应的云盘类型、云盘大小、挂载路径、是否格式化等信息。
注意：此字段可能返回 null，表示取不到有效值。
        :type MountTarget: str
        :param _DockerGraphPath: dockerd --graph 指定值。若未指定此参数，将使用内置默认路径 /var/lib/docker 作为存储根目录。
注意：此字段可能返回 null，表示取不到有效值。
        :type DockerGraphPath: str
        :param _UserScript: base64 编码的用户脚本, 此脚本会在 k8s 组件运行后执行, 需要用户保证脚本的可重入及重试逻辑, 脚本及其生成的日志文件可在节点的 /data/ccs_userscript/ 路径查看, 如果要求节点需要在进行初始化完成后才可加入调度, 可配合 unschedulable 参数使用, 在 userScript 最后初始化完成后, 添加 kubectl uncordon nodename --kubeconfig=/root/.kube/config 命令使节点加入调度
注意：此字段可能返回 null，表示取不到有效值。
        :type UserScript: str
        :param _Unschedulable: 设置加入的节点是否参与调度，默认值为0，表示参与调度；非0表示不参与调度, 待节点初始化完成之后, 可执行kubectl uncordon nodename使node加入调度.
        :type Unschedulable: int
        :param _Labels: 节点Label数组
注意：此字段可能返回 null，表示取不到有效值。
        :type Labels: list of Label
        :param _DataDisks: 多盘数据盘挂载信息：新建节点时请确保购买CVM的参数传递了购买多个数据盘的信息，如CreateClusterInstances API的RunInstancesPara下的DataDisks也需要设置购买多个数据盘, 具体可以参考CreateClusterInstances接口的添加集群节点(多块数据盘)样例；添加已有节点时，请确保填写的分区信息在节点上真实存在
注意：此字段可能返回 null，表示取不到有效值。
        :type DataDisks: list of DataDisk
        :param _ExtraArgs: 节点相关的自定义参数信息
        :type ExtraArgs: :class:`tencentcloud.tke.v20180525.models.InstanceExtraArgs`
        """
        self._DesiredPodNumber = None
        self._GPUArgs = None
        self._PreStartUserScript = None
        self._Taints = None
        self._MountTarget = None
        self._DockerGraphPath = None
        self._UserScript = None
        self._Unschedulable = None
        self._Labels = None
        self._DataDisks = None
        self._ExtraArgs = None

    @property
    def DesiredPodNumber(self):
        r"""该节点属于podCIDR大小自定义模式时，可指定节点上运行的pod数量上限
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: int
        """
        return self._DesiredPodNumber

    @DesiredPodNumber.setter
    def DesiredPodNumber(self, DesiredPodNumber):
        self._DesiredPodNumber = DesiredPodNumber

    @property
    def GPUArgs(self):
        r"""GPU驱动相关参数,相关的GPU参数获取:https://cloud.tencent.com/document/api/213/15715
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.GPUArgs`
        """
        return self._GPUArgs

    @GPUArgs.setter
    def GPUArgs(self, GPUArgs):
        self._GPUArgs = GPUArgs

    @property
    def PreStartUserScript(self):
        r"""base64 编码的用户脚本，在初始化节点之前执行，目前只对添加已有节点生效
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._PreStartUserScript

    @PreStartUserScript.setter
    def PreStartUserScript(self, PreStartUserScript):
        self._PreStartUserScript = PreStartUserScript

    @property
    def Taints(self):
        r"""节点污点
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def MountTarget(self):
        r"""数据盘挂载点, 默认不挂载数据盘. 已格式化的 ext3，ext4，xfs 文件系统的数据盘将直接挂载，其他文件系统或未格式化的数据盘将自动格式化为ext4 (tlinux系统格式化成xfs)并挂载，请注意备份数据! 无数据盘或有多块数据盘的云主机此设置不生效。
注意：多盘场景请使用下方的DataDisks数据结构，设置对应的云盘类型、云盘大小、挂载路径、是否格式化等信息。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._MountTarget

    @MountTarget.setter
    def MountTarget(self, MountTarget):
        self._MountTarget = MountTarget

    @property
    def DockerGraphPath(self):
        r"""dockerd --graph 指定值。若未指定此参数，将使用内置默认路径 /var/lib/docker 作为存储根目录。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._DockerGraphPath

    @DockerGraphPath.setter
    def DockerGraphPath(self, DockerGraphPath):
        self._DockerGraphPath = DockerGraphPath

    @property
    def UserScript(self):
        r"""base64 编码的用户脚本, 此脚本会在 k8s 组件运行后执行, 需要用户保证脚本的可重入及重试逻辑, 脚本及其生成的日志文件可在节点的 /data/ccs_userscript/ 路径查看, 如果要求节点需要在进行初始化完成后才可加入调度, 可配合 unschedulable 参数使用, 在 userScript 最后初始化完成后, 添加 kubectl uncordon nodename --kubeconfig=/root/.kube/config 命令使节点加入调度
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._UserScript

    @UserScript.setter
    def UserScript(self, UserScript):
        self._UserScript = UserScript

    @property
    def Unschedulable(self):
        r"""设置加入的节点是否参与调度，默认值为0，表示参与调度；非0表示不参与调度, 待节点初始化完成之后, 可执行kubectl uncordon nodename使node加入调度.
        :rtype: int
        """
        return self._Unschedulable

    @Unschedulable.setter
    def Unschedulable(self, Unschedulable):
        self._Unschedulable = Unschedulable

    @property
    def Labels(self):
        r"""节点Label数组
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def DataDisks(self):
        r"""多盘数据盘挂载信息：新建节点时请确保购买CVM的参数传递了购买多个数据盘的信息，如CreateClusterInstances API的RunInstancesPara下的DataDisks也需要设置购买多个数据盘, 具体可以参考CreateClusterInstances接口的添加集群节点(多块数据盘)样例；添加已有节点时，请确保填写的分区信息在节点上真实存在
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of DataDisk
        """
        return self._DataDisks

    @DataDisks.setter
    def DataDisks(self, DataDisks):
        self._DataDisks = DataDisks

    @property
    def ExtraArgs(self):
        r"""节点相关的自定义参数信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceExtraArgs`
        """
        return self._ExtraArgs

    @ExtraArgs.setter
    def ExtraArgs(self, ExtraArgs):
        self._ExtraArgs = ExtraArgs


    def _deserialize(self, params):
        self._DesiredPodNumber = params.get("DesiredPodNumber")
        if params.get("GPUArgs") is not None:
            self._GPUArgs = GPUArgs()
            self._GPUArgs._deserialize(params.get("GPUArgs"))
        self._PreStartUserScript = params.get("PreStartUserScript")
        if params.get("Taints") is not None:
            self._Taints = []
            for item in params.get("Taints"):
                obj = Taint()
                obj._deserialize(item)
                self._Taints.append(obj)
        self._MountTarget = params.get("MountTarget")
        self._DockerGraphPath = params.get("DockerGraphPath")
        self._UserScript = params.get("UserScript")
        self._Unschedulable = params.get("Unschedulable")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("DataDisks") is not None:
            self._DataDisks = []
            for item in params.get("DataDisks"):
                obj = DataDisk()
                obj._deserialize(item)
                self._DataDisks.append(obj)
        if params.get("ExtraArgs") is not None:
            self._ExtraArgs = InstanceExtraArgs()
            self._ExtraArgs._deserialize(params.get("ExtraArgs"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceChargePrepaid(AbstractModel):
    r"""包年包月配置

    """

    def __init__(self):
        r"""
        :param _Period: 购买实例的时长，单位：月。取值范围：1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36。
        :type Period: int
        :param _RenewFlag: 自动续费标识。取值范围：
NOTIFY_AND_AUTO_RENEW：通知过期且自动续费
NOTIFY_AND_MANUAL_RENEW：通知过期不自动续费
DISABLE_NOTIFY_AND_MANUAL_RENEW：不通知过期不自动续费

默认取值：NOTIFY_AND_MANUAL_RENEW。若该参数指定为NOTIFY_AND_AUTO_RENEW，在账户余额充足的情况下，实例到期后将按月自动续费。
        :type RenewFlag: str
        """
        self._Period = None
        self._RenewFlag = None

    @property
    def Period(self):
        r"""购买实例的时长，单位：月。取值范围：1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 24, 36。
        :rtype: int
        """
        return self._Period

    @Period.setter
    def Period(self, Period):
        self._Period = Period

    @property
    def RenewFlag(self):
        r"""自动续费标识。取值范围：
NOTIFY_AND_AUTO_RENEW：通知过期且自动续费
NOTIFY_AND_MANUAL_RENEW：通知过期不自动续费
DISABLE_NOTIFY_AND_MANUAL_RENEW：不通知过期不自动续费

默认取值：NOTIFY_AND_MANUAL_RENEW。若该参数指定为NOTIFY_AND_AUTO_RENEW，在账户余额充足的情况下，实例到期后将按月自动续费。
        :rtype: str
        """
        return self._RenewFlag

    @RenewFlag.setter
    def RenewFlag(self, RenewFlag):
        self._RenewFlag = RenewFlag


    def _deserialize(self, params):
        self._Period = params.get("Period")
        self._RenewFlag = params.get("RenewFlag")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceDataDiskMountSetting(AbstractModel):
    r"""CVM实例数据盘挂载配置

    """

    def __init__(self):
        r"""
        :param _InstanceType: CVM实例类型
        :type InstanceType: str
        :param _DataDisks: 数据盘挂载信息
        :type DataDisks: list of DataDisk
        :param _Zone: CVM实例所属可用区
        :type Zone: str
        """
        self._InstanceType = None
        self._DataDisks = None
        self._Zone = None

    @property
    def InstanceType(self):
        r"""CVM实例类型
        :rtype: str
        """
        return self._InstanceType

    @InstanceType.setter
    def InstanceType(self, InstanceType):
        self._InstanceType = InstanceType

    @property
    def DataDisks(self):
        r"""数据盘挂载信息
        :rtype: list of DataDisk
        """
        return self._DataDisks

    @DataDisks.setter
    def DataDisks(self, DataDisks):
        self._DataDisks = DataDisks

    @property
    def Zone(self):
        r"""CVM实例所属可用区
        :rtype: str
        """
        return self._Zone

    @Zone.setter
    def Zone(self, Zone):
        self._Zone = Zone


    def _deserialize(self, params):
        self._InstanceType = params.get("InstanceType")
        if params.get("DataDisks") is not None:
            self._DataDisks = []
            for item in params.get("DataDisks"):
                obj = DataDisk()
                obj._deserialize(item)
                self._DataDisks.append(obj)
        self._Zone = params.get("Zone")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceExtraArgs(AbstractModel):
    r"""节点自定义参数

    """

    def __init__(self):
        r"""
        :param _Kubelet: kubelet自定义参数，参数格式为["k1=v1", "k1=v2"]， 例如["root-dir=/var/lib/kubelet","feature-gates=PodShareProcessNamespace=true,DynamicKubeletConfig=true"]
注意：此字段可能返回 null，表示取不到有效值。
        :type Kubelet: list of str
        """
        self._Kubelet = None

    @property
    def Kubelet(self):
        r"""kubelet自定义参数，参数格式为["k1=v1", "k1=v2"]， 例如["root-dir=/var/lib/kubelet","feature-gates=PodShareProcessNamespace=true,DynamicKubeletConfig=true"]
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._Kubelet

    @Kubelet.setter
    def Kubelet(self, Kubelet):
        self._Kubelet = Kubelet


    def _deserialize(self, params):
        self._Kubelet = params.get("Kubelet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceUpgradeClusterStatus(AbstractModel):
    r"""节点升级过程中集群当前状态

    """

    def __init__(self):
        r"""
        :param _PodTotal: pod总数
        :type PodTotal: int
        :param _NotReadyPod: NotReady pod总数
        :type NotReadyPod: int
        """
        self._PodTotal = None
        self._NotReadyPod = None

    @property
    def PodTotal(self):
        r"""pod总数
        :rtype: int
        """
        return self._PodTotal

    @PodTotal.setter
    def PodTotal(self, PodTotal):
        self._PodTotal = PodTotal

    @property
    def NotReadyPod(self):
        r"""NotReady pod总数
        :rtype: int
        """
        return self._NotReadyPod

    @NotReadyPod.setter
    def NotReadyPod(self, NotReadyPod):
        self._NotReadyPod = NotReadyPod


    def _deserialize(self, params):
        self._PodTotal = params.get("PodTotal")
        self._NotReadyPod = params.get("NotReadyPod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceUpgradePreCheckResult(AbstractModel):
    r"""某个节点升级前检查结果

    """

    def __init__(self):
        r"""
        :param _CheckPass: 检查是否通过
        :type CheckPass: bool
        :param _Items: 检查项数组
        :type Items: list of InstanceUpgradePreCheckResultItem
        :param _SinglePods: 本节点独立pod列表
        :type SinglePods: list of str
        """
        self._CheckPass = None
        self._Items = None
        self._SinglePods = None

    @property
    def CheckPass(self):
        r"""检查是否通过
        :rtype: bool
        """
        return self._CheckPass

    @CheckPass.setter
    def CheckPass(self, CheckPass):
        self._CheckPass = CheckPass

    @property
    def Items(self):
        r"""检查项数组
        :rtype: list of InstanceUpgradePreCheckResultItem
        """
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items

    @property
    def SinglePods(self):
        r"""本节点独立pod列表
        :rtype: list of str
        """
        return self._SinglePods

    @SinglePods.setter
    def SinglePods(self, SinglePods):
        self._SinglePods = SinglePods


    def _deserialize(self, params):
        self._CheckPass = params.get("CheckPass")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = InstanceUpgradePreCheckResultItem()
                obj._deserialize(item)
                self._Items.append(obj)
        self._SinglePods = params.get("SinglePods")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceUpgradePreCheckResultItem(AbstractModel):
    r"""节点升级检查项结果

    """

    def __init__(self):
        r"""
        :param _Namespace: 工作负载的命名空间
        :type Namespace: str
        :param _WorkLoadKind: 工作负载类型
        :type WorkLoadKind: str
        :param _WorkLoadName: 工作负载名称
        :type WorkLoadName: str
        :param _Before: 驱逐节点前工作负载running的pod数目
        :type Before: int
        :param _After: 驱逐节点后工作负载running的pod数目
        :type After: int
        :param _Pods: 工作负载在本节点上的pod列表
        :type Pods: list of str
        """
        self._Namespace = None
        self._WorkLoadKind = None
        self._WorkLoadName = None
        self._Before = None
        self._After = None
        self._Pods = None

    @property
    def Namespace(self):
        r"""工作负载的命名空间
        :rtype: str
        """
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def WorkLoadKind(self):
        r"""工作负载类型
        :rtype: str
        """
        return self._WorkLoadKind

    @WorkLoadKind.setter
    def WorkLoadKind(self, WorkLoadKind):
        self._WorkLoadKind = WorkLoadKind

    @property
    def WorkLoadName(self):
        r"""工作负载名称
        :rtype: str
        """
        return self._WorkLoadName

    @WorkLoadName.setter
    def WorkLoadName(self, WorkLoadName):
        self._WorkLoadName = WorkLoadName

    @property
    def Before(self):
        r"""驱逐节点前工作负载running的pod数目
        :rtype: int
        """
        return self._Before

    @Before.setter
    def Before(self, Before):
        self._Before = Before

    @property
    def After(self):
        r"""驱逐节点后工作负载running的pod数目
        :rtype: int
        """
        return self._After

    @After.setter
    def After(self, After):
        self._After = After

    @property
    def Pods(self):
        r"""工作负载在本节点上的pod列表
        :rtype: list of str
        """
        return self._Pods

    @Pods.setter
    def Pods(self, Pods):
        self._Pods = Pods


    def _deserialize(self, params):
        self._Namespace = params.get("Namespace")
        self._WorkLoadKind = params.get("WorkLoadKind")
        self._WorkLoadName = params.get("WorkLoadName")
        self._Before = params.get("Before")
        self._After = params.get("After")
        self._Pods = params.get("Pods")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class InstanceUpgradeProgressItem(AbstractModel):
    r"""某个节点的升级进度

    """

    def __init__(self):
        r"""
        :param _InstanceID: 节点instanceID
        :type InstanceID: str
        :param _LifeState: 任务生命周期
process 运行中
paused 已停止
pauing 正在停止
done  已完成
timeout 已超时
aborted 已取消
pending 还未开始
        :type LifeState: str
        :param _StartAt: 升级开始时间
        :type StartAt: str
        :param _EndAt: 升级结束时间
        :type EndAt: str
        :param _CheckResult: 升级前检查结果
        :type CheckResult: :class:`tencentcloud.tke.v20180525.models.InstanceUpgradePreCheckResult`
        :param _Detail: 升级步骤详情
        :type Detail: list of TaskStepInfo
        """
        self._InstanceID = None
        self._LifeState = None
        self._StartAt = None
        self._EndAt = None
        self._CheckResult = None
        self._Detail = None

    @property
    def InstanceID(self):
        r"""节点instanceID
        :rtype: str
        """
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def LifeState(self):
        r"""任务生命周期
process 运行中
paused 已停止
pauing 正在停止
done  已完成
timeout 已超时
aborted 已取消
pending 还未开始
        :rtype: str
        """
        return self._LifeState

    @LifeState.setter
    def LifeState(self, LifeState):
        self._LifeState = LifeState

    @property
    def StartAt(self):
        r"""升级开始时间
        :rtype: str
        """
        return self._StartAt

    @StartAt.setter
    def StartAt(self, StartAt):
        self._StartAt = StartAt

    @property
    def EndAt(self):
        r"""升级结束时间
        :rtype: str
        """
        return self._EndAt

    @EndAt.setter
    def EndAt(self, EndAt):
        self._EndAt = EndAt

    @property
    def CheckResult(self):
        r"""升级前检查结果
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceUpgradePreCheckResult`
        """
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def Detail(self):
        r"""升级步骤详情
        :rtype: list of TaskStepInfo
        """
        return self._Detail

    @Detail.setter
    def Detail(self, Detail):
        self._Detail = Detail


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._LifeState = params.get("LifeState")
        self._StartAt = params.get("StartAt")
        self._EndAt = params.get("EndAt")
        if params.get("CheckResult") is not None:
            self._CheckResult = InstanceUpgradePreCheckResult()
            self._CheckResult._deserialize(params.get("CheckResult"))
        if params.get("Detail") is not None:
            self._Detail = []
            for item in params.get("Detail"):
                obj = TaskStepInfo()
                obj._deserialize(item)
                self._Detail.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KMSConfiguration(AbstractModel):
    r"""kms加密参数

    """

    def __init__(self):
        r"""
        :param _KeyId: kms id，可以在密钥管理控制台获取
        :type KeyId: str
        :param _KmsRegion: kms 地域
        :type KmsRegion: str
        """
        self._KeyId = None
        self._KmsRegion = None

    @property
    def KeyId(self):
        r"""kms id，可以在密钥管理控制台获取
        :rtype: str
        """
        return self._KeyId

    @KeyId.setter
    def KeyId(self, KeyId):
        self._KeyId = KeyId

    @property
    def KmsRegion(self):
        r"""kms 地域
        :rtype: str
        """
        return self._KmsRegion

    @KmsRegion.setter
    def KmsRegion(self, KmsRegion):
        self._KmsRegion = KmsRegion


    def _deserialize(self, params):
        self._KeyId = params.get("KeyId")
        self._KmsRegion = params.get("KmsRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateCatalogue(AbstractModel):
    r"""集群巡检诊断的默认目录类型

    """

    def __init__(self):
        r"""
        :param _CatalogueLevel: 目录级别，支持参数：
first：一级目录
second：二级目录
        :type CatalogueLevel: str
        :param _CatalogueName: 目录名
        :type CatalogueName: str
        """
        self._CatalogueLevel = None
        self._CatalogueName = None

    @property
    def CatalogueLevel(self):
        r"""目录级别，支持参数：
first：一级目录
second：二级目录
        :rtype: str
        """
        return self._CatalogueLevel

    @CatalogueLevel.setter
    def CatalogueLevel(self, CatalogueLevel):
        self._CatalogueLevel = CatalogueLevel

    @property
    def CatalogueName(self):
        r"""目录名
        :rtype: str
        """
        return self._CatalogueName

    @CatalogueName.setter
    def CatalogueName(self, CatalogueName):
        self._CatalogueName = CatalogueName


    def _deserialize(self, params):
        self._CatalogueLevel = params.get("CatalogueLevel")
        self._CatalogueName = params.get("CatalogueName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateDiagnostic(AbstractModel):
    r"""集群巡检诊断结果

    """

    def __init__(self):
        r"""
        :param _StartTime: 诊断开始时间
        :type StartTime: str
        :param _EndTime: 诊断结束时间
        :type EndTime: str
        :param _Catalogues: 诊断目录
        :type Catalogues: list of KubeJarvisStateCatalogue
        :param _Type: 诊断类型
        :type Type: str
        :param _Name: 诊断名称
        :type Name: str
        :param _Desc: 诊断描述
        :type Desc: str
        :param _Results: 诊断结果列表
        :type Results: list of KubeJarvisStateResultsItem
        :param _Statistics: 诊断结果统计
        :type Statistics: list of KubeJarvisStateStatistic
        """
        self._StartTime = None
        self._EndTime = None
        self._Catalogues = None
        self._Type = None
        self._Name = None
        self._Desc = None
        self._Results = None
        self._Statistics = None

    @property
    def StartTime(self):
        r"""诊断开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""诊断结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Catalogues(self):
        r"""诊断目录
        :rtype: list of KubeJarvisStateCatalogue
        """
        return self._Catalogues

    @Catalogues.setter
    def Catalogues(self, Catalogues):
        self._Catalogues = Catalogues

    @property
    def Type(self):
        r"""诊断类型
        :rtype: str
        """
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        r"""诊断名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        r"""诊断描述
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Results(self):
        r"""诊断结果列表
        :rtype: list of KubeJarvisStateResultsItem
        """
        return self._Results

    @Results.setter
    def Results(self, Results):
        self._Results = Results

    @property
    def Statistics(self):
        r"""诊断结果统计
        :rtype: list of KubeJarvisStateStatistic
        """
        return self._Statistics

    @Statistics.setter
    def Statistics(self, Statistics):
        self._Statistics = Statistics


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Catalogues") is not None:
            self._Catalogues = []
            for item in params.get("Catalogues"):
                obj = KubeJarvisStateCatalogue()
                obj._deserialize(item)
                self._Catalogues.append(obj)
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        if params.get("Results") is not None:
            self._Results = []
            for item in params.get("Results"):
                obj = KubeJarvisStateResultsItem()
                obj._deserialize(item)
                self._Results.append(obj)
        if params.get("Statistics") is not None:
            self._Statistics = []
            for item in params.get("Statistics"):
                obj = KubeJarvisStateStatistic()
                obj._deserialize(item)
                self._Statistics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateDiagnosticOverview(AbstractModel):
    r"""集群巡检诊断概览

    """

    def __init__(self):
        r"""
        :param _Catalogues: 诊断目录
        :type Catalogues: list of KubeJarvisStateCatalogue
        :param _Statistics: 诊断结果统计
        :type Statistics: list of KubeJarvisStateStatistic
        """
        self._Catalogues = None
        self._Statistics = None

    @property
    def Catalogues(self):
        r"""诊断目录
        :rtype: list of KubeJarvisStateCatalogue
        """
        return self._Catalogues

    @Catalogues.setter
    def Catalogues(self, Catalogues):
        self._Catalogues = Catalogues

    @property
    def Statistics(self):
        r"""诊断结果统计
        :rtype: list of KubeJarvisStateStatistic
        """
        return self._Statistics

    @Statistics.setter
    def Statistics(self, Statistics):
        self._Statistics = Statistics


    def _deserialize(self, params):
        if params.get("Catalogues") is not None:
            self._Catalogues = []
            for item in params.get("Catalogues"):
                obj = KubeJarvisStateCatalogue()
                obj._deserialize(item)
                self._Catalogues.append(obj)
        if params.get("Statistics") is not None:
            self._Statistics = []
            for item in params.get("Statistics"):
                obj = KubeJarvisStateStatistic()
                obj._deserialize(item)
                self._Statistics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateInspectionOverview(AbstractModel):
    r"""集群巡检检查结果概览

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Statistics: 诊断结果统计
        :type Statistics: list of KubeJarvisStateStatistic
        :param _Diagnostics: 诊断结果详情
        :type Diagnostics: list of KubeJarvisStateDiagnosticOverview
        """
        self._ClusterId = None
        self._Statistics = None
        self._Diagnostics = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Statistics(self):
        r"""诊断结果统计
        :rtype: list of KubeJarvisStateStatistic
        """
        return self._Statistics

    @Statistics.setter
    def Statistics(self, Statistics):
        self._Statistics = Statistics

    @property
    def Diagnostics(self):
        r"""诊断结果详情
        :rtype: list of KubeJarvisStateDiagnosticOverview
        """
        return self._Diagnostics

    @Diagnostics.setter
    def Diagnostics(self, Diagnostics):
        self._Diagnostics = Diagnostics


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("Statistics") is not None:
            self._Statistics = []
            for item in params.get("Statistics"):
                obj = KubeJarvisStateStatistic()
                obj._deserialize(item)
                self._Statistics.append(obj)
        if params.get("Diagnostics") is not None:
            self._Diagnostics = []
            for item in params.get("Diagnostics"):
                obj = KubeJarvisStateDiagnosticOverview()
                obj._deserialize(item)
                self._Diagnostics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateInspectionResult(AbstractModel):
    r"""集群巡检检查结果

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _StartTime: 诊断开始时间
        :type StartTime: str
        :param _EndTime: 诊断结束时间
        :type EndTime: str
        :param _Statistics: 诊断结果统计
        :type Statistics: list of KubeJarvisStateStatistic
        :param _Diagnostics: 诊断结果详情
        :type Diagnostics: list of KubeJarvisStateDiagnostic
        :param _Error: 查询巡检报告相关报错
        :type Error: str
        """
        self._ClusterId = None
        self._StartTime = None
        self._EndTime = None
        self._Statistics = None
        self._Diagnostics = None
        self._Error = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def StartTime(self):
        r"""诊断开始时间
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""诊断结束时间
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Statistics(self):
        r"""诊断结果统计
        :rtype: list of KubeJarvisStateStatistic
        """
        return self._Statistics

    @Statistics.setter
    def Statistics(self, Statistics):
        self._Statistics = Statistics

    @property
    def Diagnostics(self):
        r"""诊断结果详情
        :rtype: list of KubeJarvisStateDiagnostic
        """
        return self._Diagnostics

    @Diagnostics.setter
    def Diagnostics(self, Diagnostics):
        self._Diagnostics = Diagnostics

    @property
    def Error(self):
        r"""查询巡检报告相关报错
        :rtype: str
        """
        return self._Error

    @Error.setter
    def Error(self, Error):
        self._Error = Error


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Statistics") is not None:
            self._Statistics = []
            for item in params.get("Statistics"):
                obj = KubeJarvisStateStatistic()
                obj._deserialize(item)
                self._Statistics.append(obj)
        if params.get("Diagnostics") is not None:
            self._Diagnostics = []
            for item in params.get("Diagnostics"):
                obj = KubeJarvisStateDiagnostic()
                obj._deserialize(item)
                self._Diagnostics.append(obj)
        self._Error = params.get("Error")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateInspectionResultsItem(AbstractModel):
    r"""集群巡检结果历史列表

    """

    def __init__(self):
        r"""
        :param _Name: 巡检结果名称
        :type Name: str
        :param _Statistics: 诊断结果统计
        :type Statistics: list of KubeJarvisStateStatistic
        """
        self._Name = None
        self._Statistics = None

    @property
    def Name(self):
        r"""巡检结果名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Statistics(self):
        r"""诊断结果统计
        :rtype: list of KubeJarvisStateStatistic
        """
        return self._Statistics

    @Statistics.setter
    def Statistics(self, Statistics):
        self._Statistics = Statistics


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Statistics") is not None:
            self._Statistics = []
            for item in params.get("Statistics"):
                obj = KubeJarvisStateStatistic()
                obj._deserialize(item)
                self._Statistics.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateResultObjInfo(AbstractModel):
    r"""集群巡检诊断对象信息

    """

    def __init__(self):
        r"""
        :param _PropertyName: 对象属性名称
        :type PropertyName: str
        :param _PropertyValue: 对象属性值
        :type PropertyValue: str
        """
        self._PropertyName = None
        self._PropertyValue = None

    @property
    def PropertyName(self):
        r"""对象属性名称
        :rtype: str
        """
        return self._PropertyName

    @PropertyName.setter
    def PropertyName(self, PropertyName):
        self._PropertyName = PropertyName

    @property
    def PropertyValue(self):
        r"""对象属性值
        :rtype: str
        """
        return self._PropertyValue

    @PropertyValue.setter
    def PropertyValue(self, PropertyValue):
        self._PropertyValue = PropertyValue


    def _deserialize(self, params):
        self._PropertyName = params.get("PropertyName")
        self._PropertyValue = params.get("PropertyValue")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateResultsItem(AbstractModel):
    r"""集群巡检诊断结果详情信息

    """

    def __init__(self):
        r"""
        :param _Level: 诊断结果级别
        :type Level: str
        :param _ObjName: 诊断对象名
        :type ObjName: str
        :param _ObjInfo: 诊断对象信息
注意：此字段可能返回 null，表示取不到有效值。
        :type ObjInfo: list of KubeJarvisStateResultObjInfo
        :param _Title: 诊断项标题
        :type Title: str
        :param _Desc: 诊断项描述
        :type Desc: str
        :param _Proposal: 诊断建议
注意：此字段可能返回 null，表示取不到有效值。
        :type Proposal: str
        :param _ProposalDocUrl: 诊断建议文档链接
        :type ProposalDocUrl: str
        :param _ProposalDocName: 诊断建议文档名称
        :type ProposalDocName: str
        """
        self._Level = None
        self._ObjName = None
        self._ObjInfo = None
        self._Title = None
        self._Desc = None
        self._Proposal = None
        self._ProposalDocUrl = None
        self._ProposalDocName = None

    @property
    def Level(self):
        r"""诊断结果级别
        :rtype: str
        """
        return self._Level

    @Level.setter
    def Level(self, Level):
        self._Level = Level

    @property
    def ObjName(self):
        r"""诊断对象名
        :rtype: str
        """
        return self._ObjName

    @ObjName.setter
    def ObjName(self, ObjName):
        self._ObjName = ObjName

    @property
    def ObjInfo(self):
        r"""诊断对象信息
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KubeJarvisStateResultObjInfo
        """
        return self._ObjInfo

    @ObjInfo.setter
    def ObjInfo(self, ObjInfo):
        self._ObjInfo = ObjInfo

    @property
    def Title(self):
        r"""诊断项标题
        :rtype: str
        """
        return self._Title

    @Title.setter
    def Title(self, Title):
        self._Title = Title

    @property
    def Desc(self):
        r"""诊断项描述
        :rtype: str
        """
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def Proposal(self):
        r"""诊断建议
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: str
        """
        return self._Proposal

    @Proposal.setter
    def Proposal(self, Proposal):
        self._Proposal = Proposal

    @property
    def ProposalDocUrl(self):
        r"""诊断建议文档链接
        :rtype: str
        """
        return self._ProposalDocUrl

    @ProposalDocUrl.setter
    def ProposalDocUrl(self, ProposalDocUrl):
        self._ProposalDocUrl = ProposalDocUrl

    @property
    def ProposalDocName(self):
        r"""诊断建议文档名称
        :rtype: str
        """
        return self._ProposalDocName

    @ProposalDocName.setter
    def ProposalDocName(self, ProposalDocName):
        self._ProposalDocName = ProposalDocName


    def _deserialize(self, params):
        self._Level = params.get("Level")
        self._ObjName = params.get("ObjName")
        if params.get("ObjInfo") is not None:
            self._ObjInfo = []
            for item in params.get("ObjInfo"):
                obj = KubeJarvisStateResultObjInfo()
                obj._deserialize(item)
                self._ObjInfo.append(obj)
        self._Title = params.get("Title")
        self._Desc = params.get("Desc")
        self._Proposal = params.get("Proposal")
        self._ProposalDocUrl = params.get("ProposalDocUrl")
        self._ProposalDocName = params.get("ProposalDocName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class KubeJarvisStateStatistic(AbstractModel):
    r"""集群巡检统计结果

    """

    def __init__(self):
        r"""
        :param _HealthyLevel: 诊断结果的健康水平
        :type HealthyLevel: str
        :param _Count: 诊断结果的统计
        :type Count: int
        """
        self._HealthyLevel = None
        self._Count = None

    @property
    def HealthyLevel(self):
        r"""诊断结果的健康水平
        :rtype: str
        """
        return self._HealthyLevel

    @HealthyLevel.setter
    def HealthyLevel(self, HealthyLevel):
        self._HealthyLevel = HealthyLevel

    @property
    def Count(self):
        r"""诊断结果的统计
        :rtype: int
        """
        return self._Count

    @Count.setter
    def Count(self, Count):
        self._Count = Count


    def _deserialize(self, params):
        self._HealthyLevel = params.get("HealthyLevel")
        self._Count = params.get("Count")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Label(AbstractModel):
    r"""k8s中标签，一般以数组的方式存在

    """

    def __init__(self):
        r"""
        :param _Name: map表中的Name
        :type Name: str
        :param _Value: map表中的Value
        :type Value: str
        """
        self._Name = None
        self._Value = None

    @property
    def Name(self):
        r"""map表中的Name
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Value(self):
        r"""map表中的Value
        :rtype: str
        """
        return self._Value

    @Value.setter
    def Value(self, Value):
        self._Value = Value


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Value = params.get("Value")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListClusterInspectionResultsItemsRequest(AbstractModel):
    r"""ListClusterInspectionResultsItems请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 目标集群ID
        :type ClusterId: str
        :param _StartTime: 查询历史结果的开始时间，Unix时间戳
        :type StartTime: str
        :param _EndTime: 查询历史结果的结束时间，默认当前距离开始时间3天，Unix时间戳
        :type EndTime: str
        """
        self._ClusterId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def ClusterId(self):
        r"""目标集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def StartTime(self):
        r"""查询历史结果的开始时间，Unix时间戳
        :rtype: str
        """
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        r"""查询历史结果的结束时间，默认当前距离开始时间3天，Unix时间戳
        :rtype: str
        """
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListClusterInspectionResultsItemsResponse(AbstractModel):
    r"""ListClusterInspectionResultsItems返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InspectionResultsItems: 巡检结果历史列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InspectionResultsItems: list of KubeJarvisStateInspectionResultsItem
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InspectionResultsItems = None
        self._RequestId = None

    @property
    def InspectionResultsItems(self):
        r"""巡检结果历史列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KubeJarvisStateInspectionResultsItem
        """
        return self._InspectionResultsItems

    @InspectionResultsItems.setter
    def InspectionResultsItems(self, InspectionResultsItems):
        self._InspectionResultsItems = InspectionResultsItems

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InspectionResultsItems") is not None:
            self._InspectionResultsItems = []
            for item in params.get("InspectionResultsItems"):
                obj = KubeJarvisStateInspectionResultsItem()
                obj._deserialize(item)
                self._InspectionResultsItems.append(obj)
        self._RequestId = params.get("RequestId")


class ListClusterInspectionResultsRequest(AbstractModel):
    r"""ListClusterInspectionResults请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterIds: 目标集群列表，为空查询用户所有集群

        :type ClusterIds: list of str
        :param _Hide: 隐藏的字段信息，为了减少无效的字段返回，隐藏字段不会在返回值中返回。可选值：results

        :type Hide: list of str
        :param _Name: 指定查询结果的报告名称，默认查询最新的每个集群只查询最新的一条
        :type Name: str
        """
        self._ClusterIds = None
        self._Hide = None
        self._Name = None

    @property
    def ClusterIds(self):
        r"""目标集群列表，为空查询用户所有集群

        :rtype: list of str
        """
        return self._ClusterIds

    @ClusterIds.setter
    def ClusterIds(self, ClusterIds):
        self._ClusterIds = ClusterIds

    @property
    def Hide(self):
        r"""隐藏的字段信息，为了减少无效的字段返回，隐藏字段不会在返回值中返回。可选值：results

        :rtype: list of str
        """
        return self._Hide

    @Hide.setter
    def Hide(self, Hide):
        self._Hide = Hide

    @property
    def Name(self):
        r"""指定查询结果的报告名称，默认查询最新的每个集群只查询最新的一条
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._ClusterIds = params.get("ClusterIds")
        self._Hide = params.get("Hide")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ListClusterInspectionResultsResponse(AbstractModel):
    r"""ListClusterInspectionResults返回参数结构体

    """

    def __init__(self):
        r"""
        :param _InspectionResults: 集群诊断结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :type InspectionResults: list of KubeJarvisStateInspectionResult
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._InspectionResults = None
        self._RequestId = None

    @property
    def InspectionResults(self):
        r"""集群诊断结果列表
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of KubeJarvisStateInspectionResult
        """
        return self._InspectionResults

    @InspectionResults.setter
    def InspectionResults(self, InspectionResults):
        self._InspectionResults = InspectionResults

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InspectionResults") is not None:
            self._InspectionResults = []
            for item in params.get("InspectionResults"):
                obj = KubeJarvisStateInspectionResult()
                obj._deserialize(item)
                self._InspectionResults.append(obj)
        self._RequestId = params.get("RequestId")


class LivenessOrReadinessProbe(AbstractModel):
    r"""健康探针

    """

    def __init__(self):
        r"""
        :param _Probe: 探针参数
        :type Probe: :class:`tencentcloud.tke.v20180525.models.Probe`
        :param _Exec: 容器内检测命令参数
注意：此字段可能返回 null，表示取不到有效值。
        :type Exec: :class:`tencentcloud.tke.v20180525.models.Exec`
        :param _HttpGet: HttpGet检测参数
        :type HttpGet: :class:`tencentcloud.tke.v20180525.models.HttpGet`
        :param _TcpSocket: TcpSocket检测的端口参数
注意：此字段可能返回 null，表示取不到有效值。
        :type TcpSocket: :class:`tencentcloud.tke.v20180525.models.TcpSocket`
        """
        self._Probe = None
        self._Exec = None
        self._HttpGet = None
        self._TcpSocket = None

    @property
    def Probe(self):
        r"""探针参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.Probe`
        """
        return self._Probe

    @Probe.setter
    def Probe(self, Probe):
        self._Probe = Probe

    @property
    def Exec(self):
        r"""容器内检测命令参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.Exec`
        """
        return self._Exec

    @Exec.setter
    def Exec(self, Exec):
        self._Exec = Exec

    @property
    def HttpGet(self):
        r"""HttpGet检测参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.HttpGet`
        """
        return self._HttpGet

    @HttpGet.setter
    def HttpGet(self, HttpGet):
        self._HttpGet = HttpGet

    @property
    def TcpSocket(self):
        r"""TcpSocket检测的端口参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.TcpSocket`
        """
        return self._TcpSocket

    @TcpSocket.setter
    def TcpSocket(self, TcpSocket):
        self._TcpSocket = TcpSocket


    def _deserialize(self, params):
        if params.get("Probe") is not None:
            self._Probe = Probe()
            self._Probe._deserialize(params.get("Probe"))
        if params.get("Exec") is not None:
            self._Exec = Exec()
            self._Exec._deserialize(params.get("Exec"))
        if params.get("HttpGet") is not None:
            self._HttpGet = HttpGet()
            self._HttpGet._deserialize(params.get("HttpGet"))
        if params.get("TcpSocket") is not None:
            self._TcpSocket = TcpSocket()
            self._TcpSocket._deserialize(params.get("TcpSocket"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LoginSettings(AbstractModel):
    r"""描述了实例登录相关配置与信息。

    """

    def __init__(self):
        r"""
        :param _Password: 实例登录密码。不同操作系统类型密码复杂度限制不一样，具体如下：<li>Linux实例密码必须8到30位，至少包括两项[a-z]，[A-Z]、[0-9] 和 [( ) \` ~ ! @ # $ % ^ & *  - + = | { } [ ] : ; ' , . ? / ]中的特殊符号。</li><li>Windows实例密码必须12到30位，至少包括三项[a-z]，[A-Z]，[0-9] 和 [( ) \` ~ ! @ # $ % ^ & * - + = | { } [ ] : ; ' , . ? /]中的特殊符号。</li>若不指定该参数，则由系统随机生成密码，并通过站内信方式通知到用户。
        :type Password: str
        :param _KeyIds: 密钥ID列表。关联密钥后，就可以通过对应的私钥来访问实例；KeyId可通过接口[DescribeKeyPairs](https://cloud.tencent.com/document/api/213/15699)获取，密钥与密码不能同时指定，同时Windows操作系统不支持指定密钥。
注意：此字段可能返回 null，表示取不到有效值。
        :type KeyIds: list of str
        :param _KeepImageLogin: 保持镜像的原始设置。该参数与Password或KeyIds.N不能同时指定。只有使用自定义镜像、共享镜像或外部导入镜像创建实例时才能指定该参数为true。取值范围：<li>true：表示保持镜像的登录设置</li><li>false：表示不保持镜像的登录设置</li>默认取值：false。
        :type KeepImageLogin: str
        """
        self._Password = None
        self._KeyIds = None
        self._KeepImageLogin = None

    @property
    def Password(self):
        r"""实例登录密码。不同操作系统类型密码复杂度限制不一样，具体如下：<li>Linux实例密码必须8到30位，至少包括两项[a-z]，[A-Z]、[0-9] 和 [( ) \` ~ ! @ # $ % ^ & *  - + = | { } [ ] : ; ' , . ? / ]中的特殊符号。</li><li>Windows实例密码必须12到30位，至少包括三项[a-z]，[A-Z]，[0-9] 和 [( ) \` ~ ! @ # $ % ^ & * - + = | { } [ ] : ; ' , . ? /]中的特殊符号。</li>若不指定该参数，则由系统随机生成密码，并通过站内信方式通知到用户。
        :rtype: str
        """
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def KeyIds(self):
        r"""密钥ID列表。关联密钥后，就可以通过对应的私钥来访问实例；KeyId可通过接口[DescribeKeyPairs](https://cloud.tencent.com/document/api/213/15699)获取，密钥与密码不能同时指定，同时Windows操作系统不支持指定密钥。
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of str
        """
        return self._KeyIds

    @KeyIds.setter
    def KeyIds(self, KeyIds):
        self._KeyIds = KeyIds

    @property
    def KeepImageLogin(self):
        r"""保持镜像的原始设置。该参数与Password或KeyIds.N不能同时指定。只有使用自定义镜像、共享镜像或外部导入镜像创建实例时才能指定该参数为true。取值范围：<li>true：表示保持镜像的登录设置</li><li>false：表示不保持镜像的登录设置</li>默认取值：false。
        :rtype: str
        """
        return self._KeepImageLogin

    @KeepImageLogin.setter
    def KeepImageLogin(self, KeepImageLogin):
        self._KeepImageLogin = KeepImageLogin


    def _deserialize(self, params):
        self._Password = params.get("Password")
        self._KeyIds = params.get("KeyIds")
        self._KeepImageLogin = params.get("KeepImageLogin")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManuallyAdded(AbstractModel):
    r"""手动加入的节点

    """

    def __init__(self):
        r"""
        :param _Joining: 加入中的节点数量
        :type Joining: int
        :param _Initializing: 初始化中的节点数量
        :type Initializing: int
        :param _Normal: 正常的节点数量
        :type Normal: int
        :param _Total: 节点总数
        :type Total: int
        """
        self._Joining = None
        self._Initializing = None
        self._Normal = None
        self._Total = None

    @property
    def Joining(self):
        r"""加入中的节点数量
        :rtype: int
        """
        return self._Joining

    @Joining.setter
    def Joining(self, Joining):
        self._Joining = Joining

    @property
    def Initializing(self):
        r"""初始化中的节点数量
        :rtype: int
        """
        return self._Initializing

    @Initializing.setter
    def Initializing(self, Initializing):
        self._Initializing = Initializing

    @property
    def Normal(self):
        r"""正常的节点数量
        :rtype: int
        """
        return self._Normal

    @Normal.setter
    def Normal(self, Normal):
        self._Normal = Normal

    @property
    def Total(self):
        r"""节点总数
        :rtype: int
        """
        return self._Total

    @Total.setter
    def Total(self, Total):
        self._Total = Total


    def _deserialize(self, params):
        self._Joining = params.get("Joining")
        self._Initializing = params.get("Initializing")
        self._Normal = params.get("Normal")
        self._Total = params.get("Total")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterAsGroupAttributeRequest(AbstractModel):
    r"""ModifyClusterAsGroupAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterAsGroupAttribute: 集群关联的伸缩组属性
        :type ClusterAsGroupAttribute: :class:`tencentcloud.tke.v20180525.models.ClusterAsGroupAttribute`
        """
        self._ClusterId = None
        self._ClusterAsGroupAttribute = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterAsGroupAttribute(self):
        r"""集群关联的伸缩组属性
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterAsGroupAttribute`
        """
        return self._ClusterAsGroupAttribute

    @ClusterAsGroupAttribute.setter
    def ClusterAsGroupAttribute(self, ClusterAsGroupAttribute):
        self._ClusterAsGroupAttribute = ClusterAsGroupAttribute


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("ClusterAsGroupAttribute") is not None:
            self._ClusterAsGroupAttribute = ClusterAsGroupAttribute()
            self._ClusterAsGroupAttribute._deserialize(params.get("ClusterAsGroupAttribute"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterAsGroupAttributeResponse(AbstractModel):
    r"""ModifyClusterAsGroupAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterAsGroupOptionAttributeRequest(AbstractModel):
    r"""ModifyClusterAsGroupOptionAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ClusterAsGroupOption: 集群弹性伸缩属性
        :type ClusterAsGroupOption: :class:`tencentcloud.tke.v20180525.models.ClusterAsGroupOption`
        """
        self._ClusterId = None
        self._ClusterAsGroupOption = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterAsGroupOption(self):
        r"""集群弹性伸缩属性
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterAsGroupOption`
        """
        return self._ClusterAsGroupOption

    @ClusterAsGroupOption.setter
    def ClusterAsGroupOption(self, ClusterAsGroupOption):
        self._ClusterAsGroupOption = ClusterAsGroupOption


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("ClusterAsGroupOption") is not None:
            self._ClusterAsGroupOption = ClusterAsGroupOption()
            self._ClusterAsGroupOption._deserialize(params.get("ClusterAsGroupOption"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterAsGroupOptionAttributeResponse(AbstractModel):
    r"""ModifyClusterAsGroupOptionAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterAttributeRequest(AbstractModel):
    r"""ModifyClusterAttribute请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ProjectId: 集群所属项目
        :type ProjectId: int
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterDesc: 集群描述
        :type ClusterDesc: str
        :param _ClusterLevel: 集群等级
        :type ClusterLevel: str
        :param _AutoUpgradeClusterLevel: 自动变配集群等级
        :type AutoUpgradeClusterLevel: :class:`tencentcloud.tke.v20180525.models.AutoUpgradeClusterLevel`
        :param _QGPUShareEnable: 是否开启QGPU共享
        :type QGPUShareEnable: bool
        :param _ClusterProperty: 集群属性
        :type ClusterProperty: :class:`tencentcloud.tke.v20180525.models.ClusterProperty`
        """
        self._ClusterId = None
        self._ProjectId = None
        self._ClusterName = None
        self._ClusterDesc = None
        self._ClusterLevel = None
        self._AutoUpgradeClusterLevel = None
        self._QGPUShareEnable = None
        self._ClusterProperty = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ProjectId(self):
        r"""集群所属项目
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterDesc(self):
        r"""集群描述
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def ClusterLevel(self):
        r"""集群等级
        :rtype: str
        """
        return self._ClusterLevel

    @ClusterLevel.setter
    def ClusterLevel(self, ClusterLevel):
        self._ClusterLevel = ClusterLevel

    @property
    def AutoUpgradeClusterLevel(self):
        r"""自动变配集群等级
        :rtype: :class:`tencentcloud.tke.v20180525.models.AutoUpgradeClusterLevel`
        """
        return self._AutoUpgradeClusterLevel

    @AutoUpgradeClusterLevel.setter
    def AutoUpgradeClusterLevel(self, AutoUpgradeClusterLevel):
        self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel

    @property
    def QGPUShareEnable(self):
        r"""是否开启QGPU共享
        :rtype: bool
        """
        return self._QGPUShareEnable

    @QGPUShareEnable.setter
    def QGPUShareEnable(self, QGPUShareEnable):
        self._QGPUShareEnable = QGPUShareEnable

    @property
    def ClusterProperty(self):
        r"""集群属性
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterProperty`
        """
        return self._ClusterProperty

    @ClusterProperty.setter
    def ClusterProperty(self, ClusterProperty):
        self._ClusterProperty = ClusterProperty


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ProjectId = params.get("ProjectId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterDesc = params.get("ClusterDesc")
        self._ClusterLevel = params.get("ClusterLevel")
        if params.get("AutoUpgradeClusterLevel") is not None:
            self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel()
            self._AutoUpgradeClusterLevel._deserialize(params.get("AutoUpgradeClusterLevel"))
        self._QGPUShareEnable = params.get("QGPUShareEnable")
        if params.get("ClusterProperty") is not None:
            self._ClusterProperty = ClusterProperty()
            self._ClusterProperty._deserialize(params.get("ClusterProperty"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterAttributeResponse(AbstractModel):
    r"""ModifyClusterAttribute返回参数结构体

    """

    def __init__(self):
        r"""
        :param _ProjectId: 集群所属项目
        :type ProjectId: int
        :param _ClusterName: 集群名称
        :type ClusterName: str
        :param _ClusterDesc: 集群描述
        :type ClusterDesc: str
        :param _ClusterLevel: 集群等级
        :type ClusterLevel: str
        :param _AutoUpgradeClusterLevel: 自动变配集群等级
        :type AutoUpgradeClusterLevel: :class:`tencentcloud.tke.v20180525.models.AutoUpgradeClusterLevel`
        :param _QGPUShareEnable: 是否开启QGPU共享
        :type QGPUShareEnable: bool
        :param _ClusterProperty: 集群属性
        :type ClusterProperty: :class:`tencentcloud.tke.v20180525.models.ClusterProperty`
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._ProjectId = None
        self._ClusterName = None
        self._ClusterDesc = None
        self._ClusterLevel = None
        self._AutoUpgradeClusterLevel = None
        self._QGPUShareEnable = None
        self._ClusterProperty = None
        self._RequestId = None

    @property
    def ProjectId(self):
        r"""集群所属项目
        :rtype: int
        """
        return self._ProjectId

    @ProjectId.setter
    def ProjectId(self, ProjectId):
        self._ProjectId = ProjectId

    @property
    def ClusterName(self):
        r"""集群名称
        :rtype: str
        """
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterDesc(self):
        r"""集群描述
        :rtype: str
        """
        return self._ClusterDesc

    @ClusterDesc.setter
    def ClusterDesc(self, ClusterDesc):
        self._ClusterDesc = ClusterDesc

    @property
    def ClusterLevel(self):
        r"""集群等级
        :rtype: str
        """
        return self._ClusterLevel

    @ClusterLevel.setter
    def ClusterLevel(self, ClusterLevel):
        self._ClusterLevel = ClusterLevel

    @property
    def AutoUpgradeClusterLevel(self):
        r"""自动变配集群等级
        :rtype: :class:`tencentcloud.tke.v20180525.models.AutoUpgradeClusterLevel`
        """
        return self._AutoUpgradeClusterLevel

    @AutoUpgradeClusterLevel.setter
    def AutoUpgradeClusterLevel(self, AutoUpgradeClusterLevel):
        self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel

    @property
    def QGPUShareEnable(self):
        r"""是否开启QGPU共享
        :rtype: bool
        """
        return self._QGPUShareEnable

    @QGPUShareEnable.setter
    def QGPUShareEnable(self, QGPUShareEnable):
        self._QGPUShareEnable = QGPUShareEnable

    @property
    def ClusterProperty(self):
        r"""集群属性
        :rtype: :class:`tencentcloud.tke.v20180525.models.ClusterProperty`
        """
        return self._ClusterProperty

    @ClusterProperty.setter
    def ClusterProperty(self, ClusterProperty):
        self._ClusterProperty = ClusterProperty

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ProjectId = params.get("ProjectId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterDesc = params.get("ClusterDesc")
        self._ClusterLevel = params.get("ClusterLevel")
        if params.get("AutoUpgradeClusterLevel") is not None:
            self._AutoUpgradeClusterLevel = AutoUpgradeClusterLevel()
            self._AutoUpgradeClusterLevel._deserialize(params.get("AutoUpgradeClusterLevel"))
        self._QGPUShareEnable = params.get("QGPUShareEnable")
        if params.get("ClusterProperty") is not None:
            self._ClusterProperty = ClusterProperty()
            self._ClusterProperty._deserialize(params.get("ClusterProperty"))
        self._RequestId = params.get("RequestId")


class ModifyClusterAuthenticationOptionsRequest(AbstractModel):
    r"""ModifyClusterAuthenticationOptions请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ServiceAccounts: ServiceAccount认证配置
        :type ServiceAccounts: :class:`tencentcloud.tke.v20180525.models.ServiceAccountAuthenticationOptions`
        :param _OIDCConfig: OIDC认证配置
        :type OIDCConfig: :class:`tencentcloud.tke.v20180525.models.OIDCConfigAuthenticationOptions`
        """
        self._ClusterId = None
        self._ServiceAccounts = None
        self._OIDCConfig = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ServiceAccounts(self):
        r"""ServiceAccount认证配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.ServiceAccountAuthenticationOptions`
        """
        return self._ServiceAccounts

    @ServiceAccounts.setter
    def ServiceAccounts(self, ServiceAccounts):
        self._ServiceAccounts = ServiceAccounts

    @property
    def OIDCConfig(self):
        r"""OIDC认证配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.OIDCConfigAuthenticationOptions`
        """
        return self._OIDCConfig

    @OIDCConfig.setter
    def OIDCConfig(self, OIDCConfig):
        self._OIDCConfig = OIDCConfig


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("ServiceAccounts") is not None:
            self._ServiceAccounts = ServiceAccountAuthenticationOptions()
            self._ServiceAccounts._deserialize(params.get("ServiceAccounts"))
        if params.get("OIDCConfig") is not None:
            self._OIDCConfig = OIDCConfigAuthenticationOptions()
            self._OIDCConfig._deserialize(params.get("OIDCConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterAuthenticationOptionsResponse(AbstractModel):
    r"""ModifyClusterAuthenticationOptions返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterEndpointSPRequest(AbstractModel):
    r"""ModifyClusterEndpointSP请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _SecurityPolicies: 安全策略放通单个IP或CIDR(例如: "192.168.1.0/24",默认为拒绝所有)
        :type SecurityPolicies: list of str
        :param _SecurityGroup: 修改外网访问安全组
        :type SecurityGroup: str
        """
        self._ClusterId = None
        self._SecurityPolicies = None
        self._SecurityGroup = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def SecurityPolicies(self):
        r"""安全策略放通单个IP或CIDR(例如: "192.168.1.0/24",默认为拒绝所有)
        :rtype: list of str
        """
        return self._SecurityPolicies

    @SecurityPolicies.setter
    def SecurityPolicies(self, SecurityPolicies):
        self._SecurityPolicies = SecurityPolicies

    @property
    def SecurityGroup(self):
        r"""修改外网访问安全组
        :rtype: str
        """
        return self._SecurityGroup

    @SecurityGroup.setter
    def SecurityGroup(self, SecurityGroup):
        self._SecurityGroup = SecurityGroup


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._SecurityPolicies = params.get("SecurityPolicies")
        self._SecurityGroup = params.get("SecurityGroup")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterEndpointSPResponse(AbstractModel):
    r"""ModifyClusterEndpointSP返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterImageRequest(AbstractModel):
    r"""ModifyClusterImage请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ImageId: 指定有效的镜像ID，格式形如img-e55paxnt。可通过登录控制台查询，也可调用接口 [DescribeImages](https://cloud.tencent.com/document/api/213/15715)，取返回信息中的ImageId字段。
        :type ImageId: str
        """
        self._ClusterId = None
        self._ImageId = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ImageId(self):
        r"""指定有效的镜像ID，格式形如img-e55paxnt。可通过登录控制台查询，也可调用接口 [DescribeImages](https://cloud.tencent.com/document/api/213/15715)，取返回信息中的ImageId字段。
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ImageId = params.get("ImageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterImageResponse(AbstractModel):
    r"""ModifyClusterImage返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterNodePoolRequest(AbstractModel):
    r"""ModifyClusterNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _NodePoolId: 节点池ID
        :type NodePoolId: str
        :param _Name: 名称
        :type Name: str
        :param _MaxNodesNum: 最大节点数
        :type MaxNodesNum: int
        :param _MinNodesNum: 最小节点数
        :type MinNodesNum: int
        :param _Labels: 标签
        :type Labels: list of Label
        :param _Taints: 污点
        :type Taints: list of Taint
        :param _Annotations: 节点 Annotation 列表
        :type Annotations: list of AnnotationValue
        :param _EnableAutoscale: 是否开启伸缩
        :type EnableAutoscale: bool
        :param _OsName: 操作系统名称
        :type OsName: str
        :param _OsCustomizeType: 镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :type OsCustomizeType: str
        :param _GPUArgs: GPU驱动版本，CUDA版本，cuDNN版本以及是否启用MIG特性
        :type GPUArgs: :class:`tencentcloud.tke.v20180525.models.GPUArgs`
        :param _UserScript: base64编码后的自定义脚本
        :type UserScript: str
        :param _IgnoreExistedNode: 更新label和taint时忽略存量节点
        :type IgnoreExistedNode: bool
        :param _ExtraArgs: 节点自定义参数
        :type ExtraArgs: :class:`tencentcloud.tke.v20180525.models.InstanceExtraArgs`
        :param _Tags: 资源标签
        :type Tags: list of Tag
        :param _Unschedulable: 设置加入的节点是否参与调度，默认值为0，表示参与调度；非0表示不参与调度, 待节点初始化完成之后, 可执行kubectl uncordon nodename使node加入调度.
        :type Unschedulable: int
        :param _DeletionProtection: 删除保护开关
        :type DeletionProtection: bool
        :param _DockerGraphPath: dockerd --graph 指定值, 默认为 /var/lib/docker
        :type DockerGraphPath: str
        :param _PreStartUserScript: base64编码后的自定义脚本
        :type PreStartUserScript: str
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._Name = None
        self._MaxNodesNum = None
        self._MinNodesNum = None
        self._Labels = None
        self._Taints = None
        self._Annotations = None
        self._EnableAutoscale = None
        self._OsName = None
        self._OsCustomizeType = None
        self._GPUArgs = None
        self._UserScript = None
        self._IgnoreExistedNode = None
        self._ExtraArgs = None
        self._Tags = None
        self._Unschedulable = None
        self._DeletionProtection = None
        self._DockerGraphPath = None
        self._PreStartUserScript = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池ID
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def Name(self):
        r"""名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def MaxNodesNum(self):
        r"""最大节点数
        :rtype: int
        """
        return self._MaxNodesNum

    @MaxNodesNum.setter
    def MaxNodesNum(self, MaxNodesNum):
        self._MaxNodesNum = MaxNodesNum

    @property
    def MinNodesNum(self):
        r"""最小节点数
        :rtype: int
        """
        return self._MinNodesNum

    @MinNodesNum.setter
    def MinNodesNum(self, MinNodesNum):
        self._MinNodesNum = MinNodesNum

    @property
    def Labels(self):
        r"""标签
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Taints(self):
        r"""污点
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def Annotations(self):
        r"""节点 Annotation 列表
        :rtype: list of AnnotationValue
        """
        return self._Annotations

    @Annotations.setter
    def Annotations(self, Annotations):
        self._Annotations = Annotations

    @property
    def EnableAutoscale(self):
        r"""是否开启伸缩
        :rtype: bool
        """
        return self._EnableAutoscale

    @EnableAutoscale.setter
    def EnableAutoscale(self, EnableAutoscale):
        self._EnableAutoscale = EnableAutoscale

    @property
    def OsName(self):
        r"""操作系统名称
        :rtype: str
        """
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def OsCustomizeType(self):
        r"""镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType

    @property
    def GPUArgs(self):
        r"""GPU驱动版本，CUDA版本，cuDNN版本以及是否启用MIG特性
        :rtype: :class:`tencentcloud.tke.v20180525.models.GPUArgs`
        """
        return self._GPUArgs

    @GPUArgs.setter
    def GPUArgs(self, GPUArgs):
        self._GPUArgs = GPUArgs

    @property
    def UserScript(self):
        r"""base64编码后的自定义脚本
        :rtype: str
        """
        return self._UserScript

    @UserScript.setter
    def UserScript(self, UserScript):
        self._UserScript = UserScript

    @property
    def IgnoreExistedNode(self):
        r"""更新label和taint时忽略存量节点
        :rtype: bool
        """
        return self._IgnoreExistedNode

    @IgnoreExistedNode.setter
    def IgnoreExistedNode(self, IgnoreExistedNode):
        self._IgnoreExistedNode = IgnoreExistedNode

    @property
    def ExtraArgs(self):
        r"""节点自定义参数
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceExtraArgs`
        """
        return self._ExtraArgs

    @ExtraArgs.setter
    def ExtraArgs(self, ExtraArgs):
        self._ExtraArgs = ExtraArgs

    @property
    def Tags(self):
        r"""资源标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Unschedulable(self):
        r"""设置加入的节点是否参与调度，默认值为0，表示参与调度；非0表示不参与调度, 待节点初始化完成之后, 可执行kubectl uncordon nodename使node加入调度.
        :rtype: int
        """
        return self._Unschedulable

    @Unschedulable.setter
    def Unschedulable(self, Unschedulable):
        self._Unschedulable = Unschedulable

    @property
    def DeletionProtection(self):
        r"""删除保护开关
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection

    @property
    def DockerGraphPath(self):
        r"""dockerd --graph 指定值, 默认为 /var/lib/docker
        :rtype: str
        """
        return self._DockerGraphPath

    @DockerGraphPath.setter
    def DockerGraphPath(self, DockerGraphPath):
        self._DockerGraphPath = DockerGraphPath

    @property
    def PreStartUserScript(self):
        r"""base64编码后的自定义脚本
        :rtype: str
        """
        return self._PreStartUserScript

    @PreStartUserScript.setter
    def PreStartUserScript(self, PreStartUserScript):
        self._PreStartUserScript = PreStartUserScript


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._Name = params.get("Name")
        self._MaxNodesNum = params.get("MaxNodesNum")
        self._MinNodesNum = params.get("MinNodesNum")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Taints") is not None:
            self._Taints = []
            for item in params.get("Taints"):
                obj = Taint()
                obj._deserialize(item)
                self._Taints.append(obj)
        if params.get("Annotations") is not None:
            self._Annotations = []
            for item in params.get("Annotations"):
                obj = AnnotationValue()
                obj._deserialize(item)
                self._Annotations.append(obj)
        self._EnableAutoscale = params.get("EnableAutoscale")
        self._OsName = params.get("OsName")
        self._OsCustomizeType = params.get("OsCustomizeType")
        if params.get("GPUArgs") is not None:
            self._GPUArgs = GPUArgs()
            self._GPUArgs._deserialize(params.get("GPUArgs"))
        self._UserScript = params.get("UserScript")
        self._IgnoreExistedNode = params.get("IgnoreExistedNode")
        if params.get("ExtraArgs") is not None:
            self._ExtraArgs = InstanceExtraArgs()
            self._ExtraArgs._deserialize(params.get("ExtraArgs"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Unschedulable = params.get("Unschedulable")
        self._DeletionProtection = params.get("DeletionProtection")
        self._DockerGraphPath = params.get("DockerGraphPath")
        self._PreStartUserScript = params.get("PreStartUserScript")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterNodePoolResponse(AbstractModel):
    r"""ModifyClusterNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterRuntimeConfigRequest(AbstractModel):
    r"""ModifyClusterRuntimeConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，必填
        :type ClusterId: str
        :param _DstK8SVersion: 当需要修改运行时版本是根据另外的K8S版本获取时，需填写。例如升级校验有冲突后修改场景
        :type DstK8SVersion: str
        :param _ClusterRuntimeConfig: 需要修改集群运行时时填写
        :type ClusterRuntimeConfig: :class:`tencentcloud.tke.v20180525.models.RuntimeConfig`
        :param _NodePoolRuntimeConfig: 需要修改节点池运行时时，填需要修改的部分
        :type NodePoolRuntimeConfig: list of NodePoolRuntime
        """
        self._ClusterId = None
        self._DstK8SVersion = None
        self._ClusterRuntimeConfig = None
        self._NodePoolRuntimeConfig = None

    @property
    def ClusterId(self):
        r"""集群ID，必填
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def DstK8SVersion(self):
        r"""当需要修改运行时版本是根据另外的K8S版本获取时，需填写。例如升级校验有冲突后修改场景
        :rtype: str
        """
        return self._DstK8SVersion

    @DstK8SVersion.setter
    def DstK8SVersion(self, DstK8SVersion):
        self._DstK8SVersion = DstK8SVersion

    @property
    def ClusterRuntimeConfig(self):
        r"""需要修改集群运行时时填写
        :rtype: :class:`tencentcloud.tke.v20180525.models.RuntimeConfig`
        """
        return self._ClusterRuntimeConfig

    @ClusterRuntimeConfig.setter
    def ClusterRuntimeConfig(self, ClusterRuntimeConfig):
        self._ClusterRuntimeConfig = ClusterRuntimeConfig

    @property
    def NodePoolRuntimeConfig(self):
        r"""需要修改节点池运行时时，填需要修改的部分
        :rtype: list of NodePoolRuntime
        """
        return self._NodePoolRuntimeConfig

    @NodePoolRuntimeConfig.setter
    def NodePoolRuntimeConfig(self, NodePoolRuntimeConfig):
        self._NodePoolRuntimeConfig = NodePoolRuntimeConfig


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._DstK8SVersion = params.get("DstK8SVersion")
        if params.get("ClusterRuntimeConfig") is not None:
            self._ClusterRuntimeConfig = RuntimeConfig()
            self._ClusterRuntimeConfig._deserialize(params.get("ClusterRuntimeConfig"))
        if params.get("NodePoolRuntimeConfig") is not None:
            self._NodePoolRuntimeConfig = []
            for item in params.get("NodePoolRuntimeConfig"):
                obj = NodePoolRuntime()
                obj._deserialize(item)
                self._NodePoolRuntimeConfig.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterRuntimeConfigResponse(AbstractModel):
    r"""ModifyClusterRuntimeConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyClusterTagsRequest(AbstractModel):
    r"""ModifyClusterTags请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Tags: 集群标签
        :type Tags: list of Tag
        :param _SyncSubresource: 是否同步集群内子资源标签
        :type SyncSubresource: bool
        """
        self._ClusterId = None
        self._Tags = None
        self._SyncSubresource = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Tags(self):
        r"""集群标签
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def SyncSubresource(self):
        r"""是否同步集群内子资源标签
        :rtype: bool
        """
        return self._SyncSubresource

    @SyncSubresource.setter
    def SyncSubresource(self, SyncSubresource):
        self._SyncSubresource = SyncSubresource


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._SyncSubresource = params.get("SyncSubresource")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterTagsResponse(AbstractModel):
    r"""ModifyClusterTags返回参数结构体

    """

    def __init__(self):
        r"""
        :param _Tags: 集群标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._Tags = None
        self._RequestId = None

    @property
    def Tags(self):
        r"""集群标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = Tag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._RequestId = params.get("RequestId")


class ModifyClusterVirtualNodePoolRequest(AbstractModel):
    r"""ModifyClusterVirtualNodePool请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID，通过DescribeClusters接口获取
        :type ClusterId: str
        :param _NodePoolId: 节点池ID，通过DescribeNodePools接口获取
        :type NodePoolId: str
        :param _Name: 节点池名称，必须修改至少一个参数
        :type Name: str
        :param _SecurityGroupIds: 安全组ID列表，必须修改至少一个参数
        :type SecurityGroupIds: list of str
        :param _Labels: 虚拟节点label，必须修改至少一个参数
        :type Labels: list of Label
        :param _Taints: 虚拟节点taint，必须修改至少一个参数
        :type Taints: list of Taint
        :param _DeletionProtection: 删除保护开关，必须修改至少一个参数
        :type DeletionProtection: bool
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._Name = None
        self._SecurityGroupIds = None
        self._Labels = None
        self._Taints = None
        self._DeletionProtection = None

    @property
    def ClusterId(self):
        r"""集群ID，通过DescribeClusters接口获取
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池ID，通过DescribeNodePools接口获取
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def Name(self):
        r"""节点池名称，必须修改至少一个参数
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SecurityGroupIds(self):
        r"""安全组ID列表，必须修改至少一个参数
        :rtype: list of str
        """
        return self._SecurityGroupIds

    @SecurityGroupIds.setter
    def SecurityGroupIds(self, SecurityGroupIds):
        self._SecurityGroupIds = SecurityGroupIds

    @property
    def Labels(self):
        r"""虚拟节点label，必须修改至少一个参数
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Taints(self):
        r"""虚拟节点taint，必须修改至少一个参数
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def DeletionProtection(self):
        r"""删除保护开关，必须修改至少一个参数
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._Name = params.get("Name")
        self._SecurityGroupIds = params.get("SecurityGroupIds")
        if params.get("Labels") is not None:
            self._Labels = []
            for item in params.get("Labels"):
                obj = Label()
                obj._deserialize(item)
                self._Labels.append(obj)
        if params.get("Taints") is not None:
            self._Taints = []
            for item in params.get("Taints"):
                obj = Taint()
                obj._deserialize(item)
                self._Taints.append(obj)
        self._DeletionProtection = params.get("DeletionProtection")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyClusterVirtualNodePoolResponse(AbstractModel):
    r"""ModifyClusterVirtualNodePool返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyMasterComponentRequest(AbstractModel):
    r"""ModifyMasterComponent请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _Component: master组件名称，支持kube-apiserver、kube-scheduler、kube-controller-manager
        :type Component: str
        :param _Operation: 停机或恢复，值只能为：shutdown或restore
        :type Operation: str
        :param _DryRun: 为true时，不真正执行停机或恢复操作	
        :type DryRun: bool
        """
        self._ClusterId = None
        self._Component = None
        self._Operation = None
        self._DryRun = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Component(self):
        r"""master组件名称，支持kube-apiserver、kube-scheduler、kube-controller-manager
        :rtype: str
        """
        return self._Component

    @Component.setter
    def Component(self, Component):
        self._Component = Component

    @property
    def Operation(self):
        r"""停机或恢复，值只能为：shutdown或restore
        :rtype: str
        """
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def DryRun(self):
        r"""为true时，不真正执行停机或恢复操作	
        :rtype: bool
        """
        return self._DryRun

    @DryRun.setter
    def DryRun(self, DryRun):
        self._DryRun = DryRun


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Component = params.get("Component")
        self._Operation = params.get("Operation")
        self._DryRun = params.get("DryRun")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyMasterComponentResponse(AbstractModel):
    r"""ModifyMasterComponent返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNodePoolDesiredCapacityAboutAsgRequest(AbstractModel):
    r"""ModifyNodePoolDesiredCapacityAboutAsg请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _NodePoolId: 节点池id
        :type NodePoolId: str
        :param _DesiredCapacity: 节点池所关联的伸缩组的期望实例数
        :type DesiredCapacity: int
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._DesiredCapacity = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池id
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def DesiredCapacity(self):
        r"""节点池所关联的伸缩组的期望实例数
        :rtype: int
        """
        return self._DesiredCapacity

    @DesiredCapacity.setter
    def DesiredCapacity(self, DesiredCapacity):
        self._DesiredCapacity = DesiredCapacity


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._DesiredCapacity = params.get("DesiredCapacity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNodePoolDesiredCapacityAboutAsgResponse(AbstractModel):
    r"""ModifyNodePoolDesiredCapacityAboutAsg返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyNodePoolInstanceTypesRequest(AbstractModel):
    r"""ModifyNodePoolInstanceTypes请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _NodePoolId: 节点池id
        :type NodePoolId: str
        :param _InstanceTypes: 机型列表，主实例机型不支持修改
        :type InstanceTypes: list of str
        """
        self._ClusterId = None
        self._NodePoolId = None
        self._InstanceTypes = None

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def NodePoolId(self):
        r"""节点池id
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def InstanceTypes(self):
        r"""机型列表，主实例机型不支持修改
        :rtype: list of str
        """
        return self._InstanceTypes

    @InstanceTypes.setter
    def InstanceTypes(self, InstanceTypes):
        self._InstanceTypes = InstanceTypes


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._NodePoolId = params.get("NodePoolId")
        self._InstanceTypes = params.get("InstanceTypes")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyNodePoolInstanceTypesResponse(AbstractModel):
    r"""ModifyNodePoolInstanceTypes返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyOpenPolicyListRequest(AbstractModel):
    r"""ModifyOpenPolicyList请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _OpenPolicyInfoList: 修改的策略列表，目前仅支持修改EnforcementAction字段
        :type OpenPolicyInfoList: list of OpenPolicySwitch
        :param _Category: 策略分类 基线：baseline 优选：priority 可选：optional
        :type Category: str
        """
        self._ClusterId = None
        self._OpenPolicyInfoList = None
        self._Category = None

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def OpenPolicyInfoList(self):
        r"""修改的策略列表，目前仅支持修改EnforcementAction字段
        :rtype: list of OpenPolicySwitch
        """
        return self._OpenPolicyInfoList

    @OpenPolicyInfoList.setter
    def OpenPolicyInfoList(self, OpenPolicyInfoList):
        self._OpenPolicyInfoList = OpenPolicyInfoList

    @property
    def Category(self):
        r"""策略分类 基线：baseline 优选：priority 可选：optional
        :rtype: str
        """
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        if params.get("OpenPolicyInfoList") is not None:
            self._OpenPolicyInfoList = []
            for item in params.get("OpenPolicyInfoList"):
                obj = OpenPolicySwitch()
                obj._deserialize(item)
                self._OpenPolicyInfoList.append(obj)
        self._Category = params.get("Category")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyOpenPolicyListResponse(AbstractModel):
    r"""ModifyOpenPolicyList返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusAgentExternalLabelsRequest(AbstractModel):
    r"""ModifyPrometheusAgentExternalLabels请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _ClusterId: 集群ID
        :type ClusterId: str
        :param _ExternalLabels: 新的external_labels
        :type ExternalLabels: list of Label
        """
        self._InstanceId = None
        self._ClusterId = None
        self._ExternalLabels = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterId(self):
        r"""集群ID
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ExternalLabels(self):
        r"""新的external_labels
        :rtype: list of Label
        """
        return self._ExternalLabels

    @ExternalLabels.setter
    def ExternalLabels(self, ExternalLabels):
        self._ExternalLabels = ExternalLabels


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterId = params.get("ClusterId")
        if params.get("ExternalLabels") is not None:
            self._ExternalLabels = []
            for item in params.get("ExternalLabels"):
                obj = Label()
                obj._deserialize(item)
                self._ExternalLabels.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusAgentExternalLabelsResponse(AbstractModel):
    r"""ModifyPrometheusAgentExternalLabels返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusAlertPolicyRequest(AbstractModel):
    r"""ModifyPrometheusAlertPolicy请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _AlertRule: 告警配置
        :type AlertRule: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertPolicyItem`
        """
        self._InstanceId = None
        self._AlertRule = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AlertRule(self):
        r"""告警配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertPolicyItem`
        """
        return self._AlertRule

    @AlertRule.setter
    def AlertRule(self, AlertRule):
        self._AlertRule = AlertRule


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("AlertRule") is not None:
            self._AlertRule = PrometheusAlertPolicyItem()
            self._AlertRule._deserialize(params.get("AlertRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusAlertPolicyResponse(AbstractModel):
    r"""ModifyPrometheusAlertPolicy返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusAlertRuleRequest(AbstractModel):
    r"""ModifyPrometheusAlertRule请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _AlertRule: 告警配置
        :type AlertRule: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertRuleDetail`
        """
        self._InstanceId = None
        self._AlertRule = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def AlertRule(self):
        r"""告警配置
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusAlertRuleDetail`
        """
        return self._AlertRule

    @AlertRule.setter
    def AlertRule(self, AlertRule):
        self._AlertRule = AlertRule


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("AlertRule") is not None:
            self._AlertRule = PrometheusAlertRuleDetail()
            self._AlertRule._deserialize(params.get("AlertRule"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusAlertRuleResponse(AbstractModel):
    r"""ModifyPrometheusAlertRule返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusConfigRequest(AbstractModel):
    r"""ModifyPrometheusConfig请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _ClusterType: 集群类型
        :type ClusterType: str
        :param _ClusterId: 集群id
        :type ClusterId: str
        :param _ServiceMonitors: ServiceMonitors配置
        :type ServiceMonitors: list of PrometheusConfigItem
        :param _PodMonitors: PodMonitors配置
        :type PodMonitors: list of PrometheusConfigItem
        :param _RawJobs: prometheus原生Job配置
        :type RawJobs: list of PrometheusConfigItem
        :param _Probes: Probes 配置
        :type Probes: list of PrometheusConfigItem
        """
        self._InstanceId = None
        self._ClusterType = None
        self._ClusterId = None
        self._ServiceMonitors = None
        self._PodMonitors = None
        self._RawJobs = None
        self._Probes = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def ClusterType(self):
        r"""集群类型
        :rtype: str
        """
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterId(self):
        r"""集群id
        :rtype: str
        """
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ServiceMonitors(self):
        r"""ServiceMonitors配置
        :rtype: list of PrometheusConfigItem
        """
        return self._ServiceMonitors

    @ServiceMonitors.setter
    def ServiceMonitors(self, ServiceMonitors):
        self._ServiceMonitors = ServiceMonitors

    @property
    def PodMonitors(self):
        r"""PodMonitors配置
        :rtype: list of PrometheusConfigItem
        """
        return self._PodMonitors

    @PodMonitors.setter
    def PodMonitors(self, PodMonitors):
        self._PodMonitors = PodMonitors

    @property
    def RawJobs(self):
        r"""prometheus原生Job配置
        :rtype: list of PrometheusConfigItem
        """
        return self._RawJobs

    @RawJobs.setter
    def RawJobs(self, RawJobs):
        self._RawJobs = RawJobs

    @property
    def Probes(self):
        r"""Probes 配置
        :rtype: list of PrometheusConfigItem
        """
        return self._Probes

    @Probes.setter
    def Probes(self, Probes):
        self._Probes = Probes


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._ClusterType = params.get("ClusterType")
        self._ClusterId = params.get("ClusterId")
        if params.get("ServiceMonitors") is not None:
            self._ServiceMonitors = []
            for item in params.get("ServiceMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._ServiceMonitors.append(obj)
        if params.get("PodMonitors") is not None:
            self._PodMonitors = []
            for item in params.get("PodMonitors"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._PodMonitors.append(obj)
        if params.get("RawJobs") is not None:
            self._RawJobs = []
            for item in params.get("RawJobs"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._RawJobs.append(obj)
        if params.get("Probes") is not None:
            self._Probes = []
            for item in params.get("Probes"):
                obj = PrometheusConfigItem()
                obj._deserialize(item)
                self._Probes.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusConfigResponse(AbstractModel):
    r"""ModifyPrometheusConfig返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusGlobalNotificationRequest(AbstractModel):
    r"""ModifyPrometheusGlobalNotification请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例ID
        :type InstanceId: str
        :param _Notification: 告警通知渠道
        :type Notification: :class:`tencentcloud.tke.v20180525.models.PrometheusNotificationItem`
        """
        self._InstanceId = None
        self._Notification = None

    @property
    def InstanceId(self):
        r"""实例ID
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Notification(self):
        r"""告警通知渠道
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusNotificationItem`
        """
        return self._Notification

    @Notification.setter
    def Notification(self, Notification):
        self._Notification = Notification


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        if params.get("Notification") is not None:
            self._Notification = PrometheusNotificationItem()
            self._Notification._deserialize(params.get("Notification"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusGlobalNotificationResponse(AbstractModel):
    r"""ModifyPrometheusGlobalNotification返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusRecordRuleYamlRequest(AbstractModel):
    r"""ModifyPrometheusRecordRuleYaml请求参数结构体

    """

    def __init__(self):
        r"""
        :param _InstanceId: 实例id
        :type InstanceId: str
        :param _Name: 聚合实例名称
        :type Name: str
        :param _Content: 新的内容
        :type Content: str
        """
        self._InstanceId = None
        self._Name = None
        self._Content = None

    @property
    def InstanceId(self):
        r"""实例id
        :rtype: str
        """
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def Name(self):
        r"""聚合实例名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Content(self):
        r"""新的内容
        :rtype: str
        """
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._InstanceId = params.get("InstanceId")
        self._Name = params.get("Name")
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusRecordRuleYamlResponse(AbstractModel):
    r"""ModifyPrometheusRecordRuleYaml返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusTempRequest(AbstractModel):
    r"""ModifyPrometheusTemp请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板ID
        :type TemplateId: str
        :param _Template: 修改内容
        :type Template: :class:`tencentcloud.tke.v20180525.models.PrometheusTempModify`
        """
        self._TemplateId = None
        self._Template = None

    @property
    def TemplateId(self):
        r"""模板ID
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Template(self):
        r"""修改内容
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusTempModify`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("Template") is not None:
            self._Template = PrometheusTempModify()
            self._Template._deserialize(params.get("Template"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusTempResponse(AbstractModel):
    r"""ModifyPrometheusTemp返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPrometheusTemplateRequest(AbstractModel):
    r"""ModifyPrometheusTemplate请求参数结构体

    """

    def __init__(self):
        r"""
        :param _TemplateId: 模板ID
        :type TemplateId: str
        :param _Template: 修改内容
        :type Template: :class:`tencentcloud.tke.v20180525.models.PrometheusTemplateModify`
        """
        self._TemplateId = None
        self._Template = None

    @property
    def TemplateId(self):
        r"""模板ID
        :rtype: str
        """
        return self._TemplateId

    @TemplateId.setter
    def TemplateId(self, TemplateId):
        self._TemplateId = TemplateId

    @property
    def Template(self):
        r"""修改内容
        :rtype: :class:`tencentcloud.tke.v20180525.models.PrometheusTemplateModify`
        """
        return self._Template

    @Template.setter
    def Template(self, Template):
        self._Template = Template


    def _deserialize(self, params):
        self._TemplateId = params.get("TemplateId")
        if params.get("Template") is not None:
            self._Template = PrometheusTemplateModify()
            self._Template._deserialize(params.get("Template"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPrometheusTemplateResponse(AbstractModel):
    r"""ModifyPrometheusTemplate返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyReservedInstanceScopeRequest(AbstractModel):
    r"""ModifyReservedInstanceScope请求参数结构体

    """

    def __init__(self):
        r"""
        :param _ReservedInstanceIds: 预留券实例ID。可通过 [DescribeReservedInstances](https://cloud.tencent.com/document/product/457/99162) 接口返回值中的ReservedInstanceId获取。
        :type ReservedInstanceIds: list of str
        :param _ReservedInstanceScope: 预留券抵扣范围信息
        :type ReservedInstanceScope: :class:`tencentcloud.tke.v20180525.models.ReservedInstanceScope`
        """
        self._ReservedInstanceIds = None
        self._ReservedInstanceScope = None

    @property
    def ReservedInstanceIds(self):
        r"""预留券实例ID。可通过 [DescribeReservedInstances](https://cloud.tencent.com/document/product/457/99162) 接口返回值中的ReservedInstanceId获取。
        :rtype: list of str
        """
        return self._ReservedInstanceIds

    @ReservedInstanceIds.setter
    def ReservedInstanceIds(self, ReservedInstanceIds):
        self._ReservedInstanceIds = ReservedInstanceIds

    @property
    def ReservedInstanceScope(self):
        r"""预留券抵扣范围信息
        :rtype: :class:`tencentcloud.tke.v20180525.models.ReservedInstanceScope`
        """
        return self._ReservedInstanceScope

    @ReservedInstanceScope.setter
    def ReservedInstanceScope(self, ReservedInstanceScope):
        self._ReservedInstanceScope = ReservedInstanceScope


    def _deserialize(self, params):
        self._ReservedInstanceIds = params.get("ReservedInstanceIds")
        if params.get("ReservedInstanceScope") is not None:
            self._ReservedInstanceScope = ReservedInstanceScope()
            self._ReservedInstanceScope._deserialize(params.get("ReservedInstanceScope"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyReservedInstanceScopeResponse(AbstractModel):
    r"""ModifyReservedInstanceScope返回参数结构体

    """

    def __init__(self):
        r"""
        :param _RequestId: 唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        r"""唯一请求 ID，由服务端生成，每次请求都会返回（若请求因其他原因未能抵达服务端，则该次请求不会获得 RequestId）。定位问题时需要提供该次请求的 RequestId。
        :rtype: str
        """
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class NfsVolume(AbstractModel):
    r"""EKS Instance Nfs Volume

    """

    def __init__(self):
        r"""
        :param _Name: nfs volume 数据卷名称
        :type Name: str
        :param _Path: NFS 数据卷路径
        :type Path: str
        :param _Server: NFS 服务器地址
        :type Server: str
        :param _ReadOnly: 默认为 False
        :type ReadOnly: bool
        """
        self._Name = None
        self._Path = None
        self._Server = None
        self._ReadOnly = None

    @property
    def Name(self):
        r"""nfs volume 数据卷名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Path(self):
        r"""NFS 数据卷路径
        :rtype: str
        """
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Server(self):
        r"""NFS 服务器地址
        :rtype: str
        """
        return self._Server

    @Server.setter
    def Server(self, Server):
        self._Server = Server

    @property
    def ReadOnly(self):
        r"""默认为 False
        :rtype: bool
        """
        return self._ReadOnly

    @ReadOnly.setter
    def ReadOnly(self, ReadOnly):
        self._ReadOnly = ReadOnly


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Path = params.get("Path")
        self._Server = params.get("Server")
        self._ReadOnly = params.get("ReadOnly")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodeCountSummary(AbstractModel):
    r"""节点统计列表

    """

    def __init__(self):
        r"""
        :param _ManuallyAdded: 手动管理的节点
        :type ManuallyAdded: :class:`tencentcloud.tke.v20180525.models.ManuallyAdded`
        :param _AutoscalingAdded: 自动管理的节点
        :type AutoscalingAdded: :class:`tencentcloud.tke.v20180525.models.AutoscalingAdded`
        """
        self._ManuallyAdded = None
        self._AutoscalingAdded = None

    @property
    def ManuallyAdded(self):
        r"""手动管理的节点
        :rtype: :class:`tencentcloud.tke.v20180525.models.ManuallyAdded`
        """
        return self._ManuallyAdded

    @ManuallyAdded.setter
    def ManuallyAdded(self, ManuallyAdded):
        self._ManuallyAdded = ManuallyAdded

    @property
    def AutoscalingAdded(self):
        r"""自动管理的节点
        :rtype: :class:`tencentcloud.tke.v20180525.models.AutoscalingAdded`
        """
        return self._AutoscalingAdded

    @AutoscalingAdded.setter
    def AutoscalingAdded(self, AutoscalingAdded):
        self._AutoscalingAdded = AutoscalingAdded


    def _deserialize(self, params):
        if params.get("ManuallyAdded") is not None:
            self._ManuallyAdded = ManuallyAdded()
            self._ManuallyAdded._deserialize(params.get("ManuallyAdded"))
        if params.get("AutoscalingAdded") is not None:
            self._AutoscalingAdded = AutoscalingAdded()
            self._AutoscalingAdded._deserialize(params.get("AutoscalingAdded"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NodePool(AbstractModel):
    r"""节点池描述

    """

    def __init__(self):
        r"""
        :param _NodePoolId: NodePoolId 资源池id
        :type NodePoolId: str
        :param _Name: Name 资源池名称
        :type Name: str
        :param _ClusterInstanceId: ClusterInstanceId 集群实例id
        :type ClusterInstanceId: str
        :param _LifeState: LifeState 状态，当前节点池生命周期状态包括：creating，normal，updating，deleting，deleted
        :type LifeState: str
        :param _LaunchConfigurationId: LaunchConfigurationId 配置
        :type LaunchConfigurationId: str
        :param _AutoscalingGroupId: AutoscalingGroupId 分组id
        :type AutoscalingGroupId: str
        :param _Labels: Labels 标签
        :type Labels: list of Label
        :param _Taints: Taints 污点标记
        :type Taints: list of Taint
        :param _Annotations: 节点 Annotation 列表
        :type Annotations: list of AnnotationValue
        :param _NodeCountSummary: NodeCountSummary 节点列表
        :type NodeCountSummary: :class:`tencentcloud.tke.v20180525.models.NodeCountSummary`
        :param _AutoscalingGroupStatus: 状态信息
        :type AutoscalingGroupStatus: str
        :param _MaxNodesNum: 最大节点数量
        :type MaxNodesNum: int
        :param _MinNodesNum: 最小节点数量
        :type MinNodesNum: int
        :param _DesiredNodesNum: 期望的节点数量
        :type DesiredNodesNum: int
        :param _RuntimeConfig: 运行时描述
注意：此字段可能返回 null，表示取不到有效值。
        :type RuntimeConfig: :class:`tencentcloud.tke.v20180525.models.RuntimeConfig`
        :param _NodePoolOs: 节点池osName
        :type NodePoolOs: str
        :param _OsCustomizeType: 容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :type OsCustomizeType: str
        :param _ImageId: 镜像id
        :type ImageId: str
        :param _DesiredPodNum: 集群属于节点podCIDR大小自定义模式时，节点池需要带上pod数量属性
        :type DesiredPodNum: int
        :param _UserScript: 用户自定义脚本
        :type UserScript: str
        :param _Tags: 资源标签
注意：此字段可能返回 null，表示取不到有效值。
        :type Tags: list of Tag
        :param _DeletionProtection: 删除保护开关
        :type DeletionProtection: bool
        :param _ExtraArgs: 节点配置
注意：此字段可能返回 null，表示取不到有效值。
        :type ExtraArgs: :class:`tencentcloud.tke.v20180525.models.InstanceExtraArgs`
        :param _GPUArgs: GPU驱动相关参数
注意：此字段可能返回 null，表示取不到有效值。
        :type GPUArgs: :class:`tencentcloud.tke.v20180525.models.GPUArgs`
        :param _DockerGraphPath: dockerd --graph 指定值, 默认为 /var/lib/docker
        :type DockerGraphPath: str
        :param _DataDisks: 多盘数据盘挂载信息：新建节点时请确保购买CVM的参数传递了购买多个数据盘的信息，如CreateClusterInstances API的RunInstancesPara下的DataDisks也需要设置购买多个数据盘, 具体可以参考CreateClusterInstances接口的添加集群节点(多块数据盘)样例；添加已有节点时，请确保填写的分区信息在节点上真实存在
注意：此字段可能返回 null，表示取不到有效值。
        :type DataDisks: list of DataDisk
        :param _Unschedulable: 是否不可调度
        :type Unschedulable: int
        :param _PreStartUserScript: 用户自定义脚本,在UserScript前执行
        :type PreStartUserScript: str
        """
        self._NodePoolId = None
        self._Name = None
        self._ClusterInstanceId = None
        self._LifeState = None
        self._LaunchConfigurationId = None
        self._AutoscalingGroupId = None
        self._Labels = None
        self._Taints = None
        self._Annotations = None
        self._NodeCountSummary = None
        self._AutoscalingGroupStatus = None
        self._MaxNodesNum = None
        self._MinNodesNum = None
        self._DesiredNodesNum = None
        self._RuntimeConfig = None
        self._NodePoolOs = None
        self._OsCustomizeType = None
        self._ImageId = None
        self._DesiredPodNum = None
        self._UserScript = None
        self._Tags = None
        self._DeletionProtection = None
        self._ExtraArgs = None
        self._GPUArgs = None
        self._DockerGraphPath = None
        self._DataDisks = None
        self._Unschedulable = None
        self._PreStartUserScript = None

    @property
    def NodePoolId(self):
        r"""NodePoolId 资源池id
        :rtype: str
        """
        return self._NodePoolId

    @NodePoolId.setter
    def NodePoolId(self, NodePoolId):
        self._NodePoolId = NodePoolId

    @property
    def Name(self):
        r"""Name 资源池名称
        :rtype: str
        """
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ClusterInstanceId(self):
        r"""ClusterInstanceId 集群实例id
        :rtype: str
        """
        return self._ClusterInstanceId

    @ClusterInstanceId.setter
    def ClusterInstanceId(self, ClusterInstanceId):
        self._ClusterInstanceId = ClusterInstanceId

    @property
    def LifeState(self):
        r"""LifeState 状态，当前节点池生命周期状态包括：creating，normal，updating，deleting，deleted
        :rtype: str
        """
        return self._LifeState

    @LifeState.setter
    def LifeState(self, LifeState):
        self._LifeState = LifeState

    @property
    def LaunchConfigurationId(self):
        r"""LaunchConfigurationId 配置
        :rtype: str
        """
        return self._LaunchConfigurationId

    @LaunchConfigurationId.setter
    def LaunchConfigurationId(self, LaunchConfigurationId):
        self._LaunchConfigurationId = LaunchConfigurationId

    @property
    def AutoscalingGroupId(self):
        r"""AutoscalingGroupId 分组id
        :rtype: str
        """
        return self._AutoscalingGroupId

    @AutoscalingGroupId.setter
    def AutoscalingGroupId(self, AutoscalingGroupId):
        self._AutoscalingGroupId = AutoscalingGroupId

    @property
    def Labels(self):
        r"""Labels 标签
        :rtype: list of Label
        """
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def Taints(self):
        r"""Taints 污点标记
        :rtype: list of Taint
        """
        return self._Taints

    @Taints.setter
    def Taints(self, Taints):
        self._Taints = Taints

    @property
    def Annotations(self):
        r"""节点 Annotation 列表
        :rtype: list of AnnotationValue
        """
        return self._Annotations

    @Annotations.setter
    def Annotations(self, Annotations):
        self._Annotations = Annotations

    @property
    def NodeCountSummary(self):
        r"""NodeCountSummary 节点列表
        :rtype: :class:`tencentcloud.tke.v20180525.models.NodeCountSummary`
        """
        return self._NodeCountSummary

    @NodeCountSummary.setter
    def NodeCountSummary(self, NodeCountSummary):
        self._NodeCountSummary = NodeCountSummary

    @property
    def AutoscalingGroupStatus(self):
        r"""状态信息
        :rtype: str
        """
        return self._AutoscalingGroupStatus

    @AutoscalingGroupStatus.setter
    def AutoscalingGroupStatus(self, AutoscalingGroupStatus):
        self._AutoscalingGroupStatus = AutoscalingGroupStatus

    @property
    def MaxNodesNum(self):
        r"""最大节点数量
        :rtype: int
        """
        return self._MaxNodesNum

    @MaxNodesNum.setter
    def MaxNodesNum(self, MaxNodesNum):
        self._MaxNodesNum = MaxNodesNum

    @property
    def MinNodesNum(self):
        r"""最小节点数量
        :rtype: int
        """
        return self._MinNodesNum

    @MinNodesNum.setter
    def MinNodesNum(self, MinNodesNum):
        self._MinNodesNum = MinNodesNum

    @property
    def DesiredNodesNum(self):
        r"""期望的节点数量
        :rtype: int
        """
        return self._DesiredNodesNum

    @DesiredNodesNum.setter
    def DesiredNodesNum(self, DesiredNodesNum):
        self._DesiredNodesNum = DesiredNodesNum

    @property
    def RuntimeConfig(self):
        r"""运行时描述
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.RuntimeConfig`
        """
        return self._RuntimeConfig

    @RuntimeConfig.setter
    def RuntimeConfig(self, RuntimeConfig):
        self._RuntimeConfig = RuntimeConfig

    @property
    def NodePoolOs(self):
        r"""节点池osName
        :rtype: str
        """
        return self._NodePoolOs

    @NodePoolOs.setter
    def NodePoolOs(self, NodePoolOs):
        self._NodePoolOs = NodePoolOs

    @property
    def OsCustomizeType(self):
        r"""容器的镜像版本，"DOCKER_CUSTOMIZE"(容器定制版),"GENERAL"(普通版本，默认值)
        :rtype: str
        """
        return self._OsCustomizeType

    @OsCustomizeType.setter
    def OsCustomizeType(self, OsCustomizeType):
        self._OsCustomizeType = OsCustomizeType

    @property
    def ImageId(self):
        r"""镜像id
        :rtype: str
        """
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def DesiredPodNum(self):
        r"""集群属于节点podCIDR大小自定义模式时，节点池需要带上pod数量属性
        :rtype: int
        """
        return self._DesiredPodNum

    @DesiredPodNum.setter
    def DesiredPodNum(self, DesiredPodNum):
        self._DesiredPodNum = DesiredPodNum

    @property
    def UserScript(self):
        r"""用户自定义脚本
        :rtype: str
        """
        return self._UserScript

    @UserScript.setter
    def UserScript(self, UserScript):
        self._UserScript = UserScript

    @property
    def Tags(self):
        r"""资源标签
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: list of Tag
        """
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def DeletionProtection(self):
        r"""删除保护开关
        :rtype: bool
        """
        return self._DeletionProtection

    @DeletionProtection.setter
    def DeletionProtection(self, DeletionProtection):
        self._DeletionProtection = DeletionProtection

    @property
    def ExtraArgs(self):
        r"""节点配置
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.InstanceExtraArgs`
        """
        return self._ExtraArgs

    @ExtraArgs.setter
    def ExtraArgs(self, ExtraArgs):
        self._ExtraArgs = ExtraArgs

    @property
    def GPUArgs(self):
        r"""GPU驱动相关参数
注意：此字段可能返回 null，表示取不到有效值。
        :rtype: :class:`tencentcloud.tke.v20180525.models.GPUArgs`
        """
        return self._GPUArgs

    @GPUArgs.setter
    def GPUArgs(self, GPUArgs):
        self._GPUArgs = GPUArgs

    @property
    def DockerGraphPath(self):
        r"""dockerd --graph 指定值, 默认为 /var/lib/docker
        :rtype: str
        """
        return self._DockerGraphPath

    @DockerGraphPath.setter
    def DockerGraphPath(self, DockerGraphPath):
        self._DockerGraphPath = DockerGraphPath

    @property
    def DataDisks(self):
        r"""多盘数据盘挂载信息：新建节点时请确保购买CVM的参数传递了购买多个数据盘的信息，如CreateClusterInstances API的RunInstancesPara下的DataDisks也需要设置购买多个数据盘, 具体可以参考CreateClusterInstances接口的添加集群节点(多块数据盘)样例；添加已有节点时，请确保填写的分区信息在节点上真实存在
注意：此字段可能返回 null，表示取不到有效值。
        :rt