# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class ANNFunction(BaseModel):
    """
    ANNFunction
    """ # noqa: E501
    limit: Optional[StrictInt] = Field(default=5, description="The amount of neighbours per function ID")
    distance: Optional[Union[StrictFloat, StrictInt]] = Field(default=0.1, description="The distance between two neighbours")
    analysis_search_ids: Optional[List[Optional[StrictInt]]] = Field(default=None, description="Perform a search on functions within a list of analyses")
    collection_search_ids: Optional[Annotated[List[Optional[StrictInt]], Field(max_length=5)]] = Field(default=None, description="Search only within these collections")
    search_binary_ids: Optional[List[StrictInt]] = None
    search_function_ids: Optional[List[StrictInt]] = None
    debug_only: Optional[StrictBool] = Field(default=False, description="Searches for only functions which are debug")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["limit", "distance", "analysis_search_ids", "collection_search_ids", "search_binary_ids", "search_function_ids", "debug_only"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ANNFunction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if search_binary_ids (nullable) is None
        # and model_fields_set contains the field
        if self.search_binary_ids is None and "search_binary_ids" in self.model_fields_set:
            _dict['search_binary_ids'] = None

        # set to None if search_function_ids (nullable) is None
        # and model_fields_set contains the field
        if self.search_function_ids is None and "search_function_ids" in self.model_fields_set:
            _dict['search_function_ids'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ANNFunction from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "limit": obj.get("limit") if obj.get("limit") is not None else 5,
            "distance": obj.get("distance") if obj.get("distance") is not None else 0.1,
            "analysis_search_ids": obj.get("analysis_search_ids"),
            "collection_search_ids": obj.get("collection_search_ids"),
            "search_binary_ids": obj.get("search_binary_ids"),
            "search_function_ids": obj.get("search_function_ids"),
            "debug_only": obj.get("debug_only") if obj.get("debug_only") is not None else False
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


