# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CollectionListItem(BaseModel):
    """
    CollectionListItem
    """ # noqa: E501
    collection_name: StrictStr = Field(description="The name of the collection")
    description: StrictStr = Field(description="The description of the collection")
    collection_scope: StrictStr = Field(description="The scope of the collection")
    collection_owner: StrictStr = Field(description="The owner of the collection")
    official_collection: StrictBool = Field(description="Whether the collection is maintained by RevEng.AI")
    collection_tags: Optional[List[StrictStr]] = Field(default=None, description="The tags of the collection")
    collection_size: StrictInt = Field(description="The size of the collection")
    collection_id: StrictInt = Field(description="The ID of the collection")
    creation: datetime = Field(description="The current status of analysis")
    model_name: StrictStr = Field(description="The model being used for the collection")
    team_id: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["collection_name", "description", "collection_scope", "collection_owner", "official_collection", "collection_tags", "collection_size", "collection_id", "creation", "model_name", "team_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollectionListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if team_id (nullable) is None
        # and model_fields_set contains the field
        if self.team_id is None and "team_id" in self.model_fields_set:
            _dict['team_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollectionListItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_name": obj.get("collection_name"),
            "description": obj.get("description"),
            "collection_scope": obj.get("collection_scope"),
            "collection_owner": obj.get("collection_owner"),
            "official_collection": obj.get("official_collection"),
            "collection_tags": obj.get("collection_tags"),
            "collection_size": obj.get("collection_size"),
            "collection_id": obj.get("collection_id"),
            "creation": obj.get("creation"),
            "model_name": obj.get("model_name"),
            "team_id": obj.get("team_id")
        })
        return _obj


