# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class FunctionSearchResult(BaseModel):
    """
    FunctionSearchResult
    """ # noqa: E501
    function_id: StrictInt = Field(description="The function ID")
    function_name: StrictStr = Field(description="The name of the function")
    binary_name: StrictStr = Field(description="The name of the binary the function belongs to")
    created_at: datetime = Field(description="The creation date of the function")
    model_id: StrictInt = Field(description="The model ID used to analyze the binary the function belongs to")
    model_name: StrictStr = Field(description="The name of the model used to analyze the binary the function belongs to")
    owned_by: StrictStr = Field(description="The owner of the binary the function belongs to")
    __properties: ClassVar[List[str]] = ["function_id", "function_name", "binary_name", "created_at", "model_id", "model_name", "owned_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionSearchResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionSearchResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "function_id": obj.get("function_id"),
            "function_name": obj.get("function_name"),
            "binary_name": obj.get("binary_name"),
            "created_at": obj.get("created_at"),
            "model_id": obj.get("model_id"),
            "model_name": obj.get("model_name"),
            "owned_by": obj.get("owned_by")
        })
        return _obj


