"""adding labels to stacks [0d707865f404].

Revision ID: 0d707865f404
Revises: 0.60.0
Create Date: 2024-07-04 16:10:07.709184

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0d707865f404"
down_revision = "0.60.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    with op.batch_alter_table("stack", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("labels", sa.LargeBinary(), nullable=True)
        )


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    with op.batch_alter_table("stack", schema=None) as batch_op:
        batch_op.drop_column("labels")
