"""Add step run unique constraint [26351d482b9e].

Revision ID: 26351d482b9e
Revises: 0.71.0
Create Date: 2024-12-03 11:46:57.541578

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "26351d482b9e"
down_revision = "0.71.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.create_unique_constraint(
            "unique_step_name_for_pipeline_run", ["name", "pipeline_run_id"]
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.drop_constraint(
            "unique_step_name_for_pipeline_run", type_="unique"
        )

    # ### end Alembic commands ###
