"""Step run versioning [360fa84718bf].

Revision ID: 360fa84718bf
Revises: 85289fea86ff
Create Date: 2025-07-03 16:11:14.013214

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "360fa84718bf"
down_revision = "85289fea86ff"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.add_column(sa.Column("version", sa.Integer(), nullable=True))
        batch_op.add_column(
            sa.Column("is_retriable", sa.Boolean(), nullable=True)
        )
        batch_op.drop_constraint(
            "unique_step_name_for_pipeline_run", type_="unique"
        )
        batch_op.create_unique_constraint(
            "unique_step_name_for_pipeline_run",
            ["name", "pipeline_run_id", "version"],
        )

    op.execute(
        sa.text("UPDATE step_run SET version = 1 WHERE version IS NULL")
    )
    op.execute(
        sa.text(
            "UPDATE step_run SET is_retriable = FALSE WHERE is_retriable IS NULL"
        )
    )

    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.alter_column(
            "version", existing_type=sa.Integer(), nullable=False
        )
        batch_op.alter_column(
            "is_retriable", existing_type=sa.Boolean(), nullable=False
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision.

    Raises:
        NotImplementedError: Downgrade not supported.
    """
    # ### commands auto generated by Alembic - please adjust! ###
    raise NotImplementedError("Downgrade not supported")

    # ### end Alembic commands ###
