"""Step exception info [d4591f95ac07].

Revision ID: d4591f95ac07
Revises: 0.84.0
Create Date: 2025-07-17 14:13:54.731842

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = "d4591f95ac07"
down_revision = "0.84.0"
branch_labels = None
depends_on = None


def upgrade() -> None:
    """Upgrade database schema and/or data, creating a new revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "exception_info",
                sa.String(length=16777215).with_variant(
                    mysql.MEDIUMTEXT, "mysql"
                ),
                nullable=True,
            )
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade database schema and/or data back to the previous revision."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("step_run", schema=None) as batch_op:
        batch_op.drop_column("exception_info")

    # ### end Alembic commands ###
