# Cloud Computing Fundamentals

## Service Models

### Infrastructure as a Service (IaaS)
- Virtual machines and storage
- Networking capabilities
- Examples: AWS EC2, Google Compute Engine, Azure VMs

### Platform as a Service (PaaS)
- Development and deployment environments
- Built-in scaling and management
- Examples: Heroku, Google App Engine, Azure App Service

### Software as a Service (SaaS)
- Complete applications delivered via web
- No installation or maintenance required
- Examples: Gmail, Salesforce, Office 365

## Deployment Models

### Public Cloud
- Resources owned by third-party provider
- Shared infrastructure
- Pay-as-you-go pricing
- High scalability

### Private Cloud
- Dedicated resources for single organization
- Greater control and security
- Higher initial costs
- On-premises or hosted

### Hybrid Cloud
- Combination of public and private
- Flexibility to move workloads
- Balance between control and scalability

## Key Benefits
1. Cost efficiency - reduced hardware investment
2. Scalability - easily adjust resources
3. Reliability - built-in redundancy
4. Accessibility - access from anywhere
5. Automatic updates - always latest features

## Popular Providers
- Amazon Web Services (AWS)
- Microsoft Azure
- Google Cloud Platform (GCP)
- IBM Cloud
- Oracle Cloud