# aliro-quantum
This is an api for the Aliro Quantum App

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 2.11.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install
```sh
pip install aliro-quantum
```

Then import the package:
```python
import aliro_quantum
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

# Aliro Quantum PIP Package Getting Started
## Install the Aliro Quantum pip package 

```sh
pip install aliro-quantum
```

## Import necessary modules


```python
import aliro_quantum
from aliro_quantum.rest import ApiException
from pprint import pprint
from typing import List
```

## Set up authentication
You can retrieve your API token in your "Account" page at https://app.aliro.io/


```python
configuration = aliro_quantum.Configuration()
configuration.api_key['Authorization'] = 'API_TOKEN'
```


## Retrieve possible languages
At the time of this writing, possible languages are:
- QASM
- Quil


```python
quil_language: str
with aliro_quantum.ApiClient(configuration) as api_client:
    info_api_instance = aliro_quantum.InfoApi(api_client)
    try:
        languages_list: aliro_quantum.InfoGetResponse = info_api_instance.info_languages_get()
        quil_language = next(
            language_info.value for language_info in languages_list.data if 
            language_info.id == 'quil')
        pprint(languages_list)
    except ApiException as e:
        print("Exception when calling InfoApi->info_languages_get: %s\n" % e)
        raise e
```

    {'data': [{'id': 'qasm', 'value': 'QASM'}, {'id': 'quil', 'value': 'Quil'}]}


## Retrieve possible execution types
At the time of this writing, possible execution types are:
- real
- simulated
- both


```python
simulation_only_execution_type: str
with aliro_quantum.ApiClient(configuration) as api_client:
    info_api_instance = aliro_quantum.InfoApi(api_client)
    try:
        execution_type_info_list: aliro_quantum.InfoGetResponse = info_api_instance.info_execution_types_get()
        simulation_only_execution_type = next(
            execution_type_info.value for execution_type_info in execution_type_info_list.data if
            execution_type_info.id == '2')
        pprint(execution_type_info_list)
    except ApiException as e:
        print("Exception when calling InfoApi->auth_login_post: %s\n" % e)
        raise e
```

    {'data': [{'id': '1', 'value': 'real'},
              {'id': '2', 'value': 'simulated'},
              {'id': '3', 'value': 'both'}]}


## Get possible device targets and information


```python
devices_list: aliro_quantum.OwnerDetails
with aliro_quantum.ApiClient(configuration) as api_client:
    device_rankings_api_instance = aliro_quantum.DeviceRankingsApi(api_client)
    try:
        devices_list_response: aliro_quantum.DeviceListResponse = device_rankings_api_instance.devices_list_get()
        devices_list = devices_list_response.data
        pprint(devices_list_response)
    except ApiException as e:
        print("Exception when calling DeviceRankingsApi->devices_list_get: %s\n" % e)
        raise e
```

    {'data': {'owners': {'IBM': {'devices': {'ibmq_rome': {'device_id': 'ibmq_rome',
                                                           'display_name': 'ibmq_rome',
                                                           'gates': [{'fidelity': 0.9880405409838382,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9994152165869413,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 4,
                                                                                     'pos_x': 200.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 4},
                                                                      'qubit_to': {'fidelity_rotation': 0.9993837791241802,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 3,
                                                                                   'pos_x': 150.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 3}},
                                                                     {'fidelity': 0.9856693955271434,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9993837791241802,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 3,
                                                                                     'pos_x': 150.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 3},
                                                                      'qubit_to': {'fidelity_rotation': 0.9994152165869413,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 4,
                                                                                   'pos_x': 200.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 4}},
                                                                     {'fidelity': 0.9892630599738325,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9993837791241802,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 3,
                                                                                     'pos_x': 150.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 3},
                                                                      'qubit_to': {'fidelity_rotation': 0.9993763479004819,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 2,
                                                                                   'pos_x': 100.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 2}},
                                                                     {'fidelity': 0.9868122191056748,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9993763479004819,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 2,
                                                                                     'pos_x': 100.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 2},
                                                                      'qubit_to': {'fidelity_rotation': 0.9993837791241802,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 3,
                                                                                   'pos_x': 150.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 3}},
                                                                     {'fidelity': 0.9883232732901912,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9993763479004819,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 2,
                                                                                     'pos_x': 100.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 2},
                                                                      'qubit_to': {'fidelity_rotation': 0.9995167318229694,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 1,
                                                                                   'pos_x': 50.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 1}},
                                                                     {'fidelity': 0.9861370891980876,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9995167318229694,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 1,
                                                                                     'pos_x': 50.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 1},
                                                                      'qubit_to': {'fidelity_rotation': 0.9993763479004819,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 2,
                                                                                   'pos_x': 100.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 2}},
                                                                     {'fidelity': 0.9786906667138251,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.9995167318229694,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 1,
                                                                                     'pos_x': 50.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 1},
                                                                      'qubit_to': {'fidelity_rotation': 0.999416000095865,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 0,
                                                                                   'pos_x': 0.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 0}},
                                                                     {'fidelity': 0.9766032827219325,
                                                                      'gate_type': 'CX',
                                                                      'qubit_from': {'fidelity_rotation': 0.999416000095865,
                                                                                     'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                     'name': 0,
                                                                                     'pos_x': 0.0,
                                                                                     'pos_y': 0.0,
                                                                                     'real_qubit': 0},
                                                                      'qubit_to': {'fidelity_rotation': 0.9995167318229694,
                                                                                   'last_reported_fidelity_rotation_datetime': '2020-06-18T09:25:03+00:00',
                                                                                   'name': 1,
                                                                                   'pos_x': 50.0,
                                                                                   'pos_y': 0.0,
                                                                                   'real_qubit': 1}}],
                                                           'is_simulator': False,
                                                           'last_calibration': '2020-06-18T09:25:03+00:00',
                                                           'max_shots': 8192,
                                                           'next_available_time': None,
                                                           'price': None,
                                                           't1': 70.59164221606711,
                                                           't2': 92.8079648560683}}}}}}


## Choose desired target (owner + device ID) from devices_list


```python
example_owner = list(devices_list.owners.keys())[0]
exmaple_device_id = list(devices_list.owners[example_owner].devices.keys())[0]
example_target = aliro_quantum.OwnerDetails(
    owners={
        example_owner: aliro_quantum.OwnerDetailsOwners(
            devices={
                exmaple_device_id: aliro_quantum.DeviceDetails()
            }
        )
    }
)

pprint(f'Owner: {example_owner}')
pprint(f'Device ID: {exmaple_device_id}')
```

    'Owner: IBM'
    'Device ID: ibmq_rome'


## Create submission info


```python
submission_name = 'test_submission'
submission_post_parameters = aliro_quantum.Submission(
    circuits=[
        aliro_quantum.Circuit(
            body='DECLARE ro BIT[1]\nH 0\nMEASURE 0 ro[0]\n',
            jobs=[
                aliro_quantum.Job(
                    allocations=aliro_quantum.JobAllocations(
                        input_parameters=aliro_quantum.CompilationParameters(
                            num_allocations=4
                        )
                    ),
                    execution=aliro_quantum.JobExecution(
                        parameters=aliro_quantum.ExecutionParameters(
                            num_shots=200,
                            output_type=simulation_only_execution_type
                        )
                    ),
                    target=example_target
                )
            ],
            language=quil_language
        )
    ],
    name=submission_name
)
```

## Submit the new submission


```python
with aliro_quantum.ApiClient(configuration) as api_client:
    submissions_api_instance = aliro_quantum.SubmissionsApi(api_client)
    try:
        submission_api_response = submissions_api_instance.submissions_post(submission_post_parameters=submission_post_parameters)
        pprint(submission_api_response)
    except ApiException as e:
        print("Exception when calling SubmissionsApi->submissions_post: %s\n" % e)
```

    {'success': True}


## Wait for completion
This will likely take a few minutes or more.


```python
submission_details: aliro_quantum.Submission
with aliro_quantum.ApiClient(configuration) as api_client:
    submissions_api_instance = aliro_quantum.SubmissionsApi(api_client)
    try:
        for submission_get_response in submissions_api_instance.submissions_submission_name_stream_get(
            submission_name=submission_name,
            completion_only='true'
        ):
            submission_details = submission_get_response.submission_detail
            break
    except ApiException as e:
        print("Exception when calling SubmissionsApi->submissions_submission_name_stream_get: %s\n" % e)
```

## Print results
Shot-for-shot results will be a list of measurements for each allocation of the circuit.


```python
first_circuit: aliro_quantum.Circuit = submission_details.circuits[0]
first_job: aliro_quantum.Job = first_circuit.jobs[0]
errors: List[aliro_quantum.JobErrors] = first_job.errors
if len(errors):
    pprint(errors)
else:
    execution: aliro_quantum.JobExecution = first_job.execution
    results: aliro_quantum.ExecutionResults = execution.results
    results_simulated: aliro_quantum.ResultsData = results.simulated
    results_simulated_measurements: aliro_quantum.ResultsDataMeasurements = results_simulated.measurements

    pprint(results_simulated_measurements.raw)
```

    [[[1],
      [1],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [0],
      [1],
      [1],
      [0],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [0],
      [1],
      [1],
      [0],
      [0],
      [1],
      [1],
      [1],
      [0],
      [0],
      [0],
      [1],
      [0],
      [0],
      [0],
      [1],
      [0],
      [0],
      [0],
      [1],
      [0],
      [0],
      [0],
      [1],
      [1]],
     [[0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [1],
      [0],
      [1],
      [0],
      [1],
      [1],
      [0],
      [1],
      [0],
      [1],
      [0],
      [0],
      [0],
      [1],
      [0],
      [1],
      [0],
      [0],
      [1],
      [1],
      [0],
      [1],
      [0],
      [1],
      [0],
      [0],
      [0],
      [1],
      [1],
      [1],
      [0],
      [1],
      [1],
      [0],
      [1],
      [0],
      [1],
      [1],
      [0],
      [1],
      [1],
      [1]],
     [[1],
      [0],
      [1],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [1],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [0],
      [1],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [1],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [1],
      [1],
      [1],
      [1],
      [0],
      [0],
      [1]],
     [[0],
      [0],
      [1],
      [0],
      [1],
      [0],
      [1],
      [0],
      [1],
      [1],
      [0],
      [1],
      [1],
      [0],
      [0],
      [0],
      [1],
      [1],
      [1],
      [1],
      [1],
      [0],
      [1],
      [0],
      [1],
      [1],
      [0],
      [0],
      [0],
      [1],
      [1],
      [1],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [1],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [0],
      [1]]]



## Documentation for API Endpoints

All URIs are relative to *https://app.aliro.io*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthenticationApi* | [**auth_login_post**](docs/AuthenticationApi.md#auth_login_post) | **POST** /auth/login | login using username and password
*CircuitApi* | [**circuit_qaoa_post**](docs/CircuitApi.md#circuit_qaoa_post) | **POST** /circuit/qaoa | compiles a quantum circuit for use in QAOA
*CircuitApi* | [**circuit_translation_post**](docs/CircuitApi.md#circuit_translation_post) | **POST** /circuit/translation | translates circuits into other quantum languages
*CircuitApi* | [**circuit_visualization_get**](docs/CircuitApi.md#circuit_visualization_get) | **GET** /circuit/visualization | 
*CircuitApi* | [**circuit_visualization_post**](docs/CircuitApi.md#circuit_visualization_post) | **POST** /circuit/visualization | converts a Quil circuit into a PNG image
*CredentialsApi* | [**credentials_vendor_delete**](docs/CredentialsApi.md#credentials_vendor_delete) | **DELETE** /credentials/{vendor} | delete vendor credentials for a user
*CredentialsApi* | [**credentials_vendor_put**](docs/CredentialsApi.md#credentials_vendor_put) | **PUT** /credentials/{vendor} | add vendor credentials for a user
*DeviceRankingsApi* | [**devices_list_get**](docs/DeviceRankingsApi.md#devices_list_get) | **GET** /devicesList | retrieves list of potential devices to run the circuit on
*DeviceRankingsApi* | [**devices_list_stream_get**](docs/DeviceRankingsApi.md#devices_list_stream_get) | **GET** /devicesList/stream | streams device detail updates
*DeviceRankingsApi* | [**devices_next_available_get**](docs/DeviceRankingsApi.md#devices_next_available_get) | **GET** /devices/nextAvailable | retrieves list of next avaiable times for devices
*DeviceRankingsApi* | [**rankings_list_post**](docs/DeviceRankingsApi.md#rankings_list_post) | **POST** /rankingsList | retrieves predicted device rankings
*InfoApi* | [**info_execution_types_get**](docs/InfoApi.md#info_execution_types_get) | **GET** /info/executionTypes | get list of possible execution types for jobs
*InfoApi* | [**info_languages_get**](docs/InfoApi.md#info_languages_get) | **GET** /info/languages | get list of languages in database
*JobsApi* | [**jobs_cancel_job_id_post**](docs/JobsApi.md#jobs_cancel_job_id_post) | **POST** /jobs/cancel/{jobId} | cancel job
*SubmissionsApi* | [**submissions_delete**](docs/SubmissionsApi.md#submissions_delete) | **DELETE** /submissions | delete submissions
*SubmissionsApi* | [**submissions_get**](docs/SubmissionsApi.md#submissions_get) | **GET** /submissions | get all user&#39;s submissions
*SubmissionsApi* | [**submissions_post**](docs/SubmissionsApi.md#submissions_post) | **POST** /submissions | submit a new submission
*SubmissionsApi* | [**submissions_submission_name_get**](docs/SubmissionsApi.md#submissions_submission_name_get) | **GET** /submissions/{submissionName} | get submissions
*SubmissionsApi* | [**submissions_submission_name_stream_get**](docs/SubmissionsApi.md#submissions_submission_name_stream_get) | **GET** /submissions/{submissionName}/stream | stream submission updates
*UserApi* | [**user_information_update_post**](docs/UserApi.md#user_information_update_post) | **POST** /user/informationUpdate | update user email and name
*UserApi* | [**user_password_change_post**](docs/UserApi.md#user_password_change_post) | **POST** /user/passwordChange | change user password from known password


## Documentation For Models

 - [Allocation](docs/Allocation.md)
 - [BasicSuccess](docs/BasicSuccess.md)
 - [ChangePasswordParams](docs/ChangePasswordParams.md)
 - [Circuit](docs/Circuit.md)
 - [CircuitInput](docs/CircuitInput.md)
 - [CompilationParameters](docs/CompilationParameters.md)
 - [CompiledCircuit](docs/CompiledCircuit.md)
 - [CompiledCircuitResponse](docs/CompiledCircuitResponse.md)
 - [ControlFlowGraphCircuit](docs/ControlFlowGraphCircuit.md)
 - [CredentialsAddParameters](docs/CredentialsAddParameters.md)
 - [CredentialsAqt](docs/CredentialsAqt.md)
 - [CredentialsBasic](docs/CredentialsBasic.md)
 - [CredentialsDeleteParameters](docs/CredentialsDeleteParameters.md)
 - [CredentialsHoneywell](docs/CredentialsHoneywell.md)
 - [CredentialsIbm](docs/CredentialsIbm.md)
 - [CredentialsIbmProvider](docs/CredentialsIbmProvider.md)
 - [CredentialsRigetti](docs/CredentialsRigetti.md)
 - [CredentialsVendor](docs/CredentialsVendor.md)
 - [DeleteSubmissionParameters](docs/DeleteSubmissionParameters.md)
 - [DeviceDetails](docs/DeviceDetails.md)
 - [DeviceListResponse](docs/DeviceListResponse.md)
 - [DeviceRanking](docs/DeviceRanking.md)
 - [DeviceRankingResponse](docs/DeviceRankingResponse.md)
 - [DeviceRankingsParameters](docs/DeviceRankingsParameters.md)
 - [ExecutionParameters](docs/ExecutionParameters.md)
 - [ExecutionResults](docs/ExecutionResults.md)
 - [Gate](docs/Gate.md)
 - [InfoGetResponse](docs/InfoGetResponse.md)
 - [InfoGetResponseData](docs/InfoGetResponseData.md)
 - [Job](docs/Job.md)
 - [JobAllocations](docs/JobAllocations.md)
 - [JobCosts](docs/JobCosts.md)
 - [JobErrors](docs/JobErrors.md)
 - [JobExecution](docs/JobExecution.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [OwnerDetails](docs/OwnerDetails.md)
 - [OwnerDetailsOwners](docs/OwnerDetailsOwners.md)
 - [PidResponse](docs/PidResponse.md)
 - [Qubit](docs/Qubit.md)
 - [Reservation](docs/Reservation.md)
 - [ResultsData](docs/ResultsData.md)
 - [ResultsDataMeasurements](docs/ResultsDataMeasurements.md)
 - [Submission](docs/Submission.md)
 - [SubmissionDetailResponse](docs/SubmissionDetailResponse.md)
 - [SubmissionSummary](docs/SubmissionSummary.md)
 - [SubmissionSummaryJobs](docs/SubmissionSummaryJobs.md)
 - [SubmissionSummaryResponse](docs/SubmissionSummaryResponse.md)
 - [TranslationParameters](docs/TranslationParameters.md)
 - [TranslationResponse](docs/TranslationResponse.md)
 - [UpdateUserInformationParams](docs/UpdateUserInformationParams.md)
 - [UserInfo](docs/UserInfo.md)
 - [VisualizationResponse](docs/VisualizationResponse.md)


## Documentation For Authorization
Aliro users can retrieve their API key in their account page at https://app.aliro.io/


## JwtKeyAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

nick@aliroquantum.com


