from ..exception.service_exception import ServiceErrorException as ServiceErrorException
from ..portal_auth.entity_table.auth_user import AuthUser as AuthUser
from ..services.auth_service import AuthService as AuthService
from ..services.db_engine_service import DBEngineService as DBEngineService
from .auth_data_rule import AuthDataRule as AuthDataRule
from _typeshed import Incomplete
from fastapi import APIRouter, Request as Request
from sqlmodel.ext.asyncio.session import AsyncSession

class AuthRouter(APIRouter):
    permission_rules: Incomplete
    default_role: Incomplete
    auth_role: Incomplete
    auth_obj: Incomplete
    auth_act: Incomplete
    db_config: Incomplete
    data_rules: list[AuthDataRule]
    def __init__(self, default_role: str | None = None, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, db_config_name: str | None = None, *args, **kwargs) -> None: ...
    async def get_async_session(self) -> AsyncSession: ...
    def api_route(self, path: str, *, auth: bool = True, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, **kwargs): ...
    def add_auth_data_rule(self, path: str, **kwargs): ...
    def get(self, path: str, *, auth: bool = True, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, **kwargs): ...
    def post(self, path: str, *, auth: bool = True, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, **kwargs): ...
    def put(self, path: str, *, auth: bool = True, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, **kwargs): ...
    def patch(self, path: str, *, auth: bool = True, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, **kwargs): ...
    def delete(self, path: str, *, auth: bool = True, auth_role: str | None = None, auth_obj: str | None = None, auth_act: str | None = None, **kwargs): ...

def get_data_rule_from_request(*, request: Request, data_rules: list[AuthDataRule]) -> AuthDataRule | None: ...
