from ..exception.service_exception import DataNotFoundException as DataNotFoundException
from ..schemas.element import Paging as Paging
from ..schemas.query_request import QueryRequest as QueryRequest
from ..tools.query_builder import QueryBuilder as QueryBuilder
from ..type.var import SQLModelCreate as SQLModelCreate, SQLModelDB as SQLModelDB, SQLModelResponse as SQLModelResponse, SQLModelUpdate as SQLModelUpdate
from sqlmodel.ext.asyncio.session import AsyncSession as AsyncSession
from typing import Any

class DataService:
    @classmethod
    def db_insert(cls, db: AsyncSession, *, db_model_class: type[SQLModelDB], create_model: SQLModelCreate | dict[str, Any]) -> SQLModelDB: ...
    @classmethod
    async def create(cls, db: AsyncSession, *, db_model_class: type[SQLModelDB], create_model: SQLModelCreate | dict[str, Any], response_class: type[SQLModelResponse] = None, auto_commit: bool = True) -> SQLModelDB | SQLModelResponse: ...
    @classmethod
    async def db_get(cls, db: AsyncSession, primary_id: int, *, db_model_class: type[SQLModelDB]) -> SQLModelDB | None: ...
    @classmethod
    async def read(cls, db: AsyncSession, primary_id: int, *, model_class: type[SQLModelDB], response_class: type[SQLModelResponse] = None) -> SQLModelDB | SQLModelResponse: ...
    @classmethod
    async def db_update(cls, db: AsyncSession, primary_id: int, *, model_class: type[SQLModelDB], update_model: SQLModelUpdate | dict[str, Any]) -> SQLModelDB | None: ...
    @classmethod
    async def update(cls, db: AsyncSession, primary_id: int, *, model_class: type[SQLModelDB], update_model: SQLModelUpdate | dict[str, Any], response_class: type[SQLModelResponse] = None, auto_commit: bool = True) -> SQLModelDB | SQLModelResponse: ...
    @classmethod
    async def db_delete(cls, db: AsyncSession, primary_id: int, *, db_model_class: type[SQLModelDB]) -> bool: ...
    @classmethod
    async def delete(cls, db: AsyncSession, primary_id: int, *, model_class: type[SQLModelDB], auto_commit: bool = True) -> bool: ...
    @classmethod
    async def query_field(cls, db: AsyncSession, condition: list[str, str, str], *, model_class: type[SQLModelDB], response_class: type[SQLModelResponse]): ...
    @classmethod
    async def query(cls, db: AsyncSession, query: QueryRequest, *, model_class: type[SQLModelDB], response_class: type[SQLModelResponse]): ...
    @classmethod
    async def query_first(cls, db: AsyncSession, query: QueryRequest, *, model_class: type[SQLModelDB]): ...
    @classmethod
    def get_primary_key_name(cls, model_class: type[SQLModelDB]) -> str | list[str] | None: ...
