# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### AmplifyApp <a name="AmplifyApp" id="must-cdk.AmplifyApp"></a>

#### Initializers <a name="Initializers" id="must-cdk.AmplifyApp.Initializer"></a>

```python
import must_cdk

must_cdk.AmplifyApp(
  scope: Construct,
  id: str,
  app_name: str,
  repository: str,
  access_token: str = None,
  basic_auth: BasicAuthConfig = None,
  branches: typing.List[BranchOptions] = None,
  build_settings: BuildSettings = None,
  build_spec: str = None,
  custom_domain: CustomDomainOptions = None,
  custom_rules: typing.List[CustomRule] = None,
  environment_variables: typing.Mapping[str] = None,
  platform: str = None,
  tags: typing.Mapping[str] = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.appName">app_name</a></code> | <code>str</code> | The name for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The Git repository URL for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.accessToken">access_token</a></code> | <code>str</code> | GitHub personal access token for repository access. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.basicAuth">basic_auth</a></code> | <code><a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a></code> | Basic authentication configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.branches">branches</a></code> | <code>typing.List[BranchOptions](#must-cdk.BranchOptions)</code> | Branch configurations for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.buildSettings">build_settings</a></code> | <code><a href="#must-cdk.BuildSettings">BuildSettings</a></code> | Build settings for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.buildSpec">build_spec</a></code> | <code>str</code> | Build specification for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.customDomain">custom_domain</a></code> | <code><a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a></code> | Custom domain configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.customRules">custom_rules</a></code> | <code>typing.List[CustomRule](#must-cdk.CustomRule)</code> | Custom rules for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.environmentVariables">environment_variables</a></code> | <code>typing.Mapping[str]</code> | Environment variables for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.platform">platform</a></code> | <code>str</code> | Platform for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Tags to apply to the Amplify app resources. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.AmplifyApp.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.AmplifyApp.Initializer.parameter.id"></a>

- *Type:* str

---

##### `app_name`<sup>Required</sup> <a name="app_name" id="must-cdk.AmplifyApp.Initializer.parameter.appName"></a>

- *Type:* str

The name for the Amplify app.

---

##### `repository`<sup>Required</sup> <a name="repository" id="must-cdk.AmplifyApp.Initializer.parameter.repository"></a>

- *Type:* str

The Git repository URL for the Amplify app.

Format: https://github.com/user/repo or similar.

---

##### `access_token`<sup>Optional</sup> <a name="access_token" id="must-cdk.AmplifyApp.Initializer.parameter.accessToken"></a>

- *Type:* str

GitHub personal access token for repository access.

If not provided, will attempt to use GitHub CLI token or MUFIN_PUSH_TOKEN environment variable.

Note: For production deployments, consider migrating to GitHub Apps for better security,
organization support, and higher rate limits after initial setup.

---

##### `basic_auth`<sup>Optional</sup> <a name="basic_auth" id="must-cdk.AmplifyApp.Initializer.parameter.basicAuth"></a>

- *Type:* <a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a>

Basic authentication configuration for the Amplify app.

---

##### `branches`<sup>Optional</sup> <a name="branches" id="must-cdk.AmplifyApp.Initializer.parameter.branches"></a>

- *Type:* typing.List[BranchOptions](#must-cdk.BranchOptions)

Branch configurations for the Amplify app.

If not provided, a default 'main' branch will be created.

---

##### `build_settings`<sup>Optional</sup> <a name="build_settings" id="must-cdk.AmplifyApp.Initializer.parameter.buildSettings"></a>

- *Type:* <a href="#must-cdk.BuildSettings">BuildSettings</a>

Build settings for the Amplify app.

---

##### `build_spec`<sup>Optional</sup> <a name="build_spec" id="must-cdk.AmplifyApp.Initializer.parameter.buildSpec"></a>

- *Type:* str

Build specification for the Amplify app.

Defines the build commands and output artifacts.

---

##### `custom_domain`<sup>Optional</sup> <a name="custom_domain" id="must-cdk.AmplifyApp.Initializer.parameter.customDomain"></a>

- *Type:* <a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a>

Custom domain configuration for the Amplify app.

---

##### `custom_rules`<sup>Optional</sup> <a name="custom_rules" id="must-cdk.AmplifyApp.Initializer.parameter.customRules"></a>

- *Type:* typing.List[CustomRule](#must-cdk.CustomRule)

Custom rules for the Amplify app.

Used for redirects, rewrites, and other routing rules.

---

##### `environment_variables`<sup>Optional</sup> <a name="environment_variables" id="must-cdk.AmplifyApp.Initializer.parameter.environmentVariables"></a>

- *Type:* typing.Mapping[str]

Environment variables for the Amplify app.

These will be available during the build process.

---

##### `platform`<sup>Optional</sup> <a name="platform" id="must-cdk.AmplifyApp.Initializer.parameter.platform"></a>

- *Type:* str
- *Default:* "WEB"

Platform for the Amplify app.

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.AmplifyApp.Initializer.parameter.tags"></a>

- *Type:* typing.Mapping[str]

Tags to apply to the Amplify app resources.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.AmplifyApp.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="must-cdk.AmplifyApp.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.AmplifyApp.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.AmplifyApp.isConstruct"></a>

```python
import must_cdk

must_cdk.AmplifyApp.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.AmplifyApp.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.AmplifyApp.property.app">app</a></code> | <code>aws_cdk.aws_amplify.CfnApp</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.property.branches">branches</a></code> | <code>typing.List[aws_cdk.aws_amplify.CfnBranch]</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.property.domain">domain</a></code> | <code>aws_cdk.aws_amplify.CfnDomain</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.AmplifyApp.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `app`<sup>Required</sup> <a name="app" id="must-cdk.AmplifyApp.property.app"></a>

```python
app: CfnApp
```

- *Type:* aws_cdk.aws_amplify.CfnApp

---

##### `branches`<sup>Required</sup> <a name="branches" id="must-cdk.AmplifyApp.property.branches"></a>

```python
branches: typing.List[CfnBranch]
```

- *Type:* typing.List[aws_cdk.aws_amplify.CfnBranch]

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.AmplifyApp.property.domain"></a>

```python
domain: CfnDomain
```

- *Type:* aws_cdk.aws_amplify.CfnDomain

---


### AmplifyAppProps <a name="AmplifyAppProps" id="must-cdk.AmplifyAppProps"></a>

Properties for creating an AWS Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.AmplifyAppProps.Initializer"></a>

```python
import must_cdk

must_cdk.AmplifyAppProps(
  app_name: str,
  repository: str,
  access_token: str = None,
  basic_auth: BasicAuthConfig = None,
  branches: typing.List[BranchOptions] = None,
  build_settings: BuildSettings = None,
  build_spec: str = None,
  custom_domain: CustomDomainOptions = None,
  custom_rules: typing.List[CustomRule] = None,
  environment_variables: typing.Mapping[str] = None,
  platform: str = None,
  tags: typing.Mapping[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyAppProps.property.appName">app_name</a></code> | <code>str</code> | The name for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.repository">repository</a></code> | <code>str</code> | The Git repository URL for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.accessToken">access_token</a></code> | <code>str</code> | GitHub personal access token for repository access. |
| <code><a href="#must-cdk.AmplifyAppProps.property.basicAuth">basic_auth</a></code> | <code><a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a></code> | Basic authentication configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.branches">branches</a></code> | <code>typing.List[BranchOptions](#must-cdk.BranchOptions)</code> | Branch configurations for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.buildSettings">build_settings</a></code> | <code><a href="#must-cdk.BuildSettings">BuildSettings</a></code> | Build settings for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.buildSpec">build_spec</a></code> | <code>str</code> | Build specification for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.customDomain">custom_domain</a></code> | <code><a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a></code> | Custom domain configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.customRules">custom_rules</a></code> | <code>typing.List[CustomRule](#must-cdk.CustomRule)</code> | Custom rules for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.environmentVariables">environment_variables</a></code> | <code>typing.Mapping[str]</code> | Environment variables for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.platform">platform</a></code> | <code>str</code> | Platform for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Tags to apply to the Amplify app resources. |

---

##### `app_name`<sup>Required</sup> <a name="app_name" id="must-cdk.AmplifyAppProps.property.appName"></a>

```python
app_name: str
```

- *Type:* str

The name for the Amplify app.

---

##### `repository`<sup>Required</sup> <a name="repository" id="must-cdk.AmplifyAppProps.property.repository"></a>

```python
repository: str
```

- *Type:* str

The Git repository URL for the Amplify app.

Format: https://github.com/user/repo or similar.

---

##### `access_token`<sup>Optional</sup> <a name="access_token" id="must-cdk.AmplifyAppProps.property.accessToken"></a>

```python
access_token: str
```

- *Type:* str

GitHub personal access token for repository access.

If not provided, will attempt to use GitHub CLI token or MUFIN_PUSH_TOKEN environment variable.

Note: For production deployments, consider migrating to GitHub Apps for better security,
organization support, and higher rate limits after initial setup.

---

##### `basic_auth`<sup>Optional</sup> <a name="basic_auth" id="must-cdk.AmplifyAppProps.property.basicAuth"></a>

```python
basic_auth: BasicAuthConfig
```

- *Type:* <a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a>

Basic authentication configuration for the Amplify app.

---

##### `branches`<sup>Optional</sup> <a name="branches" id="must-cdk.AmplifyAppProps.property.branches"></a>

```python
branches: typing.List[BranchOptions]
```

- *Type:* typing.List[BranchOptions](#must-cdk.BranchOptions)

Branch configurations for the Amplify app.

If not provided, a default 'main' branch will be created.

---

##### `build_settings`<sup>Optional</sup> <a name="build_settings" id="must-cdk.AmplifyAppProps.property.buildSettings"></a>

```python
build_settings: BuildSettings
```

- *Type:* <a href="#must-cdk.BuildSettings">BuildSettings</a>

Build settings for the Amplify app.

---

##### `build_spec`<sup>Optional</sup> <a name="build_spec" id="must-cdk.AmplifyAppProps.property.buildSpec"></a>

```python
build_spec: str
```

- *Type:* str

Build specification for the Amplify app.

Defines the build commands and output artifacts.

---

##### `custom_domain`<sup>Optional</sup> <a name="custom_domain" id="must-cdk.AmplifyAppProps.property.customDomain"></a>

```python
custom_domain: CustomDomainOptions
```

- *Type:* <a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a>

Custom domain configuration for the Amplify app.

---

##### `custom_rules`<sup>Optional</sup> <a name="custom_rules" id="must-cdk.AmplifyAppProps.property.customRules"></a>

```python
custom_rules: typing.List[CustomRule]
```

- *Type:* typing.List[CustomRule](#must-cdk.CustomRule)

Custom rules for the Amplify app.

Used for redirects, rewrites, and other routing rules.

---

##### `environment_variables`<sup>Optional</sup> <a name="environment_variables" id="must-cdk.AmplifyAppProps.property.environmentVariables"></a>

```python
environment_variables: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Environment variables for the Amplify app.

These will be available during the build process.

---

##### `platform`<sup>Optional</sup> <a name="platform" id="must-cdk.AmplifyAppProps.property.platform"></a>

```python
platform: str
```

- *Type:* str
- *Default:* "WEB"

Platform for the Amplify app.

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.AmplifyAppProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Tags to apply to the Amplify app resources.

---

### BasicAuthConfig <a name="BasicAuthConfig" id="must-cdk.BasicAuthConfig"></a>

Basic authentication configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BasicAuthConfig.Initializer"></a>

```python
import must_cdk

must_cdk.BasicAuthConfig(
  password: str,
  username: str,
  enable_basic_auth: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BasicAuthConfig.property.password">password</a></code> | <code>str</code> | Password for basic authentication. |
| <code><a href="#must-cdk.BasicAuthConfig.property.username">username</a></code> | <code>str</code> | Username for basic authentication. |
| <code><a href="#must-cdk.BasicAuthConfig.property.enableBasicAuth">enable_basic_auth</a></code> | <code>bool</code> | Whether to enable basic authentication. |

---

##### `password`<sup>Required</sup> <a name="password" id="must-cdk.BasicAuthConfig.property.password"></a>

```python
password: str
```

- *Type:* str

Password for basic authentication.

---

##### `username`<sup>Required</sup> <a name="username" id="must-cdk.BasicAuthConfig.property.username"></a>

```python
username: str
```

- *Type:* str

Username for basic authentication.

---

##### `enable_basic_auth`<sup>Optional</sup> <a name="enable_basic_auth" id="must-cdk.BasicAuthConfig.property.enableBasicAuth"></a>

```python
enable_basic_auth: bool
```

- *Type:* bool
- *Default:* true

Whether to enable basic authentication.

---

### BranchOptions <a name="BranchOptions" id="must-cdk.BranchOptions"></a>

Branch configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BranchOptions.Initializer"></a>

```python
import must_cdk

must_cdk.BranchOptions(
  branch_name: str,
  build_spec: str = None,
  enable_auto_build: bool = None,
  environment_variables: typing.Mapping[str] = None,
  framework: str = None,
  pull_request_preview: bool = None,
  stage: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BranchOptions.property.branchName">branch_name</a></code> | <code>str</code> | The name of the branch. |
| <code><a href="#must-cdk.BranchOptions.property.buildSpec">build_spec</a></code> | <code>str</code> | Branch-specific build specification. |
| <code><a href="#must-cdk.BranchOptions.property.enableAutoBuild">enable_auto_build</a></code> | <code>bool</code> | Whether to enable automatic builds for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.environmentVariables">environment_variables</a></code> | <code>typing.Mapping[str]</code> | Environment variables specific to this branch. |
| <code><a href="#must-cdk.BranchOptions.property.framework">framework</a></code> | <code>str</code> | The framework for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.pullRequestPreview">pull_request_preview</a></code> | <code>bool</code> | Whether to enable pull request previews for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.stage">stage</a></code> | <code>str</code> | The stage for the branch (e.g., PRODUCTION, BETA, DEVELOPMENT). |

---

##### `branch_name`<sup>Required</sup> <a name="branch_name" id="must-cdk.BranchOptions.property.branchName"></a>

```python
branch_name: str
```

- *Type:* str

The name of the branch.

---

##### `build_spec`<sup>Optional</sup> <a name="build_spec" id="must-cdk.BranchOptions.property.buildSpec"></a>

```python
build_spec: str
```

- *Type:* str

Branch-specific build specification.

---

##### `enable_auto_build`<sup>Optional</sup> <a name="enable_auto_build" id="must-cdk.BranchOptions.property.enableAutoBuild"></a>

```python
enable_auto_build: bool
```

- *Type:* bool
- *Default:* true

Whether to enable automatic builds for this branch.

---

##### `environment_variables`<sup>Optional</sup> <a name="environment_variables" id="must-cdk.BranchOptions.property.environmentVariables"></a>

```python
environment_variables: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Environment variables specific to this branch.

---

##### `framework`<sup>Optional</sup> <a name="framework" id="must-cdk.BranchOptions.property.framework"></a>

```python
framework: str
```

- *Type:* str

The framework for this branch.

---

##### `pull_request_preview`<sup>Optional</sup> <a name="pull_request_preview" id="must-cdk.BranchOptions.property.pullRequestPreview"></a>

```python
pull_request_preview: bool
```

- *Type:* bool
- *Default:* false

Whether to enable pull request previews for this branch.

---

##### `stage`<sup>Optional</sup> <a name="stage" id="must-cdk.BranchOptions.property.stage"></a>

```python
stage: str
```

- *Type:* str
- *Default:* "PRODUCTION"

The stage for the branch (e.g., PRODUCTION, BETA, DEVELOPMENT).

---

### BuildSettings <a name="BuildSettings" id="must-cdk.BuildSettings"></a>

Build settings for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BuildSettings.Initializer"></a>

```python
import must_cdk

must_cdk.BuildSettings(
  cache_type: str = None,
  compute_type: str = None,
  enable_auto_branch_creation: bool = None,
  enable_auto_branch_deletion: bool = None,
  enable_branch_auto_build: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BuildSettings.property.cacheType">cache_type</a></code> | <code>str</code> | Cache type for the build. |
| <code><a href="#must-cdk.BuildSettings.property.computeType">compute_type</a></code> | <code>str</code> | Compute type for the build. |
| <code><a href="#must-cdk.BuildSettings.property.enableAutoBranchCreation">enable_auto_branch_creation</a></code> | <code>bool</code> | Whether to enable automatic branch creation when a new branch is pushed to the repository. |
| <code><a href="#must-cdk.BuildSettings.property.enableAutoBranchDeletion">enable_auto_branch_deletion</a></code> | <code>bool</code> | Whether to enable automatic branch deletion when a branch is deleted from the repository. |
| <code><a href="#must-cdk.BuildSettings.property.enableBranchAutoBuild">enable_branch_auto_build</a></code> | <code>bool</code> | Whether to enable automatic builds when code is pushed to a branch. |

---

##### `cache_type`<sup>Optional</sup> <a name="cache_type" id="must-cdk.BuildSettings.property.cacheType"></a>

```python
cache_type: str
```

- *Type:* str
- *Default:* "AMPLIFY_MANAGED"

Cache type for the build.

---

##### `compute_type`<sup>Optional</sup> <a name="compute_type" id="must-cdk.BuildSettings.property.computeType"></a>

```python
compute_type: str
```

- *Type:* str
- *Default:* "STANDARD"

Compute type for the build.

---

##### `enable_auto_branch_creation`<sup>Optional</sup> <a name="enable_auto_branch_creation" id="must-cdk.BuildSettings.property.enableAutoBranchCreation"></a>

```python
enable_auto_branch_creation: bool
```

- *Type:* bool
- *Default:* false

Whether to enable automatic branch creation when a new branch is pushed to the repository.

---

##### `enable_auto_branch_deletion`<sup>Optional</sup> <a name="enable_auto_branch_deletion" id="must-cdk.BuildSettings.property.enableAutoBranchDeletion"></a>

```python
enable_auto_branch_deletion: bool
```

- *Type:* bool
- *Default:* false

Whether to enable automatic branch deletion when a branch is deleted from the repository.

---

##### `enable_branch_auto_build`<sup>Optional</sup> <a name="enable_branch_auto_build" id="must-cdk.BuildSettings.property.enableBranchAutoBuild"></a>

```python
enable_branch_auto_build: bool
```

- *Type:* bool
- *Default:* true

Whether to enable automatic builds when code is pushed to a branch.

---

### CustomDomainOptions <a name="CustomDomainOptions" id="must-cdk.CustomDomainOptions"></a>

Custom domain configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.CustomDomainOptions.Initializer"></a>

```python
import must_cdk

must_cdk.CustomDomainOptions(
  domain_name: str,
  auto_subdomain_creation_patterns: typing.List[str] = None,
  enable_auto_subdomain: bool = None,
  sub_domains: typing.List[SubDomainOptions] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomDomainOptions.property.domainName">domain_name</a></code> | <code>str</code> | The custom domain name for the Amplify app. |
| <code><a href="#must-cdk.CustomDomainOptions.property.autoSubdomainCreationPatterns">auto_subdomain_creation_patterns</a></code> | <code>typing.List[str]</code> | Patterns for automatic subdomain creation. |
| <code><a href="#must-cdk.CustomDomainOptions.property.enableAutoSubdomain">enable_auto_subdomain</a></code> | <code>bool</code> | Whether to enable automatic subdomain creation. |
| <code><a href="#must-cdk.CustomDomainOptions.property.subDomains">sub_domains</a></code> | <code>typing.List[SubDomainOptions](./SubDomainOptions.md#must-cdk.SubDomainOptions)</code> | Subdomain configurations for the custom domain. |

---

##### `domain_name`<sup>Required</sup> <a name="domain_name" id="must-cdk.CustomDomainOptions.property.domainName"></a>

```python
domain_name: str
```

- *Type:* str

The custom domain name for the Amplify app.

---

##### `auto_subdomain_creation_patterns`<sup>Optional</sup> <a name="auto_subdomain_creation_patterns" id="must-cdk.CustomDomainOptions.property.autoSubdomainCreationPatterns"></a>

```python
auto_subdomain_creation_patterns: typing.List[str]
```

- *Type:* typing.List[str]

Patterns for automatic subdomain creation.

---

##### `enable_auto_subdomain`<sup>Optional</sup> <a name="enable_auto_subdomain" id="must-cdk.CustomDomainOptions.property.enableAutoSubdomain"></a>

```python
enable_auto_subdomain: bool
```

- *Type:* bool
- *Default:* false

Whether to enable automatic subdomain creation.

---

##### `sub_domains`<sup>Optional</sup> <a name="sub_domains" id="must-cdk.CustomDomainOptions.property.subDomains"></a>

```python
sub_domains: typing.List[SubDomainOptions]
```

- *Type:* typing.List[SubDomainOptions](./SubDomainOptions.md#must-cdk.SubDomainOptions)

Subdomain configurations for the custom domain.

---

### CustomRule <a name="CustomRule" id="must-cdk.CustomRule"></a>

Custom routing rule for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.CustomRule.Initializer"></a>

```python
import must_cdk

must_cdk.CustomRule(
  source: str,
  target: str,
  condition: str = None,
  status: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRule.property.source">source</a></code> | <code>str</code> | Source pattern to match in the URL. |
| <code><a href="#must-cdk.CustomRule.property.target">target</a></code> | <code>str</code> | Target URL to redirect or rewrite to. |
| <code><a href="#must-cdk.CustomRule.property.condition">condition</a></code> | <code>str</code> | Condition to apply the rule. |
| <code><a href="#must-cdk.CustomRule.property.status">status</a></code> | <code>str</code> | HTTP status code for the redirect. |

---

##### `source`<sup>Required</sup> <a name="source" id="must-cdk.CustomRule.property.source"></a>

```python
source: str
```

- *Type:* str

Source pattern to match in the URL.

---

##### `target`<sup>Required</sup> <a name="target" id="must-cdk.CustomRule.property.target"></a>

```python
target: str
```

- *Type:* str

Target URL to redirect or rewrite to.

---

##### `condition`<sup>Optional</sup> <a name="condition" id="must-cdk.CustomRule.property.condition"></a>

```python
condition: str
```

- *Type:* str

Condition to apply the rule.

---

##### `status`<sup>Optional</sup> <a name="status" id="must-cdk.CustomRule.property.status"></a>

```python
status: str
```

- *Type:* str
- *Default:* "200"

HTTP status code for the redirect.

---

