# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### ApiGatewayToLambda <a name="ApiGatewayToLambda" id="must-cdk.ApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.ApiGatewayToLambda.Initializer"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambda(
  scope: Construct,
  id: str,
  api_name: str,
  lambda_function: IFunction,
  create_usage_plan: bool = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[CustomRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  lambda_api_props: LambdaRestApiProps = None,
  log_group_props: LogGroupProps = None,
  proxy: bool = None,
  rest_api_props: RestApiProps = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.apiName">api_name</a></code> | <code>str</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.createUsagePlan">create_usage_plan</a></code> | <code>bool</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.customRoutes">custom_routes</a></code> | <code>typing.List[CustomRoute](#must-cdk.CustomRoute)</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaApiProps">lambda_api_props</a></code> | <code>aws_cdk.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.proxy">proxy</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.restApiProps">rest_api_props</a></code> | <code>aws_cdk.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* str

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.apiName"></a>

- *Type:* str

API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `create_usage_plan`<sup>Optional</sup> <a name="create_usage_plan" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.createUsagePlan"></a>

- *Type:* bool

Whether to create a Usage Plan.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.customDomainName"></a>

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.customRoutes"></a>

- *Type:* typing.List[CustomRoute](#must-cdk.CustomRoute)

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.enableLogging"></a>

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.existingCertificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambda_api_props`<sup>Optional</sup> <a name="lambda_api_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaApiProps"></a>

- *Type:* aws_cdk.aws_apigateway.LambdaRestApiProps

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.logGroupProps"></a>

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.proxy"></a>

- *Type:* bool

---

##### `rest_api_props`<sup>Optional</sup> <a name="rest_api_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.restApiProps"></a>

- *Type:* aws_cdk.aws_apigateway.RestApiProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.ApiGatewayToLambda.addRoute">add_route</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `to_string` <a name="to_string" id="must-cdk.ApiGatewayToLambda.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_route` <a name="add_route" id="must-cdk.ApiGatewayToLambda.addRoute"></a>

```python
def add_route(
  handler: IFunction,
  method: str,
  path: str,
  method_options: MethodOptions = None
) -> Method
```

Add a custom route after construction (for dynamic route addition).

###### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.handler"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

###### `method`<sup>Required</sup> <a name="method" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.method"></a>

- *Type:* str

---

###### `path`<sup>Required</sup> <a name="path" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.path"></a>

- *Type:* str

---

###### `method_options`<sup>Optional</sup> <a name="method_options" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.methodOptions"></a>

- *Type:* aws_cdk.aws_apigateway.MethodOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.ApiGatewayToLambda.isConstruct"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambda.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.ApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGateway">api_gateway</a></code> | <code>aws_cdk.aws_apigateway.RestApi</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiUrl">api_url</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup">api_gateway_log_group</a></code> | <code>aws_cdk.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.aRecord">a_record</a></code> | <code>aws_cdk.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.domain">domain</a></code> | <code>aws_cdk.aws_apigateway.DomainName</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.usagePlan">usage_plan</a></code> | <code>aws_cdk.aws_apigateway.UsagePlan</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.ApiGatewayToLambda.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `api_gateway`<sup>Required</sup> <a name="api_gateway" id="must-cdk.ApiGatewayToLambda.property.apiGateway"></a>

```python
api_gateway: RestApi
```

- *Type:* aws_cdk.aws_apigateway.RestApi

---

##### `api_url`<sup>Required</sup> <a name="api_url" id="must-cdk.ApiGatewayToLambda.property.apiUrl"></a>

```python
api_url: str
```

- *Type:* str

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambda.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `api_gateway_log_group`<sup>Optional</sup> <a name="api_gateway_log_group" id="must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```python
api_gateway_log_group: LogGroup
```

- *Type:* aws_cdk.aws_logs.LogGroup

---

##### `a_record`<sup>Optional</sup> <a name="a_record" id="must-cdk.ApiGatewayToLambda.property.aRecord"></a>

```python
a_record: ARecord
```

- *Type:* aws_cdk.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.ApiGatewayToLambda.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.ApiGatewayToLambda.property.domain"></a>

```python
domain: DomainName
```

- *Type:* aws_cdk.aws_apigateway.DomainName

---

##### `usage_plan`<sup>Optional</sup> <a name="usage_plan" id="must-cdk.ApiGatewayToLambda.property.usagePlan"></a>

```python
usage_plan: UsagePlan
```

- *Type:* aws_cdk.aws_apigateway.UsagePlan

---


### ApiGatewayToLambdaProps <a name="ApiGatewayToLambdaProps" id="must-cdk.ApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.ApiGatewayToLambdaProps.Initializer"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambdaProps(
  api_name: str,
  lambda_function: IFunction,
  create_usage_plan: bool = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[CustomRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  lambda_api_props: LambdaRestApiProps = None,
  log_group_props: LogGroupProps = None,
  proxy: bool = None,
  rest_api_props: RestApiProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.apiName">api_name</a></code> | <code>str</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan">create_usage_plan</a></code> | <code>bool</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customRoutes">custom_routes</a></code> | <code>typing.List[CustomRoute](#must-cdk.CustomRoute)</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps">lambda_api_props</a></code> | <code>aws_cdk.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.proxy">proxy</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.restApiProps">rest_api_props</a></code> | <code>aws_cdk.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.ApiGatewayToLambdaProps.property.apiName"></a>

```python
api_name: str
```

- *Type:* str

API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `create_usage_plan`<sup>Optional</sup> <a name="create_usage_plan" id="must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan"></a>

```python
create_usage_plan: bool
```

- *Type:* bool

Whether to create a Usage Plan.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.ApiGatewayToLambdaProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.ApiGatewayToLambdaProps.property.customRoutes"></a>

```python
custom_routes: typing.List[CustomRoute]
```

- *Type:* typing.List[CustomRoute](#must-cdk.CustomRoute)

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.ApiGatewayToLambdaProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.ApiGatewayToLambdaProps.property.existingCertificate"></a>

```python
existing_certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.ApiGatewayToLambdaProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambda_api_props`<sup>Optional</sup> <a name="lambda_api_props" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps"></a>

```python
lambda_api_props: LambdaRestApiProps
```

- *Type:* aws_cdk.aws_apigateway.LambdaRestApiProps

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.ApiGatewayToLambdaProps.property.logGroupProps"></a>

```python
log_group_props: LogGroupProps
```

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambdaProps.property.proxy"></a>

```python
proxy: bool
```

- *Type:* bool

---

##### `rest_api_props`<sup>Optional</sup> <a name="rest_api_props" id="must-cdk.ApiGatewayToLambdaProps.property.restApiProps"></a>

```python
rest_api_props: RestApiProps
```

- *Type:* aws_cdk.aws_apigateway.RestApiProps

---

### CustomRoute <a name="CustomRoute" id="must-cdk.CustomRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.CustomRoute.Initializer"></a>

```python
import must_cdk

must_cdk.CustomRoute(
  handler: IFunction,
  method: str,
  path: str,
  method_options: MethodOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRoute.property.handler">handler</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.method">method</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.path">path</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.methodOptions">method_options</a></code> | <code>aws_cdk.aws_apigateway.MethodOptions</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.CustomRoute.property.handler"></a>

```python
handler: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `method`<sup>Required</sup> <a name="method" id="must-cdk.CustomRoute.property.method"></a>

```python
method: str
```

- *Type:* str

---

##### `path`<sup>Required</sup> <a name="path" id="must-cdk.CustomRoute.property.path"></a>

```python
path: str
```

- *Type:* str

---

##### `method_options`<sup>Optional</sup> <a name="method_options" id="must-cdk.CustomRoute.property.methodOptions"></a>

```python
method_options: MethodOptions
```

- *Type:* aws_cdk.aws_apigateway.MethodOptions

---

