# ECS CodeDeploy Examples

This directory contains examples for deploying containerized applications using Amazon ECS with AWS CodeDeploy for Blue/Green deployments.

## Examples

### ECS with CodeDeploy Blue/Green Deployment
- **Files**: `ecs-codedeploy.ts` / `ecs_codedeploy.py`
- **Description**: Production-ready ECS service with Blue/Green deployment strategy
- **Features**:
  - Blue/Green deployment with CodeDeploy
  - Application Load Balancer integration
  - Auto-scaling based on CPU and memory
  - Health checks and monitoring
  - VPC and security group configuration
  - Container insights enabled

## Key Components

### 1. VPC Configuration
- Multi-AZ setup with public and private subnets
- NAT gateways for outbound internet access
- Security groups with proper ingress/egress rules

### 2. ECS Cluster
- Container insights enabled for monitoring
- Optimized for Fargate tasks

### 3. Blue/Green Deployment
- Zero-downtime deployments
- Automatic rollback on failure
- Configurable deployment timeouts
- Traffic shifting strategies

### 4. Auto Scaling
- CPU and memory-based scaling policies
- Configurable min/max capacity
- Scale-in and scale-out cooldowns

## Deployment

```bash
# TypeScript
npm install
cdk deploy EcsCodeDeployStack

# Python
pip install aws-cdk-lib must-cdk
cdk deploy EcsCodeDeployStack
```

## Customization

### Container Configuration
Update the container image and configuration:
```typescript
containers: [
  {
    name: 'my-app',
    image: 'my-registry/my-app:latest',
    portMappings: [{ containerPort: 8080 }],
    environment: {
      NODE_ENV: 'production',
      DATABASE_URL: 'your-database-url'
    }
  }
]
```

### Scaling Configuration
Adjust auto-scaling parameters:
```typescript
autoScaling: {
  minCapacity: 2,
  maxCapacity: 20,
  targetCpuUtilization: 70,
  targetMemoryUtilization: 80
}
```

## Monitoring

The example includes:
- CloudWatch Container Insights
- Application Load Balancer health checks
- ECS service metrics
- Auto-scaling metrics

## Security Best Practices

- Tasks run in private subnets
- Security groups with minimal required access
- IAM roles with least privilege
- Encryption in transit and at rest
- VPC Flow Logs (optional)
