import * as iam from "aws-cdk-lib/aws-iam";
import * as logs from "aws-cdk-lib/aws-logs";
import { Construct } from "constructs";

export function setupLogging(
  scope: Construct,
  apiName: string,
  logGroupProps?: logs.LogGroupProps,
): {
  logGroup: logs.LogGroup;
  role: iam.Role;
} {
  const logGroup = new logs.LogGroup(scope, "ApiGatewayLogGroup", {
    logGroupName: `/aws/apigateway/${apiName}`,
    ...logGroupProps,
  });

  const role = new iam.Role(scope, "ApiGatewayCloudWatchRole", {
    assumedBy: new iam.ServicePrincipal("apigateway.amazonaws.com"),
    managedPolicies: [
      iam.ManagedPolicy.fromAwsManagedPolicyName(
        "service-role/AmazonAPIGatewayPushToCloudWatchLogs",
      ),
    ],
  });

  return { logGroup, role };
}
