import * as apigatewayv2 from "aws-cdk-lib/aws-apigatewayv2";
import { ICertificate } from "aws-cdk-lib/aws-certificatemanager";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as logs from "aws-cdk-lib/aws-logs";
import * as route53 from "aws-cdk-lib/aws-route53";

export interface WebSocketRoute {
  readonly routeKey: string;
  readonly handler: lambda.IFunction;
  readonly routeResponseSelectionExpression?: string;
}

export interface WebSocketApiGatewayToLambdaProps {
  /**
   * Primary Lambda function for the API (usually handles $default route)
   */
  readonly lambdaFunction: lambda.IFunction;

  /**
   * WebSocket API configuration
   */
  readonly apiName: string;
  readonly apiProps?: apigatewayv2.WebSocketApiProps;

  /**
   * Optional custom domain name for API Gateway
   */
  readonly customDomainName?: string;

  /**
   * Optional Route53 hosted zone for custom domain
   */
  readonly hostedZone?: route53.IHostedZone;

  /**
   * Optional ACM certificate to use instead of creating a new one
   */
  readonly existingCertificate?: ICertificate;

  /**
   * CloudWatch Logs configuration
   */
  readonly logGroupProps?: logs.LogGroupProps;

  /**
   * Custom routes for WebSocket API
   * Common routes: $connect, $disconnect, $default, or custom route keys
   */
  readonly customRoutes?: WebSocketRoute[];

  /**
   * Enable CloudWatch logging for API Gateway
   */
  readonly enableLogging?: boolean;

  /**
   * Stage name for the WebSocket API
   * @default 'dev'
   */
  readonly stageName?: string;
}
