#!/usr/bin/env node

import * as fs from "fs";
import * as path from "path";
import { Command } from "commander";
import { amplifyCommand } from "./commands/amplify";

/**
 * Get the version from package.json
 */
function getVersion(): string {
  try {
    // First try relative to current directory (development mode)
    const packageJsonPath = path.resolve(__dirname, "../../package.json");
    if (fs.existsSync(packageJsonPath)) {
      const packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
      return packageJson.version;
    }
  } catch (error) {
    // Ignore error and try next approach
  }

  try {
    // Fallback: try to resolve the package.json of must-cdk (installed mode)
    const packageJsonPath = require.resolve("must-cdk/package.json");
    const packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
    return packageJson.version;
  } catch (error) {
    // Last resort fallback
    return "0.0.0";
  }
}

/**
 * Main CLI entry point for must-cdk
 */
export function main() {
  const program = new Command();

  program
    .name("must-cdk")
    .description(
      "A CLI tool for AWS CDK constructs that implement common architectural patterns and best practices",
    )
    .version(getVersion());

  // Add the amplify command
  program.addCommand(amplifyCommand);

  // Parse command line arguments
  program.parse();
}

// If this file is run directly, execute the main function
if (require.main === module) {
  main();
}
