# -*- coding: utf-8 -*-

__all__ = ['Yok']


class Yok(object):
    """Yok is Korean abusive slangs interpreted on internet.

    Disclaimer:

        Yok은 특정 정치적 성향이나 정치적인 옳고 그름과 무관하게
        보편적 인식에서 타인이나 집단에 대한 비하적 목적으로 사용될 수 있는 단어를 포함함.

        다소 불쾌함을 줄 수 있는 단어를 다수 포함하고 있음.

        출처 1) namu.wiki/w/욕설/한국어


    .. code-block:: python

        >>> from koshort.dictionary import Yok
        >>> yok = Yok()
        >>> print(yok)  # see whats inside.
        썩을년
        되놈
        종간나
        ...
        >>> yok.list_attrs()
        ['wiki_slangs', 'filtered_slangs', 'filtered_slangs_2', 'yok']
        >>> print(yok.wiki_slangs)
        ['간나새끼', '개간나', '...']

    """

    def __init__(self):
        self.wiki_slangs = [
            '간나새끼', '개간나', '종간나', '좆간나',
            '걸보', '개간년', '개나리', '개년', '개독', '개돼지', '개새끼',
            '개소리', '개씨발', '개씹할', '개씹', '개좆', '개지랄',
            '개차반', '거렁뱅이', '걸레', '고자', '광녀', '광년', '괴뢰',
            '그지깽깽이', '급식충', '김치녀', '꺼벙이', '꼬붕', '꼰대', '꼴통',
            '놈', '뇬', '노슬아치', '느금마', '니기미', '니미럴', '니상년', '노답',
            '닥쳐', '닭대가리', '돼지', '돼지새끼', '되놈', '된장녀', '뒈지다', '등신', '따까리',
            '땡중', '떨거지', '또라이', '똥꼬충', '돌아이', '똘마니', '똘추', '똥', '똥개', '띨빵',
            '루저', '망나니', '매국노', '머저리', '먹사', '멍청도', '멍청이', '무뇌',
            '미제', '미치광이', '미친개', '미친놈', '미친새끼', '미친',
            '바보', '버러지', '병신', '벌레', '보슬아치',
            '보전깨', '보지년', '보추', '불한당', '븅딱', '빌어먹을', '빠가',
            '빠돼쌍', '빨갱이', '빨통', '삐꾸', '빡대가리', '새끼', '십장생',
            '싸가지', '싸이코', '사이코', '쌍욕', '쌍놈', '쌍년', '썅놈', '썅년', '썅',
            '쓰레기', '씨팔', '씨발', '시발', '씨발놈', '씨발년', '씨발새끼', '씨부럴', '씨방새',
            '씹', '씹새끼', '씹새', '씹창', '씹년', '아다', '애자',
            '양놈', '양아치', '언년이', '얼간이', '에라이', '애미', '애비', '엠창', '엄창',
            '엠창인생', '열폭', '염병', '엠병', '엿먹다', '오랑캐', '왜놈', '우라질', '육시럴',
            '응 니애미', '인간쓰레기', '인조새', '일베충',
            '잡놈', '잡종', '장애인', '재수없다', '저능아', '정박아', '정신병자', '정액받이', '제기랄',
            '줸장', '존나', '졸라', '종간나새끼', '좆간나새끼', '좆', '좆같다', '좆까', '좆나', '존나',
            '좆도 아닌', '좆망', '좆물', '좆밥', '좆만이', '좆대가리', '좆집', '쥐새끼',
            '지기미', '지랄', '짱깨', '쩌리', '쪼다', '쪽발이', '쪽바리', '쫄보',
            '찌랭이', '찌질이', '찐따', '찐찌버거', '창녀', '창놈', '천치', '춍', '촛불좀비',
            '추남', '추녀', '충', '친일파', '코흘리개', '통구이', '트롤',
            '틀딱충', '파쇼', '폐인', '폐녀자', '피싸개', '한남', '한남충', '허접',
            '호구', '호로', '후레자식', '호모', '홍어', '화냥년', '환향년', '후장', '후빨',
        ]
        self.filtered_slangs = [
            '10새', '10새기', '10새리', '10세리', '10쉐이', '10쉑', '10스', '10쌔', ' 10쌔기', '10쎄', '10알', '10창', '10탱',
            '18것', '18넘', '18년', '18노', '18놈', '18뇬', '18럼', '18롬', '18새', '18새끼', '18색', '18세끼', '18세리', '18섹', '18쉑', '18스', '18아', 'ㅅㅂㄹㅁ', 'ㅆㅂㄹㅁ', 'ㅆㅍ', 'ㅆㅣ', 'ㅆ앙',
            '갈보', '갈보년', '강아지', '같은년', '같은뇬', '개같은', '개구라', '개년', '개놈', '개뇬', '개대중', '개독', '개돼중', '개랄', '개보지', '개뻥', '개뿔', '개새', '개새기', '개새끼', '개새키', '개색기', '개색끼', '개색키', '개색히', '개섀 끼', '개세', '개세끼', '개세이', '개소리', '개쑈', ' 개쇳기', '개수작', '개쉐', '개쉐리', '개쉐이', '개쉑', '개쉽',
        ]
        self.filtered_slangs_2 = [
            '개 스끼', '개시키', '개십새기', ' 개십새끼', '개쐑', '개씹', '개아들', '개자슥', '개자지', '개접', '개좆', '개좌식', '개허 접', '걔새', '걔수작', '걔시끼', '걔시키', '걔썌', '걸레', '게색기', '게색끼', '광뇬', '구녕', '구라', '구멍', '그년', '그새끼', '냄비', '놈현', '뇬', '눈깔', '뉘미럴', '니귀미', '니기미', '니미', '니미랄', '니미럴', '니미씹', '니아배', '니아베', '니아비', '니어매', '니어메', '니어미', '닝기리', '닝기미',
            '메친넘', '메친놈', '미췬', '미친', '미틴',
            '바랄년', '병자', '뱅마', '뱅신', '벼엉신', '병쉰', '병신', '부랄', '부럴', '불알', '불할', '붕가', '붙어먹', '뷰웅', '븅', '븅신', '빌어먹', '빙시', '빙신', '빠가', '빠구리', '빠굴', '빠큐', '뻐큐', '뻑큐', '뽁큐',
            '상넘이', ' 상놈을', '상놈의', '상놈이', '새갸', '새꺄', '새끼', '새새끼', '새키', '색끼', '생쑈', '세갸', '세꺄', '세끼', '섹스', '쇼하네', '쉐', '쉐기', '쉐끼', '쉐리', '쉐에기', '쉐키', '쉑', '쉣', '쉨', '쉬발', '쉬밸', '쉬벌', '쉬뻘', '쉬펄', '쉽알', '스패킹', '스팽', '시궁창', '시끼', '시댕', '시뎅', '시랄', '시발', '시벌', '시부랄', '시부럴', '시부리', '시불', '시브랄', '시팍', '시팔', '시펄', '신발끈', '심발끈', '심탱', '십8', '십라', '십새', '십새끼', '십세', '십쉐', '십쉐이', ' 십스키', '십쌔', '십창', '십탱', '싶알',
            '싸가지', '싹아지', '쌉년', '쌍넘', '쌍년', '쌍놈', '쌍뇬', '쌔끼', ' 쌕', '쌩 쑈', '쌴년', '썅', '썅년', '썅놈', '썡쇼', '써벌', '썩을년', '썩을놈', '쎄꺄', '쎄엑', ' 쒸벌', '쒸뻘', '쒸팔', '쒸펄', '쓰바', '쓰박', '쓰발', '쓰벌', '쓰팔', '씁새', '씁얼', '씌파', '씨8', ' 씨끼', '씨댕', '씨뎅', '씨바', '씨바랄', '씨박', '씨발', '씨방', '씨방새', '씨방세', '씨밸', '씨뱅', '씨벌', '씨벨', '씨봉', '씨봉알', '씨부랄', '씨부럴', '씨부렁', ' 씨부리', '씨불', '씨붕', '씨브랄', ' 씨빠', '씨빨', '씨뽀랄', '씨앙', '씨파', '씨팍', '씨팔', '씨펄', '씸년', '씸뇬', ' 씸새끼', '씹같', '씹년', '씹뇬', '씹보지', '씹새', '씹새기', '씹새끼', '씹새리', '씹세', '씹쉐', '씹스키', '씹쌔', '씹이', '씹자지', '씹질', '씹창', '씹탱', '씹퇭', '씹팔', '씹할', '씹헐',
            '아가리', '아갈', '아갈이', '아갈통', '아구창', '아구통', '아굴', '얌마', '양넘', '양년', '양놈', '엄창', '엠병', '여물통', '염병', '엿같', '옘병', '옘빙', '오입', '왜년', '왜놈', '욤병', '육갑', '은년', '을년', '이년', '이새끼', '이새키', '이스끼', '이스키', '임마',
            '자슥', '잡것', '잡넘', '잡년', '잡놈', '저년', '저새끼', '접년', '젖밥', '조까', '조까치', '조낸', '조또', '조랭', '조빠', '조쟁이', '조지냐', '조진다', '조찐', '  조질래', '존나', '존나게', '존니', '존만', ' 존만한', '좀물', '좁년', '좆', '좁밥', '좃까', '좃또', '좃만', '좃밥', '좃이', '좃찐', '좆같', '좆까', '좆나', '좆또', '좆만', '좆밥', '좆이', '좆찐', '좇같', '좇이', '좌식', '주글', '주글래', '주데이', '주뎅', '주뎅이', '주둥아리', '주둥이', '주접', '주접떨', '죽고잡', '죽을래', '죽통', '쥐 랄', '쥐롤', '쥬디', '지랄', '지럴', '지롤', '지미랄', '짜식', '짜아식', '쪼다', '쫍빱', '찌랄', '창녀',
            '캐년', '캐놈', '퍽큐', '호로', '후라들', '후래자식', '후레', '후뢰', '씨ㅋ발', 'ㅆ1발', '씌발', '띠발', '띄발', '뛰발', '띠ㅋ발', '뉘뮈'
        ]

        self.yok = list(set((self.wiki_slangs + self.filtered_slangs + self.filtered_slangs_2)))

    def __str__(self):
        return '\n'.join(self.yok)

    def list_attrs(self):
        """List wordsets included in the class.

        Returns:
            list: name of the attributes.
        """

        return list(self.__dict__.keys())
